/*
 * Decompiled with CFR 0.152.
 */
package ua.kiev.author.cryptolib;

import java.math.BigInteger;
import ua.kiev.author.cryptolib.BaseField;
import ua.kiev.author.cryptolib.EcPoint;

public class StdCurves {
    public static Object[] GetStandardCurve(int n2, boolean bl) {
        Object[] objectArray = new Object[3];
        int n3 = -1;
        int[] nArray = null;
        BigInteger bigInteger = null;
        switch (n2) {
            case 163: {
                n3 = 1;
                nArray = BaseField.getElement("5FF6108462A2DC8210AB403925E638A19C1455D21");
                bigInteger = new BigInteger("400000000000000000002BEC12BE2262D39BCF14D", 16);
                break;
            }
            case 167: {
                n3 = 1;
                nArray = BaseField.getElement("6EE3CEEB230811759F20518A0930F1A4315A827DAC");
                bigInteger = new BigInteger("3FFFFFFFFFFFFFFFFFFFFFB12EBCC7D7F29FF7701F", 16);
                break;
            }
            case 173: {
                n3 = 0;
                nArray = BaseField.getElement("108576C80499DB2FC16EDDF6853BBB278F6B6FB437D9");
                if (bl) {
                    nArray = BaseField.getElement("043D7E139319F43BA00944915740E1E6651B06E278C7");
                }
                bigInteger = new BigInteger("800000000000000000000189B4E67606E3825BB2831", 16);
                break;
            }
            case 179: {
                n3 = 1;
                nArray = BaseField.getElement("4A6E0856526436F2F88DD07A341E32D04184572BEB710");
                if (bl) {
                    nArray = BaseField.getElement("19C9EBC4FD8308193D3A61762C547C82F2E6B2182CBCB");
                }
                bigInteger = new BigInteger("3FFFFFFFFFFFFFFFFFFFFFFB981960435FE5AB64236EF", 16);
                break;
            }
            case 191: {
                n3 = 1;
                nArray = BaseField.getElement("7BC86E2102902EC4D5890E8B6B4981FF27E0482750FEFC03");
                if (bl) {
                    nArray = BaseField.getElement("13871C9D29D6CEEA740FD57444F72FDBAE559C13A1E31EF8");
                }
                bigInteger = new BigInteger("40000000000000000000000069A779CAC1DABC6788F7474F", 16);
                break;
            }
            case 233: {
                n3 = 1;
                nArray = BaseField.getElement("06973B15095675534C7CF7E64A21BD54EF5DD3B8A0326AA936ECE454D2C");
                if (bl) {
                    nArray = BaseField.getElement("080F920952A702C75B704A424C018EEA55AA44664F3A003E0962D4F9A8E");
                }
                bigInteger = new BigInteger("1000000000000000000000000000013E974E72F8A6922031D2603CFE0D7", 16);
                break;
            }
            case 257: {
                n3 = 0;
                nArray = BaseField.getElement("1CEF494720115657E18F938D7A7942394FF9425C1458C57861F9EEA6ADBE3BE10");
                bigInteger = new BigInteger("800000000000000000000000000000006759213AF182E987D3E17714907D470D", 16);
                break;
            }
            case 307: {
                n3 = 1;
                nArray = BaseField.getElement("393C7F7D53666B5054B5E6C6D3DE94F4296C0C599E2E2E241050DF18B6090BDC90186904968BB");
                bigInteger = new BigInteger("3FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC079C2F3825DA70D390FBBA588D4604022B7B7", 16);
                break;
            }
            case 367: {
                n3 = 1;
                nArray = BaseField.getElement("43FC8AD242B0B7A6F3D1627AD5654447556B47BF6AA4A64B0C2AFE42CADAB8F93D92394C79A79755437B56995136");
                bigInteger = new BigInteger("40000000000000000000000000000000000000000000009C300B75A3FA824F22428FD28CE8812245EF44049B2D49", 16);
                break;
            }
            case 431: {
                n3 = 1;
                nArray = BaseField.getElement("03CE10490F6A708FC26DFE8C3D27C4F94E690134D5BFF988D8D28AAEAEDE975936C66BAC536B18AE2DC312CA493117DAA469C640CAF3");
                if (bl) {
                    nArray = BaseField.getElement("53FB7AF7B4407000A6F226AD6BAD28378646BD83F1F940810A4C19536EE65E53F40F973F2F06C5E80EFE3B43651BD5FF8B06BA5F9299");
                }
                bigInteger = new BigInteger("3FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFBA3175458009A8C0A724F02F81AA8A1FCBAF80D90C7A95110504CF", 16);
                break;
            }
            case 509: {
                n3 = 1;
                nArray = BaseField.getElement("17A7821EB5205A6B8E8409CBB4BB4CAF3D393CA9641A0A7676E629AE52186F08966DC8743D8AE3A08D14FB95D997A3717FBC08AD85EEB78090E8BA6242DD0532");
                if (bl) {
                    nArray = BaseField.getElement("197D9BE30EE2381E551DA2A0386EA6277DFB60F51D81364F2C4B2F3500F31ADCF9C012AE648360378360E15E41640418CD4A8B845536B9F3A2B3BFD1D1ADE6A3");
                }
                bigInteger = new BigInteger("10000000000000000000000000000000000000000000000000000000000000001DD401302388FE904935573948ED58F7E13242A783052CC89E34020362A758F9", 16);
            }
        }
        objectArray[0] = new Integer(n3);
        objectArray[1] = nArray;
        objectArray[2] = bigInteger;
        if (n3 < 0) {
            objectArray = null;
        }
        return objectArray;
    }

    public static EcPoint GetStandardBasePoint(int n2, boolean bl) {
        if (!bl) {
            switch (n2) {
                case 163: {
                    return new EcPoint("2E2F85F5DD74CE983A5C4237229DAF8A3F35823BE", "3826F008A8C51D7B95284D9D03FF0E00CE2CD723A");
                }
                case 167: {
                    return new EcPoint("7A1F6653786A68192803910A3D30B2A2018B21CD54", "5F49EB26781C0EC6B8909156D98ED435E45FD59918");
                }
                case 173: {
                    return new EcPoint("04D41A619BCC6EADF0448FA22FAD567A9181D37389CA", "10B51CC12849B234C75E6DD2028BF7FF5C1CE0D991A1");
                }
                case 179: {
                    return new EcPoint("6BA06FE51464B2BD26DC57F48819BA9954667022C7D03", "25FBC363582DCEC065080CA8287AAFF09788A66DC3A9E");
                }
                case 191: {
                    return new EcPoint("714114B762F2FF4A7912A6D2AC58B9B5C2FCFE76DAEB7129", "29C41E568B77C617EFE5902F11DB96FA9613CD8D03DB08DA");
                }
                case 233: {
                    return new EcPoint("3FCDA526B6CDF83BA1118DF35B3C31761D3545F32728D003EEB25EFE96", "9CA8B57A934C54DEEDA9E54A7BBAD95E3B2E91C54D32BE0B9DF96D8D35");
                }
                case 257: {
                    return new EcPoint("02A29EF207D0E9B6C55CD260B306C7E007AC491CA1B10C62334A9E8DCD8D20FB7", "10686D41FF744D4449FCCF6D8EEA03102E6812C93A9D60B978B702CF156D814EF");
                }
                case 307: {
                    return new EcPoint("216EE8B189D291A0224984C1E92F1D16BF75CCD825A087A239B276D3167743C52C02D6E7232AA", "5D9306BACD22B7FAEB09D2E049C6E2866C5D1677762A8F2F2DC9A11C7F7BE8340AB2237C7F2A0");
                }
                case 367: {
                    return new EcPoint("324A6EDDD512F08C49A99AE0D3F961197A76413E7BE81A400CA681E09639B5FE12E59A109F78BF4A373541B3B9A1", "01AB597A5B4477F59E39539007C7F977D1A567B92B043A49C6B61984C3FE3481AAF454CD41BA1F051626442B3C10");
                }
                case 431: {
                    return new EcPoint("1A62BA79D98133A16BBAE7ED9A8E03C32E0824D57AEF72F88986874E5AAE49C27BED49A2A95058068426C2171E99FD3B43C5947C857D", "70B5E1E14031C1F70BBEFE96BDDE66F451754B4CA5F48DA241F331AA396B8D1839A855C1769B1EA14BA53308B5E2723724E090E02DB9");
                }
            }
            return null;
        }
        switch (n2) {
            case 173: {
                return new EcPoint("0A3B8B8D704089B24318CAA51917CB6E424B4E6DEA56", "005A43D5EE1F400349CF35150C74F119A39145F0CB08");
            }
            case 179: {
                return new EcPoint("11F4112265410477159E0D3E39BC4AC4ADE43B21B66B9", "2CA5F0B34C61A86216F13766591CB266E2819EE582B3C");
            }
            case 191: {
                return new EcPoint("7159E0D3E39BC4AC4ADE43B21B66B94F2AF25ABEEB1D85D3", "57E45D546BE6201E9705E029535D009D31F51D81E18226BE");
            }
            case 233: {
                return new EcPoint("0A0823B8ACF069F1CDE256256F21D90DB35CA795792D5F758EC2E9992FB", "19DAE222AF326D33AFB7761953F624A23D3EB1CA7A1C300F0AA9953CA85");
            }
            case 431: {
                return new EcPoint("2020182CFCD7C724157B363D4ABFD4C16251773C595D4E5C88572FA9D5EBB58142326448C08D3EE3E17E40B835D3090DCFBA7C5ADEA6", "18E1B6EFB28EEF8A1F9C1859ED57C74CA747E4E1A60294C005D1920E80903A432929855828DD7F21714F837E119A044987F00110ADAD");
            }
        }
        return null;
    }
}

