/*
 * Decompiled with CFR 0.152.
 */
package ua.kiev.author.cryptolib;

import java.security.SecureRandom;
import java.util.Random;

public class Prng4145A
extends Random {
    private int[] Uz = new int[128];
    private int[] Key = new int[8];
    private int S0;
    private int S1;
    private int D0;
    private int D1;

    public Prng4145A() {
        try {
            SecureRandom secureRandom = new SecureRandom();
            byte[] byArray = SecureRandom.getSeed(32);
            byte[] byArray2 = SecureRandom.getSeed(8);
            byte[] byArray3 = new byte[8];
            long l2 = System.currentTimeMillis();
            for (int i2 = 0; i2 < 8; ++i2) {
                byArray3[i2] = (byte)(l2 >> i2 * 8);
            }
            this.SetSBoxKey(null, byArray);
            this.Reinit(byArray2, byArray3);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Can't seed random generator");
        }
    }

    public Prng4145A(long l2) {
        this();
        byte[] byArray = new byte[8];
        for (int i2 = 0; i2 < 8; ++i2) {
            byArray[i2] = (byte)(l2 >> i2 * 8);
        }
        this.Reinit(null, byArray);
    }

    public Prng4145A(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        this.SetSBoxKey(byArray, byArray2);
        this.Reinit(byArray3, byArray4);
    }

    public void finalize() {
        for (int i2 = 0; i2 < 8; ++i2) {
            this.Key[i2] = 0;
        }
        this.S0 = 0;
        this.S1 = 0;
        this.D0 = 0;
        this.D1 = 0;
    }

    public void SetSBoxKey(byte[] byArray, byte[] byArray2) {
        int n2;
        if (byArray == null) {
            byArray = Prng4145A.getVector("400D9F7957C1ACF28ABED466E53B28134A6334ABE5D116CCBD00F257799E882F7D11E942A7C3502C04FABB6E98D5863FD2A8E057FC13312FB5746B9E46CD098A");
        }
        for (n2 = 0; n2 < 4; ++n2) {
            for (int i2 = 0; i2 < 16; ++i2) {
                int n3 = (byArray[n2 * 16 + i2] & 0xF) << n2 * 8;
                this.Uz[n2 * 32 + i2] = (n3 << 11) + (n3 >>> 21);
                n3 = (byArray[n2 * 16 + i2] & 0xF0) << n2 * 8;
                this.Uz[n2 * 32 + i2 + 16] = (n3 << 11) + (n3 >>> 21);
            }
        }
        for (n2 = 0; n2 <= 7; ++n2) {
            this.Key[n2] = byArray2[n2 * 4 + 0] & 0xFF | (byArray2[n2 * 4 + 1] & 0xFF) << 8 | (byArray2[n2 * 4 + 2] & 0xFF) << 16 | (byArray2[n2 * 4 + 3] & 0xFF) << 24;
        }
    }

    public void Reinit(byte[] byArray, byte[] byArray2) {
        if (byArray != null) {
            this.S0 = this.a(byArray, 0);
            this.S1 = this.a(byArray, 4);
        }
        if (byArray2 != null) {
            int n2 = this.S0;
            int n3 = this.S1;
            this.S0 = this.a(byArray2, 0);
            this.S1 = this.a(byArray2, 4);
            this.a();
            this.D0 = this.S0;
            this.D1 = this.S1;
            this.S0 = n2;
            this.S1 = n3;
        }
    }

    public static byte[] getVector(String string) {
        byte[] byArray = new byte[string.length() + 1 >> 1];
        int n2 = 0;
        for (int i2 = string.length() - 1; i2 >= 0; --i2) {
            int n3 = n2 >> 1;
            byArray[n3] = (byte)(byArray[n3] | Integer.parseInt(string.substring(i2, i2 + 1), 16) << (n2 & 1) * 4);
            ++n2;
        }
        return byArray;
    }

    private int a(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16 | (byArray[n2 + 3] & 0xFF) << 24;
    }

    private void a() {
        int n2 = this.S0;
        for (int i2 = 0; i2 < 32; ++i2) {
            int n3 = this.S1;
            this.S1 = n2;
            n2 += this.Key[(i2 ^ 2147483624 + i2 >> 31) & 7];
            n2 = n3 ^ this.Uz[n2 & 0xF] ^ this.Uz[(n2 >> 4 & 0xF) + 16] ^ this.Uz[(n2 >> 8 & 0xF) + 32] ^ this.Uz[(n2 >> 12 & 0xF) + 48] ^ this.Uz[(n2 >> 16 & 0xF) + 64] ^ this.Uz[(n2 >> 20 & 0xF) + 80] ^ this.Uz[(n2 >> 24 & 0xF) + 96] ^ this.Uz[(n2 >> 28 & 0xF) + 112];
        }
        this.S0 = this.S1;
        this.S1 = n2;
    }

    protected int next(int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.S0 ^= this.D0;
            this.S1 ^= this.D1;
            this.a();
            n3 |= (this.S0 & 1) << i2;
            this.S0 ^= this.D0;
            this.S1 ^= this.D1;
            this.a();
        }
        return n3;
    }

    public void nextBytes(byte[] byArray) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = (byte)this.next(8);
        }
    }
}

