/*
 * Decompiled with CFR 0.152.
 */
package ua.kiev.author.cryptolib;

import java.math.BigInteger;
import java.util.Random;
import ua.kiev.author.cryptolib.BaseField;
import ua.kiev.author.cryptolib.EcPoint;
import ua.kiev.author.cryptolib.Ecc4145;
import ua.kiev.author.cryptolib.Gost34311;
import ua.kiev.author.cryptolib.Prng4145A;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class EcDHKD {
    public static final int KDF_N739_INTERNATIONAL_STD = 0;
    public static final int KDF_N739_INTERNATIONAL_COFACTOR = 1;
    public static final int KDF_N739_UA_STD = 2;
    public static final int KDF_N739_UA_COFACTOR = 3;
    public static final int KDF_N739_FCOMPATIBLE_STD = 6;
    public static final int KDF_N739_FCOMPATIBLE_COFACTOR = 7;
    private static final int a = 1;
    private static final int b = 2;
    private static final int c = 4;
    private Ecc4145 a;
    private Gost34311 a;
    private static final byte[] a = new byte[]{0, 0, 0, 1, 48, 25, 48, 15, 6, 11, 42, -122, 36, 2, 1, 1, 1, 1, 1, 1, 5, 5, 0, -94, 6, 4, 4, 0, 0, 1, 0};
    private static final byte[] b = new byte[]{0, 0, 0, 1, 48, 93, 48, 15, 6, 11, 42, -122, 36, 2, 1, 1, 1, 1, 1, 1, 5, 5, 0, -96, 66, 4, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -94, 6, 4, 4, 0, 0, 1, 0};

    public EcDHKD(int n2, int n3, int n4, int n5, int n6, int[] nArray, BigInteger bigInteger, EcPoint ecPoint, byte[] byArray, byte[] byArray2, boolean bl, Random random) {
        if (random == null) {
            random = new Prng4145A();
        }
        this.a = new Gost34311(byArray, byArray2, bl);
        this.a = new Ecc4145(random);
        if (!this.a.SetBaseField(n2, n3, n4, n5)) {
            throw new IllegalArgumentException("Invalid Base Field");
        }
        if (!this.a.SetCurve(n6, nArray, bigInteger)) {
            throw new IllegalArgumentException("Invalid Curve");
        }
        if (!this.a.SetBasePoint(ecPoint)) {
            throw new IllegalArgumentException("Invalid Base Point");
        }
    }

    public EcDHKD(int n2, int n3, int n4, int n5, int n6, int[] nArray, BigInteger bigInteger, EcPoint ecPoint, byte[] byArray, byte[] byArray2, Random random) {
        this(n2, n3, n4, n5, n6, nArray, bigInteger, ecPoint, byArray, byArray2, false, random);
    }

    public EcDHKD(int n2, boolean bl, EcPoint ecPoint, byte[] byArray, byte[] byArray2, boolean bl2, Random random) {
        if (random == null) {
            random = new Prng4145A();
        }
        this.a = new Gost34311(byArray, byArray2, bl2);
        this.a = new Ecc4145(random);
        if (!this.a.SetStdCurve(n2, bl)) {
            throw new IllegalArgumentException("Invalid Base Field");
        }
        if (ecPoint == null) {
            if (!this.a.SetStdBasePoint()) {
                throw new IllegalArgumentException("No Standard Base Point");
            }
        } else if (!this.a.SetBasePoint(ecPoint)) {
            throw new IllegalArgumentException("Invalid Base Point");
        }
    }

    public EcDHKD(int n2, boolean bl, EcPoint ecPoint, byte[] byArray, byte[] byArray2, Random random) {
        this(n2, bl, ecPoint, byArray, byArray2, false, random);
    }

    public EcDHKD(Ecc4145 ecc4145, byte[] byArray, boolean bl) {
        this.a = new Gost34311(byArray, null, bl);
        this.a = new Ecc4145(new Prng4145A());
        int[] nArray = ecc4145.GetBaseField();
        if (!this.a.SetBaseField(nArray[0], nArray[1], nArray[2], nArray[3])) {
            throw new IllegalArgumentException("Invalid Base Field");
        }
        Object[] objectArray = ecc4145.GetCurve();
        if (!this.a.SetCurve((Integer)objectArray[0], (int[])objectArray[1], (BigInteger)objectArray[2])) {
            throw new IllegalArgumentException("Invalid Curve");
        }
        if (!this.a.SetBasePoint(ecc4145.GetBasePoint())) {
            throw new IllegalArgumentException("Invalid Base Point");
        }
    }

    public EcDHKD(Ecc4145 ecc4145, byte[] byArray) {
        this(ecc4145, byArray, false);
    }

    public EcDHKD(int n2, boolean bl, EcPoint ecPoint) {
        this(n2, bl, ecPoint, null, null, null);
    }

    public static int[] getElement(String string) {
        return BaseField.getElement(string);
    }

    public static int[] getElementLSB(byte[] byArray) {
        return BaseField.getElementLSB(byArray);
    }

    public static int[] getElementMSB(byte[] byArray) {
        return BaseField.getElement(byArray, byArray.length);
    }

    public int[] fromByteArrayEl(byte[] byArray) {
        return BaseField.getElement(byArray, byArray.length);
    }

    public byte[] toByteArray(int[] nArray) {
        return this.a.toByteArray(nArray);
    }

    public byte[] toByteArrayLsb(int[] nArray) {
        byte[] byArray = this.a.toByteArray(nArray);
        EcDHKD.a(byArray);
        return byArray;
    }

    public boolean VerifyParams(int n2) {
        return this.a.VerifyParams(n2);
    }

    public int[] ShrinkPoint(EcPoint ecPoint) {
        return this.a.ShrinkPoint(ecPoint);
    }

    public EcPoint ExpandPoint(int[] nArray) {
        return this.a.ExpandPoint(nArray);
    }

    public Ecc4145 GetInternalEcc() {
        return this.a;
    }

    private byte[] a(int[] nArray, int n2) {
        int n3 = this.a.BaseSize + 1;
        n3 = n3 + 31 & 0xFFFFFFE0;
        byte[] byArray = BaseField.toByteArrayLSB(nArray, n3);
        byArray[n3 - 1] = (byte)n2;
        this.a.Hash(byArray, n3);
        return this.a.HashEnd();
    }

    public Object[] DeriveKeySend(EcPoint ecPoint) {
        BigInteger bigInteger = this.a.GeneratePrivateKey();
        EcPoint ecPoint2 = this.a.ScalarMul(bigInteger, this.a.a);
        EcPoint ecPoint3 = this.a.ScalarMul(bigInteger, ecPoint);
        byte[] byArray = this.a(ecPoint3.x, 0);
        byte[] byArray2 = this.a(ecPoint3.x, 1);
        return new Object[]{byArray, byArray2, ecPoint2};
    }

    public Object[] DeriveKeyReceive(EcPoint ecPoint, BigInteger bigInteger) {
        int n2;
        if (!this.a.VerifyPublicKey(ecPoint)) {
            return null;
        }
        EcPoint ecPoint2 = this.a.ScalarMul(bigInteger, ecPoint);
        byte[] byArray = this.a(ecPoint2.x, 0);
        byte[] byArray2 = this.a(ecPoint2.x, 1);
        for (n2 = 0; n2 < 16; ++n2) {
            ecPoint2.x[n2] = 0;
        }
        for (n2 = 0; n2 < 16; ++n2) {
            ecPoint2.y[n2] = 0;
        }
        return new Object[]{byArray, byArray2};
    }

    private static void a(byte[] byArray) {
        for (int i2 = 0; i2 < byArray.length / 2; ++i2) {
            byte by = byArray[i2];
            byArray[i2] = byArray[byArray.length - i2 - 1];
            byArray[byArray.length - i2 - 1] = by;
        }
    }

    private void a(EcPoint ecPoint) {
        int n2 = this.a.GetBaseField()[0];
        int n3 = (n2 + 7) / 8;
        BigInteger bigInteger = (BigInteger)this.a.GetCurve()[2];
        byte[] byArray = bigInteger.toByteArray();
        EcDHKD.a(byArray);
        byte[] byArray2 = new byte[64];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        int n4 = (byArray2[n3 - 1] & 0xFF) * 256 + (byArray2[n3 - 2] & 0xFF);
        int n5 = 1 << (n2 & 7) + 8;
        for (int i2 = n5 / n4; i2 > 1; i2 >>= 1) {
            this.a.AfSum(ecPoint, ecPoint);
        }
    }

    public byte[] DeriveKey(EcPoint ecPoint, BigInteger bigInteger, boolean bl, byte[] byArray) {
        int n2 = bl ? 3 : 2;
        return this.DeriveKeyEx(ecPoint, bigInteger, n2, byArray);
    }

    public byte[] DeriveKeyEx(EcPoint ecPoint, BigInteger bigInteger, int n2, byte[] byArray) {
        int n3;
        EcPoint ecPoint2 = ecPoint.newCopy();
        if ((n2 & 1) != 0) {
            this.a(ecPoint2);
            if (!this.a.VerifyPublicKeyPartial(ecPoint2)) {
                return null;
            }
        } else if (!this.a.VerifyPublicKey(ecPoint2)) {
            return null;
        }
        ecPoint2 = this.a.ScalarMul(bigInteger, ecPoint2);
        byte[] byArray2 = this.a.toByteArray(ecPoint2.x);
        if ((n2 & 2) != 0) {
            for (n3 = 0; byArray2[n3] == 0 && n3 < byArray2.length - 1; ++n3) {
            }
        }
        if ((n2 & 4) != 0 && n3 != 0) {
            return null;
        }
        this.a.Hash(byArray2, n3, byArray2.length - n3);
        if (byArray == null) {
            this.a.Hash(a, a.length);
        } else {
            if (byArray.length < 64) {
                this.a.Clear();
                return null;
            }
            this.a.Hash(b, 0, 27);
            this.a.Hash(byArray, 64);
            this.a.Hash(b, 91, 8);
        }
        ecPoint2.Cleanup();
        for (int i2 = 0; i2 < byArray2.length; ++i2) {
            byArray2[i2] = 0;
        }
        return this.a.HashEnd();
    }
}

