/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor;

import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import ua.avtor.Consts;
import ua.avtor.GOST28147AlgorithmParameterSpec;
import ua.avtor.GOST28147Key;
import ua.kiev.author.cryptolib.Gost28147;

public class GOST28147MAC
extends MacSpi {
    Gost28147 a = null;

    public String getAlgorithm() {
        return "GOST28147";
    }

    @Override
    public int engineGetMacLength() {
        return 8;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.a = new Gost28147();
        this.a.ClearSync();
        if (!(key instanceof GOST28147Key)) {
            throw new InvalidKeyException(Consts.GetMsgError(7));
        }
        Serializable serializable = (GOST28147Key)key;
        this.a.SetKey(((GOST28147Key)serializable).keyData);
        if (algorithmParameterSpec != null) {
            if (algorithmParameterSpec instanceof GOST28147AlgorithmParameterSpec) {
                this.a.SetSBox(((GOST28147AlgorithmParameterSpec)algorithmParameterSpec).getSBox());
                return;
            } else {
                serializable = GOST28147AlgorithmParameterSpec.copyInstance(algorithmParameterSpec);
                if (serializable == null) throw new InvalidAlgorithmParameterException(Consts.GetMsgError(16));
                this.a.SetSBox(((GOST28147AlgorithmParameterSpec)serializable).getSBox());
            }
            return;
        } else {
            this.a.SetSBox(Consts.a);
        }
    }

    @Override
    public void engineUpdate(byte by) throws IllegalStateException {
        byte[] byArray = new byte[]{by};
        if (this.a == null) {
            throw new IllegalStateException(Consts.GetMsgError(19));
        }
        this.a.MAC(byArray, 0, 1);
    }

    @Override
    public void engineUpdate(byte[] byArray, int n2, int n3) throws IllegalStateException {
        if (this.a == null) {
            throw new IllegalStateException(Consts.GetMsgError(19));
        }
        this.a.MAC(byArray, n2, n3);
    }

    @Override
    public byte[] engineDoFinal() throws IllegalStateException {
        if (this.a == null) {
            throw new IllegalStateException(Consts.GetMsgError(19));
        }
        byte[] byArray = new byte[8];
        this.a.GetMAC8(byArray);
        return byArray;
    }

    @Override
    public final void engineReset() {
        if (this.a == null) {
            throw new IllegalStateException(Consts.GetMsgError(19));
        }
        this.a.ClearSync();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

