/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor;

import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.SecretKeySpec;
import ua.avtor.Consts;
import ua.avtor.GOST28147Key;
import ua.avtor.GOST28147KeySpec;

public final class GOST28147KeyFactory
extends SecretKeyFactorySpi {
    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof GOST28147KeySpec) {
            GOST28147KeySpec gOST28147KeySpec = (GOST28147KeySpec)keySpec;
            return new GOST28147Key(gOST28147KeySpec.a, gOST28147KeySpec.b);
        }
        if (keySpec instanceof SecretKeySpec) {
            SecretKeySpec secretKeySpec = (SecretKeySpec)keySpec;
            if (!secretKeySpec.getAlgorithm().equalsIgnoreCase("GOST28147")) {
                throw new InvalidKeySpecException(Consts.GetMsgError(7));
            }
            return new GOST28147Key(secretKeySpec.getEncoded());
        }
        throw new InvalidKeySpecException(Consts.GetMsgError(7));
    }

    protected KeySpec engineGetKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        if (!secretKey.getAlgorithm().equalsIgnoreCase("GOST28147") || !secretKey.getFormat().equalsIgnoreCase("RAW")) {
            throw new InvalidKeySpecException("Invalid key type");
        }
        if (GOST28147KeySpec.class.isAssignableFrom(clazz) && secretKey instanceof GOST28147Key) {
            GOST28147Key gOST28147Key = (GOST28147Key)secretKey;
            GOST28147KeySpec gOST28147KeySpec = new GOST28147KeySpec(gOST28147Key.keyData, null);
            gOST28147KeySpec.b = gOST28147Key.pSBox;
            return gOST28147KeySpec;
        }
        throw new InvalidKeySpecException("Invalid key type/spec");
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
        if (!secretKey.getAlgorithm().equalsIgnoreCase("GOST28147") || !secretKey.getFormat().equalsIgnoreCase("RAW")) {
            throw new InvalidKeyException("Invalid key type");
        }
        return new GOST28147Key(secretKey.getEncoded());
    }
}

