/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import ua.avtor.Consts;
import ua.avtor.DSTU4145PublicKey;

public final class GOST28147AlgorithmParameterSpec
implements Serializable,
AlgorithmParameterSpec {
    private static final long serialVersionUID = 1005324146939615607L;
    byte[] sBox = new byte[64];
    byte[] sync = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    boolean explicitSBox = false;

    static GOST28147AlgorithmParameterSpec copyInstance(Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(252);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object2 = objectInputStream.readObject();
            objectInputStream.close();
            return (GOST28147AlgorithmParameterSpec)object2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public GOST28147AlgorithmParameterSpec(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            Arrays.fill(this.sync, (byte)0);
        } else {
            int n2 = 0;
            if (byArray.length == 10 && byArray[0] == 4 && byArray[1] == 8) {
                n2 = 2;
            }
            System.arraycopy(byArray, n2, this.sync, 0, 8);
        }
        if (byArray2 == null) {
            System.arraycopy(Consts.a, 0, this.sBox, 0, 64);
        } else {
            this.explicitSBox = true;
            if (byArray2.length == 64) {
                System.arraycopy(byArray2, 0, this.sBox, 0, 64);
            } else if (byArray2.length == 66) {
                this.sBox = DSTU4145PublicKey.UnPackUz(Arrays.copyOfRange(byArray2, 2, 66));
            } else if (byArray2.length == 131) {
                this.sBox = DSTU4145PublicKey.UnPackUz(Arrays.copyOfRange(byArray2, 3, 131));
            }
        }
    }

    private void a(byte[] byArray) throws IOException {
        if (byArray.length == 8) {
            System.arraycopy(byArray, 0, this.sync, 0, 8);
            System.arraycopy(Consts.a, 0, this.sBox, 0, 64);
        } else if (byArray.length == 64 || byArray.length == 128) {
            this.explicitSBox = true;
            this.sBox = DSTU4145PublicKey.UnPackUz(byArray);
        } else {
            throw new IOException();
        }
    }

    public GOST28147AlgorithmParameterSpec(byte[] byArray) {
        if (byArray == null || byArray.length < 2) {
            throw new IllegalArgumentException("data missing");
        }
        if (byArray.length == 2 && byArray[0] == 5 && byArray[1] == 0) {
            System.arraycopy(Consts.a, 0, this.sBox, 0, 64);
            return;
        }
        try {
            if (byArray[0] == 4) {
                DerInputStream derInputStream = new DerInputStream(byArray);
                this.a(derInputStream.getOctetString());
                return;
            }
            DerInputStream derInputStream = new DerInputStream(byArray);
            DerValue[] derValueArray = derInputStream.getSequence(3);
            if (derValueArray.length < 1 || derValueArray.length > 2) {
                throw new IOException();
            }
            if (derValueArray.length == 1) {
                this.a(derValueArray[0].getOctetString());
            } else {
                if (derValueArray[0].tag != 5) {
                    if (derValueArray[0].length() != 8) {
                        throw new IOException();
                    }
                    System.arraycopy(derValueArray[0].getOctetString(), 0, this.sync, 0, 8);
                }
                if (derValueArray[1].length() != 64 && derValueArray[1].length() != 128) {
                    throw new IOException();
                }
                this.explicitSBox = true;
                this.sBox = DSTU4145PublicKey.UnPackUz(derValueArray[1].getOctetString());
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("bad data format");
        }
    }

    byte[] getSBox() {
        return (byte[])this.sBox.clone();
    }

    byte[] getSync() {
        return (byte[])this.sync.clone();
    }

    public byte[] getDerEncoded() {
        byte[] byArray = new byte[78];
        byArray[0] = 48;
        byArray[1] = 76;
        byArray[2] = 4;
        byArray[3] = 8;
        System.arraycopy(this.sync, 0, byArray, 4, 8);
        byArray[12] = 4;
        byArray[13] = 64;
        System.arraycopy(DSTU4145PublicKey.UzCrlToCert(this.sBox), 0, byArray, 14, 64);
        return byArray;
    }
}

