/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor.DsLib.Utils;

public class Pointer {
    private byte[] data = null;
    private int pos = 0;

    public Pointer(byte[] byArray) {
        this.data = byArray;
    }

    public Pointer(byte[] byArray, int n2) {
        this.data = byArray;
        this.pos = n2;
    }

    int getPosition() {
        return this.pos;
    }

    public void SetPosition(int n2) {
        this.pos = n2;
    }

    byte[] getData() {
        return this.data;
    }

    public byte[] Copy(int n2) {
        if (n2 == -1) {
            return this.data;
        }
        if (n2 == 0) {
            return null;
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.data, this.pos, byArray, 0, n2);
        return byArray;
    }

    public void CopyTo(byte[] byArray, int n2, int n3) {
        System.arraycopy(this.data, this.pos, byArray, n2, n3);
    }

    public void Add(byte[] byArray) {
        byte[] byArray2 = this.data;
        this.data = new byte[this.data.length + byArray.length];
        System.arraycopy(byArray2, 0, this.data, 0, byArray2.length);
        System.arraycopy(byArray, 0, this.data, this.data.length - byArray.length, byArray.length);
    }

    public void UpdateData(Pointer pointer, int n2) {
        System.arraycopy(pointer.Copy(n2), 0, this.data, this.pos, n2);
    }

    public void UpdateData(byte[] byArray, int n2) {
        if (n2 != 0) {
            System.arraycopy(byArray, 0, this.data, this.pos, n2);
        }
    }

    public int Get() {
        return this.data[this.pos] & 0xFF;
    }

    public int Get(int n2) {
        return this.data[this.pos + n2] & 0xFF;
    }

    public void Set(byte by) {
        this.data[this.pos] = by;
    }

    public Pointer Next() {
        ++this.pos;
        return this;
    }

    public Pointer Next(int n2) {
        this.pos += n2;
        return this;
    }

    public Pointer Prev() {
        --this.pos;
        return this;
    }

    public Pointer Prev(int n2) {
        this.pos -= n2;
        return this;
    }

    public boolean CompareTo(byte[] byArray) {
        if (this.data == null || byArray == null) {
            return false;
        }
        if (this.data.length - this.pos < byArray.length) {
            return false;
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (this.data[this.pos + i2] == byArray[i2]) continue;
            return false;
        }
        return true;
    }

    public Pointer ClonePos(int n2) {
        return new Pointer(this.data, this.pos + n2);
    }

    public boolean isNULL() {
        return this.data == null;
    }
}

