/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor.DsLib.Utils;

import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.TimeZone;
import ua.avtor.DsLib.Utils.Ddec;
import ua.avtor.DsLib.Utils.Pointer;

public class DerEncoder {
    private Pointer boxPtr;
    private Pointer pStart;
    private Pointer pOut;
    private int boxSize = 768;
    private int[] seqLst = new int[30];
    private int seqDeep = 0;

    public DerEncoder() {
        this.boxPtr = new Pointer(new byte[this.boxSize]);
        this.pStart = this.boxPtr.ClonePos(0);
        this.pOut = this.pStart.ClonePos(0);
    }

    public final int getSize() {
        return this.pOut.getPosition() - this.pStart.getPosition();
    }

    public final byte[] getEncoded() {
        return this.pStart.Copy(this.getSize());
    }

    public final void SpecificBegin(byte by) {
        this.enlarge(0);
        ++this.seqDeep;
        this.seqLst[this.seqDeep] = this.getSize();
        this.pOut.Set(by);
        this.pOut.Next();
        this.pOut.Set((byte)-128);
        this.pOut.Next();
    }

    public final void SpecificEnd() {
        if (this.seqDeep == 0) {
            return;
        }
        int n2 = this.getSize() - this.seqLst[this.seqDeep] - 2;
        this.correctLength(this.seqLst[this.seqDeep], n2);
        --this.seqDeep;
    }

    public final void SpecificStop() {
        if (this.seqDeep == 0) {
            return;
        }
        this.enlarge(0);
        this.pStart.Next(this.seqLst[this.seqDeep] + 1).Set((byte)-128);
        this.pStart.Prev(this.seqLst[this.seqDeep] + 1);
        this.pOut.Set((byte)0);
        this.pOut.Next();
        this.pOut.Set((byte)0);
        this.pOut.Next();
        --this.seqDeep;
    }

    public final void SeqBegin() {
        this.SpecificBegin((byte)48);
    }

    public final void SeqEnd() {
        this.SpecificEnd();
    }

    public final void SeqStop() {
        this.SpecificStop();
    }

    public final void SetBegin() {
        this.SpecificBegin((byte)49);
    }

    public final void SetEnd() {
        this.SpecificEnd();
    }

    public final void OctetBegin() {
        this.SpecificBegin((byte)4);
    }

    public final void OctetEnd() {
        this.SpecificEnd();
    }

    public final void BitstringBegin() {
        this.SpecificBegin((byte)3);
        this.pOut.Set((byte)0);
        this.pOut.Next();
    }

    public final void BitstringEnd() {
        this.SpecificEnd();
    }

    public final void addInteger(int n2) {
        byte[] byArray = new byte[]{(byte)n2, (byte)(n2 >> 8), (byte)(n2 >> 16), (byte)(n2 >> 24)};
        this.addSignedBigintLSB(byArray, 4);
    }

    public final void addOctets(byte[] byArray) {
        this.addSpecific((byte)4, byArray);
    }

    public final void addOctetsReverse(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        for (int i2 = 0; i2 < byArray2.length; ++i2) {
            byArray2[i2] = byArray[byArray2.length - 1 - i2];
        }
        this.addSpecific((byte)4, byArray2);
    }

    public final void addBitstring(byte[] byArray, int n2, int n3) {
        this.enlarge(n2);
        this.pOut.Set((byte)3);
        this.pOut.Next();
        this.addLength(n2 + 1);
        this.pOut.Set((byte)n3);
        this.pOut.Next();
        this.pOut.UpdateData(byArray, n2);
        this.pOut.Next(n2);
    }

    public final void addBitstringReverse(byte[] byArray, int n2, int n3) {
        this.enlarge(n2);
        this.pOut.Set((byte)3);
        this.pOut.Next();
        this.addLength(n2 + 1);
        this.pOut.Set((byte)n3);
        this.pOut.Next();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            this.pOut.Set(byArray[i2]);
            this.pOut.Next();
        }
    }

    public final void addBigintLSB(byte[] byArray) {
        int n2;
        this.enlarge(n2);
        this.pOut.Set((byte)2);
        this.pOut.Next();
        for (n2 = byArray.length; n2 > 1 && byArray[n2 - 1] == 0; --n2) {
        }
        int n3 = byArray[n2 - 1] >> 7 & 1;
        this.addLength(n3 + n2);
        if (n3 != 0) {
            this.pOut.Set((byte)0);
            this.pOut.Next();
        }
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            this.pOut.Set(byArray[i2]);
            this.pOut.Next();
        }
    }

    public final void addBigintMSB(byte[] byArray) {
        int n2;
        Pointer pointer = new Pointer(byArray);
        this.enlarge(n2);
        this.pOut.Set((byte)2);
        this.pOut.Next();
        for (n2 = byArray.length; n2 > 1 && pointer.Get() == 0; --n2) {
            pointer.Next();
        }
        int n3 = 1;
        if (n2 > 0) {
            n3 = (pointer.Get() & 0xFF) >> 7 & 1;
        }
        this.addLength(n3 + n2);
        if (n3 != 0) {
            this.pOut.Set((byte)0);
            this.pOut.Next();
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.pOut.Set((byte)pointer.Get(i2));
            this.pOut.Next();
        }
    }

    public final void addSpecific(byte by, String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.addSpecific(by, byArray);
    }

    public final void addSpecific(byte by, byte[] byArray) {
        int n2 = 0;
        if (byArray != null) {
            n2 = byArray.length;
        }
        this.addSpecific(by, byArray, n2);
    }

    public final void addSpecific(byte by, byte[] byArray, int n2) {
        this.enlarge(n2);
        this.pOut.Set(by);
        this.pOut.Next();
        this.addLength(n2);
        this.pOut.UpdateData(byArray, n2);
        this.pOut.Next(n2);
    }

    public final void addOid(String string) {
        this.enlarge(64);
        int n2 = this.getSize();
        this.pOut.Set((byte)6);
        this.pOut.Next();
        this.pOut.Set((byte)0);
        this.pOut.Next();
        int n3 = this.oidstr2Octets(string, this.pOut.ClonePos(0));
        this.pOut.Next(n3);
        this.correctLength(n2, n3);
    }

    public final void addTime(long l2) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.setTimeInMillis(l2);
        Pointer pointer = new Pointer(new byte[0]);
        try {
            pointer.Add(new DecimalFormat("0000").format(calendar.get(1)).getBytes("UTF8"));
            pointer.Add(new DecimalFormat("00").format(calendar.get(2) + 1).getBytes("UTF8"));
            pointer.Add(new DecimalFormat("00").format(calendar.get(5)).getBytes("UTF8"));
            pointer.Add(new DecimalFormat("00").format(calendar.get(10)).getBytes("UTF8"));
            pointer.Add(new DecimalFormat("00").format(calendar.get(12)).getBytes("UTF8"));
            pointer.Add(new DecimalFormat("00").format(calendar.get(13)).getBytes("UTF8"));
            pointer.Add("Z".getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        if (calendar.get(1) > 2049 || calendar.get(1) < 1950) {
            this.addSpecific((byte)24, pointer.Copy(15));
        } else {
            this.addSpecific((byte)23, pointer.Next(2).Copy(13));
        }
    }

    public final void addObject(byte[] byArray) {
        int n2 = byArray.length;
        this.enlarge(n2);
        this.pOut.UpdateData(byArray, n2);
        this.pOut.Next(n2);
    }

    public final void addObject(byte[] byArray, int n2) {
        this.enlarge(n2);
        this.pOut.UpdateData(byArray, n2);
        this.pOut.Next(n2);
    }

    public final void addObjectImplicit(byte by, byte[] byArray) {
        int n2 = byArray.length;
        this.enlarge(n2);
        this.pOut.UpdateData(byArray, n2);
        this.pOut.Set(by);
        this.pOut.Next(n2);
    }

    public final void addDerParams(byte[] byArray) {
        int n2 = Ddec.DerGetTotalSize(byArray);
        if (n2 > 0) {
            this.addObject(byArray, n2);
        }
    }

    public final void addBool(boolean bl) {
        this.enlarge(1);
        this.pOut.Set((byte)1);
        this.pOut.Next();
        this.pOut.Set((byte)1);
        this.pOut.Next();
        this.pOut.Set((byte)(bl ? 255 : 0));
        this.pOut.Next();
    }

    public final void addNull() {
        this.enlarge(0);
        this.pOut.Set((byte)5);
        this.pOut.Next();
        this.pOut.Set((byte)0);
        this.pOut.Next();
    }

    private void addSignedBigintLSB(byte[] byArray, int n2) {
        byte[] byArray2 = byArray;
        this.enlarge(n2);
        this.pOut.Set((byte)2);
        this.pOut.Next();
        if ((byArray2[n2 - 1] & 0xFF & 0x80) == 0) {
            while (n2 > 1 && byArray2[n2 - 1] == 0 && (byArray2[n2 - 2] & 0xFF & 0x80) == 0) {
                --n2;
            }
        } else {
            while (n2 > 1 && (byArray2[n2 - 1] & 0xFF) == 255 && (byArray2[n2 - 2] & 0xFF & 0x80) != 0) {
                --n2;
            }
        }
        this.addLength(n2);
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            this.pOut.Set(byArray2[i2]);
            this.pOut.Next();
        }
    }

    private void enlarge(int n2) {
        int n3 = this.getSize();
        if (n3 + n2 + 30 < this.boxSize) {
            return;
        }
        int n4 = this.boxSize + n2 + 2048;
        byte[] byArray = new byte[n4];
        System.arraycopy(this.boxPtr.getData(), 0, byArray, 0, this.boxPtr.getData().length);
        this.boxPtr = new Pointer(byArray);
        this.boxSize = n4;
        this.pStart = this.boxPtr.ClonePos(0);
        this.pOut = this.boxPtr.ClonePos(n3);
    }

    private int addLength(int n2) {
        if (n2 <= 127) {
            this.pOut.Set((byte)n2);
            this.pOut.Next();
            return 1;
        }
        if (n2 <= 255) {
            this.pOut.Set((byte)-127);
            this.pOut.Next();
            this.pOut.Set((byte)n2);
            this.pOut.Next();
            return 2;
        }
        if (n2 <= 65535) {
            this.pOut.Set((byte)-126);
            this.pOut.Next();
            this.pOut.Set((byte)(n2 >> 8));
            this.pOut.Next();
            this.pOut.Set((byte)n2);
            this.pOut.Next();
            return 3;
        }
        if (n2 <= 0xFFFFFF) {
            this.pOut.Set((byte)-125);
            this.pOut.Next();
            this.pOut.Set((byte)(n2 >> 16));
            this.pOut.Next();
            this.pOut.Set((byte)(n2 >> 8));
            this.pOut.Next();
            this.pOut.Set((byte)n2);
            this.pOut.Next();
            return 4;
        }
        this.pOut.Set((byte)-124);
        this.pOut.Next();
        this.pOut.Set((byte)(n2 >> 24));
        this.pOut.Next();
        this.pOut.Set((byte)(n2 >> 16));
        this.pOut.Next();
        this.pOut.Set((byte)(n2 >> 8));
        this.pOut.Next();
        this.pOut.Set((byte)n2);
        this.pOut.Next();
        return 5;
    }

    private int correctLength(int n2, int n3) {
        Pointer pointer = new Pointer(new byte[5]);
        Pointer pointer2 = this.pOut;
        this.pOut = pointer.ClonePos(0);
        int n4 = this.addLength(n3);
        int n5 = n4 - 1;
        this.pOut = pointer2;
        Pointer pointer3 = this.pStart.ClonePos(n2 + 2);
        Pointer pointer4 = pointer3.ClonePos(n5);
        if (n5 != 0) {
            this.pOut.Next(n5);
            pointer4.UpdateData(pointer3, n3);
        }
        pointer3.Prev().UpdateData(pointer, n4);
        pointer3.Next();
        return n4;
    }

    private int oidstr2Octets(String string, Pointer pointer) {
        int n2 = pointer.getPosition();
        int n3 = 2;
        int n4 = string.charAt(0) - 48;
        int n5 = 0;
        while (n3 != string.length()) {
            while (n3 != string.length() && string.charAt(n3) != '.') {
                n5 = n5 * 10 + (string.charAt(n3) - 48);
                ++n3;
            }
            if (n3 != string.length() && string.charAt(n3) == '.') {
                ++n3;
            }
            for (int i2 = 4; i2 >= 1; --i2) {
                if (n5 >> i2 * 7 == 0) continue;
                pointer.Set((byte)(n5 >> i2 * 7 & 0x7F | 0x80));
                pointer.Next();
            }
            if (n4 >= 0) {
                n5 += n4 * 40;
            }
            pointer.Set((byte)(n5 & 0x7F));
            pointer.Next();
            n5 = 0;
            n4 = -1;
        }
        return pointer.getPosition() - n2;
    }
}

