/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor.DsLib.Utils;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;
import ua.avtor.DsLib.Utils.ArrayUtil;
import ua.avtor.DsLib.Utils.DdecException;
import ua.avtor.DsLib.Utils.Pointer;
import ua.avtor.DsLib.Utils.Two;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ddec {
    public static int DerGetTotalSize(Pointer pointer) {
        if (pointer.isNULL()) {
            return 0;
        }
        Pointer pointer2 = pointer;
        int n2 = pointer2.Get(1);
        if (n2 < 128) {
            return 2 + (n2 & 0x7F);
        }
        if (n2 == 128) {
            return 2 + Ddec.DdecGetObjLen(pointer2.ClonePos(1));
        }
        if (n2 == 129) {
            return 3 + pointer2.Get(2);
        }
        if (n2 == 130) {
            return 4 + pointer2.Get(2) * 256 + pointer2.Get(3);
        }
        if (n2 == 131) {
            return 5 + pointer2.Get(2) * 65536 + pointer2.Get(3) * 256 + pointer2.Get(4);
        }
        if (n2 == 132) {
            return 6 + pointer2.Get(2) * 0x1000000 + pointer2.Get(3) * 65536 + pointer2.Get(4) * 256 + pointer2.Get(5);
        }
        return 0;
    }

    public static int DerGetTotalSize(byte[] byArray) {
        if (byArray == null || byArray.length < 2) {
            return 0;
        }
        byte[] byArray2 = byArray;
        if ((byArray2[1] & 0xFF) < 128) {
            return 2 + (byArray2[1] & 0x7F);
        }
        if ((byArray2[1] & 0xFF) == 128) {
            Pointer pointer = new Pointer(byArray, 1);
            return 2 + Ddec.DdecGetObjLen(pointer);
        }
        if ((byArray2[1] & 0xFF) == 129) {
            return 3 + (byArray2[2] & 0xFF);
        }
        if ((byArray2[1] & 0xFF) == 130) {
            return 4 + (byArray2[2] & 0xFF) * 256 + (byArray2[3] & 0xFF);
        }
        if ((byArray2[1] & 0xFF) == 131) {
            return 5 + (byArray2[2] & 0xFF) * 65536 + (byArray2[3] & 0xFF) * 256 + (byArray2[4] & 0xFF);
        }
        if ((byArray2[1] & 0xFF) == 132) {
            return 6 + (byArray2[2] & 0xFF) * 0x1000000 + (byArray2[3] & 0xFF) * 65536 + (byArray2[4] & 0xFF) * 256 + (byArray2[5] & 0xFF);
        }
        return 0;
    }

    private static int DdecGetObjLen(Pointer pointer) {
        int n2 = pointer.Get();
        pointer.Next();
        if ((n2 & 0x80) == 0) {
            return n2;
        }
        if ((n2 & 0xFF) == 128) {
            Pointer pointer2 = pointer.ClonePos(0);
            int n3 = 2;
            while (pointer2.Get() != 0) {
                int n4 = Ddec.DerGetTotalSize(pointer2);
                n3 += n4;
                pointer2.Next(n4);
            }
            if (pointer2.Get(1) != 0) {
                return 0;
            }
            return n3;
        }
        if ((n2 &= 0x7F) <= 4) {
            int n5 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                n5 *= 256;
                n5 += pointer.Get();
                pointer.Next();
            }
            return n5;
        }
        return 0;
    }

    private static int DdecPickTag(Pointer pointer, int n2) {
        Pointer pointer2 = pointer.ClonePos(0);
        if (n2 > 127) {
            pointer2.Prev();
        }
        if (n2 > 255) {
            pointer2.Prev();
        }
        if (n2 > 65535) {
            pointer2.Prev();
        }
        if (n2 > 0xFFFFFF) {
            pointer2.Prev();
        }
        return pointer2.Prev(2).Get();
    }

    private static byte[] DerOidstrToOctets(String string) {
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        int n2 = 2;
        int n3 = string.charAt(0) - 48;
        int n4 = 0;
        int n5 = string.length();
        while (n2 < n5) {
            while (n2 < n5 && string.charAt(n2) != '.') {
                n4 = n4 * 10 + (string.charAt(n2) - 48);
                ++n2;
            }
            ++n2;
            for (int i2 = 4; i2 >= 1; --i2) {
                if (n4 >> i2 * 7 == 0) continue;
                arrayList.add((byte)(n4 >> i2 * 7 & 0x7F | 0x80));
            }
            if (n3 >= 0) {
                n4 += n3 * 40;
            }
            arrayList.add((byte)(n4 & 0x7F));
            n4 = 0;
            n3 = -1;
        }
        byte[] byArray = new byte[arrayList.size()];
        for (int i3 = 0; i3 < byArray.length; ++i3) {
            byArray[i3] = (Byte)arrayList.get(i3);
        }
        return byArray;
    }

    public static byte[] DerEncodeOid(String string) {
        byte[] byArray = Ddec.DerOidstrToOctets(string);
        if (byArray.length == 0) {
            return null;
        }
        byte[] byArray2 = new byte[2 + byArray.length];
        byArray2[0] = 6;
        byArray2[1] = (byte)byArray.length;
        System.arraycopy(byArray, 0, byArray2, 2, byArray.length);
        return byArray2;
    }

    public static boolean DerIsOidInCsvList(byte[] byArray, String string) {
        return Ddec.DerIsOidInCsvList(new Pointer(byArray), string);
    }

    public static boolean DerIsOidInCsvList(Pointer pointer, String string) {
        String[] stringArray;
        String string2;
        if (string == null) {
            return false;
        }
        try {
            string2 = Ddec.DerGetElementOid(pointer, "D");
        }
        catch (DdecException ddecException) {
            return false;
        }
        for (String string3 : stringArray = string.split("[, ]")) {
            if (!string3.equals(string2)) continue;
            return true;
        }
        return false;
    }

    private static int DdecEnter(Pointer pointer, char c2, int n2, int n3) throws DdecException {
        int n4;
        boolean bl;
        int n5 = pointer.Get();
        switch (c2) {
            case 'E': {
                boolean bl2 = bl = (n5 & 0xC0) != 0 && (n5 & 0x20) != 0;
                if (n2 < 0) break;
                bl = bl && (n5 & 0x1F) == n2;
                break;
            }
            case 'Y': {
                bl = (n5 & 0xC0) != 0 && (n5 & 0x1F) == n2;
                break;
            }
            case 'S': {
                bl = n5 == 48;
                break;
            }
            case 'U': {
                bl = n5 == 49;
                break;
            }
            case 'G': {
                bl = n5 == 3;
                break;
            }
            case 'Q': {
                bl = n5 == 4;
                break;
            }
            default: {
                throw new DdecException(-5);
            }
        }
        if (!bl) {
            throw new DdecException(-2);
        }
        pointer.Next();
        if (pointer.Get() == 128) {
            n4 = 0;
            pointer.Next();
        } else {
            n4 = Ddec.DdecGetObjLen(pointer);
            n3 = pointer.getPosition() + n4;
        }
        if (c2 == 'G' && n4 > 0) {
            pointer.Next();
        }
        return n3;
    }

    private static void DdecSkip(Pointer pointer, char c2, int n2, boolean bl, int n3) throws DdecException {
        int n4 = 1;
        if (c2 == 'x' && n2 > 0) {
            n4 = n2;
        }
        for (int i2 = 1; i2 <= n4; ++i2) {
            boolean bl2;
            if (pointer.getPosition() >= n3) {
                throw new DdecException(-3);
            }
            int n5 = pointer.Get();
            switch (c2) {
                case 'e': {
                    boolean bl3 = bl2 = (n5 & 0xC0) != 0 && (n5 & 0x20) != 0;
                    if (n2 < 0) break;
                    bl2 = bl2 && (n5 & 0x1F) == n2;
                    break;
                }
                case 's': {
                    bl2 = n5 == 48;
                    break;
                }
                case 'u': {
                    bl2 = n5 == 49;
                    break;
                }
                case 'y': {
                    bl2 = (n5 & 0xC0) != 0 && (n5 & 0x1F) == n2;
                    break;
                }
                case 'c': {
                    bl2 = n5 == 12 || n5 == 18 || n5 == 19 || n5 == 20 || n5 == 21 || n5 == 22 || n5 == 25 || n5 == 26 || n5 == 27 || n5 == 28 || n5 == 30;
                    break;
                }
                case 't': {
                    bl2 = n5 == 23 || n5 == 24;
                    break;
                }
                case 'b': {
                    bl2 = n5 == 1;
                    break;
                }
                case 'i': {
                    bl2 = n5 == 2;
                    break;
                }
                case 'g': {
                    bl2 = n5 == 3;
                    break;
                }
                case 'q': {
                    bl2 = n5 == 4;
                    break;
                }
                case 'n': {
                    bl2 = n5 == 5;
                    break;
                }
                case 'd': {
                    bl2 = n5 == 6;
                    break;
                }
                case 'r': {
                    bl2 = n5 == 9;
                    break;
                }
                case 'z': {
                    bl2 = n5 == 10;
                    break;
                }
                case 'x': {
                    bl2 = n5 != 0;
                    break;
                }
                default: {
                    throw new DdecException(-5);
                }
            }
            if (!bl2) {
                if (bl) break;
                throw new DdecException(-2);
            }
            pointer.Next();
            int n6 = Ddec.DdecGetObjLen(pointer);
            pointer.Next(n6);
        }
    }

    private static Two<Integer, Integer> DdecFindRdnSet(Pointer pointer, char c2, int n2, String string, int n3) throws DdecException {
        boolean bl = false;
        int n4 = 0;
        int n5 = 0;
        n3 = (c2 | 0x20) == 102 ? Ddec.DdecEnter(pointer, 'S', -1, n3) : Ddec.DdecEnter(pointer, 'U', -1, n3);
        int n6 = 0;
        while (n2 + n6 < string.length() && string.charAt(n2 + n6) == '.' || string.charAt(n2 + n6) >= '0' && string.charAt(n2 + n6) <= '9') {
            ++n6;
        }
        byte[] byArray = Ddec.DerOidstrToOctets(string.substring(n2, n2 + n6));
        n2 += n6;
        if (pointer.getPosition() < n3) {
            boolean bl2 = bl = pointer.Get() == 49;
        }
        while (pointer.getPosition() < n3) {
            if (!bl) {
                n4 = Ddec.DdecEnter(pointer, 'S', -1, n4);
            } else {
                n4 = Ddec.DdecEnter(pointer, 'U', -1, n4);
                n5 = Ddec.DdecEnter(pointer, 'S', -1, n5);
            }
            if (pointer.Get() == 6) {
                pointer.Next();
                int n7 = Ddec.DdecGetObjLen(pointer);
                if (n7 == byArray.length && pointer.CompareTo(byArray)) {
                    pointer.Next(n7);
                    n3 = n4;
                    return new Two<Integer, Integer>(n2, n3);
                }
            }
            pointer.SetPosition(n4);
        }
        throw new DdecException(-2);
    }

    private static Two<Pointer, Integer> DdecGetPtr(Pointer pointer, char c2, int n2, int n3) throws DdecException {
        boolean bl;
        int n4 = pointer.Get();
        switch (c2) {
            case 'C': 
            case 'c': {
                bl = n4 == 12 || n4 == 18 || n4 == 19 || n4 == 20 || n4 == 21 || n4 == 22 || n4 == 25 || n4 == 26 || n4 == 27 || n4 == 28 || n4 == 30;
                break;
            }
            case 'T': 
            case 't': {
                bl = n4 == 23 || n4 == 24;
                break;
            }
            case 'B': 
            case 'b': {
                bl = n4 == 1;
                break;
            }
            case 'I': 
            case 'i': {
                bl = n4 == 2;
                break;
            }
            case 'G': 
            case 'g': {
                bl = n4 == 3;
                break;
            }
            case 'Q': 
            case 'q': {
                bl = (n4 & 0xDF) == 4;
                break;
            }
            case 'N': 
            case 'n': {
                bl = n4 == 5;
                break;
            }
            case 'D': 
            case 'd': {
                bl = n4 == 6;
                break;
            }
            case 'R': 
            case 'r': {
                bl = n4 == 9;
                break;
            }
            case 'Z': 
            case 'z': {
                bl = n4 == 10;
                break;
            }
            case 'S': 
            case 's': {
                bl = n4 == 48;
                break;
            }
            case 'U': 
            case 'u': {
                bl = n4 == 49;
                break;
            }
            case 'E': 
            case 'e': {
                boolean bl2 = bl = (n4 & 0xC0) != 0 && (n4 & 0x20) != 0;
                if (n2 < 0) break;
                bl = bl && (n4 & 0x1F) == n2;
                break;
            }
            case 'Y': 
            case 'y': {
                bl = (n4 & 0xC0) != 0 && (n4 & 0x1F) == n2;
                break;
            }
            case 'X': 
            case 'x': {
                bl = n4 != 0;
                break;
            }
            default: {
                throw new DdecException(-5);
            }
        }
        if (!bl) {
            throw new DdecException(-1);
        }
        int n5 = pointer.getPosition();
        pointer.Next();
        int n6 = Ddec.DdecGetObjLen(pointer);
        if (c2 >= 'a') {
            n6 = pointer.getPosition() - n5 + n6;
        } else {
            if (n4 == 3) {
                pointer.Next();
                --n6;
            }
            n5 = pointer.getPosition();
        }
        if (n5 + n6 > n3) {
            throw new DdecException(-3);
        }
        Pointer pointer2 = pointer.ClonePos(0);
        pointer2.SetPosition(n5);
        int n7 = n6;
        if ((n4 & 0x20) != 0 && (c2 == 'Q' || c2 == 'Y')) {
            byte[] byArray = Ddec.DdecConstructCopy(pointer2, n7);
            return new Two<Pointer, Integer>(new Pointer(byArray), byArray.length);
        }
        return new Two<Pointer, Integer>(pointer2, n7);
    }

    static byte[] DdecConstructCopy(Pointer pointer, int n2) {
        int n3 = 0;
        int n4 = pointer.getPosition();
        while (pointer.getPosition() - n4 < n2) {
            pointer.Next();
            int n5 = Ddec.DdecGetObjLen(pointer);
            n3 += n5;
            pointer.Next(n5);
        }
        byte[] byArray = new byte[n3];
        n3 = 0;
        pointer.SetPosition(n4);
        while (pointer.getPosition() - n4 < n2) {
            pointer.Next();
            int n6 = Ddec.DdecGetObjLen(pointer);
            pointer.CopyTo(byArray, n3, n6);
            n3 += n6;
            pointer.Next(n6);
        }
        return byArray;
    }

    public static Two<Pointer, Integer> DerGetElementPtr(byte[] byArray, String string) throws DdecException {
        Pointer pointer = new Pointer(byArray);
        return Ddec.DerGetElementPtr(pointer, string);
    }

    public static Two<Pointer, Integer> DerGetElementPtr(Pointer pointer, String string) throws DdecException {
        Pointer pointer2 = pointer.ClonePos(0);
        if (pointer.isNULL()) {
            throw new DdecException(-3);
        }
        int n2 = Integer.MAX_VALUE;
        int n3 = Ddec.DerGetTotalSize(pointer2);
        if (n3 > 0) {
            n2 = pointer2.getPosition() + n3;
        }
        int n4 = 0;
        while (true) {
            if (n4 < string.length() && string.charAt(n4) == ' ') {
                ++n4;
                continue;
            }
            if (pointer2.getPosition() >= n2) {
                throw new DdecException(-3);
            }
            boolean bl = false;
            if (n4 < string.length() && string.charAt(n4) == 'o') {
                bl = true;
                ++n4;
            }
            char c2 = string.charAt(n4);
            ++n4;
            int n5 = -1;
            switch (c2) {
                case 'E': 
                case 'Y': 
                case 'e': 
                case 'x': 
                case 'y': {
                    while (n4 < string.length() && string.charAt(n4) >= '0' && string.charAt(n4) <= '9') {
                        if (n5 == -1) {
                            n5 = 0;
                        }
                        n5 = n5 * 10 + (string.charAt(n4) - 48);
                        ++n4;
                    }
                    break;
                }
                case 'G': 
                case 'Q': {
                    if (n4 >= string.length() || string.charAt(n4) != '=') break;
                    ++n4;
                }
            }
            if (c2 == 'a' || c2 == 'f' || c2 == 'F') {
                Two<Integer, Integer> two = Ddec.DdecFindRdnSet(pointer2, c2, n4, string, n2);
                n4 = (Integer)two.first;
                n2 = (Integer)two.second;
                if (n4 != string.length()) continue;
                Pointer pointer3 = pointer2;
                int n6 = n2 - pointer2.getPosition();
                return new Two<Pointer, Integer>(pointer3, n6);
            }
            if (n4 == string.length()) {
                return Ddec.DdecGetPtr(pointer2, c2, n5, n2);
            }
            if (c2 >= 'A' && c2 <= 'Z') {
                n2 = Ddec.DdecEnter(pointer2, c2, n5, n2);
                continue;
            }
            Ddec.DdecSkip(pointer2, c2, n5, bl, n2);
        }
    }

    private static void DerEnumElements(byte[] byArray, String string, Method method, Pointer pointer) throws InvocationTargetException, IllegalAccessException, DdecException {
        DerSearchRec derSearchRec = Ddec.DerFindFirstElement(byArray, string);
        while (derSearchRec != null) {
            if (method != null) {
                method.invoke(null, new Two<Pointer, Pointer>(pointer, derSearchRec.der));
            }
            derSearchRec = Ddec.DerFindNextElement(derSearchRec);
        }
    }

    public static DerSearchRec DerFindElementInit(byte[] byArray, String string) {
        return Ddec.DerFindElementInit(new Pointer(byArray), string);
    }

    public static DerSearchRec DerFindElementInit(Pointer pointer, String string) {
        Two<Pointer, Integer> two;
        try {
            two = Ddec.DerGetElementPtr(pointer, string);
        }
        catch (DdecException ddecException) {
            return null;
        }
        DerSearchRec derSearchRec = new DerSearchRec();
        derSearchRec.der = (Pointer)two.first;
        derSearchRec._p2 = ((Pointer)two.first).ClonePos((Integer)two.second);
        derSearchRec.size = 0;
        return derSearchRec;
    }

    public static DerSearchRec DerFindFirstElement(byte[] byArray, String string) {
        return Ddec.DerFindFirstElement(new Pointer(byArray), string);
    }

    public static DerSearchRec DerFindFirstElement(Pointer pointer, String string) {
        DerSearchRec derSearchRec = Ddec.DerFindElementInit(pointer, string);
        return Ddec.DerFindNextElement(derSearchRec);
    }

    public static DerSearchRec DerFindNextElement(DerSearchRec derSearchRec) {
        if (derSearchRec == null) {
            return null;
        }
        derSearchRec.der.Next(derSearchRec.size);
        if (derSearchRec.der.getPosition() >= derSearchRec._p2.getPosition()) {
            return null;
        }
        if (derSearchRec.der.Get() == 0) {
            return null;
        }
        derSearchRec.size = Ddec.DerGetTotalSize(derSearchRec.der);
        return derSearchRec;
    }

    public static byte[] DerGetElementBuf(byte[] byArray, String string) throws DdecException {
        return Ddec.DerGetElementBuf(new Pointer(byArray), string);
    }

    public static byte[] DerGetElementBuf(Pointer pointer, String string) throws DdecException {
        Two<Pointer, Integer> two = Ddec.DerGetElementPtr(pointer, string);
        return ((Pointer)two.first).Copy((Integer)two.second);
    }

    public static byte[] DerGetElementForward(byte[] byArray, String string) throws DdecException {
        return Ddec.DerGetElementBuf(byArray, string);
    }

    public static byte[] DerGetElementReverse(byte[] byArray, String string) throws DdecException {
        return Ddec.DerGetElementReverse(new Pointer(byArray), string);
    }

    public static byte[] DerGetElementReverse(Pointer pointer, String string) throws DdecException {
        byte[] byArray = Ddec.DerGetElementBuf(pointer, string);
        ArrayUtil.reverse(byArray);
        return byArray;
    }

    public static byte[] DerGetElementOctetsLSB(byte[] byArray, String string) throws DdecException {
        return Ddec.DerGetElementForward(byArray, string);
    }

    public static byte[] DerGetElementOctets(byte[] byArray, String string) throws DdecException {
        return Ddec.DerGetElementReverse(byArray, string);
    }

    public static byte[] DerGetElementBitstring(byte[] byArray, String string) throws DdecException {
        return Ddec.DerGetElementReverse(byArray, string);
    }

    public static String DerGetElementOid(byte[] byArray, String string) throws DdecException {
        return Ddec.DerGetElementOid(new Pointer(byArray), string);
    }

    public static String DerGetElementOid(Pointer pointer, String string) throws DdecException {
        String string2 = "";
        Two<Pointer, Integer> two = Ddec.DerGetElementPtr(pointer, string);
        Pointer pointer2 = (Pointer)two.first;
        int n2 = (Integer)two.second;
        if (n2 < 1) {
            throw new DdecException(-6);
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            do {
                n4 = (n4 << 7) + (pointer2.Get(n3) & 0x7F);
            } while ((pointer2.Get(++n3 - 1) & 0x80) != 0);
            if (string2.equals("")) {
                string2 = string2 + (char)(n4 / 40 + 48);
                n4 %= 40;
            }
            string2 = string2 + "." + n4;
        }
        return string2;
    }

    public static void DerGetElementBigInt(byte[] byArray, String string, byte[] byArray2) throws DdecException {
        Ddec.DerGetElementBigInt(new Pointer(byArray), string, byArray2);
    }

    public static void DerGetElementBigInt(Pointer pointer, String string, byte[] byArray) throws DdecException {
        byte[] byArray2 = Ddec.DerGetElementReverse(pointer, string);
        int n2 = 0;
        if ((byArray2[byArray2.length - 1] & 0x80) != 0) {
            n2 = -1;
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = n2;
        }
        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
    }

    public static int DerGetElementInt(byte[] byArray, String string) throws DdecException {
        return Ddec.DerGetElementInt(new Pointer(byArray), string);
    }

    public static int DerGetElementInt(Pointer pointer, String string) throws DdecException {
        byte[] byArray = new byte[4];
        Ddec.DerGetElementBigInt(pointer, string, byArray);
        return ((byArray[3] & 0xFF) << 24) + ((byArray[2] & 0xFF) << 16) + ((byArray[1] & 0xFF) << 8) + (byArray[0] & 0xFF);
    }

    public static long DerGetElementInt64(byte[] byArray, String string) throws DdecException {
        byte[] byArray2 = new byte[8];
        Ddec.DerGetElementBigInt(byArray, string, byArray2);
        long l2 = (long)((byArray2[3] & 0xFF) << 24) + (long)((byArray2[2] & 0xFF) << 16) + (long)((byArray2[1] & 0xFF) << 8) + (long)(byArray2[0] & 0xFF);
        l2 = l2 + ((long)(byArray2[4] & 0xFF) << 32) + ((long)(byArray2[5] & 0xFF) << 40) + ((long)(byArray2[6] & 0xFF) << 48) + ((long)(byArray2[7] & 0xFF) << 56);
        return l2;
    }

    public static boolean DerGetElementBool(byte[] byArray, String string) throws DdecException {
        return Ddec.DerGetElementBool(new Pointer(byArray), string);
    }

    public static boolean DerGetElementBool(Pointer pointer, String string) throws DdecException {
        byte[] byArray = Ddec.DerGetElementBuf(pointer, string);
        return byArray[0] != 0;
    }

    public static void DerGetElementNull(byte[] byArray, String string) throws DdecException {
        Ddec.DerGetElementNull(new Pointer(byArray), string);
    }

    public static void DerGetElementNull(Pointer pointer, String string) throws DdecException {
        Ddec.DerGetElementPtr(pointer, string);
    }

    public static boolean DerIsElementPresent(Pointer pointer, String string) {
        try {
            Ddec.DerGetElementNull(pointer, string);
            return true;
        }
        catch (DdecException ddecException) {
            return false;
        }
    }

    public static boolean DerIsElementPresent(byte[] byArray, String string) {
        return Ddec.DerIsElementPresent(new Pointer(byArray), string);
    }

    public static String DerGetElementStr(byte[] byArray, String string) throws DdecException {
        return Ddec.DerGetElementStr(new Pointer(byArray), string);
    }

    public static String DerGetElementStr(Pointer pointer, String string) throws DdecException {
        String string2 = "";
        Two<Pointer, Integer> two = Ddec.DerGetElementPtr(pointer, string);
        Pointer pointer2 = (Pointer)two.first;
        int n2 = (Integer)two.second;
        int n3 = Ddec.DdecPickTag(pointer2, n2);
        byte[] byArray = pointer2.Copy(n2);
        if (n3 != 30) {
            try {
                string2 = new String(byArray, "UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            return string2;
        }
        if (n3 == 30) {
            try {
                string2 = new String(byArray, "UTF-16BE");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            return string2;
        }
        throw new DdecException(-1);
    }

    public static long DerGetElementTime(byte[] byArray, String string) throws DdecException {
        return Ddec.DerGetElementTime(new Pointer(byArray), string);
    }

    public static long DerGetElementTime(Pointer pointer, String string) throws DdecException {
        byte[] byArray = Ddec.DerGetElementBuf(pointer, string);
        int n2 = 0;
        while (n2 < byArray.length) {
            int n3 = n2++;
            byArray[n3] = (byte)(byArray[n3] - 48);
        }
        Pointer pointer2 = new Pointer(byArray);
        int n4 = pointer2.Get();
        pointer2.Next();
        n4 = n4 * 10 + pointer2.Get();
        pointer2.Next();
        if (byArray.length > 13) {
            n4 = n4 * 10 + pointer2.Get();
            pointer2.Next();
            n4 = n4 * 10 + pointer2.Get();
            pointer2.Next();
        } else {
            n4 = n4 < 50 ? (n4 += 2000) : (n4 += 1900);
        }
        int n5 = pointer2.Get();
        pointer2.Next();
        n5 = n5 * 10 + pointer2.Get();
        pointer2.Next();
        --n5;
        int n6 = pointer2.Get();
        pointer2.Next();
        n6 = n6 * 10 + pointer2.Get();
        pointer2.Next();
        int n7 = pointer2.Get();
        pointer2.Next();
        n7 = n7 * 10 + pointer2.Get();
        pointer2.Next();
        int n8 = pointer2.Get();
        pointer2.Next();
        n8 = n8 * 10 + pointer2.Get();
        pointer2.Next();
        int n9 = pointer2.Get();
        pointer2.Next();
        n9 = n9 * 10 + pointer2.Get();
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.set(n4, n5, n6, n7, n8, n9);
        return calendar.getTimeInMillis();
    }

    public static byte[] TryGetElementBuf(byte[] byArray, String string) {
        try {
            return Ddec.DerGetElementBuf(new Pointer(byArray), string);
        }
        catch (DdecException ddecException) {
            return null;
        }
    }

    public static byte[] TryGetElementBuf(Pointer pointer, String string) {
        try {
            return Ddec.DerGetElementBuf(pointer, string);
        }
        catch (DdecException ddecException) {
            return null;
        }
    }

    public static String TryGetElementOid(byte[] byArray, String string) {
        try {
            return Ddec.DerGetElementOid(new Pointer(byArray), string);
        }
        catch (DdecException ddecException) {
            return null;
        }
    }

    public static String TryGetElementOid(Pointer pointer, String string) {
        try {
            return Ddec.DerGetElementOid(pointer, string);
        }
        catch (DdecException ddecException) {
            return null;
        }
    }

    public static int TryGetElementInt(byte[] byArray, String string) {
        try {
            return Ddec.DerGetElementInt(new Pointer(byArray), string);
        }
        catch (DdecException ddecException) {
            return 0;
        }
    }

    public static class DerSearchRec {
        public Pointer der;
        public Pointer _p2;
        public int size;
    }
}

