/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor.DsLib;

import ua.avtor.DsLib.Algorithms.CryptoAlgorithmFactory;
import ua.avtor.DsLib.Algorithms.MessageDigestAlg;
import ua.avtor.DsLib.DsAlgorithmException;
import ua.avtor.DsLib.DsDataCorruptedException;
import ua.avtor.DsLib.DsInvalidOperationException;
import ua.avtor.DsLib.Utils.Ddec;
import ua.avtor.DsLib.Utils.DdecException;
import ua.avtor.DsLib.Utils.Pointer;
import ua.avtor.DsLib.Utils.Two;

public class TimeStampResponse {
    int status;
    int failureInfo;
    String statusString;
    byte[] cms;
    byte[] pTstInfo;
    MessageDigestAlg digestAlg;

    static int bitrevers(byte by) {
        by = (byte)((by & 0x55) << 1 | by >> 1 & 0x55);
        by = (byte)((by & 0x33) << 2 | by >> 2 & 0x33);
        by = (byte)((by & 0xF) << 4 | by >> 4 & 0xF);
        return by;
    }

    public TimeStampResponse(byte[] byArray) throws DsDataCorruptedException {
        Object object;
        byte[] byArray2 = null;
        boolean bl = false;
        this.status = 0;
        this.failureInfo = 0;
        this.pTstInfo = null;
        this.digestAlg = null;
        if (byArray.length <= 2 || Ddec.DerGetTotalSize(byArray) != byArray.length) {
            throw new DsDataCorruptedException();
        }
        try {
            this.status = Ddec.DerGetElementInt(byArray, "SSI");
        }
        catch (DdecException ddecException) {
            try {
                byArray2 = Ddec.DerGetElementBuf(byArray, "s");
            }
            catch (DdecException ddecException2) {
                throw new DsDataCorruptedException();
            }
            bl = true;
        }
        if (!bl) {
            try {
                this.statusString = Ddec.DerGetElementStr(byArray, "SSiSC");
            }
            catch (DdecException ddecException) {
                this.statusString = null;
            }
            try {
                object = Ddec.DerGetElementPtr(byArray, "SSiosG");
                int n2 = 0;
                for (int i2 = ((Integer)((Two)object).second).intValue(); i2 > 0; --i2) {
                    this.failureInfo |= TimeStampResponse.bitrevers((byte)((Pointer)((Two)object).first).Get()) << n2;
                    ((Pointer)((Two)object).first).Next();
                    n2 = (byte)(n2 + 8);
                }
            }
            catch (DdecException ddecException) {
                // empty catch block
            }
            try {
                byArray2 = Ddec.DerGetElementBuf(byArray, "Sss");
            }
            catch (DdecException ddecException) {
                return;
            }
        }
        this.cms = byArray2;
        try {
            object = Ddec.DerGetElementOid(this.cms, "SdE0SiuSD");
            if (!((String)object).equals("1.2.840.113549.1.9.16.1.4")) {
                throw new DsDataCorruptedException();
            }
            this.pTstInfo = Ddec.DerGetElementBuf(this.cms, "SdE0SiuSdE0Q");
            if (this.pTstInfo.length != Ddec.DerGetTotalSize(this.pTstInfo)) {
                throw new DsDataCorruptedException();
            }
        }
        catch (DdecException ddecException) {
            throw new DsDataCorruptedException();
        }
    }

    public int getStatus() {
        return this.status;
    }

    public int getFailureInfo() {
        return this.failureInfo;
    }

    public String getStatusString() {
        return this.statusString;
    }

    public byte[] getCms() throws DsInvalidOperationException {
        if (this.pTstInfo == null) {
            throw new DsInvalidOperationException();
        }
        return this.cms;
    }

    public String getPolicy() throws DsInvalidOperationException, DsDataCorruptedException {
        if (this.pTstInfo == null) {
            throw new DsInvalidOperationException();
        }
        try {
            return Ddec.DerGetElementOid(this.pTstInfo, "SiD");
        }
        catch (DdecException ddecException) {
            throw new DsDataCorruptedException();
        }
    }

    public byte[] getSerial() throws DsInvalidOperationException, DsDataCorruptedException {
        if (this.pTstInfo == null) {
            throw new DsInvalidOperationException();
        }
        try {
            return Ddec.DerGetElementBuf(this.pTstInfo, "SidsI");
        }
        catch (DdecException ddecException) {
            throw new DsDataCorruptedException();
        }
    }

    public long getGenerationTime() throws DsDataCorruptedException {
        try {
            return Ddec.DerGetElementTime(this.pTstInfo, "SidsiT");
        }
        catch (DdecException ddecException) {
            throw new DsDataCorruptedException();
        }
    }

    public boolean compareWithRequest(byte[] byArray) {
        Two<Pointer, Integer> two;
        Two<Pointer, Integer> two2;
        if (this.pTstInfo == null) {
            return false;
        }
        try {
            two2 = Ddec.DerGetElementPtr(byArray, "SiSSD");
            two = Ddec.DerGetElementPtr(this.pTstInfo, "SidSSD");
        }
        catch (DdecException ddecException) {
            return false;
        }
        if (!((Integer)two2.second).equals(two.second)) {
            return false;
        }
        if (!((Pointer)two2.first).CompareTo(((Pointer)two.first).Copy((Integer)two2.second))) {
            return false;
        }
        try {
            two2 = Ddec.DerGetElementPtr(byArray, "SiSsQ");
            two = Ddec.DerGetElementPtr(this.pTstInfo, "SidSsQ");
        }
        catch (DdecException ddecException) {
            return false;
        }
        if (!((Integer)two2.second).equals(two.second)) {
            return false;
        }
        if (!((Pointer)two2.first).CompareTo(((Pointer)two.first).Copy((Integer)two2.second))) {
            return false;
        }
        try {
            two2 = Ddec.DerGetElementPtr(byArray, "SisodI");
            try {
                two = Ddec.DerGetElementPtr(this.pTstInfo, "SidsitosobI");
            }
            catch (DdecException ddecException) {
                return false;
            }
            if (!((Integer)two2.second).equals(two.second)) {
                return false;
            }
            if (!((Pointer)two2.first).CompareTo(((Pointer)two.first).Copy((Integer)two2.second))) {
                return false;
            }
        }
        catch (DdecException ddecException) {
            // empty catch block
        }
        return true;
    }

    public boolean compareWithDigest(String string, byte[] byArray) {
        if (this.pTstInfo == null) {
            return false;
        }
        if (string != null && !string.equals("")) {
            try {
                if (!string.equals(Ddec.DerGetElementOid(this.pTstInfo, "SidSSD"))) {
                    return false;
                }
            }
            catch (DdecException ddecException) {
                return false;
            }
        }
        try {
            Two<Pointer, Integer> two = Ddec.DerGetElementPtr(this.pTstInfo, "SidSsQ");
            if (byArray.length != (Integer)two.second) {
                return false;
            }
            if (!((Pointer)two.first).CompareTo(byArray)) {
                return false;
            }
        }
        catch (DdecException ddecException) {
            return false;
        }
        return true;
    }

    public void compareWithDocBegin(String string, CryptoAlgorithmFactory cryptoAlgorithmFactory) throws DsDataCorruptedException, DsAlgorithmException {
        if (string == null || string.equals("")) {
            try {
                string = Ddec.DerGetElementOid(this.pTstInfo, "SidSSD");
            }
            catch (DdecException ddecException) {
                throw new DsDataCorruptedException();
            }
        }
        this.digestAlg = cryptoAlgorithmFactory.getDigestAlg(string, null, null);
        if (this.digestAlg == null) {
            throw new DsAlgorithmException();
        }
    }

    public void compareWithDocUpdate(byte[] byArray) throws DsInvalidOperationException {
        if (this.digestAlg == null) {
            throw new DsInvalidOperationException();
        }
        this.digestAlg.update(byArray);
    }

    public boolean compareWithDocFinal() throws DsInvalidOperationException {
        if (this.digestAlg == null) {
            throw new DsInvalidOperationException();
        }
        byte[] byArray = this.digestAlg.getDigest();
        return this.compareWithDigest(null, byArray);
    }
}

