/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor.DsLib;

import ua.avtor.DsLib.Algorithms.CryptoAlgorithmFactory;
import ua.avtor.DsLib.Algorithms.MessageDigestAlg;
import ua.avtor.DsLib.DsAlgorithmException;
import ua.avtor.DsLib.DsInvalidOperationException;
import ua.avtor.DsLib.Utils.DerEncoder;

public class TimeStampRequest {
    String hashOid;
    byte[] hashParams;
    String policyOid;
    byte[] hash;
    byte[] nonce;
    MessageDigestAlg digestAlg;
    boolean reqCert;

    public TimeStampRequest(byte[] byArray) throws DsInvalidOperationException {
        throw new DsInvalidOperationException();
    }

    public TimeStampRequest(String string, byte[] byArray, byte[] byArray2) {
        this.hashOid = string;
        if (byArray != null) {
            this.hashParams = byArray;
        }
        this.hash = byArray2;
        this.reqCert = false;
        this.digestAlg = null;
    }

    public TimeStampRequest(String string, byte[] byArray, CryptoAlgorithmFactory cryptoAlgorithmFactory) throws DsAlgorithmException {
        this.hashOid = string;
        if (byArray != null) {
            this.hashParams = byArray;
        }
        this.reqCert = false;
        this.digestAlg = cryptoAlgorithmFactory.getDigestAlg(string, byArray, null);
        if (this.digestAlg == null) {
            throw new DsAlgorithmException();
        }
    }

    public final void setPolicy(String string) {
        this.policyOid = string;
    }

    public final void setNonce(byte[] byArray) {
        this.nonce = byArray;
    }

    public final void reqCertificate(boolean bl) {
        this.reqCert = bl;
    }

    public final void update(byte[] byArray) throws DsInvalidOperationException {
        if (this.digestAlg == null) {
            throw new DsInvalidOperationException();
        }
        this.digestAlg.update(byArray);
    }

    public final byte[] getEncoded() {
        if (this.digestAlg != null) {
            this.hash = this.digestAlg.getDigest();
            this.digestAlg = null;
        }
        DerEncoder derEncoder = new DerEncoder();
        derEncoder.SeqBegin();
        derEncoder.addInteger(1);
        derEncoder.SeqBegin();
        derEncoder.SeqBegin();
        derEncoder.addOid(this.hashOid);
        if (this.hashParams != null) {
            derEncoder.addObject(this.hashParams);
        }
        derEncoder.SeqEnd();
        derEncoder.addOctets(this.hash);
        derEncoder.SeqEnd();
        if (this.policyOid != null && !this.policyOid.equals("")) {
            derEncoder.addOid(this.policyOid);
        }
        if (this.nonce != null) {
            derEncoder.addBigintMSB(this.nonce);
        }
        if (this.reqCert) {
            derEncoder.addBool(this.reqCert);
        }
        derEncoder.SeqEnd();
        return derEncoder.getEncoded();
    }
}

