/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor.DsLib;

import java.util.ArrayList;
import ua.avtor.DsLib.Certificate;
import ua.avtor.DsLib.CertificateException;
import ua.avtor.DsLib.DsDataCorruptedException;
import ua.avtor.DsLib.DsDataNotFoundException;
import ua.avtor.DsLib.DsException;
import ua.avtor.DsLib.DsInvalidOperationException;
import ua.avtor.DsLib.DsInvalidParamException;
import ua.avtor.DsLib.PrivateKeys.PrivateKey;
import ua.avtor.DsLib.Utils.Ddec;
import ua.avtor.DsLib.Utils.DdecException;
import ua.avtor.DsLib.Utils.DerEncoder;
import ua.avtor.DsLib.Utils.Pointer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignerInfo {
    public PrivateKey privateKey;
    public int verificationStatus;
    Certificate cert = null;
    ArrayList<byte[]> signedAttrs = new ArrayList();
    ArrayList<byte[]> unsignedAttrs = new ArrayList();
    int version;
    byte[] sid;
    byte[] signature;
    byte[] encodedSignedAttrs;
    boolean signaturePresent;
    String digestOid;
    byte[] digestParam;
    String signatureOid;
    byte[] signatureParam;

    public SignerInfo(byte[] byArray, PrivateKey privateKey) throws CertificateException {
        this.privateKey = privateKey;
        this.signaturePresent = false;
        this.digestOid = null;
        this.digestParam = null;
        this.signatureOid = null;
        this.signatureParam = null;
        this.version = 1;
        this.verificationStatus = 1;
        this.cert = new Certificate(byArray);
    }

    public SignerInfo(byte[] byArray) throws DsDataCorruptedException {
        Ddec.DerSearchRec derSearchRec;
        this.privateKey = null;
        this.signaturePresent = true;
        this.digestOid = null;
        this.signatureOid = null;
        this.version = 1;
        this.verificationStatus = 1;
        try {
            this.sid = Ddec.DerGetElementBuf(byArray, "Six");
        }
        catch (DdecException ddecException) {
            throw new DsDataCorruptedException();
        }
        if (this.sid[0] == -128) {
            this.sid[0] = 4;
            this.version = 3;
        }
        this.digestOid = this.newDerOid(byArray, "SixSD");
        if (this.digestOid == null) {
            throw new DsDataCorruptedException();
        }
        this.digestParam = this.newDerData(byArray, "SixSdx");
        try {
            this.encodedSignedAttrs = Ddec.DerGetElementBuf(byArray, "Sixse0");
            this.encodedSignedAttrs[0] = 49;
            derSearchRec = Ddec.DerFindFirstElement(this.encodedSignedAttrs, "U");
            while (derSearchRec != null) {
                this.signedAttrs.add(derSearchRec.der.Copy(derSearchRec.size));
                derSearchRec = Ddec.DerFindNextElement(derSearchRec);
            }
        }
        catch (DdecException ddecException) {
            // empty catch block
        }
        this.signatureOid = this.newDerOid(byArray, "Sixsoe0SD");
        if (this.signatureOid == null) {
            throw new DsDataCorruptedException();
        }
        this.signatureParam = this.newDerData(byArray, "Sixsoe0Sdx");
        try {
            this.signature = Ddec.DerGetElementBuf(byArray, "Sixsoe0sQ");
        }
        catch (DdecException ddecException) {
            throw new DsDataCorruptedException();
        }
        derSearchRec = Ddec.DerFindFirstElement(byArray, "Sixsoe0sqE1");
        while (derSearchRec != null) {
            this.unsignedAttrs.add(derSearchRec.der.Copy(derSearchRec.size));
            derSearchRec = Ddec.DerFindNextElement(derSearchRec);
        }
    }

    public final void addSignedAttribute(String string, byte[] byArray, int n2) throws DsInvalidOperationException, DsInvalidParamException {
        byte[] byArray2 = new byte[]{6, 9, 42, -122, 72, -122, -9, 13, 1, 9, 3};
        byte[] byArray3 = new byte[]{6, 9, 42, -122, 72, -122, -9, 13, 1, 9, 4};
        if (this.signaturePresent) {
            throw new DsInvalidOperationException();
        }
        byte[] byArray4 = Ddec.DerEncodeOid(string);
        if (byArray4 == null) {
            throw new DsInvalidParamException();
        }
        int n3 = -1;
        if (new Pointer(byArray4).CompareTo(byArray2) || new Pointer(byArray4).CompareTo(byArray3)) {
            for (int i2 = 0; i2 < this.signedAttrs.size(); ++i2) {
                byte[] byArray5;
                byte[] byArray6 = this.signedAttrs.get(i2);
                try {
                    byArray5 = Ddec.DerGetElementBuf(byArray6, "Sd");
                }
                catch (DdecException ddecException) {
                    byArray5 = null;
                }
                if (!new Pointer(byArray4).CompareTo(byArray5)) continue;
                n3 = i2;
                break;
            }
        }
        DerEncoder derEncoder = new DerEncoder();
        derEncoder.SeqBegin();
        derEncoder.addObject(byArray4, byArray4.length);
        derEncoder.SetBegin();
        derEncoder.addObject(byArray, n2);
        derEncoder.SetEnd();
        derEncoder.SeqEnd();
        if (n3 < 0) {
            this.signedAttrs.add(derEncoder.getEncoded());
        } else {
            this.signedAttrs.set(n3, derEncoder.getEncoded());
        }
    }

    public final void addUnsignedAttribute(String string, byte[] byArray, int n2) {
        DerEncoder derEncoder = new DerEncoder();
        derEncoder.SeqBegin();
        derEncoder.addOid(string);
        derEncoder.SetBegin();
        derEncoder.addObject(byArray, n2);
        derEncoder.SetEnd();
        derEncoder.SeqEnd();
        this.unsignedAttrs.add(derEncoder.getEncoded());
    }

    public final void setUnsignedAttribute(String string, byte[] byArray, int n2) throws DsInvalidParamException {
        byte[] byArray2 = Ddec.DerEncodeOid(string);
        if (byArray2 == null) {
            throw new DsInvalidParamException();
        }
        int n3 = -1;
        for (int i2 = 0; i2 < this.unsignedAttrs.size(); ++i2) {
            byte[] byArray3;
            try {
                byArray3 = Ddec.DerGetElementBuf(this.unsignedAttrs.get(i2), "Sd");
            }
            catch (DdecException ddecException) {
                byArray3 = null;
            }
            if (!new Pointer(byArray2).CompareTo(byArray3)) continue;
            n3 = i2;
            break;
        }
        if (n3 >= 0) {
            this.unsignedAttrs.remove(n3);
        }
        if (byArray != null) {
            this.addUnsignedAttribute(string, byArray, n2);
        }
    }

    public final Certificate getCertificate() {
        return this.cert;
    }

    public final boolean isSignedAttributePresent(String string) throws DsInvalidParamException {
        try {
            this.getSignedAttribute(string);
        }
        catch (DsDataNotFoundException dsDataNotFoundException) {
            return false;
        }
        return true;
    }

    public final byte[] getSignedAttribute(String string) throws DsDataNotFoundException, DsInvalidParamException {
        return this.getEncodedAttribute(this.signedAttrs, string);
    }

    public final boolean isUnsignedAttributePresent(String string) throws DsInvalidParamException {
        try {
            this.getUnsignedAttribute(string);
        }
        catch (DsDataNotFoundException dsDataNotFoundException) {
            return false;
        }
        return true;
    }

    public final byte[] getUnsignedAttribute(String string) throws DsDataNotFoundException, DsInvalidParamException {
        return this.getEncodedAttribute(this.unsignedAttrs, string);
    }

    public final void ensureSigned() throws DsException {
        if (!this.signaturePresent) {
            byte[] byArray = this.getSignedAttributes();
            this.privateKey.signatureUpdate(byArray);
            this.signature = this.privateKey.signatureGet();
            this.signaturePresent = true;
        }
    }

    public final byte[] getEncoded() throws DsException {
        byte[] byArray;
        this.ensureSigned();
        DerEncoder derEncoder = new DerEncoder();
        derEncoder.SeqBegin();
        derEncoder.addInteger(this.getVersion());
        byte[] byArray2 = this.getSignerIdentifier();
        if (byArray2[0] == 48) {
            derEncoder.addObject(byArray2);
        } else {
            byArray = new byte[byArray2.length - 2];
            System.arraycopy(byArray2, 2, byArray, 0, byArray.length);
            derEncoder.addSpecific((byte)-128, byArray);
        }
        derEncoder.SeqBegin();
        derEncoder.addOid(this.getDigestOid());
        derEncoder.addDerParams(this.getDigestParams());
        derEncoder.SeqEnd();
        byArray = this.getSignedAttributes();
        if (byArray != null) {
            derEncoder.addObjectImplicit((byte)-96, byArray);
        }
        derEncoder.SeqBegin();
        derEncoder.addOid(this.getSignatureOid());
        derEncoder.addDerParams(this.getSignatureParams());
        derEncoder.SeqEnd();
        derEncoder.addOctets(this.signature);
        if (!this.unsignedAttrs.isEmpty()) {
            derEncoder.SpecificBegin((byte)-95);
            for (byte[] byArray3 : this.unsignedAttrs) {
                derEncoder.addObject(byArray3);
            }
            derEncoder.SpecificEnd();
        }
        derEncoder.SeqEnd();
        return derEncoder.getEncoded();
    }

    public final int getVerificationStatus() {
        return this.verificationStatus;
    }

    public final boolean hasSignature() {
        return this.signaturePresent;
    }

    public final int getVersion() {
        return this.version;
    }

    public final boolean hasSignedAttributes() {
        return !this.signedAttrs.isEmpty();
    }

    public final void setCertificateData(byte[] byArray) throws CertificateException {
        this.cert = new Certificate(byArray);
    }

    public final String getDigestOid() {
        if (this.privateKey != null) {
            return this.privateKey.getDigestOid();
        }
        return this.digestOid;
    }

    public final byte[] getDigestParams() {
        if (this.privateKey != null) {
            return this.privateKey.getDigestParams();
        }
        return this.digestParam;
    }

    public final String getSignatureOid() {
        if (this.privateKey != null) {
            return this.privateKey.getSignatureOid();
        }
        return this.signatureOid;
    }

    public final byte[] getSignatureParams() {
        if (this.privateKey != null) {
            return this.privateKey.getSignatureParams();
        }
        return this.signatureParam;
    }

    public final byte[] getSignature() throws DsInvalidOperationException {
        if (!this.signaturePresent) {
            throw new DsInvalidOperationException();
        }
        return this.signature;
    }

    public final byte[] getSignedAttributes() throws DsDataNotFoundException {
        if (this.signedAttrs.isEmpty()) {
            throw new DsDataNotFoundException();
        }
        if (this.encodedSignedAttrs == null) {
            DerEncoder derEncoder = new DerEncoder();
            derEncoder.SetBegin();
            for (byte[] byArray : this.signedAttrs) {
                derEncoder.addObject(byArray);
            }
            derEncoder.SetEnd();
            this.encodedSignedAttrs = derEncoder.getEncoded();
        }
        return this.encodedSignedAttrs;
    }

    public final byte[] getSignerIdentifier() throws DsInvalidOperationException, CertificateException {
        if (this.sid == null) {
            if (this.cert == null) {
                throw new DsInvalidOperationException();
            }
            DerEncoder derEncoder = new DerEncoder();
            derEncoder.SeqBegin();
            byte[] byArray = this.cert.getIssuerDN();
            derEncoder.addObject(byArray);
            byte[] byArray2 = this.cert.getSerial();
            derEncoder.addObject(byArray2);
            derEncoder.SeqEnd();
            this.sid = derEncoder.getEncoded();
        }
        return this.sid;
    }

    String newDerOid(byte[] byArray, String string) {
        try {
            return Ddec.DerGetElementOid(byArray, string);
        }
        catch (DdecException ddecException) {
            return null;
        }
    }

    byte[] newDerData(byte[] byArray, String string) {
        try {
            return Ddec.DerGetElementBuf(byArray, string);
        }
        catch (DdecException ddecException) {
            return null;
        }
    }

    byte[] getEncodedAttribute(ArrayList<byte[]> arrayList, String string) throws DsInvalidParamException, DsDataNotFoundException {
        byte[] byArray = Ddec.DerEncodeOid(string);
        if (byArray == null) {
            throw new DsInvalidParamException();
        }
        for (byte[] byArray2 : arrayList) {
            byte[] byArray3;
            try {
                byArray3 = Ddec.DerGetElementBuf(byArray2, "Sd");
            }
            catch (DdecException ddecException) {
                continue;
            }
            if (!new Pointer(byArray).CompareTo(byArray3)) continue;
            try {
                return Ddec.DerGetElementBuf(byArray2, "SdUx");
            }
            catch (DdecException ddecException) {
            }
        }
        throw new DsDataNotFoundException();
    }
}

