/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor.DsLib;

import java.io.IOException;
import ua.avtor.DsLib.Algorithms.CryptoAlgorithmFactory;
import ua.avtor.DsLib.Algorithms.MessageDigestAlg;
import ua.avtor.DsLib.DsAlgorithmException;
import ua.avtor.DsLib.DsDataCorruptedException;
import ua.avtor.DsLib.Transport.UriTransport;
import ua.avtor.DsLib.Utils.Ddec;
import ua.avtor.DsLib.Utils.DdecException;
import ua.avtor.DsLib.Utils.DerEncoder;

public class SignaturePolicy {
    String policyId;
    String uri;
    String explicitText;
    String organization;
    byte[] hash;
    String hashOid;
    byte[] hashParams;

    public SignaturePolicy(String string, String string2) {
        this.policyId = string;
        this.uri = string2;
        this.hashOid = "1.2.804.2.1.1.1.1.2.1";
    }

    public SignaturePolicy(String string, String string2, String string3, String string4) {
        this.policyId = string;
        this.uri = string2;
        this.organization = string3;
        this.explicitText = string4;
        this.hashOid = "1.2.804.2.1.1.1.1.2.1";
    }

    public SignaturePolicy(byte[] byArray) throws DsDataCorruptedException {
        if (byArray.length <= 2 || Ddec.DerGetTotalSize(byArray) != byArray.length) {
            throw new DsDataCorruptedException();
        }
        try {
            this.policyId = Ddec.DerGetElementOid(byArray, "SD");
        }
        catch (DdecException ddecException) {
            throw new DsDataCorruptedException();
        }
        try {
            this.hashOid = Ddec.DerGetElementOid(byArray, "SdSSD");
        }
        catch (DdecException ddecException) {
            throw new DsDataCorruptedException();
        }
        try {
            this.hashParams = Ddec.DerGetElementBuf(byArray, "SdSSdx");
        }
        catch (DdecException ddecException) {
            // empty catch block
        }
        try {
            this.hash = Ddec.DerGetElementBuf(byArray, "SdSsQ");
        }
        catch (DdecException ddecException) {
            // empty catch block
        }
        Ddec.DerSearchRec derSearchRec = Ddec.DerFindFirstElement(byArray, "SdsS");
        while (derSearchRec != null) {
            block19: {
                try {
                    String string = Ddec.DerGetElementOid(derSearchRec.der, "SD");
                    if (string.equals("1.2.840.113549.1.9.16.5.1")) {
                        try {
                            this.uri = Ddec.DerGetElementStr(derSearchRec.der, "SdC");
                        }
                        catch (DdecException ddecException) {
                            // empty catch block
                        }
                    }
                    if (!string.equals("1.2.840.113549.1.9.16.5.2")) break block19;
                    try {
                        this.organization = Ddec.DerGetElementStr(derSearchRec.der, "SdSSC");
                    }
                    catch (DdecException ddecException) {
                        // empty catch block
                    }
                    try {
                        this.explicitText = Ddec.DerGetElementStr(derSearchRec.der, "SdSsC");
                    }
                    catch (DdecException ddecException) {}
                }
                catch (DdecException ddecException) {
                    // empty catch block
                }
            }
            derSearchRec = Ddec.DerFindNextElement(derSearchRec);
        }
    }

    public final String getOid() {
        return this.policyId;
    }

    public final String getUri() {
        return this.uri;
    }

    public final String getExplicitText() {
        return this.explicitText;
    }

    public final String getOrganization() {
        return this.organization;
    }

    public final void calcPolicyHash(CryptoAlgorithmFactory cryptoAlgorithmFactory, String string, byte[] byArray, UriTransport uriTransport) throws DsAlgorithmException, IOException {
        MessageDigestAlg messageDigestAlg;
        byte[] byArray2 = uriTransport.get(this.uri, null, null);
        this.hashOid = string;
        this.hashParams = null;
        if (byArray != null) {
            this.hashParams = byArray;
        }
        if ((messageDigestAlg = cryptoAlgorithmFactory.getDigestAlg(string, byArray, null)) == null) {
            throw new DsAlgorithmException();
        }
        messageDigestAlg.update(byArray2);
        this.hash = messageDigestAlg.getDigest();
    }

    public final byte[] getEncoded() {
        DerEncoder derEncoder = new DerEncoder();
        derEncoder.SeqBegin();
        derEncoder.addOid(this.policyId);
        derEncoder.SeqBegin();
        derEncoder.SeqBegin();
        derEncoder.addOid(this.hashOid);
        if (this.hashParams != null) {
            derEncoder.addObject(this.hashParams);
        }
        derEncoder.SeqEnd();
        derEncoder.addOctets(this.hash);
        derEncoder.SeqEnd();
        derEncoder.SeqBegin();
        if (this.uri != null) {
            derEncoder.SeqBegin();
            derEncoder.addOid("1.2.840.113549.1.9.16.5.1");
            derEncoder.addSpecific((byte)22, this.uri);
            derEncoder.SeqEnd();
        }
        if (this.organization != null || this.explicitText != null) {
            derEncoder.SeqBegin();
            derEncoder.addOid("1.2.840.113549.1.9.16.5.2");
            derEncoder.SeqBegin();
            if (this.organization != null) {
                derEncoder.SeqBegin();
                derEncoder.addSpecific((byte)12, this.organization);
                derEncoder.SeqBegin();
                derEncoder.addInteger(1);
                derEncoder.SeqEnd();
                derEncoder.SeqEnd();
            }
            if (this.explicitText != null) {
                derEncoder.addSpecific((byte)12, this.explicitText);
            }
            derEncoder.SeqEnd();
            derEncoder.SeqEnd();
        }
        derEncoder.SeqEnd();
        derEncoder.SeqEnd();
        return derEncoder.getEncoded();
    }
}

