/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor.DsLib;

import java.util.ArrayList;
import ua.avtor.DsLib.Algorithms.KeyWrapAlg;
import ua.avtor.DsLib.Certificate;
import ua.avtor.DsLib.CertificateException;
import ua.avtor.DsLib.Certificates.CertificateFinder;
import ua.avtor.DsLib.DsDataCorruptedException;
import ua.avtor.DsLib.DsDataNotFoundException;
import ua.avtor.DsLib.DsException;
import ua.avtor.DsLib.DsInvalidOperationException;
import ua.avtor.DsLib.PrivateKeys.PrivateKey;
import ua.avtor.DsLib.Utils.Ddec;
import ua.avtor.DsLib.Utils.DdecException;
import ua.avtor.DsLib.Utils.DerEncoder;
import ua.avtor.DsLib.Utils.Pointer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecipientInfo {
    Certificate cert;
    byte[] rid;
    byte[] encoded;
    boolean preferIssuerSN = false;
    Certificate originatorCert;
    CertificateFinder originatorCertFinder;
    ArrayList<Certificate> attachedCerts = new ArrayList();

    public RecipientInfo(byte[] byArray, int n2) throws CertificateException {
        this.cert = new Certificate(byArray);
        this.originatorCertFinder = null;
        this.attachedCerts = null;
        this.originatorCert = null;
    }

    public RecipientInfo(byte[] byArray, CertificateFinder certificateFinder, ArrayList<Certificate> arrayList) throws DsDataCorruptedException {
        this.cert = null;
        this.originatorCertFinder = certificateFinder;
        this.attachedCerts = arrayList;
        this.originatorCert = null;
        if (byArray[0] == 48) {
            try {
                this.rid = Ddec.DerGetElementBuf(byArray, "Six");
            }
            catch (DdecException ddecException) {
                throw new DsDataCorruptedException();
            }
            if (this.rid[0] == -128) {
                this.rid[0] = 4;
            }
        } else {
            try {
                this.rid = Ddec.DerGetElementBuf(byArray, "E1ie0oe1sSSx");
            }
            catch (DdecException ddecException) {
                throw new DsDataCorruptedException();
            }
            if (this.rid[0] != 48) {
                try {
                    this.rid = Ddec.DerGetElementBuf(this.rid, "E0q");
                }
                catch (DdecException ddecException) {
                    throw new DsDataCorruptedException();
                }
            }
        }
        this.encoded = byArray;
    }

    public final byte[] getRecipientIdentifier() throws DsInvalidOperationException, CertificateException {
        if (this.rid == null || this.rid.length == 0) {
            if (this.cert == null) {
                throw new DsInvalidOperationException();
            }
            DerEncoder derEncoder = new DerEncoder();
            byte[] byArray = null;
            if (!this.preferIssuerSN) {
                byArray = this.cert.getSubjectKeyIdentifier();
            }
            if (byArray != null) {
                derEncoder.addOctets(byArray);
            } else {
                derEncoder.SeqBegin();
                byte[] byArray2 = this.cert.getIssuerDN();
                derEncoder.addObject(byArray2);
                byte[] byArray3 = this.cert.getSerial();
                derEncoder.addObject(byArray3);
                derEncoder.SeqEnd();
            }
            this.rid = derEncoder.getEncoded();
        }
        return this.rid;
    }

    public final byte[] getEncoded(KeyWrapAlg keyWrapAlg) throws DsInvalidOperationException, CertificateException {
        if (this.encoded != null && this.encoded.length != 0) {
            return this.encoded;
        }
        DerEncoder derEncoder = new DerEncoder();
        if (keyWrapAlg.getEphemeralKey() == null) {
            this.encodeKeyTrans(derEncoder, keyWrapAlg);
        } else {
            this.encodeKeyAgree(derEncoder, keyWrapAlg);
        }
        return derEncoder.getEncoded();
    }

    public final Certificate getCertificate() throws DsInvalidOperationException {
        if (this.cert == null) {
            throw new DsInvalidOperationException();
        }
        return this.cert;
    }

    public final Certificate getOriginatorCertificate() {
        return this.originatorCert;
    }

    public final byte[] decryptSessionKey(PrivateKey privateKey) throws DsException {
        byte[] byArray;
        String string;
        byte[] byArray2;
        byte[] byArray3;
        String string2;
        byte[] byArray4;
        if (this.encoded == null || this.encoded.length == 0) {
            throw new DsInvalidOperationException();
        }
        if (this.encoded[0] == 48) {
            byte[] byArray5;
            String string3;
            byte[] byArray6;
            try {
                byArray6 = Ddec.DerGetElementBuf(this.encoded, "SixsQ");
            }
            catch (DdecException ddecException) {
                throw new DsDataCorruptedException();
            }
            try {
                string3 = Ddec.DerGetElementOid(this.encoded, "SixSD");
            }
            catch (DdecException ddecException) {
                string3 = null;
            }
            try {
                byArray5 = Ddec.DerGetElementBuf(this.encoded, "SixSdx");
            }
            catch (DdecException ddecException) {
                byArray5 = null;
            }
            return privateKey.decryptSessionKey(string3, byArray5, byArray6, null, null, null);
        }
        try {
            byArray4 = Ddec.DerGetElementBuf(this.encoded, "E1ie0oe1sSSxQ");
        }
        catch (DdecException ddecException) {
            throw new DsDataCorruptedException();
        }
        try {
            string2 = Ddec.DerGetElementOid(this.encoded, "E1ie0oe1SD");
        }
        catch (DdecException ddecException) {
            string2 = null;
        }
        try {
            byArray3 = Ddec.DerGetElementBuf(this.encoded, "E1ie0oe1Sdx");
        }
        catch (DdecException ddecException) {
            byArray3 = null;
        }
        try {
            byArray2 = Ddec.DerGetElementBuf(this.encoded, "E1ie0E1Q");
        }
        catch (DdecException ddecException) {
            byArray2 = null;
        }
        if (Ddec.DerIsElementPresent(this.encoded, "E1iE0E1SD")) {
            try {
                string = Ddec.DerGetElementOid(this.encoded, "E1iE0E1SD");
                byArray = Ddec.DerGetElementBuf(this.encoded, "E1iE0E1sG");
            }
            catch (DdecException ddecException) {
                throw new DsDataCorruptedException();
            }
        } else {
            byte[] byArray7;
            byte[] byArray8 = Ddec.TryGetElementBuf(this.encoded, "E1iE0x");
            if (byArray8 == null) {
                throw new DsDataCorruptedException();
            }
            if (byArray8[0] == -128) {
                byArray8[0] = 4;
            }
            if ((byArray7 = this.findOriginatorCert(byArray8)) == null) {
                throw new DsDataNotFoundException("Originator certificate");
            }
            this.originatorCert = new Certificate(byArray7);
            string = this.originatorCert.getPublicKeyAlgOid();
            byArray = this.originatorCert.getPublicKey();
        }
        return privateKey.decryptSessionKey(string2, byArray3, byArray4, string, byArray, byArray2);
    }

    public void setPreferIdIssuerSN(boolean bl) {
        this.preferIssuerSN = bl;
    }

    byte[] findOriginatorCert(byte[] byArray) throws DsException {
        byte[] byArray2 = null;
        if (this.attachedCerts != null) {
            for (Certificate certificate : this.attachedCerts) {
                if (!certificate.isMyIdentifier(byArray)) continue;
                return certificate.getEncoded();
            }
        }
        if (byArray2 == null && this.originatorCertFinder != null) {
            byArray2 = byArray[0] == 48 ? this.originatorCertFinder.findCertificate(0, byArray) : this.originatorCertFinder.findCertificate(1, new Pointer(byArray).Next(2).Copy(byArray.length - 2));
        }
        return byArray2;
    }

    void encodeKeyTrans(DerEncoder derEncoder, KeyWrapAlg keyWrapAlg) throws DsInvalidOperationException, CertificateException {
        derEncoder.SeqBegin();
        byte[] byArray = this.getRecipientIdentifier();
        if (byArray[0] == 48) {
            derEncoder.addInteger(0);
            derEncoder.addObject(byArray);
        } else {
            derEncoder.addInteger(2);
            byte[] byArray2 = new byte[byArray.length - 2];
            System.arraycopy(byArray, 2, byArray2, 0, byArray2.length);
            derEncoder.addSpecific((byte)-128, byArray2);
        }
        derEncoder.SeqBegin();
        derEncoder.addOid(keyWrapAlg.getOid());
        derEncoder.addDerParams(keyWrapAlg.getParams());
        derEncoder.SeqEnd();
        derEncoder.addOctets(keyWrapAlg.getWrappedKey());
        derEncoder.SeqEnd();
    }

    void encodeKeyAgree(DerEncoder derEncoder, KeyWrapAlg keyWrapAlg) throws CertificateException, DsInvalidOperationException {
        derEncoder.SpecificBegin((byte)-95);
        derEncoder.addInteger(3);
        derEncoder.SpecificBegin((byte)-96);
        derEncoder.SpecificBegin((byte)-95);
        derEncoder.SeqBegin();
        derEncoder.addOid(this.cert.getPublicKeyAlgOid());
        derEncoder.addNull();
        derEncoder.SeqEnd();
        derEncoder.addBitstring(keyWrapAlg.getEphemeralKey(), keyWrapAlg.getEphemeralKey().length, 0);
        derEncoder.SpecificEnd();
        derEncoder.SpecificEnd();
        derEncoder.SeqBegin();
        derEncoder.addOid(keyWrapAlg.getOid());
        derEncoder.addDerParams(keyWrapAlg.getParams());
        derEncoder.SeqEnd();
        derEncoder.SeqBegin();
        derEncoder.SeqBegin();
        byte[] byArray = this.getRecipientIdentifier();
        if (byArray[0] == 48) {
            derEncoder.addObject(byArray);
        } else {
            derEncoder.SpecificBegin((byte)-96);
            derEncoder.addObject(byArray);
            derEncoder.SpecificEnd();
        }
        derEncoder.addOctets(keyWrapAlg.getWrappedKey());
        derEncoder.SeqEnd();
        derEncoder.SeqEnd();
        derEncoder.SpecificEnd();
    }
}

