/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor.DsLib.PrivateKeys;

import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.crypto.Cipher;
import ua.avtor.DsLib.Algorithms.CryptoAlgorithmFactory;
import ua.avtor.DsLib.Algorithms.InternationalAlgFactory;
import ua.avtor.DsLib.Algorithms.MessageDigestAlg;
import ua.avtor.DsLib.DsAlgorithmException;
import ua.avtor.DsLib.DsException;
import ua.avtor.DsLib.PrivateKeys.PrivateKey;
import ua.avtor.DsLib.PrivateKeys.PrivateKeyRsaAbstract;
import ua.avtor.DsLib.Utils.Ddec;
import ua.avtor.DsLib.Utils.DerEncoder;

public class PrivateKeyRsaPkcs8
extends PrivateKeyRsaAbstract {
    private java.security.PrivateKey privKey;
    private Signature sg;
    private byte[] publicInfo;
    protected static CryptoAlgorithmFactory algs = new InternationalAlgFactory();
    protected MessageDigestAlg digestAlg;
    protected boolean digestInitialized = false;
    protected boolean signatureInitialized = false;

    public PrivateKeyRsaPkcs8(byte[] byArray, String string, int n2, byte[] byArray2) throws DsException {
        if (byArray != null) {
            try {
                PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                this.privKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
                this.publicInfo = this.rsaP8toPublic(byArray);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new DsAlgorithmException("RSA", (Throwable)generalSecurityException);
            }
        }
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(n2);
            KeyPair keyPair = keyPairGenerator.genKeyPair();
            this.privKey = keyPair.getPrivate();
            this.publicInfo = keyPair.getPublic().getEncoded();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new DsAlgorithmException("RSA-" + Integer.toString(n2), (Throwable)noSuchAlgorithmException);
        }
    }

    private byte[] rsaP8toPublic(byte[] byArray) {
        DerEncoder derEncoder = new DerEncoder();
        derEncoder.SeqBegin();
        derEncoder.SeqBegin();
        derEncoder.addOid(this.getSignatureOid());
        derEncoder.addObject(this.getSignatureParams());
        derEncoder.SeqEnd();
        derEncoder.BitstringBegin();
        derEncoder.SeqBegin();
        byte[] byArray2 = Ddec.TryGetElementBuf(byArray, "SisQSii");
        derEncoder.addObject(byArray2);
        byte[] byArray3 = Ddec.TryGetElementBuf(byArray, "SisQSiii");
        derEncoder.addObject(byArray3);
        derEncoder.SeqEnd();
        derEncoder.BitstringEnd();
        derEncoder.SeqEnd();
        return derEncoder.getEncoded();
    }

    protected void finalize() throws Throwable {
        if (this.privKey != null) {
            this.cleanup();
        }
        super.finalize();
    }

    public PrivateKey clone() {
        try {
            return new PrivateKeyRsaPkcs8(this.getEncoded(), null, 0, null);
        }
        catch (DsException dsException) {
            return null;
        }
    }

    public void cleanup() {
        if (this.privKey != null) {
            this.privKey = null;
        }
    }

    public byte[] getEncoded() {
        return this.privKey.getEncoded();
    }

    public byte[] getPublicKeyInfo() {
        return (byte[])this.publicInfo.clone();
    }

    public void digestUpdate(byte[] byArray) {
        if (!this.digestInitialized) {
            this.digestAlg = algs.getDigestAlg(this.getDigestOid(), this.getDigestParams(), null);
            this.digestInitialized = true;
        }
        this.digestAlg.update(byArray);
    }

    public byte[] digestGet() {
        this.digestInitialized = false;
        return this.digestAlg.getDigest();
    }

    public void signatureUpdate(byte[] byArray) {
        if (!this.signatureInitialized) {
            try {
                String string = null;
                String string2 = this.getDigestOid();
                if (string2.equals("1.3.14.3.2.26")) {
                    string = "SHA1withRSA";
                }
                if (string2.equals("2.16.840.1.101.3.4.2.1")) {
                    string = "SHA256withRSA";
                }
                if (string2.equals("2.16.840.1.101.3.4.2.2")) {
                    string = "SHA384withRSA";
                }
                if (string2.equals("2.16.840.1.101.3.4.2.3")) {
                    string = "SHA512withRSA";
                }
                if (string2.equals("2.16.840.1.101.3.4.2.4")) {
                    string = "SHA224withRSA";
                }
                if (string2.equals("1.2.840.113549.2.5")) {
                    string = "MD5withRSA";
                }
                if (string == null) {
                    throw new IllegalArgumentException(new DsAlgorithmException("Unknown RSA digest"));
                }
                this.sg = Signature.getInstance(string);
                this.sg.initSign(this.privKey);
                this.signatureInitialized = true;
            }
            catch (GeneralSecurityException generalSecurityException) {
                return;
            }
        }
        try {
            this.sg.update(byArray);
        }
        catch (SignatureException signatureException) {
            this.signatureInitialized = false;
        }
    }

    public byte[] signatureGet() {
        if (!this.signatureInitialized) {
            return null;
        }
        this.signatureInitialized = false;
        try {
            return this.sg.sign();
        }
        catch (SignatureException signatureException) {
            return null;
        }
    }

    public byte[] decryptSessionKey(String string, byte[] byArray, byte[] byArray2, String string2, byte[] byArray3, byte[] byArray4) throws DsException {
        if (!string.equals("1.2.840.113549.1.1.1")) {
            throw new DsAlgorithmException(string);
        }
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1PADDING");
            cipher.init(2, this.privKey);
            return cipher.doFinal(byArray2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new DsAlgorithmException("", (Throwable)generalSecurityException);
        }
    }
}

