/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor.DsLib.PrivateKeys;

import java.io.UnsupportedEncodingException;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import ua.avtor.DsLib.DsAlgorithmException;
import ua.avtor.DsLib.DsDataNotFoundException;
import ua.avtor.DsLib.DsException;
import ua.avtor.DsLib.DsInvalidParamException;
import ua.avtor.DsLib.KeyStores.KeyStore;
import ua.avtor.DsLib.PrivateKeys.PKCS11Utils.Pkcs11Session;
import ua.avtor.DsLib.PrivateKeys.PrivateKey;
import ua.avtor.DsLib.PrivateKeys.PrivateKeyRsaAbstract;
import ua.avtor.DsLib.Utils.Ddec;
import ua.avtor.DsLib.Utils.DdecException;
import ua.avtor.DsLib.Utils.DerEncoder;

public class PrivateKeyRsa
extends PrivateKeyRsaAbstract {
    protected Pkcs11Session session;
    protected long privKey;
    protected boolean digestInitialized;
    protected boolean signInitialized;
    protected long ckmDigest = 544L;
    protected long ckmSignature = 6L;
    private boolean cloned = false;

    protected PrivateKeyRsa() {
        this.digestInitialized = false;
        this.signInitialized = false;
    }

    public PrivateKeyRsa(Pkcs11Session pkcs11Session, byte[] byArray) throws DsDataNotFoundException, PKCS11Exception {
        byte[] byArray2;
        this.session = pkcs11Session;
        try {
            Ddec.DerGetElementOid(byArray, "SSD");
            byArray2 = Ddec.DerGetElementBuf(byArray, "SsG=SI");
        }
        catch (DdecException ddecException) {
            throw new DsDataNotFoundException();
        }
        if (byArray2.length > 1 && byArray2[0] == 0) {
            byte[] byArray3 = new byte[byArray2.length - 1];
            System.arraycopy(byArray2, 1, byArray3, 0, byArray3.length);
            byArray2 = byArray3;
        }
        try {
            this.privKey = pkcs11Session.getPrivateKeyHandle(null, 288L, byArray2);
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (pKCS11Exception.getErrorCode() != 130L) {
                throw pKCS11Exception;
            }
            pkcs11Session.getPublicKeyHandle(null, 288L, byArray2);
            throw new PKCS11Exception(96L);
        }
        this.digestInitialized = false;
        this.signInitialized = false;
    }

    public PrivateKeyRsa(Pkcs11Session pkcs11Session, long l2) throws PKCS11Exception {
        this.session = pkcs11Session;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L)};
        pkcs11Session.getAttributeValue(l2, cK_ATTRIBUTEArray);
        long l3 = cK_ATTRIBUTEArray[0].getLong();
        this.privKey = l3 == 3L ? l2 : pkcs11Session.getBindedObjectHandle(l2, 3L);
        this.digestInitialized = false;
        this.signInitialized = false;
    }

    public PrivateKeyRsa(Pkcs11Session pkcs11Session, boolean bl, String string, int n2, byte[] byArray) throws PKCS11Exception {
        this.session = pkcs11Session;
        this.generateKey(bl, true, string, n2, byArray);
        this.digestInitialized = false;
        this.signInitialized = false;
    }

    public PrivateKeyRsa(KeyStore keyStore, long l2, Pkcs11Session pkcs11Session, long l3, String string, boolean bl, String string2, int n2, byte[] byArray) throws DsException, PKCS11Exception {
        this.session = pkcs11Session.newSession();
        this.privKey = l3;
        this.cloned = true;
        try {
            if (l3 == 0L) {
                this.generateKey(true, bl, string, n2, byArray);
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.cleanup();
            throw pKCS11Exception;
        }
        this.digestInitialized = false;
        this.signInitialized = false;
    }

    protected void finalize() throws Throwable {
        if (this.session != null) {
            this.cleanup();
        }
        super.finalize();
    }

    public PrivateKey clone() {
        PrivateKeyRsa privateKeyRsa = new PrivateKeyRsa();
        privateKeyRsa.privKey = this.privKey;
        privateKeyRsa.digestOid = this.digestOid;
        privateKeyRsa.digestWithSignOid = this.digestWithSignOid;
        privateKeyRsa.digestWithSignParams = this.digestWithSignParams;
        try {
            privateKeyRsa.session = this.session.newSession();
            privateKeyRsa.cloned = true;
        }
        catch (PKCS11Exception pKCS11Exception) {
            privateKeyRsa.session = this.session;
            privateKeyRsa.privKey = 0L;
        }
        return privateKeyRsa;
    }

    public void cleanup() {
        if (this.cloned) {
            this.session.closeSilent();
            this.session = null;
        }
    }

    protected void generateKey(boolean bl, boolean bl2, String string, int n2, byte[] byArray) throws PKCS11Exception {
        long l2;
        Object object;
        if (string == null) {
            object = Long.toString(System.nanoTime() >> 20, 16);
            object = ((String)object).substring(((String)object).length() - 8);
            string = "cl3keyr" + (String)object;
        }
        object = new CK_ATTRIBUTE[]{};
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{};
        try {
            object = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, bl), new CK_ATTRIBUTE(3L, string.getBytes("UTF8")), new CK_ATTRIBUTE(289L, n2), new CK_ATTRIBUTE(290L, new byte[]{1, 0, 1})};
            cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, bl), new CK_ATTRIBUTE(3L, string.getBytes("UTF8")), new CK_ATTRIBUTE(2L, new byte[]{1}), new CK_ATTRIBUTE(259L, new byte[]{1}), new CK_ATTRIBUTE(354L, new byte[]{0}), new CK_ATTRIBUTE(264L, new byte[]{1}), new CK_ATTRIBUTE(261L, new byte[]{1}), new CK_ATTRIBUTE(263L, new byte[]{1})};
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(unsupportedEncodingException);
        }
        long[] lArray = this.session.generateKeyPair(0L, (CK_ATTRIBUTE[])object, cK_ATTRIBUTEArray);
        long l3 = lArray[0];
        this.privKey = l2 = lArray[1];
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(288L)};
        this.session.getAttributeValue(l3, cK_ATTRIBUTEArray2);
        byte[] byArray2 = cK_ATTRIBUTEArray2[0].getByteArray();
        byte[] byArray3 = new byte[8];
        System.arraycopy(byArray2, byArray2.length - 8, byArray3, 0, 8);
        CK_ATTRIBUTE cK_ATTRIBUTE = new CK_ATTRIBUTE(258L, byArray3);
        this.session.setAttributeValue(l2, new CK_ATTRIBUTE[]{cK_ATTRIBUTE});
        this.session.setAttributeValue(l3, new CK_ATTRIBUTE[]{cK_ATTRIBUTE});
    }

    public void setDigestAlg(String string, byte[] byArray) throws DsException {
        if (string.equals("1.3.14.3.2.26")) {
            this.ckmDigest = 544L;
            this.ckmSignature = 6L;
        } else if (string.equals("2.16.840.1.101.3.4.2.1")) {
            this.ckmDigest = 592L;
            this.ckmSignature = 64L;
        } else if (string.equals("2.16.840.1.101.3.4.2.2")) {
            this.ckmDigest = 608L;
            this.ckmSignature = 65L;
        } else if (string.equals("2.16.840.1.101.3.4.2.3")) {
            this.ckmDigest = 624L;
            this.ckmSignature = 66L;
        } else if (string.equals("2.16.840.1.101.3.4.2.4")) {
            this.ckmDigest = 597L;
            this.ckmSignature = 70L;
        } else {
            throw new DsAlgorithmException();
        }
        super.setDigestAlg(string, byArray);
    }

    public byte[] getPublicKeyInfo() throws DsException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(288L), new CK_ATTRIBUTE(290L)};
        try {
            this.session.getAttributeValue(this.privKey, cK_ATTRIBUTEArray);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new DsException(0x70000003);
        }
        byte[] byArray = cK_ATTRIBUTEArray[0].getByteArray();
        byte[] byArray2 = cK_ATTRIBUTEArray[1].getByteArray();
        DerEncoder derEncoder = new DerEncoder();
        derEncoder.SeqBegin();
        derEncoder.SeqBegin();
        derEncoder.addOid(this.getSignatureOid());
        derEncoder.addNull();
        derEncoder.SeqEnd();
        derEncoder.BitstringBegin();
        derEncoder.SeqBegin();
        derEncoder.addBigintMSB(byArray);
        derEncoder.addBigintMSB(byArray2);
        derEncoder.SeqEnd();
        derEncoder.BitstringEnd();
        derEncoder.SeqEnd();
        return derEncoder.getEncoded();
    }

    public void deleteContainer() throws DsException {
        long l2 = 0L;
        long l3 = 0L;
        try {
            l2 = this.session.getBindedObjectHandle(this.privKey, 2L);
        }
        catch (PKCS11Exception pKCS11Exception) {
            // empty catch block
        }
        try {
            l3 = this.session.getBindedObjectHandle(this.privKey, 1L);
        }
        catch (PKCS11Exception pKCS11Exception) {
            // empty catch block
        }
        try {
            this.session.destroyObject(this.privKey);
            this.privKey = 0L;
            if (l2 != 0L) {
                this.session.destroyObject(l2);
            }
            if (l3 != 0L) {
                this.session.destroyObject(l3);
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new DsInvalidParamException("", (Throwable)pKCS11Exception);
        }
        this.cleanup();
    }

    public void digestUpdate(byte[] byArray) throws DsException {
        try {
            if (!this.digestInitialized) {
                this.session.digestInit(this.ckmDigest, null);
                this.digestInitialized = true;
            }
            this.session.digestUpdate(byArray);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new DsInvalidParamException("", (Throwable)pKCS11Exception);
        }
    }

    public byte[] digestGet() throws DsException {
        this.digestInitialized = false;
        try {
            return this.session.digestFinal();
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new DsInvalidParamException("", (Throwable)pKCS11Exception);
        }
    }

    public void signatureUpdate(byte[] byArray) throws DsException {
        try {
            if (!this.signInitialized) {
                this.session.signInit(this.ckmSignature, this.privKey);
                this.signInitialized = true;
            }
            this.session.signUpdate(byArray);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new DsInvalidParamException("", (Throwable)pKCS11Exception);
        }
    }

    public byte[] signatureGet() throws DsException {
        this.signInitialized = false;
        try {
            return this.session.signFinal();
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new DsInvalidParamException("", (Throwable)pKCS11Exception);
        }
    }

    public byte[] decryptSessionKey(String string, byte[] byArray, byte[] byArray2, String string2, byte[] byArray3, byte[] byArray4) throws DsException {
        long l2 = 0L;
        if (string.equals("1.2.840.113549.1.1.1")) {
            l2 = 1L;
        }
        if (l2 == 0L) {
            throw new DsAlgorithmException();
        }
        try {
            this.session.decryptInit(l2, this.privKey, null);
            return this.session.decrypt(byArray2);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new DsInvalidParamException("", (Throwable)pKCS11Exception);
        }
    }

    public long getHandle() {
        return this.privKey;
    }
}

