/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor.DsLib.PrivateKeys;

import java.math.BigInteger;
import ua.avtor.DsLib.DsAlgorithmException;
import ua.avtor.DsLib.DsDataCorruptedException;
import ua.avtor.DsLib.DsException;
import ua.avtor.DsLib.DsInvalidParamException;
import ua.avtor.DsLib.PrivateKeys.PrivateKey;
import ua.avtor.DsLib.PrivateKeys.PrivateKeyDstuAbstract;
import ua.avtor.DsLib.Utils.ArrayUtil;
import ua.avtor.DsLib.Utils.Ddec;
import ua.avtor.DsLib.Utils.DdecException;
import ua.avtor.DsLib.Utils.DerEncoder;
import ua.kiev.author.cryptolib.EcDHKD;
import ua.kiev.author.cryptolib.EcPoint;
import ua.kiev.author.cryptolib.Ecc4145;
import ua.kiev.author.cryptolib.Gost28147;
import ua.kiev.author.cryptolib.Gost34311;
import ua.kiev.author.cryptolib.Prng4145A;

public class PrivateKeyDstuPkcs8
extends PrivateKeyDstuAbstract {
    private String algOid;
    private byte[] algParams;
    private byte[] keyBytesMsb;
    Ecc4145 ecc = new Ecc4145(new Prng4145A());
    EcDHKD ecdh = null;
    BigInteger privKey;
    protected Gost34311 digest = null;
    protected boolean digestInitialized = false;
    private static byte[] gostSBox114n1 = new byte[]{-87, -42, -21, 69, -15, 60, 112, -126, -128, -60, -106, 123, 35, 31, 94, -83, -10, 88, -21, -92, -64, 55, 41, 29, 56, -39, 107, -16, 37, -54, 78, 23, -8, -23, 114, 13, -58, 21, -76, 58, 40, -105, 95, 11, -63, -34, -93, 100, 56, -75, 100, -22, 44, 23, -97, -48, 18, 62, 109, -72, -6, -59, 121, 4};

    public static boolean initializeEccByParams(String string, byte[] byArray, Ecc4145 ecc4145) {
        byte[] byArray2;
        boolean bl = false;
        if (!string.equals("1.2.804.2.1.1.1.1.3.1.1")) {
            if (string.equals("1.2.804.2.1.1.1.1.3.1.1.1.1")) {
                bl = true;
            } else {
                return false;
            }
        }
        if ((byArray2 = Ddec.TryGetElementBuf(byArray, "Sd")) != null) {
            if (!ecc4145.SetStdParamsByEncodedOid(byArray2, 0)) {
                return false;
            }
        } else {
            BigInteger bigInteger;
            int[] nArray;
            byte[] byArray3;
            int n2;
            int n3;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            try {
                n3 = Ddec.DerGetElementInt(byArray, "SSoe0SI");
                if (Ddec.DerIsElementPresent(byArray, "SSoe0SiI")) {
                    n4 = Ddec.DerGetElementInt(byArray, "SSoe0SiI");
                } else if (Ddec.DerIsElementPresent(byArray, "SSoe0SiSI")) {
                    n6 = Ddec.DerGetElementInt(byArray, "SSoe0SiSI");
                    n5 = Ddec.DerGetElementInt(byArray, "SSoe0SiSiI");
                    n4 = Ddec.DerGetElementInt(byArray, "SSoe0SiSiiI");
                }
            }
            catch (DdecException ddecException) {
                return false;
            }
            if (!ecc4145.SetBaseField(n3, n4, n5, n6)) {
                return false;
            }
            try {
                n2 = Ddec.DerGetElementInt(byArray, "SSoe0sI");
                byArray3 = Ddec.DerGetElementBuf(byArray, "SSoe0siQ");
                nArray = bl ? ecc4145.fromByteArrayEl(byArray3) : ecc4145.fromByteArrayLsbEl(byArray3);
                byArray3 = Ddec.DerGetElementBuf(byArray, "SSoe0siqI");
                bigInteger = new BigInteger(byArray3);
            }
            catch (DdecException ddecException) {
                return false;
            }
            if (!ecc4145.SetCurve(n2, nArray, bigInteger)) {
                return false;
            }
            try {
                byArray3 = Ddec.DerGetElementBuf(byArray, "SSoe0siqiQ");
                int[] nArray2 = bl ? ecc4145.fromByteArrayEl(byArray3) : ecc4145.fromByteArrayLsbEl(byArray3);
                EcPoint ecPoint = ecc4145.ExpandPoint(nArray2);
                if (!ecc4145.SetBasePoint(ecPoint)) {
                    return false;
                }
            }
            catch (DdecException ddecException) {
                return false;
            }
        }
        return true;
    }

    public PrivateKeyDstuPkcs8(byte[] byArray, String string, int n2, byte[] byArray2) throws DsException {
        if (byArray != null) {
            try {
                this.algOid = Ddec.DerGetElementOid(byArray, "SiSD");
                this.algParams = Ddec.DerGetElementBuf(byArray, "SiSdx");
                this.keyBytesMsb = Ddec.DerGetElementBuf(byArray, "SisQ");
            }
            catch (DdecException ddecException) {
                throw new DsInvalidParamException("pkcs8 format", (Throwable)ddecException);
            }
            if (!PrivateKeyDstuPkcs8.initializeEccByParams(this.algOid, this.algParams, this.ecc)) {
                throw new DsAlgorithmException();
            }
            ArrayUtil.reverse(this.keyBytesMsb);
            this.privKey = new BigInteger(1, this.keyBytesMsb);
        } else {
            if (string == null) {
                string = super.getSignatureOid();
            }
            this.algOid = string;
            this.algParams = byArray2;
            if (byArray2 == null) {
                this.algParams = this.getParamsByKeylen(n2);
            }
            if (!PrivateKeyDstuPkcs8.initializeEccByParams(this.algOid, this.algParams, this.ecc)) {
                throw new DsAlgorithmException();
            }
            this.privKey = this.ecc.GeneratePrivateKey();
            this.keyBytesMsb = this.privKey.toByteArray();
            if (this.keyBytesMsb.length < this.ecc.SignSize / 2) {
                ArrayUtil.reverse(this.keyBytesMsb);
                this.keyBytesMsb = ArrayUtil.resizeOf(this.keyBytesMsb, this.ecc.SignSize / 2);
                ArrayUtil.reverse(this.keyBytesMsb);
            }
        }
        byte[] byArray3 = Ddec.TryGetElementBuf(this.algParams, "SxQ");
        this.digest = new Gost34311(byArray3, null, true);
    }

    protected void finalize() throws Throwable {
        if (this.privKey != null) {
            this.cleanup();
        }
        super.finalize();
    }

    protected byte[] getParamsByKeylen(int n2) throws DsException {
        int[] nArray = new int[]{163, 167, 173, 179, 191, 233, 257, 307, 367, 431};
        byte[] byArray = new byte[]{48, 15, 6, 13, 42, -122, 36, 2, 1, 1, 1, 1, 3, 1, 1, 2, 6};
        if (n2 != 0) {
            int n3 = -1;
            for (int i2 = 0; i2 < 10; ++i2) {
                if (nArray[i2] != n2) continue;
                n3 = i2;
            }
            if (n3 < 0) {
                throw new DsInvalidParamException();
            }
            byArray[16] = (byte)n3;
        }
        return byArray;
    }

    public String getSignatureOid() {
        return this.algOid;
    }

    public PrivateKey clone() {
        try {
            return new PrivateKeyDstuPkcs8(this.getEncoded(), null, 0, null);
        }
        catch (DsException dsException) {
            return null;
        }
    }

    public void cleanup() {
        if (this.privKey != null) {
            this.privKey = null;
            ArrayUtil.clear(this.keyBytesMsb);
        }
    }

    public byte[] getEncoded() {
        DerEncoder derEncoder = new DerEncoder();
        derEncoder.SeqBegin();
        derEncoder.addInteger(0);
        derEncoder.SeqBegin();
        derEncoder.addOid(this.getSignatureOid());
        derEncoder.addDerParams(this.algParams);
        derEncoder.SeqEnd();
        derEncoder.addOctetsReverse(this.keyBytesMsb);
        derEncoder.SeqEnd();
        return derEncoder.getEncoded();
    }

    public byte[] getPublicKeyInfo() {
        DerEncoder derEncoder = new DerEncoder();
        derEncoder.SeqBegin();
        derEncoder.SeqBegin();
        derEncoder.addOid(this.getSignatureOid());
        derEncoder.addObject(this.algParams);
        derEncoder.SeqEnd();
        derEncoder.BitstringBegin();
        EcPoint ecPoint = this.ecc.CalcPublicKey(this.privKey);
        byte[] byArray = this.ecc.toByteArray(this.ecc.ShrinkPoint(ecPoint));
        if (!this.getSignatureOid().equals("1.2.804.2.1.1.1.1.3.1.1.1.1")) {
            ArrayUtil.reverse(byArray);
        }
        derEncoder.addOctets(byArray);
        derEncoder.BitstringEnd();
        derEncoder.SeqEnd();
        return derEncoder.getEncoded();
    }

    public void digestUpdate(byte[] byArray) {
        if (!this.digestInitialized) {
            this.digest.Clear();
            this.digestInitialized = true;
        }
        this.digest.Hash(byArray, byArray.length);
    }

    public byte[] digestGet() {
        this.digestInitialized = false;
        return this.digest.HashEnd();
    }

    public void signatureUpdate(byte[] byArray) {
        this.digestUpdate(byArray);
    }

    public byte[] signatureGet() {
        byte[] byArray = this.digestGet();
        byte[] byArray2 = this.ecc.Sign(this.privKey, byArray);
        if (this.internationalMode) {
            int n2 = byArray2.length;
            if (n2 < 128) {
                byArray2 = ArrayUtil.resizeOf(byArray2, n2 + 2);
                System.arraycopy(byArray2, 0, byArray2, 2, n2);
                byArray2[0] = 4;
                byArray2[1] = (byte)n2;
            } else {
                byArray2 = ArrayUtil.resizeOf(byArray2, n2 + 3);
                System.arraycopy(byArray2, 0, byArray2, 3, n2);
                byArray2[0] = 4;
                byArray2[1] = -127;
                byArray2[2] = (byte)n2;
            }
        }
        return byArray2;
    }

    public byte[] decryptSessionKey(String string, byte[] byArray, byte[] byArray2, String string2, byte[] byArray3, byte[] byArray4) throws DsException {
        Gost28147 gost28147;
        byte[] byArray5;
        byte[] byArray6;
        int n2 = -1;
        if (string.equals("1.2.804.2.1.1.1.1.3.4")) {
            n2 = 3;
        }
        if (string.equals("1.2.804.2.1.1.1.1.3.5")) {
            n2 = 2;
        }
        if (n2 < 0) {
            throw new DsAlgorithmException();
        }
        if (byArray3.length > 68 || byArray3[1] > 64) {
            throw new DsAlgorithmException();
        }
        byte[] byArray7 = (byte[])byArray3.clone();
        ArrayUtil.reverse(byArray7);
        byArray7 = ArrayUtil.resizeOf(byArray7, byArray7.length - 2);
        if (string2.equals("1.2.804.2.1.1.1.1.3.1.1.1.1")) {
            ArrayUtil.reverse(byArray7);
        }
        int[] nArray = this.ecc.fromByteArrayEl(byArray7);
        EcPoint ecPoint = this.ecc.ExpandPoint(nArray);
        String string3 = Ddec.TryGetElementOid(byArray, "SD");
        if (string3 == null) {
            throw new DsAlgorithmException();
        }
        if (!string3.equals("1.2.804.2.1.1.1.1.1.1.5")) {
            throw new DsAlgorithmException();
        }
        if (this.ecdh == null) {
            byArray6 = Ddec.TryGetElementBuf(this.algParams, "SxQ");
            this.ecdh = new EcDHKD(this.ecc, byArray6, true);
        }
        if ((byArray5 = (gost28147 = new Gost28147(gostSBox114n1, byArray6 = this.ecdh.DeriveKeyEx(ecPoint, this.privKey, n2, byArray4), true)).UnwrapKey(byArray2, 0, byArray2.length)) == null) {
            throw new DsDataCorruptedException("unwrap");
        }
        return byArray5;
    }
}

