/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor.DsLib.PrivateKeys;

import java.io.UnsupportedEncodingException;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_ECDH1_DERIVE_PARAMS;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import ua.avtor.DsLib.DsAlgorithmException;
import ua.avtor.DsLib.DsDataNotFoundException;
import ua.avtor.DsLib.DsException;
import ua.avtor.DsLib.DsInvalidParamException;
import ua.avtor.DsLib.KeyStores.KeyStore;
import ua.avtor.DsLib.PrivateKeys.PKCS11Utils.Pkcs11Session;
import ua.avtor.DsLib.PrivateKeys.PrivateKey;
import ua.avtor.DsLib.PrivateKeys.PrivateKeyDstuAbstract;
import ua.avtor.DsLib.Utils.Ddec;
import ua.avtor.DsLib.Utils.DdecException;
import ua.avtor.DsLib.Utils.DerEncoder;

public class PrivateKeyDstu
extends PrivateKeyDstuAbstract {
    protected Pkcs11Session session;
    protected long privKey;
    protected byte[] derSBox = new byte[0];
    protected boolean digestInitialized;
    protected boolean signInitialized;
    private boolean cloned = false;

    static void byteReverse(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            byArray2[n3 - i2 - 1] = byArray[n2 + i2];
        }
        System.arraycopy(byArray2, 0, byArray, n2, n3);
    }

    protected PrivateKeyDstu() {
        this.digestInitialized = false;
        this.signInitialized = false;
    }

    public PrivateKeyDstu(Pkcs11Session pkcs11Session, byte[] byArray) throws DsException, PKCS11Exception {
        String string;
        byte[] byArray2;
        this.session = pkcs11Session;
        try {
            byArray2 = Ddec.DerGetElementForward(byArray, "SsG");
            if (byArray2[0] != 4 || byArray2[1] > 64) {
                throw new DsException(0x70000004);
            }
            string = Ddec.DerGetElementOid(byArray, "SSD");
        }
        catch (DdecException ddecException) {
            throw new DsDataNotFoundException();
        }
        if (string.equals("1.2.804.2.1.1.1.1.3.1.1.1.1")) {
            PrivateKeyDstu.byteReverse(byArray2, 2, byArray2.length - 2);
        }
        try {
            this.privKey = pkcs11Session.getPrivateKeyHandle(null, 385L, byArray2);
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (pKCS11Exception.getErrorCode() != 130L) {
                throw pKCS11Exception;
            }
            pkcs11Session.getPublicKeyHandle(null, 385L, byArray2);
            throw new PKCS11Exception(96L);
        }
        this.refreshParams();
        this.digestInitialized = false;
        this.signInitialized = false;
    }

    public PrivateKeyDstu(Pkcs11Session pkcs11Session, long l2) throws PKCS11Exception, DsException {
        this.session = pkcs11Session;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L)};
        pkcs11Session.getAttributeValue(l2, cK_ATTRIBUTEArray);
        long l3 = cK_ATTRIBUTEArray[0].getLong();
        this.privKey = l3 == 3L ? l2 : pkcs11Session.getBindedObjectHandle(l2, 3L);
        this.refreshParams();
        this.digestInitialized = false;
        this.signInitialized = false;
    }

    public PrivateKeyDstu(Pkcs11Session pkcs11Session, boolean bl, String string, int n2, byte[] byArray) throws DsException, PKCS11Exception {
        this.session = pkcs11Session;
        this.generateKey(bl, true, string, n2, byArray);
        this.refreshParams();
        this.digestInitialized = false;
        this.signInitialized = false;
    }

    public PrivateKeyDstu(KeyStore keyStore, long l2, Pkcs11Session pkcs11Session, long l3, String string, boolean bl, String string2, int n2, byte[] byArray) throws DsException, PKCS11Exception {
        this.session = pkcs11Session.newSession();
        this.privKey = l3;
        this.cloned = true;
        try {
            if (l3 == 0L) {
                this.generateKey(true, bl, string, n2, byArray);
            }
            this.refreshParams();
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.cleanup();
            throw pKCS11Exception;
        }
        catch (DsException dsException) {
            this.cleanup();
            throw dsException;
        }
        this.digestInitialized = false;
        this.signInitialized = false;
    }

    protected void finalize() throws Throwable {
        if (this.session != null) {
            this.cleanup();
        }
        super.finalize();
    }

    public PrivateKey clone() {
        PrivateKeyDstu privateKeyDstu = new PrivateKeyDstu();
        privateKeyDstu.privKey = this.privKey;
        privateKeyDstu.derSBox = this.derSBox;
        privateKeyDstu.internationalMode = this.internationalMode;
        try {
            privateKeyDstu.session = this.session.newSession();
            privateKeyDstu.cloned = true;
        }
        catch (PKCS11Exception pKCS11Exception) {
            privateKeyDstu.session = this.session;
            privateKeyDstu.privKey = 0L;
        }
        return privateKeyDstu;
    }

    public void cleanup() {
        if (this.cloned) {
            this.session.closeSilent();
            this.session = null;
        }
    }

    protected void generateKey(boolean bl, boolean bl2, String string, int n2, byte[] byArray) throws DsException, PKCS11Exception {
        long l2;
        if (string == null) {
            long l3 = System.nanoTime();
            String string2 = "0000000" + Long.toString(l3 >> 20 ^ l3, 16);
            string2 = string2.substring(string2.length() - 8);
            string = "cl3keyd" + string2.toUpperCase();
        }
        int[] nArray = new int[]{163, 167, 173, 179, 191, 233, 257, 307, 367, 431};
        byte[] byArray2 = new byte[]{48, 15, 6, 13, 42, -122, 36, 2, 1, 1, 1, 1, 3, 1, 1, 2, 6};
        if (byArray == null) {
            if (n2 != 0) {
                int n3 = -1;
                for (int i2 = 0; i2 < 10; ++i2) {
                    if (nArray[i2] != n2) continue;
                    n3 = i2;
                }
                if (n3 < 0) {
                    throw new DsInvalidParamException();
                }
                byArray2[16] = (byte)n3;
            }
            byArray = byArray2;
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{};
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{};
        try {
            cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, bl), new CK_ATTRIBUTE(3L, string.getBytes("UTF8")), new CK_ATTRIBUTE(384L, byArray)};
            cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, bl), new CK_ATTRIBUTE(3L, string.getBytes("UTF8")), new CK_ATTRIBUTE(2L, true), new CK_ATTRIBUTE(259L, true), new CK_ATTRIBUTE(354L, false), new CK_ATTRIBUTE(264L, true), new CK_ATTRIBUTE(268L, true)};
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(unsupportedEncodingException);
        }
        long[] lArray = this.session.generateKeyPair(2151809090L, cK_ATTRIBUTEArray, cK_ATTRIBUTEArray2);
        long l4 = lArray[0];
        this.privKey = l2 = lArray[1];
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray3 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(385L)};
        this.session.getAttributeValue(l4, cK_ATTRIBUTEArray3);
        byte[] byArray3 = new byte[8];
        System.arraycopy(cK_ATTRIBUTEArray3[0].getByteArray(), 2, byArray3, 0, 8);
        CK_ATTRIBUTE cK_ATTRIBUTE = new CK_ATTRIBUTE(258L, byArray3);
        this.session.setAttributeValue(l2, new CK_ATTRIBUTE[]{cK_ATTRIBUTE});
        this.session.setAttributeValue(l4, new CK_ATTRIBUTE[]{cK_ATTRIBUTE});
    }

    public byte[] getPublicKeyInfo() throws DsException {
        long l2;
        try {
            l2 = this.session.getBindedObjectHandle(this.privKey, 2L);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new DsException(0x70000003, (Throwable)pKCS11Exception);
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(385L), new CK_ATTRIBUTE(384L)};
        try {
            this.session.getAttributeValue(l2, cK_ATTRIBUTEArray);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new DsException(0x70000003, (Throwable)pKCS11Exception);
        }
        byte[] byArray = cK_ATTRIBUTEArray[0].getByteArray();
        byte[] byArray2 = cK_ATTRIBUTEArray[1].getByteArray();
        DerEncoder derEncoder = new DerEncoder();
        derEncoder.SeqBegin();
        derEncoder.SeqBegin();
        derEncoder.addOid(this.getSignatureOid());
        derEncoder.addObject(byArray2);
        derEncoder.SeqEnd();
        derEncoder.BitstringBegin();
        derEncoder.addObject(byArray);
        derEncoder.BitstringEnd();
        derEncoder.SeqEnd();
        return derEncoder.getEncoded();
    }

    public void deleteContainer() throws DsException {
        long l2 = 0L;
        long l3 = 0L;
        try {
            l2 = this.session.getBindedObjectHandle(this.privKey, 2L);
        }
        catch (PKCS11Exception pKCS11Exception) {
            // empty catch block
        }
        try {
            l3 = this.session.getBindedObjectHandle(this.privKey, 1L);
        }
        catch (PKCS11Exception pKCS11Exception) {
            // empty catch block
        }
        try {
            this.session.destroyObject(this.privKey);
            this.privKey = 0L;
            if (l2 != 0L) {
                this.session.destroyObject(l2);
            }
            if (l3 != 0L) {
                this.session.destroyObject(l3);
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new DsInvalidParamException("", (Throwable)pKCS11Exception);
        }
        this.cleanup();
    }

    public void digestUpdate(byte[] byArray) throws DsException {
        try {
            if (!this.digestInitialized) {
                if (this.derSBox.length != 0) {
                    this.session.digestInit(2151809057L, this.derSBox);
                } else {
                    this.session.digestInit(2151809057L, null);
                }
                this.digestInitialized = true;
            }
            this.session.digestUpdate(byArray);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new DsInvalidParamException("", (Throwable)pKCS11Exception);
        }
    }

    public byte[] digestGet() throws DsException {
        this.digestInitialized = false;
        try {
            return this.session.digestFinal();
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new DsInvalidParamException("", (Throwable)pKCS11Exception);
        }
    }

    public void signatureUpdate(byte[] byArray) throws DsException {
        try {
            if (!this.signInitialized) {
                this.session.signInit(2151809074L, this.privKey);
                this.signInitialized = true;
            }
            this.session.signUpdate(byArray);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new DsInvalidParamException("", (Throwable)pKCS11Exception);
        }
    }

    public byte[] signatureGet() throws DsException {
        byte[] byArray;
        this.signInitialized = false;
        try {
            byArray = this.session.signFinal();
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new DsInvalidParamException("", (Throwable)pKCS11Exception);
        }
        if (this.internationalMode) {
            int n2 = byArray.length;
            if (n2 < 128) {
                byte[] byArray2 = new byte[n2 + 2];
                System.arraycopy(byArray, 0, byArray2, 2, n2);
                byArray2[0] = 4;
                byArray2[1] = (byte)n2;
                return byArray2;
            }
            byte[] byArray3 = new byte[n2 + 3];
            System.arraycopy(byArray, 0, byArray3, 3, n2);
            byArray3[0] = 4;
            byArray3[1] = -127;
            byArray3[2] = (byte)n2;
            return byArray3;
        }
        return byArray;
    }

    public byte[] decryptSessionKey(String string, byte[] byArray, byte[] byArray2, String string2, byte[] byArray3, byte[] byArray4) throws DsException {
        Object object;
        long l2 = 0L;
        if (string.equals("1.2.804.2.1.1.1.1.3.4")) {
            l2 = 2151809092L;
        }
        if (string.equals("1.2.804.2.1.1.1.1.3.5")) {
            l2 = 2151809091L;
        }
        if (l2 == 0L) {
            throw new DsAlgorithmException();
        }
        if (byArray3.length > 68 || byArray3[1] > 64) {
            throw new DsAlgorithmException();
        }
        byte[] byArray5 = (byte[])byArray3.clone();
        if (string2.equals("1.2.804.2.1.1.1.1.3.1.1.1.1")) {
            PrivateKeyDstu.byteReverse(byArray5, 2, byArray5.length - 2);
        }
        try {
            object = Ddec.DerGetElementOid(byArray, "SD");
            if (!((String)object).equals("1.2.804.2.1.1.1.1.1.1.5")) {
                throw new DsAlgorithmException();
            }
        }
        catch (DdecException ddecException) {
            throw new DsAlgorithmException();
        }
        object = new CK_ECDH1_DERIVE_PARAMS(2151809553L, byArray4, byArray5);
        try {
            CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(l2, (CK_ECDH1_DERIVE_PARAMS)object);
            long l3 = this.session.deriveKey(cK_MECHANISM, this.privKey, 2151809297L);
            long l4 = this.session.unwrapKey(2151809046L, l3, byArray2, 2151809297L, true);
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
            this.session.getAttributeValue(l4, cK_ATTRIBUTEArray);
            this.session.destroyObject(l3);
            this.session.destroyObject(l4);
            return cK_ATTRIBUTEArray[0].getByteArray();
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new DsInvalidParamException("", (Throwable)pKCS11Exception);
        }
    }

    public long getHandle() {
        return this.privKey;
    }

    protected void refreshParams() throws DsException {
        this.derSBox = new byte[0];
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(384L)};
        try {
            this.session.getAttributeValue(this.privKey, cK_ATTRIBUTEArray);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new DsException(0x70000003, (Throwable)pKCS11Exception);
        }
        byte[] byArray = cK_ATTRIBUTEArray[0].getByteArray();
        byte[] byArray2 = null;
        try {
            byArray2 = Ddec.DerGetElementBuf(byArray, "Sxq");
        }
        catch (DdecException ddecException) {
            // empty catch block
        }
        if (byArray2 != null) {
            this.derSBox = byArray2;
        }
    }
}

