/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor.DsLib.PrivateKeys.PKCS11Utils;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.CK_SESSION_INFO;
import sun.security.pkcs11.wrapper.PKCS11;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import ua.avtor.DsLib.PrivateKeys.PKCS11Utils.Pkcs11Module;

public class Pkcs11Session {
    protected Pkcs11Module p11module;
    protected long hSession;
    protected PKCS11 f;
    final int paddingE = 512;
    final int paddingD = 256;

    public Pkcs11Session(Pkcs11Module pkcs11Module, long l2) {
        this.p11module = pkcs11Module;
        this.f = this.p11module.f;
        this.hSession = l2;
    }

    public PKCS11 getHandle() {
        return this.f;
    }

    public long getSessionHandle() {
        return this.hSession;
    }

    public Pkcs11Module getModule() {
        return this.p11module;
    }

    public Pkcs11Session newSession() throws PKCS11Exception {
        CK_SESSION_INFO cK_SESSION_INFO = this.f.C_GetSessionInfo(this.hSession);
        return this.p11module.newSession(cK_SESSION_INFO.slotID);
    }

    public long getSessionState() throws PKCS11Exception {
        CK_SESSION_INFO cK_SESSION_INFO = this.f.C_GetSessionInfo(this.hSession);
        return cK_SESSION_INFO.state;
    }

    public long getSessionDeviceError() throws PKCS11Exception {
        CK_SESSION_INFO cK_SESSION_INFO = this.f.C_GetSessionInfo(this.hSession);
        return cK_SESSION_INFO.ulDeviceError;
    }

    public void close() throws PKCS11Exception {
        this.f.C_CloseSession(this.hSession);
    }

    public void closeSilent() {
        try {
            this.f.C_CloseSession(this.hSession);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void login(String string) throws PKCS11Exception {
        char[] cArray = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        this.f.C_Login(this.hSession, 1L, cArray);
    }

    public void logout() throws PKCS11Exception {
        this.f.C_Logout(this.hSession);
    }

    public void changePin(String string, String string2) throws PKCS11Exception {
        throw new PKCS11Exception(84L);
    }

    public void findObjectsInit(CK_ATTRIBUTE[] cK_ATTRIBUTEArray) throws PKCS11Exception {
        this.f.C_FindObjectsInit(this.hSession, cK_ATTRIBUTEArray);
    }

    public long[] findObjects(int n2) throws PKCS11Exception {
        return this.f.C_FindObjects(this.hSession, n2);
    }

    public void findObjectsFinal() throws PKCS11Exception {
        this.f.C_FindObjectsFinal(this.hSession);
    }

    public long[] findAllObjects(CK_ATTRIBUTE[] cK_ATTRIBUTEArray) throws PKCS11Exception {
        long[] lArray;
        long[] lArray2 = null;
        this.f.C_FindObjectsInit(this.hSession, cK_ATTRIBUTEArray);
        do {
            lArray = this.f.C_FindObjects(this.hSession, 64L);
            if (lArray2 == null) {
                lArray2 = lArray;
                continue;
            }
            long[] lArray3 = new long[lArray2.length + lArray.length];
            System.arraycopy(lArray2, 0, lArray3, 0, lArray2.length);
            System.arraycopy(lArray, 0, lArray3, lArray2.length, lArray.length);
            lArray2 = lArray3;
        } while (lArray.length == 64);
        this.f.C_FindObjectsFinal(this.hSession);
        return lArray2;
    }

    public long[] findAllObjects(long l2) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, l2)};
        return this.findAllObjects(cK_ATTRIBUTEArray);
    }

    public void getAttributeValue(long l2, CK_ATTRIBUTE[] cK_ATTRIBUTEArray) throws PKCS11Exception {
        this.f.C_GetAttributeValue(this.hSession, l2, cK_ATTRIBUTEArray);
    }

    public void setAttributeValue(long l2, CK_ATTRIBUTE[] cK_ATTRIBUTEArray) throws PKCS11Exception {
        this.f.C_SetAttributeValue(this.hSession, l2, cK_ATTRIBUTEArray);
    }

    public byte[] getAttributeValue(long l2, long l3) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(l3)};
        this.f.C_GetAttributeValue(this.hSession, l2, cK_ATTRIBUTEArray);
        if (cK_ATTRIBUTEArray[0].pValue instanceof char[]) {
            char[] cArray = cK_ATTRIBUTEArray[0].getCharArray();
            byte[] byArray = new byte[cArray.length];
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                byArray[i2] = (byte)cArray[i2];
            }
            return byArray;
        }
        return cK_ATTRIBUTEArray[0].getByteArray();
    }

    public CK_ATTRIBUTE getAttribute(long l2, long l3) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(l3)};
        this.f.C_GetAttributeValue(this.hSession, l2, cK_ATTRIBUTEArray);
        return cK_ATTRIBUTEArray[0];
    }

    public void setAttributeValue(long l2, long l3, byte[] byArray) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(l3, byArray)};
        this.f.C_SetAttributeValue(this.hSession, l2, cK_ATTRIBUTEArray);
    }

    public long createObject(CK_ATTRIBUTE[] cK_ATTRIBUTEArray) throws PKCS11Exception {
        return this.f.C_CreateObject(this.hSession, cK_ATTRIBUTEArray);
    }

    public void destroyObject(long l2) throws PKCS11Exception {
        this.f.C_DestroyObject(this.hSession, l2);
    }

    public long getBindedObjectHandle(long l2, long l3) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L)};
        this.f.C_GetAttributeValue(this.hSession, l2, cK_ATTRIBUTEArray);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, l3), cK_ATTRIBUTEArray[0]};
        this.f.C_FindObjectsInit(this.hSession, cK_ATTRIBUTEArray2);
        long[] lArray = this.f.C_FindObjects(this.hSession, 1L);
        this.f.C_FindObjectsFinal(this.hSession);
        if (lArray.length != 1) {
            throw new PKCS11Exception(130L);
        }
        return lArray[0];
    }

    public long getPublicKeyHandle(String string, long l2, byte[] byArray) throws PKCS11Exception {
        ArrayList<CK_ATTRIBUTE> arrayList = new ArrayList<CK_ATTRIBUTE>();
        arrayList.add(new CK_ATTRIBUTE(0L, 2L));
        arrayList.add(new CK_ATTRIBUTE(1L, true));
        if (string != null) {
            try {
                arrayList.add(new CK_ATTRIBUTE(3L, string.getBytes("UTF8")));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        if (byArray != null) {
            arrayList.add(new CK_ATTRIBUTE(l2, byArray));
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[arrayList.size()];
        for (int i2 = 0; i2 < cK_ATTRIBUTEArray.length; ++i2) {
            cK_ATTRIBUTEArray[i2] = (CK_ATTRIBUTE)arrayList.get(i2);
        }
        this.f.C_FindObjectsInit(this.hSession, cK_ATTRIBUTEArray);
        long[] lArray = this.f.C_FindObjects(this.hSession, 1L);
        this.f.C_FindObjectsFinal(this.hSession);
        if (lArray.length != 1) {
            throw new PKCS11Exception(130L);
        }
        return lArray[0];
    }

    public long getPrivateKeyHandle(String string, long l2, byte[] byArray) throws PKCS11Exception {
        long l3 = this.getPublicKeyHandle(string, l2, byArray);
        return this.getBindedObjectHandle(l3, 3L);
    }

    public byte[] getDataValue(String string, String string2) throws PKCS11Exception {
        ArrayList<CK_ATTRIBUTE> arrayList = new ArrayList<CK_ATTRIBUTE>();
        arrayList.add(new CK_ATTRIBUTE(0L, 0L));
        if (string != null) {
            try {
                arrayList.add(new CK_ATTRIBUTE(3L, string.getBytes("UTF8")));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        if (string2 != null) {
            try {
                arrayList.add(new CK_ATTRIBUTE(16L, string2.getBytes("UTF8")));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[arrayList.size()];
        for (int i2 = 0; i2 < cK_ATTRIBUTEArray.length; ++i2) {
            cK_ATTRIBUTEArray[i2] = (CK_ATTRIBUTE)arrayList.get(i2);
        }
        this.f.C_FindObjectsInit(this.hSession, cK_ATTRIBUTEArray);
        long[] lArray = this.f.C_FindObjects(this.hSession, 1L);
        this.f.C_FindObjectsFinal(this.hSession);
        if (lArray.length != 1) {
            throw new PKCS11Exception(130L);
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
        this.f.C_GetAttributeValue(this.hSession, lArray[0], cK_ATTRIBUTEArray2);
        return cK_ATTRIBUTEArray2[0].getByteArray();
    }

    public byte[] getCertificateBySubject(byte[] byArray) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 1L), new CK_ATTRIBUTE(257L, byArray)};
        this.f.C_FindObjectsInit(this.hSession, cK_ATTRIBUTEArray);
        long[] lArray = this.f.C_FindObjects(this.hSession, 1L);
        this.f.C_FindObjectsFinal(this.hSession);
        if (lArray.length != 1) {
            throw new PKCS11Exception(130L);
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
        this.f.C_GetAttributeValue(this.hSession, lArray[0], cK_ATTRIBUTEArray2);
        return cK_ATTRIBUTEArray2[0].getByteArray();
    }

    public void setCertificateForKey(long l2, byte[] byArray) throws PKCS11Exception {
        try {
            long l3 = this.getBindedObjectHandle(l2, 1L);
            this.destroyObject(l3);
        }
        catch (PKCS11Exception pKCS11Exception) {
            // empty catch block
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L), new CK_ATTRIBUTE(258L), new CK_ATTRIBUTE(1L)};
        this.getAttributeValue(l2, cK_ATTRIBUTEArray);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{cK_ATTRIBUTEArray[0], cK_ATTRIBUTEArray[1], cK_ATTRIBUTEArray[2], new CK_ATTRIBUTE(0L, 1L), new CK_ATTRIBUTE(17L, byArray)};
        this.createObject(cK_ATTRIBUTEArray2);
    }

    public void generateRandom(byte[] byArray) throws PKCS11Exception {
        this.f.C_GenerateRandom(this.hSession, byArray);
    }

    public long[] generateKeyPair(long l2, CK_ATTRIBUTE[] cK_ATTRIBUTEArray, CK_ATTRIBUTE[] cK_ATTRIBUTEArray2) throws PKCS11Exception {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(l2);
        return this.f.C_GenerateKeyPair(this.hSession, cK_MECHANISM, cK_ATTRIBUTEArray, cK_ATTRIBUTEArray2);
    }

    public long[] generateEphemeralKeyPair(long l2, byte[] byArray) throws PKCS11Exception {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(l2);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, false), new CK_ATTRIBUTE(268L, true), new CK_ATTRIBUTE(2L, true), new CK_ATTRIBUTE(384L, byArray)};
        return this.f.C_GenerateKeyPair(this.hSession, cK_MECHANISM, cK_ATTRIBUTEArray, cK_ATTRIBUTEArray);
    }

    public long generateSecretKey(long l2, long l3, byte[] byArray) throws PKCS11Exception {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(l2);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 4L), new CK_ATTRIBUTE(1L, false), new CK_ATTRIBUTE(354L, true), new CK_ATTRIBUTE(259L, byArray == null), new CK_ATTRIBUTE(256L, l3)};
        long l4 = this.f.C_GenerateKey(this.hSession, cK_MECHANISM, cK_ATTRIBUTEArray);
        if (byArray != null) {
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
            this.f.C_GetAttributeValue(this.hSession, l4, cK_ATTRIBUTEArray2);
            System.arraycopy(cK_ATTRIBUTEArray2[0].getByteArray(), 0, byArray, 0, cK_ATTRIBUTEArray2[0].getByteArray().length);
        }
        return l4;
    }

    public byte[] wrapKey(long l2, long l3, long l4) throws PKCS11Exception {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(l2);
        return this.f.C_WrapKey(this.hSession, cK_MECHANISM, l3, l4);
    }

    public long unwrapKey(long l2, long l3, byte[] byArray, long l4, boolean bl) throws PKCS11Exception {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(l2);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = bl ? new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 4L), new CK_ATTRIBUTE(1L, false), new CK_ATTRIBUTE(256L, l4), new CK_ATTRIBUTE(259L, false), new CK_ATTRIBUTE(354L, true)} : new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 4L), new CK_ATTRIBUTE(1L, false), new CK_ATTRIBUTE(256L, l4)};
        return this.f.C_UnwrapKey(this.hSession, cK_MECHANISM, l3, byArray, cK_ATTRIBUTEArray);
    }

    public long deriveKey(CK_MECHANISM cK_MECHANISM, long l2, long l3) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 4L), new CK_ATTRIBUTE(1L, false), new CK_ATTRIBUTE(256L, l3), new CK_ATTRIBUTE(262L, true), new CK_ATTRIBUTE(263L, true)};
        return this.f.C_DeriveKey(this.hSession, cK_MECHANISM, l2, cK_ATTRIBUTEArray);
    }

    public void digestInit(long l2, byte[] byArray) throws PKCS11Exception {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(l2, byArray);
        this.f.C_DigestInit(this.hSession, cK_MECHANISM);
    }

    public void signInit(long l2, long l3) throws PKCS11Exception {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(l2);
        this.f.C_SignInit(this.hSession, cK_MECHANISM, l3);
    }

    public void verifyInit(long l2, long l3) throws PKCS11Exception {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(l2);
        this.f.C_VerifyInit(this.hSession, cK_MECHANISM, l3);
    }

    public void encryptInit(long l2, long l3, byte[] byArray) throws PKCS11Exception {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(l2, byArray);
        this.f.C_EncryptInit(this.hSession, cK_MECHANISM, l3);
    }

    public void decryptInit(long l2, long l3, byte[] byArray) throws PKCS11Exception {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(l2, byArray);
        this.f.C_DecryptInit(this.hSession, cK_MECHANISM, l3);
    }

    public void digestUpdate(byte[] byArray) throws PKCS11Exception {
        this.f.C_DigestUpdate(this.hSession, 0L, byArray, 0, byArray.length);
    }

    public void digestUpdate(byte[] byArray, int n2, int n3) throws PKCS11Exception {
        this.f.C_DigestUpdate(this.hSession, 0L, byArray, n2, n3);
    }

    public byte[] digestFinal() throws PKCS11Exception {
        byte[] byArray = new byte[64];
        int n2 = this.f.C_DigestFinal(this.hSession, byArray, 0, byArray.length);
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    public byte[] digest(byte[] byArray) throws PKCS11Exception {
        this.digestUpdate(byArray);
        return this.digestFinal();
    }

    public void signUpdate(byte[] byArray) throws PKCS11Exception {
        this.f.C_SignUpdate(this.hSession, 0L, byArray, 0, byArray.length);
    }

    public void signUpdate(byte[] byArray, int n2, int n3) throws PKCS11Exception {
        this.f.C_SignUpdate(this.hSession, 0L, byArray, n2, n3);
    }

    public byte[] signFinal() throws PKCS11Exception {
        return this.f.C_SignFinal(this.hSession, 0);
    }

    public byte[] sign(byte[] byArray) throws PKCS11Exception {
        return this.f.C_Sign(this.hSession, byArray);
    }

    public void verifyUpdate(byte[] byArray) throws PKCS11Exception {
        this.f.C_VerifyUpdate(this.hSession, 0L, byArray, 0, byArray.length);
    }

    public void verifyUpdate(byte[] byArray, int n2, int n3) throws PKCS11Exception {
        this.f.C_VerifyUpdate(this.hSession, 0L, byArray, n2, n3);
    }

    public void verifyFinal(byte[] byArray) throws PKCS11Exception {
        this.f.C_VerifyFinal(this.hSession, byArray);
    }

    public void verify(byte[] byArray, byte[] byArray2) throws PKCS11Exception {
        this.f.C_Verify(this.hSession, byArray, byArray2);
    }

    public byte[] encryptUpdate(byte[] byArray) throws PKCS11Exception {
        byte[] byArray2 = new byte[byArray.length + 512];
        int n2 = this.f.C_EncryptUpdate(this.hSession, 0L, byArray, 0, byArray.length, 0L, byArray2, 0, byArray2.length);
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray2, 0, byArray3, 0, n2);
        return byArray3;
    }

    public byte[] encryptUpdate(byte[] byArray, int n2, int n3) throws PKCS11Exception {
        byte[] byArray2 = new byte[n3 + 512];
        int n4 = this.f.C_EncryptUpdate(this.hSession, 0L, byArray, n2, n3, 0L, byArray2, 0, byArray2.length);
        byte[] byArray3 = new byte[n4];
        System.arraycopy(byArray2, 0, byArray3, 0, n4);
        return byArray3;
    }

    public byte[] encryptFinal() throws PKCS11Exception {
        byte[] byArray = new byte[512];
        int n2 = this.f.C_EncryptFinal(this.hSession, 0L, byArray, 0, byArray.length);
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    public byte[] encrypt(byte[] byArray) throws PKCS11Exception {
        byte[] byArray2 = new byte[byArray.length + 512];
        int n2 = this.f.C_Encrypt(this.hSession, byArray, 0, byArray.length, byArray2, 0, byArray2.length);
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray2, 0, byArray3, 0, n2);
        return byArray3;
    }

    public byte[] decryptUpdate(byte[] byArray) throws PKCS11Exception {
        byte[] byArray2 = new byte[byArray.length + 256];
        int n2 = this.f.C_DecryptUpdate(this.hSession, 0L, byArray, 0, byArray.length, 0L, byArray2, 0, byArray2.length);
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray2, 0, byArray3, 0, n2);
        return byArray3;
    }

    public byte[] decryptUpdate(byte[] byArray, int n2, int n3) throws PKCS11Exception {
        byte[] byArray2 = new byte[n3 + 256];
        int n4 = this.f.C_DecryptUpdate(this.hSession, 0L, byArray, n2, n3, 0L, byArray2, 0, byArray2.length);
        byte[] byArray3 = new byte[n4];
        System.arraycopy(byArray2, 0, byArray3, 0, n4);
        return byArray3;
    }

    public byte[] decryptFinal() throws PKCS11Exception {
        byte[] byArray = new byte[256];
        int n2 = this.f.C_DecryptFinal(this.hSession, 0L, byArray, 0, byArray.length);
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    public byte[] decrypt(byte[] byArray) throws PKCS11Exception {
        byte[] byArray2 = new byte[byArray.length + 256];
        int n2 = this.f.C_Decrypt(this.hSession, byArray, 0, byArray.length, byArray2, 0, byArray2.length);
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray2, 0, byArray3, 0, n2);
        return byArray3;
    }
}

