/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor.DsLib;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;
import ua.avtor.DsLib.DsDataCorruptedException;
import ua.avtor.DsLib.DsException;
import ua.avtor.DsLib.DsInvalidOperationException;
import ua.avtor.DsLib.DsInvalidParamException;
import ua.avtor.DsLib.PrivateKeys.PrivateKey;
import ua.avtor.DsLib.Utils.Ddec;
import ua.avtor.DsLib.Utils.DdecException;
import ua.avtor.DsLib.Utils.DerEncoder;

public class Pkcs10Request {
    ArrayList<byte[]> subject = new ArrayList();
    ArrayList<byte[]> extensions = new ArrayList();
    ArrayList<byte[]> dirattribs = new ArrayList();
    PrivateKey privateKey;
    static final ST_X500KeysOidsTp[] X500KeysOidsTp = new ST_X500KeysOidsTp[]{new ST_X500KeysOidsTp("CN", "2.5.4.3", 0), new ST_X500KeysOidsTp("SN", "2.5.4.4", 0), new ST_X500KeysOidsTp("?", "2.5.4.5", 19), new ST_X500KeysOidsTp("C", "2.5.4.6", 19), new ST_X500KeysOidsTp("L", "2.5.4.7", 0), new ST_X500KeysOidsTp("ST", "2.5.4.8", 0), new ST_X500KeysOidsTp("O", "2.5.4.10", 0), new ST_X500KeysOidsTp("OU", "2.5.4.11", 0), new ST_X500KeysOidsTp("T", "2.5.4.12", 0), new ST_X500KeysOidsTp("?", "2.5.4.20", 19), new ST_X500KeysOidsTp("?", "2.5.4.24", 18), new ST_X500KeysOidsTp("?", "2.5.4.25", 18), new ST_X500KeysOidsTp("?", "2.5.4.27", 19), new ST_X500KeysOidsTp("G", "2.5.4.42", 0), new ST_X500KeysOidsTp("I", "2.5.4.43", 0), new ST_X500KeysOidsTp("?", "2.5.4.46", 19), new ST_X500KeysOidsTp("DC", "0.9.2342.19200300.100.1.25", 22), new ST_X500KeysOidsTp("E", "1.2.840.113549.1.9.1", 22), new ST_X500KeysOidsTp("STREET", "2.5.4.9", 0)};

    public Pkcs10Request(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public final void addSubjectName(String string, String string2) throws DsInvalidParamException {
        String string3 = string;
        if (string.charAt(0) >= 'A') {
            string3 = null;
            for (ST_X500KeysOidsTp sT_X500KeysOidsTp : X500KeysOidsTp) {
                if (!string.equals(sT_X500KeysOidsTp.key)) continue;
                string3 = sT_X500KeysOidsTp.oid;
                break;
            }
            if (string3 == null) {
                throw new DsInvalidParamException();
            }
        }
        byte by = 0;
        for (ST_X500KeysOidsTp sT_X500KeysOidsTp : X500KeysOidsTp) {
            if (!string3.equals(sT_X500KeysOidsTp.oid)) continue;
            by = sT_X500KeysOidsTp.tag;
            break;
        }
        if (by == 0) {
            by = 12;
        }
        DerEncoder derEncoder = new DerEncoder();
        derEncoder.SeqBegin();
        derEncoder.addOid(string3);
        derEncoder.addSpecific(by, string2);
        derEncoder.SeqEnd();
        this.subject.add(derEncoder.getEncoded());
    }

    public final void addSubjectComponent(String string, byte[] byArray) {
        DerEncoder derEncoder = new DerEncoder();
        derEncoder.SeqBegin();
        derEncoder.addOid(string);
        derEncoder.addObject(byArray);
        derEncoder.SeqEnd();
        this.subject.add(derEncoder.getEncoded());
    }

    public final void setSubjectDN(byte[] byArray) {
        this.subject.clear();
        Ddec.DerSearchRec derSearchRec = Ddec.DerFindFirstElement(byArray, "S");
        while (derSearchRec != null) {
            try {
                this.subject.add(Ddec.DerGetElementBuf(derSearchRec.der, "U"));
            }
            catch (DdecException ddecException) {
                // empty catch block
            }
            derSearchRec = Ddec.DerFindNextElement(derSearchRec);
        }
    }

    public final void addExtension(String string, boolean bl, byte[] byArray) {
        DerEncoder derEncoder = new DerEncoder();
        derEncoder.SeqBegin();
        derEncoder.addOid(string);
        if (bl) {
            derEncoder.addBool(true);
        }
        derEncoder.OctetBegin();
        derEncoder.addObject(byArray);
        derEncoder.OctetEnd();
        derEncoder.SeqEnd();
        this.extensions.add(derEncoder.getEncoded());
    }

    public final void addExtensionKu(byte by) {
        byte[] byArray = new byte[]{3, 2, 1, by};
        if ((by & 7) == 0) {
            byArray[2] = 3;
        }
        if ((by & 0xF) == 0) {
            byArray[2] = 4;
        }
        if ((by & 0x3F) == 0) {
            byArray[2] = 6;
        }
        if ((by & 0x7F) == 0) {
            byArray[2] = 7;
        }
        this.addExtension("2.5.29.15", true, byArray);
    }

    public final void addExtensionKu(int n2) {
        this.addExtensionKu((byte)n2);
    }

    public final void addExtensionEku(boolean bl, String string) {
        DerEncoder derEncoder = new DerEncoder();
        derEncoder.SeqBegin();
        for (String string2 : string.split("[, ]")) {
            if (string2.equals("")) continue;
            derEncoder.addOid(string2);
        }
        derEncoder.SeqEnd();
        this.addExtension("2.5.29.37", bl, derEncoder.getEncoded());
    }

    public final void addExtensionRfc822Name(String string) {
        DerEncoder derEncoder = new DerEncoder();
        derEncoder.SeqBegin();
        derEncoder.addSpecific((byte)-127, string);
        derEncoder.SeqEnd();
        this.addExtension("2.5.29.17", false, derEncoder.getEncoded());
    }

    public void addDirectoryAttribute(String string, String string2) {
        DerEncoder derEncoder = new DerEncoder();
        derEncoder.SeqBegin();
        derEncoder.addOid(string);
        derEncoder.SetBegin();
        try {
            byte by = 19;
            byte[] byArray = string2.getBytes("UTF8");
            if (byArray.length > string2.length()) {
                by = 12;
            }
            derEncoder.addSpecific(by, byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        derEncoder.SetEnd();
        derEncoder.SeqEnd();
        this.dirattribs.add(derEncoder.getEncoded());
    }

    public final void addExtensionSubjectKeyId() throws DsException {
        byte[] byArray;
        if (this.privateKey == null) {
            throw new DsInvalidOperationException();
        }
        byte[] byArray2 = this.getPublicKeyInfo();
        try {
            byArray = Ddec.DerGetElementBuf(byArray2, "SsG");
        }
        catch (DdecException ddecException) {
            throw new DsDataCorruptedException();
        }
        this.privateKey.digestUpdate(byArray);
        byte[] byArray3 = this.privateKey.digestGet();
        DerEncoder derEncoder = new DerEncoder();
        derEncoder.addOctets(byArray3);
        this.addExtension("2.5.29.14", false, derEncoder.getEncoded());
    }

    public byte[] getSubjectDN() {
        DerEncoder derEncoder = new DerEncoder();
        derEncoder.SeqBegin();
        for (byte[] byArray : this.subject) {
            derEncoder.SetBegin();
            derEncoder.addObject(byArray);
            derEncoder.SetEnd();
        }
        derEncoder.SeqEnd();
        return derEncoder.getEncoded();
    }

    public byte[] getExtensions() {
        DerEncoder derEncoder = new DerEncoder();
        derEncoder.SeqBegin();
        for (byte[] byArray : this.extensions) {
            derEncoder.addObject(byArray);
        }
        if (!this.dirattribs.isEmpty()) {
            derEncoder.SeqBegin();
            derEncoder.addOid("2.5.29.9");
            derEncoder.OctetBegin();
            derEncoder.SeqBegin();
            for (byte[] byArray : this.dirattribs) {
                derEncoder.addObject(byArray);
            }
            derEncoder.SeqEnd();
            derEncoder.OctetEnd();
            derEncoder.SeqEnd();
        }
        derEncoder.SeqEnd();
        return derEncoder.getEncoded();
    }

    public byte[] getPublicKeyInfo() throws DsException {
        if (this.privateKey == null) {
            throw new DsInvalidOperationException();
        }
        return this.privateKey.getPublicKeyInfo();
    }

    public String getPublicKeyAlgOid() throws DsException {
        byte[] byArray = this.getPublicKeyInfo();
        try {
            return Ddec.DerGetElementOid(byArray, "SSD");
        }
        catch (DdecException ddecException) {
            throw new DsDataCorruptedException();
        }
    }

    public byte[] getEncoded() throws DsException {
        DerEncoder derEncoder = new DerEncoder();
        derEncoder.SeqBegin();
        derEncoder.addInteger(0);
        derEncoder.addObject(this.getSubjectDN());
        derEncoder.addObject(this.getPublicKeyInfo());
        if (this.extensions.size() > 0) {
            derEncoder.SpecificBegin((byte)-96);
            derEncoder.SeqBegin();
            derEncoder.addOid("1.2.840.113549.1.9.14");
            derEncoder.SetBegin();
            derEncoder.addObject(this.getExtensions());
            derEncoder.SetEnd();
            derEncoder.SeqEnd();
            derEncoder.SpecificEnd();
        }
        derEncoder.SeqEnd();
        return this.signAndEncode(derEncoder.getEncoded());
    }

    public byte[] getEncodedAsCert(int n2) throws DsException {
        DerEncoder derEncoder = new DerEncoder();
        derEncoder.SeqBegin();
        derEncoder.SpecificBegin((byte)-96);
        derEncoder.addInteger(2);
        derEncoder.SpecificEnd();
        derEncoder.addInteger((int)System.currentTimeMillis());
        derEncoder.SeqBegin();
        derEncoder.addOid(this.privateKey.getHashWithSignOid());
        derEncoder.addDerParams(this.privateKey.getHashWithSignParams());
        derEncoder.SeqEnd();
        derEncoder.addObject(this.getSubjectDN());
        derEncoder.SeqBegin();
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.set(14, 0);
        calendar.set(13, 0);
        derEncoder.addTime(calendar.getTimeInMillis());
        calendar.add(5, n2);
        derEncoder.addTime(calendar.getTimeInMillis());
        derEncoder.SeqEnd();
        derEncoder.addObject(this.getSubjectDN());
        derEncoder.addObject(this.getPublicKeyInfo());
        if (this.extensions.size() > 0) {
            derEncoder.SpecificBegin((byte)-93);
            derEncoder.addObject(this.getExtensions());
            derEncoder.SpecificEnd();
        }
        derEncoder.SeqEnd();
        return this.signAndEncode(derEncoder.getEncoded());
    }

    public byte[] getEncodedAsCert() throws DsException {
        return this.getEncodedAsCert(365);
    }

    byte[] signAndEncode(byte[] byArray) throws DsException {
        this.privateKey.signatureUpdate(byArray);
        byte[] byArray2 = this.privateKey.signatureGetAsRequest();
        DerEncoder derEncoder = new DerEncoder();
        derEncoder.SeqBegin();
        derEncoder.addObject(byArray);
        derEncoder.SeqBegin();
        derEncoder.addOid(this.privateKey.getHashWithSignOid());
        derEncoder.addDerParams(this.privateKey.getHashWithSignParams());
        derEncoder.SeqEnd();
        derEncoder.BitstringBegin();
        derEncoder.addObject(byArray2);
        derEncoder.BitstringEnd();
        derEncoder.SeqEnd();
        return derEncoder.getEncoded();
    }

    static class ST_X500KeysOidsTp {
        public String key;
        public String oid;
        public byte tag;

        public ST_X500KeysOidsTp(String string, String string2, byte by) {
            this.key = string;
            this.oid = string2;
            this.tag = by;
        }
    }
}

