/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor.DsLib;

import java.util.ArrayList;
import ua.avtor.DsLib.Algorithms.CryptoAlgorithmFactory;
import ua.avtor.DsLib.Algorithms.MessageDigestAlg;
import ua.avtor.DsLib.Algorithms.MessageVerifierAlg;
import ua.avtor.DsLib.Certificate;
import ua.avtor.DsLib.CertificateException;
import ua.avtor.DsLib.Certificates.CertificateFinder;
import ua.avtor.DsLib.DsAlgorithmException;
import ua.avtor.DsLib.DsDataCorruptedException;
import ua.avtor.DsLib.DsInvalidOperationException;
import ua.avtor.DsLib.OcspRequest;
import ua.avtor.DsLib.Utils.Ddec;
import ua.avtor.DsLib.Utils.DdecException;
import ua.avtor.DsLib.Utils.DerEncoder;
import ua.avtor.DsLib.Utils.Pointer;
import ua.avtor.DsLib.Utils.Three;
import ua.avtor.DsLib.Utils.Two;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OcspResponse {
    public static final int OCS_OK = 0;
    public static final int OCS_REVOKED = 1;
    public static final int OCS_UNKNOWN = 2;
    public static final int OCS_NOTINRESP = -1;
    protected byte[] resp = null;
    protected int verificationStatus;
    protected int responseStatus;
    byte[] pBor = null;
    ArrayList<Certificate> additionalCerts = new ArrayList();

    public OcspResponse(byte[] byArray) throws DsDataCorruptedException {
        if (byArray.length <= 2 || Ddec.DerGetTotalSize(byArray) != byArray.length) {
            throw new DsDataCorruptedException();
        }
        this.responseStatus = 0;
        this.verificationStatus = 1;
        try {
            this.responseStatus = Ddec.DerGetElementInt(byArray, "SZ");
        }
        catch (DdecException ddecException) {
            throw new DsDataCorruptedException();
        }
        try {
            this.pBor = Ddec.DerGetElementBuf(byArray, "SzE0SdQs");
        }
        catch (DdecException ddecException) {
            this.pBor = null;
        }
        if (this.pBor == null && this.responseStatus == 0) {
            throw new DsDataCorruptedException();
        }
        if (this.pBor != null) {
            String string;
            try {
                string = Ddec.DerGetElementOid(byArray, "SzE0SD");
            }
            catch (DdecException ddecException) {
                string = "";
            }
            if (!string.equals("1.3.6.1.5.5.7.48.1.1")) {
                throw new DsDataCorruptedException();
            }
            this.resp = this.pBor;
        }
    }

    public OcspResponse(byte[] byArray, boolean bl) throws DsInvalidOperationException, DsDataCorruptedException {
        if (!bl) {
            throw new DsInvalidOperationException();
        }
        this.responseStatus = 0;
        this.verificationStatus = 1;
        this.resp = byArray;
        this.pBor = this.resp;
        try {
            Ddec.DerGetElementNull(this.pBor, "SSoe0xT");
        }
        catch (DdecException ddecException) {
            throw new DsDataCorruptedException();
        }
    }

    public OcspResponse clone() {
        OcspResponse ocspResponse = new OcspResponse();
        ocspResponse.resp = this.resp;
        ocspResponse.pBor = this.pBor;
        ocspResponse.responseStatus = this.responseStatus;
        return ocspResponse;
    }

    public final byte[] getEncoded() {
        DerEncoder derEncoder = new DerEncoder();
        derEncoder.SeqBegin();
        byte[] byArray = new byte[]{(byte)this.responseStatus};
        derEncoder.addSpecific((byte)10, byArray);
        derEncoder.SpecificBegin((byte)-96);
        derEncoder.SeqBegin();
        derEncoder.addOid("1.3.6.1.5.5.7.48.1.1");
        derEncoder.OctetBegin();
        derEncoder.addObject(this.resp);
        derEncoder.OctetEnd();
        derEncoder.SeqEnd();
        derEncoder.SpecificEnd();
        derEncoder.SeqEnd();
        return derEncoder.getEncoded();
    }

    public final int getResponseStatus() {
        return this.responseStatus;
    }

    public final long getResponseTime() throws DsInvalidOperationException, DsDataCorruptedException {
        if (this.pBor == null) {
            throw new DsInvalidOperationException();
        }
        try {
            return Ddec.DerGetElementTime(this.pBor, "SSoe0xT");
        }
        catch (DdecException ddecException) {
            throw new DsDataCorruptedException();
        }
    }

    public final byte[] getResponderId() throws DsInvalidOperationException, DsDataCorruptedException {
        if (this.pBor == null) {
            throw new DsInvalidOperationException();
        }
        try {
            return Ddec.DerGetElementBuf(this.pBor, "SSoe0x");
        }
        catch (DdecException ddecException) {
            throw new DsDataCorruptedException();
        }
    }

    public final byte[] getOcspIdentifier() throws DsInvalidOperationException, DsDataCorruptedException {
        if (this.pBor == null) {
            throw new DsInvalidOperationException();
        }
        DerEncoder derEncoder = new DerEncoder();
        derEncoder.SeqBegin();
        try {
            derEncoder.addObject(Ddec.DerGetElementBuf(this.pBor, "SSoe0x"));
            derEncoder.addObject(Ddec.DerGetElementBuf(this.pBor, "SSoe0xt"));
        }
        catch (DdecException ddecException) {
            throw new DsDataCorruptedException();
        }
        derEncoder.SeqEnd();
        return derEncoder.getEncoded();
    }

    public final byte[] getBasicOCSPResponse() throws DsInvalidOperationException {
        if (this.pBor == null) {
            throw new DsInvalidOperationException();
        }
        return this.pBor;
    }

    public final Three<Integer, Integer, Long> getCertificateStatus(Certificate certificate, String string, CryptoAlgorithmFactory cryptoAlgorithmFactory) throws DsInvalidOperationException, DsDataCorruptedException, DsAlgorithmException, CertificateException {
        MessageDigestAlg messageDigestAlg;
        if (this.pBor == null) {
            throw new DsInvalidOperationException();
        }
        if (string == null || string.equals("")) {
            try {
                string = Ddec.DerGetElementOid(this.pBor, "SSoe0xtSSSSD");
            }
            catch (DdecException ddecException) {
                throw new DsDataCorruptedException();
            }
        }
        if ((messageDigestAlg = cryptoAlgorithmFactory.getDigestAlg(string, null, null)) == null) {
            throw new DsAlgorithmException();
        }
        byte[] byArray = certificate.getSerial();
        byte[] byArray2 = certificate.getIssuerDN();
        messageDigestAlg.update(byArray2);
        byte[] byArray3 = messageDigestAlg.getDigest();
        return this.calcStatus(byArray, byArray3);
    }

    public final Three<Integer, Integer, Long> getCerificateStatus(Certificate certificate, String string, CryptoAlgorithmFactory cryptoAlgorithmFactory) throws DsInvalidOperationException, DsDataCorruptedException, DsAlgorithmException, CertificateException {
        return this.getCertificateStatus(certificate, string, cryptoAlgorithmFactory);
    }

    public final Three<Integer, Integer, Long> getCertificateStatus(OcspRequest ocspRequest) throws DsInvalidOperationException, DsDataCorruptedException {
        byte[] byArray;
        byte[] byArray2;
        if (this.pBor == null) {
            throw new DsInvalidOperationException();
        }
        byte[] byArray3 = ocspRequest.getEncoded();
        try {
            byArray2 = Ddec.DerGetElementBuf(byArray3, "SSoe0oe1SSSsqqi");
        }
        catch (DdecException ddecException) {
            throw new DsDataCorruptedException();
        }
        try {
            byArray = Ddec.DerGetElementBuf(byArray3, "SSoe0oe1SSSsQ");
        }
        catch (DdecException ddecException) {
            byArray = null;
        }
        return this.calcStatus(byArray2, byArray);
    }

    public final Three<Integer, Integer, Long> getCerificateStatus(OcspRequest ocspRequest) throws DsInvalidOperationException, DsDataCorruptedException {
        return this.getCertificateStatus(ocspRequest);
    }

    public final long getCertificateStatusTime() throws DsInvalidOperationException, DsDataCorruptedException {
        if (this.pBor == null) {
            throw new DsInvalidOperationException();
        }
        try {
            return Ddec.DerGetElementTime(this.pBor, "SSoe0xtSSsxT");
        }
        catch (DdecException ddecException) {
            throw new DsDataCorruptedException();
        }
    }

    public final Certificate getAdditionalCertificate(int n2) throws CertificateException {
        if (this.additionalCerts.isEmpty()) {
            Ddec.DerSearchRec derSearchRec = Ddec.DerFindFirstElement(this.pBor, "SssgE0S");
            while (derSearchRec != null) {
                Certificate certificate = new Certificate(derSearchRec.der.Copy(derSearchRec.size));
                this.additionalCerts.add(certificate);
                derSearchRec = Ddec.DerFindNextElement(derSearchRec);
            }
        }
        if (n2 < this.additionalCerts.size()) {
            return this.additionalCerts.get(n2);
        }
        return null;
    }

    public final Certificate verifySignature(CryptoAlgorithmFactory cryptoAlgorithmFactory, CertificateFinder certificateFinder, Certificate certificate) throws DsInvalidOperationException, DsDataCorruptedException, CertificateException, DsAlgorithmException {
        Object object;
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        String string;
        if (this.pBor == null) {
            throw new DsInvalidOperationException();
        }
        try {
            string = Ddec.DerGetElementOid(this.pBor, "SsSD");
        }
        catch (DdecException ddecException) {
            throw new DsDataCorruptedException();
        }
        try {
            byArray3 = Ddec.DerGetElementBuf(this.pBor, "SsSdx");
        }
        catch (DdecException ddecException) {
            byArray3 = null;
        }
        try {
            byArray2 = Ddec.DerGetElementBuf(this.pBor, "Ss");
        }
        catch (DdecException ddecException) {
            byArray2 = null;
        }
        try {
            byArray = Ddec.DerGetElementBuf(this.pBor, "SssG");
        }
        catch (DdecException ddecException) {
            throw new DsDataCorruptedException();
        }
        if (certificate == null) {
            int n2;
            byte[] byArray4;
            try {
                byArray4 = Ddec.DerGetElementBuf(this.pBor, "SSoe0E1s");
                n2 = 2;
            }
            catch (DdecException ddecException) {
                try {
                    byArray4 = Ddec.DerGetElementBuf(this.pBor, "SSoe0E2Q");
                    n2 = 1;
                }
                catch (DdecException ddecException2) {
                    throw new DsDataCorruptedException();
                }
            }
            certificate = this.findLocalCertificate(n2, byArray4);
            if (certificate == null && certificateFinder != null && (object = (Object)certificateFinder.findCertificate(n2, byArray4)) != null) {
                certificate = new Certificate((byte[])object);
            }
            if (certificate == null) {
                this.verificationStatus = 2;
                return null;
            }
        }
        if ((object = cryptoAlgorithmFactory.getVerifierAlg(null, null, string, byArray3, certificate)) == null) {
            throw new DsAlgorithmException();
        }
        ((MessageVerifierAlg)object).update(byArray2);
        boolean bl = ((MessageVerifierAlg)object).verify(byArray);
        if (bl) {
            this.verificationStatus = 0;
            return certificate;
        }
        this.verificationStatus = 5;
        return null;
    }

    public final int getVerificationStatus() {
        return this.verificationStatus;
    }

    protected OcspResponse() {
        this.verificationStatus = 1;
    }

    Certificate findLocalCertificate(int n2, byte[] byArray) throws CertificateException {
        int n3 = 0;
        Certificate certificate = this.getAdditionalCertificate(n3);
        while (certificate != null) {
            byte[] byArray2;
            if (n2 == 2) {
                byArray2 = certificate.getSubjectDN();
                if (byArray.length == byArray2.length && new Pointer(byArray).CompareTo(byArray2)) {
                    return certificate;
                }
            } else {
                try {
                    byArray2 = certificate.getSubjectKeyIdentifier();
                    if (byArray.length == byArray2.length && new Pointer(byArray).CompareTo(byArray2)) {
                        return certificate;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            certificate = this.getAdditionalCertificate(++n3);
        }
        return null;
    }

    Three<Integer, Integer, Long> calcStatus(byte[] byArray, byte[] byArray2) throws DsDataCorruptedException {
        Pointer pointer;
        Two<Pointer, Integer> two;
        int n2 = 0;
        long l2 = 0L;
        try {
            two = Ddec.DerGetElementPtr(this.pBor, "SSoe0xtSSSsqqi");
        }
        catch (DdecException ddecException) {
            throw new DsDataCorruptedException();
        }
        if ((Integer)two.second != byArray.length || !((Pointer)two.first).CompareTo(byArray)) {
            return new Three<Integer, Integer, Long>(-1, n2, l2);
        }
        try {
            two = Ddec.DerGetElementPtr(this.pBor, "SSoe0xtSSSsQ");
        }
        catch (DdecException ddecException) {
            throw new DsDataCorruptedException();
        }
        if ((Integer)two.second != byArray2.length || !((Pointer)two.first).CompareTo(byArray2)) {
            return new Three<Integer, Integer, Long>(-1, n2, l2);
        }
        try {
            pointer = (Pointer)Ddec.DerGetElementPtr((byte[])this.pBor, (String)"SSoe0xtSSsx").first;
        }
        catch (DdecException ddecException) {
            throw new DsDataCorruptedException();
        }
        if (pointer.Get() == 128) {
            return new Three<Integer, Integer, Long>(0, n2, l2);
        }
        if (pointer.Get() == 130) {
            return new Three<Integer, Integer, Long>(2, n2, l2);
        }
        if (pointer.Get() == 161) {
            try {
                l2 = Ddec.DerGetElementTime(pointer, "E1T");
            }
            catch (DdecException ddecException) {
                throw new DsDataCorruptedException();
            }
            try {
                n2 = Ddec.DerGetElementInt(pointer, "E1tE0Z");
            }
            catch (DdecException ddecException) {
                n2 = 0;
            }
            return new Three<Integer, Integer, Long>(1, n2, l2);
        }
        throw new DsDataCorruptedException();
    }
}

