/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor.DsLib;

import java.util.Arrays;
import ua.avtor.DsLib.Algorithms.CryptoAlgorithmFactory;
import ua.avtor.DsLib.Algorithms.MessageDigestAlg;
import ua.avtor.DsLib.Certificate;
import ua.avtor.DsLib.CertificateException;
import ua.avtor.DsLib.DsAlgorithmException;
import ua.avtor.DsLib.Utils.DerEncoder;

public class OcspRequest {
    byte[] req;

    public OcspRequest(String string, CryptoAlgorithmFactory cryptoAlgorithmFactory, Certificate certificate, Certificate certificate2) throws DsAlgorithmException, CertificateException {
        byte[] byArray;
        MessageDigestAlg messageDigestAlg = cryptoAlgorithmFactory.getDigestAlg(string, null, null);
        if (messageDigestAlg == null) {
            throw new DsAlgorithmException();
        }
        if (certificate2 == null) {
            byArray = certificate.getAuthorityKeyIdentifier();
        } else {
            byte[] byArray2 = certificate2.getPublicKey();
            messageDigestAlg.update(byArray2);
            byArray = messageDigestAlg.getDigest();
        }
        this.encode(messageDigestAlg, certificate, byArray);
    }

    public OcspRequest(String string, CryptoAlgorithmFactory cryptoAlgorithmFactory, Certificate certificate, byte[] byArray) throws DsAlgorithmException, CertificateException {
        MessageDigestAlg messageDigestAlg = cryptoAlgorithmFactory.getDigestAlg(string, null, null);
        if (messageDigestAlg == null) {
            throw new DsAlgorithmException();
        }
        this.encode(messageDigestAlg, certificate, byArray);
    }

    public byte[] getEncoded() {
        return this.req;
    }

    void encode(MessageDigestAlg messageDigestAlg, Certificate certificate, byte[] byArray) throws CertificateException {
        DerEncoder derEncoder = new DerEncoder();
        derEncoder.SeqBegin();
        derEncoder.SeqBegin();
        derEncoder.SeqBegin();
        derEncoder.SeqBegin();
        derEncoder.SeqBegin();
        derEncoder.SeqBegin();
        derEncoder.addOid(messageDigestAlg.getOid());
        derEncoder.addDerParams(messageDigestAlg.getParams());
        derEncoder.SeqEnd();
        byte[] byArray2 = certificate.getIssuerDN();
        messageDigestAlg.update(byArray2);
        byte[] byArray3 = messageDigestAlg.getDigest();
        derEncoder.addOctets(byArray3);
        if (byArray != null) {
            byArray3 = byArray;
        } else {
            Arrays.fill(byArray3, (byte)0);
        }
        derEncoder.addOctets(byArray3);
        byte[] byArray4 = certificate.getSerial();
        derEncoder.addObject(byArray4);
        derEncoder.SeqEnd();
        derEncoder.SeqEnd();
        derEncoder.SeqEnd();
        derEncoder.SeqEnd();
        derEncoder.SeqEnd();
        this.req = derEncoder.getEncoded();
    }
}

