/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor.DsLib.KeyStores;

import java.util.Arrays;
import ua.avtor.DsLib.Algorithms.ContentEncryptionAlg;
import ua.avtor.DsLib.Algorithms.CryptoAlgorithmFactory;
import ua.avtor.DsLib.Algorithms.MessageDigestAlg;
import ua.avtor.DsLib.Algorithms.PasswordBasedAlg;
import ua.avtor.DsLib.Certificate;
import ua.avtor.DsLib.CertificateException;
import ua.avtor.DsLib.DsAlgorithmException;
import ua.avtor.DsLib.DsDataCorruptedException;
import ua.avtor.DsLib.DsException;
import ua.avtor.DsLib.KeyStores.KeyStoreException;
import ua.avtor.DsLib.KeyStores.PfxBag;
import ua.avtor.DsLib.PrivateKeys.PrivateKey;
import ua.avtor.DsLib.Utils.ArrayUtil;
import ua.avtor.DsLib.Utils.Ddec;
import ua.avtor.DsLib.Utils.DdecException;
import ua.avtor.DsLib.Utils.DerEncoder;
import ua.avtor.DsLib.Utils.Pointer;

class PfxSlot {
    public PfxBag[] bags = new PfxBag[0];
    public String description;
    public boolean empty;
    public boolean modified;
    private byte[] authSafe;
    private byte[] macData;
    private CryptoAlgorithmFactory algs;
    private String defAuthOid = null;
    private String defPbeOid = null;
    private String defPrfOid = null;
    private String defEncOid = null;
    private int defaultIterations = 10000;
    private int defaultSaltLength = 16;
    public boolean defaultEncryptCert = false;
    private String cachedPsw;
    private boolean loggedIn;

    private byte[] DerGetBytes(Pointer pointer, String string) {
        try {
            return Ddec.DerGetElementBuf(pointer, string);
        }
        catch (DdecException ddecException) {
            return null;
        }
    }

    private byte[] DerGetBytes(byte[] byArray, String string) {
        return this.DerGetBytes(new Pointer(byArray), string);
    }

    private String DerGetOid(Pointer pointer, String string) {
        try {
            return Ddec.DerGetElementOid(pointer, string);
        }
        catch (DdecException ddecException) {
            return "";
        }
    }

    private String DerGetOid(byte[] byArray, String string) {
        return this.DerGetOid(new Pointer(byArray), string);
    }

    private void parseAuthSafe() throws DsAlgorithmException {
        Ddec.DerSearchRec derSearchRec = Ddec.DerFindElementInit(this.authSafe, "S");
        while (Ddec.DerFindNextElement(derSearchRec) != null) {
            Object object;
            String string = this.DerGetOid(derSearchRec.der, "SD");
            if (string.equals("1.2.840.113549.1.7.1")) {
                object = this.DerGetBytes(derSearchRec.der, "SdE0Q");
                this.parseBags((byte[])object, false);
            }
            if (!string.equals("1.2.840.113549.1.7.6") || !this.loggedIn) continue;
            object = this.DerGetOid(derSearchRec.der, "SdE0SiSdSD");
            byte[] byArray = this.DerGetBytes(derSearchRec.der, "SdE0SiSdSds");
            byte[] byArray2 = this.DerGetBytes(derSearchRec.der, "SdE0SiSdsY0");
            PasswordBasedAlg passwordBasedAlg = this.algs.getPasswordBasedAlg(this.cachedPsw, (String)object, byArray);
            ContentEncryptionAlg contentEncryptionAlg = passwordBasedAlg.getEncryptor();
            if (contentEncryptionAlg == null) {
                throw new DsAlgorithmException();
            }
            int n2 = contentEncryptionAlg.decryptFinal(byArray2, 0, byArray2.length);
            byArray2 = ArrayUtil.resizeOf(byArray2, n2);
            this.parseBags(byArray2, true);
        }
    }

    public PfxSlot(byte[] byArray, String string, CryptoAlgorithmFactory cryptoAlgorithmFactory) throws DsDataCorruptedException {
        this.algs = cryptoAlgorithmFactory;
        this.description = string;
        this.loggedIn = false;
        boolean bl = this.empty = byArray == null;
        if (byArray != null) {
            this.authSafe = this.DerGetBytes(byArray, "SiSdE0Q");
            this.macData = this.DerGetBytes(byArray, "Siss");
            if (this.authSafe == null) {
                throw new DsDataCorruptedException();
            }
            this.defAuthOid = this.DerGetOid(this.macData, "SSSD");
            try {
                this.parseAuthSafe();
            }
            catch (DsAlgorithmException dsAlgorithmException) {
                throw new DsDataCorruptedException();
            }
        }
    }

    private void addBag(byte[] byArray, int n2, byte[] byArray2, boolean bl) {
        PfxBag pfxBag = new PfxBag();
        pfxBag.data = byArray;
        pfxBag.type = n2;
        pfxBag.attribs = byArray2;
        pfxBag.encrypted = bl;
        PfxBag[] pfxBagArray = new PfxBag[this.bags.length + 1];
        System.arraycopy(this.bags, 0, pfxBagArray, 0, this.bags.length);
        this.bags = pfxBagArray;
        this.bags[this.bags.length - 1] = pfxBag;
    }

    private void parseBags(byte[] byArray, boolean bl) throws DsAlgorithmException {
        Ddec.DerSearchRec derSearchRec = Ddec.DerFindElementInit(byArray, "S");
        while (Ddec.DerFindNextElement(derSearchRec) != null) {
            Object object;
            String string = this.DerGetOid(derSearchRec.der, "SD");
            byte[] byArray2 = this.DerGetBytes(derSearchRec.der, "Sde0u");
            if (string.equals("1.2.840.113549.1.12.10.1.1")) {
                object = this.DerGetBytes(derSearchRec.der, "SdE0s");
                this.addBag((byte[])object, 1, byArray2, bl);
            }
            if (string.equals("1.2.840.113549.1.12.10.1.2")) {
                object = this.DerGetOid(derSearchRec.der, "SdE0SSD");
                byte[] byArray3 = this.DerGetBytes(derSearchRec.der, "SdE0SSds");
                if (this.loggedIn) {
                    PasswordBasedAlg passwordBasedAlg = this.algs.getPasswordBasedAlg(this.cachedPsw, (String)object, byArray3);
                    ContentEncryptionAlg contentEncryptionAlg = passwordBasedAlg.getEncryptor();
                    if (contentEncryptionAlg == null) {
                        throw new DsAlgorithmException();
                    }
                    if (this.defPbeOid == null) {
                        this.defPbeOid = passwordBasedAlg.getOid();
                        this.defPrfOid = passwordBasedAlg.getKdf2PrfOid();
                        this.defEncOid = passwordBasedAlg.getPbe2EncOid();
                    }
                    byte[] byArray4 = this.DerGetBytes(derSearchRec.der, "SdE0SsQ");
                    int n2 = contentEncryptionAlg.decryptFinal(byArray4, 0, byArray4.length);
                    byArray4 = ArrayUtil.resizeOf(byArray4, n2);
                    this.addBag(byArray4, 2, byArray2, bl);
                } else {
                    this.addBag(null, 2, byArray2, bl);
                }
            }
            if (string.equals("1.2.840.113549.1.12.10.1.3")) {
                object = this.DerGetBytes(derSearchRec.der, "SdE0SdE0Q");
                this.addBag((byte[])object, 3, byArray2, bl);
            }
            if (string.equals("1.2.840.113549.1.12.10.1.4")) {
                object = this.DerGetBytes(derSearchRec.der, "SdE0SdE0Q");
                this.addBag((byte[])object, 4, byArray2, bl);
            }
            if (!string.equals("1.2.840.113549.1.12.10.1.5")) continue;
            object = this.DerGetBytes(derSearchRec.der, "SdE0x");
            this.addBag((byte[])object, 5, byArray2, bl);
        }
    }

    private void selectAlgsSet() {
        int n2 = 804;
        for (int i2 = 0; i2 < this.bags.length; ++i2) {
            String string;
            PfxBag pfxBag = this.bags[i2];
            if (pfxBag.type != 1 && pfxBag.type != 2 || pfxBag.data == null || (string = Ddec.TryGetElementOid(pfxBag.data, "SiSD")).startsWith("1.2.804.")) continue;
            n2 = 840;
        }
        if (n2 == 804) {
            this.defAuthOid = "1.2.804.2.1.1.1.1.2.1";
            this.defPbeOid = "1.2.840.113549.1.5.13";
            this.defPrfOid = "1.2.804.2.1.1.1.1.1.2";
            this.defEncOid = "1.2.804.2.1.1.1.1.1.1.3";
        }
        if (n2 == 840) {
            this.defAuthOid = "1.3.14.3.2.26";
            this.defPbeOid = "1.2.840.113549.1.12.1.3";
            this.defPrfOid = null;
            this.defEncOid = null;
        }
    }

    private byte[] pbeEncrypt(boolean bl, byte[] byArray, DerEncoder derEncoder) throws DsAlgorithmException {
        if (this.defAuthOid == null) {
            this.selectAlgsSet();
        }
        byte[] byArray2 = new byte[this.defaultSaltLength];
        this.algs.generateRandom(byArray2);
        PasswordBasedAlg passwordBasedAlg = this.algs.getPasswordBasedAlg(this.cachedPsw, this.defPbeOid, byArray2, this.defaultIterations, this.defPrfOid, this.defEncOid);
        if (derEncoder != null) {
            derEncoder.SeqBegin();
            derEncoder.addOid(passwordBasedAlg.getOid());
            derEncoder.addDerParams(passwordBasedAlg.getParams());
            derEncoder.SeqEnd();
        }
        byte[] byArray3 = new byte[byArray.length + 32];
        ContentEncryptionAlg contentEncryptionAlg = passwordBasedAlg.getEncryptor();
        if (contentEncryptionAlg == null) {
            throw new DsAlgorithmException();
        }
        int n2 = contentEncryptionAlg.encryptFinal(byArray, 0, byArray.length, byArray3, 0);
        byArray3 = ArrayUtil.resizeOf(byArray3, n2);
        return byArray3;
    }

    private byte[] encodeBag(PfxBag pfxBag) throws DsAlgorithmException {
        DerEncoder derEncoder = new DerEncoder();
        derEncoder.SeqBegin();
        derEncoder.addOid("1.2.840.113549.1.12.10.1." + pfxBag.type);
        derEncoder.SpecificBegin((byte)-96);
        switch (pfxBag.type) {
            case 1: {
                derEncoder.addObject(pfxBag.data);
                break;
            }
            case 2: {
                derEncoder.SeqBegin();
                byte[] byArray = this.pbeEncrypt(true, pfxBag.data, derEncoder);
                derEncoder.addOctets(byArray);
                derEncoder.SeqEnd();
                break;
            }
            case 3: 
            case 4: {
                derEncoder.SeqBegin();
                derEncoder.addOid("1.2.840.113549.1.9." + Integer.toString(pfxBag.type + 19) + ".1");
                derEncoder.SpecificBegin((byte)-96);
                derEncoder.addOctets(pfxBag.data);
                derEncoder.SpecificEnd();
                derEncoder.SeqEnd();
                break;
            }
            case 5: {
                derEncoder.addObject(pfxBag.data);
            }
        }
        derEncoder.SpecificEnd();
        derEncoder.addDerParams(pfxBag.attribs);
        derEncoder.SeqEnd();
        return derEncoder.getEncoded();
    }

    private void encodeAuthSafe() throws DsAlgorithmException {
        byte[] byArray;
        DerEncoder derEncoder = new DerEncoder();
        derEncoder.SeqBegin();
        DerEncoder derEncoder2 = new DerEncoder();
        derEncoder2.SeqBegin();
        boolean bl = false;
        boolean bl2 = false;
        for (int i2 = 0; i2 < this.bags.length; ++i2) {
            byArray = this.encodeBag(this.bags[i2]);
            if (this.bags[i2].encrypted) {
                derEncoder2.addObject(byArray);
                bl2 = true;
                continue;
            }
            derEncoder.addObject(byArray);
            bl = true;
        }
        derEncoder.SeqEnd();
        derEncoder2.SeqEnd();
        DerEncoder derEncoder3 = new DerEncoder();
        derEncoder3.SeqBegin();
        if (bl) {
            derEncoder3.SeqBegin();
            derEncoder3.addOid("1.2.840.113549.1.7.1");
            derEncoder3.SpecificBegin((byte)-96);
            derEncoder3.addOctets(derEncoder.getEncoded());
            derEncoder3.SpecificEnd();
            derEncoder3.SeqEnd();
        }
        if (bl2) {
            derEncoder3.SeqBegin();
            derEncoder3.addOid("1.2.840.113549.1.7.6");
            derEncoder3.SpecificBegin((byte)-96);
            derEncoder3.SeqBegin();
            derEncoder3.addInteger(0);
            derEncoder3.SeqBegin();
            derEncoder3.addOid("1.2.840.113549.1.7.1");
            byArray = this.pbeEncrypt(false, derEncoder2.getEncoded(), derEncoder3);
            derEncoder3.addSpecific((byte)-128, byArray);
            derEncoder3.SeqEnd();
            derEncoder3.SeqEnd();
            derEncoder3.SpecificEnd();
            derEncoder3.SeqEnd();
        }
        derEncoder3.SeqEnd();
        this.authSafe = derEncoder3.getEncoded();
    }

    private void encodeMacData() throws DsAlgorithmException {
        if (this.defAuthOid == null) {
            this.selectAlgsSet();
        }
        byte[] byArray = new byte[this.defaultSaltLength];
        this.algs.generateRandom(byArray);
        PasswordBasedAlg passwordBasedAlg = this.algs.getPasswordBasedAlg(this.cachedPsw, this.defAuthOid, byArray, this.defaultIterations, null, null);
        MessageDigestAlg messageDigestAlg = passwordBasedAlg.getDigester();
        if (messageDigestAlg == null) {
            throw new DsAlgorithmException();
        }
        messageDigestAlg.update(this.authSafe);
        DerEncoder derEncoder = new DerEncoder();
        derEncoder.SeqBegin();
        derEncoder.SeqBegin();
        derEncoder.SeqBegin();
        derEncoder.addOid(passwordBasedAlg.getOid());
        derEncoder.addNull();
        derEncoder.SeqEnd();
        derEncoder.addOctets(messageDigestAlg.getDigest());
        derEncoder.SeqEnd();
        derEncoder.addOctets(byArray);
        derEncoder.addInteger(this.defaultIterations);
        derEncoder.SeqEnd();
        this.macData = derEncoder.getEncoded();
    }

    public boolean setSlotProperty(String string, String string2) {
        String[] stringArray;
        if (string.toLowerCase().equals("algs")) {
            String[] stringArray2 = string2.split(",");
            if (stringArray2[0].length() > 0) {
                this.defAuthOid = stringArray2[0];
            }
            if (stringArray2[1].length() > 0) {
                this.defPbeOid = stringArray2[1];
            }
            if (stringArray2[2].length() > 0) {
                this.defPrfOid = stringArray2[2];
            }
            if (stringArray2[3].length() > 0) {
                this.defEncOid = stringArray2[3];
            }
            if (stringArray2.length > 4 && stringArray2[4].length() > 0) {
                this.defaultIterations = Integer.parseInt(stringArray2[4]);
            }
            if (stringArray2.length > 5 && stringArray2[5].length() > 0) {
                this.defaultSaltLength = Integer.parseInt(stringArray2[5]);
            }
            return true;
        }
        if (string.toLowerCase().equals("decryptcerts") && (stringArray = string2.split(",")).length > 0 && stringArray[0].equals("now")) {
            for (int i2 = 0; i2 < this.bags.length; ++i2) {
                if (this.bags[i2].type != 3 && this.bags[i2].type != 4) continue;
                this.bags[i2].encrypted = false;
                this.modified = true;
            }
            return true;
        }
        if (string.toLowerCase().equals("certificateencryption")) {
            stringArray = string2.split(",");
            if (stringArray.length > 0) {
                this.defaultEncryptCert = stringArray[0].equals("true");
            }
            return true;
        }
        return false;
    }

    public byte[] getEncoded() throws DsAlgorithmException {
        if (this.modified) {
            if (!this.loggedIn) {
                throw new RuntimeException("not logged in");
            }
            this.encodeAuthSafe();
            this.encodeMacData();
            this.modified = false;
        }
        DerEncoder derEncoder = new DerEncoder();
        derEncoder.SeqBegin();
        derEncoder.addInteger(3);
        derEncoder.SeqBegin();
        derEncoder.addOid("1.2.840.113549.1.7.1");
        derEncoder.SpecificBegin((byte)-96);
        derEncoder.addOctets(this.authSafe);
        derEncoder.SpecificEnd();
        derEncoder.SeqEnd();
        derEncoder.addObject(this.macData);
        derEncoder.SeqEnd();
        return derEncoder.getEncoded();
    }

    public int insertBag(byte[] byArray, int n2, byte[] byArray2) {
        boolean bl = false;
        if (n2 == 3 || n2 == 4) {
            bl = this.defaultEncryptCert;
        }
        this.addBag(byArray, n2, byArray2, bl);
        this.modified = true;
        this.empty = false;
        return this.bags.length - 1;
    }

    public void removeBag(int n2) {
        for (int i2 = n2; i2 < this.bags.length - 1; ++i2) {
            this.bags[i2] = this.bags[i2 + 1];
        }
        PfxBag[] pfxBagArray = new PfxBag[this.bags.length - 1];
        System.arraycopy(this.bags, 0, pfxBagArray, 0, this.bags.length - 1);
        this.bags = pfxBagArray;
        this.modified = true;
    }

    public boolean login(String string) throws KeyStoreException, DsAlgorithmException {
        PasswordBasedAlg passwordBasedAlg;
        MessageDigestAlg messageDigestAlg;
        if (this.loggedIn) {
            throw new KeyStoreException("already loggedIn", null);
        }
        if (this.empty) {
            if (this.cachedPsw == null || !this.cachedPsw.equals(string)) {
                return false;
            }
            this.loggedIn = true;
            return true;
        }
        int n2 = 1;
        String string2 = this.DerGetOid(this.macData, "SSSD");
        byte[] byArray = this.DerGetBytes(this.macData, "SsQ");
        byte[] byArray2 = this.DerGetBytes(this.macData, "SSsQ");
        if (Ddec.DerIsElementPresent(this.macData, "SsqI")) {
            n2 = Ddec.TryGetElementInt(this.macData, "SsqI");
        }
        if ((messageDigestAlg = (passwordBasedAlg = this.algs.getPasswordBasedAlg(string, string2, byArray, n2, null, null)).getDigester()) == null) {
            throw new KeyStoreException("", new DsAlgorithmException());
        }
        messageDigestAlg.update(this.authSafe);
        byte[] byArray3 = messageDigestAlg.getDigest();
        if (byArray2.length != byArray3.length) {
            return false;
        }
        for (int i2 = 0; i2 < byArray2.length; ++i2) {
            if (byArray2[i2] == byArray3[i2]) continue;
            return false;
        }
        this.cachedPsw = string;
        this.loggedIn = true;
        this.empty = false;
        this.bags = new PfxBag[0];
        try {
            this.parseAuthSafe();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            this.cachedPsw = null;
            this.loggedIn = false;
            this.parseAuthSafe();
            return false;
        }
        return true;
    }

    public void logout() throws DsAlgorithmException {
        if (this.modified) {
            this.getEncoded();
        }
        this.cachedPsw = null;
        this.loggedIn = false;
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public boolean changePassword(String string, String string2) throws DsAlgorithmException {
        if (this.loggedIn) {
            if (!string.equals(this.cachedPsw)) {
                return false;
            }
            this.cachedPsw = string2;
            this.modified = true;
        } else if (this.empty) {
            this.cachedPsw = string2;
        } else {
            try {
                if (!this.login(string)) {
                    return false;
                }
            }
            catch (KeyStoreException keyStoreException) {
                return false;
            }
            this.cachedPsw = string2;
            this.modified = true;
            this.logout();
        }
        return true;
    }

    public String getBagLabel(int n2) {
        String string = null;
        if (this.bags[n2].attribs != null) {
            try {
                string = Ddec.DerGetElementStr(this.bags[n2].attribs, "a1.2.840.113549.1.9.20UC");
            }
            catch (DdecException ddecException) {
                // empty catch block
            }
        }
        if (string == null) {
            string = "##" + Integer.toString(n2);
        }
        return string;
    }

    public void setBagAttribute(int n2, String string, int n3, byte[] byArray) {
        DerEncoder derEncoder = new DerEncoder();
        derEncoder.SetBegin();
        if (this.bags[n2].attribs != null) {
            Ddec.DerSearchRec derSearchRec = Ddec.DerFindElementInit(this.bags[n2].attribs, "U");
            while (Ddec.DerFindNextElement(derSearchRec) != null) {
                String string2 = Ddec.TryGetElementOid(derSearchRec.der, "SD");
                if (string.equals(string2)) continue;
                derEncoder.addObject(derSearchRec.der.Copy(derSearchRec.size));
            }
        }
        derEncoder.SeqBegin();
        derEncoder.addOid(string);
        derEncoder.SetBegin();
        derEncoder.addSpecific((byte)n3, byArray);
        derEncoder.SetEnd();
        derEncoder.SeqEnd();
        derEncoder.SetEnd();
        this.bags[n2].attribs = derEncoder.getEncoded();
        this.modified = true;
    }

    public int keyByKeyIdentifier(byte[] byArray) {
        for (int i2 = 0; i2 < this.bags.length; ++i2) {
            byte[] byArray2;
            PfxBag pfxBag = this.bags[i2];
            if (pfxBag.type != 1 && pfxBag.type != 2 || pfxBag.attribs == null || !Arrays.equals(byArray2 = Ddec.TryGetElementBuf(pfxBag.attribs, "a1.2.840.113549.1.9.21UQ"), byArray)) continue;
            return i2;
        }
        return -1;
    }

    public int keyByCertId(byte[] byArray) {
        for (int i2 = 0; i2 < this.bags.length; ++i2) {
            int n2;
            Certificate certificate;
            if (this.bags[i2].type != 3) continue;
            try {
                certificate = new Certificate(this.bags[i2].data);
            }
            catch (CertificateException certificateException) {
                continue;
            }
            if (!certificate.isMyIdentifier(byArray)) continue;
            byte[] byArray2 = certificate.getSubjectKeyIdentifier();
            if (byArray2 != null && (n2 = this.keyByKeyIdentifier(byArray2)) >= 0) {
                return n2;
            }
            int n3 = this.keyByPublic(certificate.getPublicKeyInfo());
            if (n3 < 0) continue;
            return n3;
        }
        return -1;
    }

    public int keyByPublic(byte[] byArray) {
        byte[] byArray2 = Ddec.TryGetElementBuf(byArray, "SsG");
        for (int i2 = 0; i2 < this.bags.length; ++i2) {
            PrivateKey privateKey;
            PfxBag pfxBag = this.bags[i2];
            if (pfxBag.type != 1 && pfxBag.type != 2 || pfxBag.data == null) continue;
            if (pfxBag.pubkey == null && (privateKey = this.algs.getSignerAlg(pfxBag.data, null, 0, null)) != null) {
                try {
                    pfxBag.pubkey = Ddec.TryGetElementBuf(privateKey.getPublicKeyInfo(), "SsG");
                    privateKey.cleanup();
                }
                catch (DsException dsException) {
                    // empty catch block
                }
            }
            if (!Arrays.equals(byArray2, pfxBag.pubkey)) continue;
            return i2;
        }
        return -1;
    }

    public int keyByPkcs8(byte[] byArray) {
        byte[] byArray2 = Ddec.TryGetElementBuf(byArray, "SisQ");
        for (int i2 = 0; i2 < this.bags.length; ++i2) {
            byte[] byArray3;
            PfxBag pfxBag = this.bags[i2];
            if (pfxBag.type != 1 && pfxBag.type != 2 || pfxBag.data == null || !Arrays.equals(byArray2, byArray3 = Ddec.TryGetElementBuf(pfxBag.data, "SisQ"))) continue;
            return i2;
        }
        return -1;
    }

    public int keyByLabel(String string) {
        for (int i2 = 0; i2 < this.bags.length; ++i2) {
            PfxBag pfxBag = this.bags[i2];
            if (pfxBag.type != 1 && pfxBag.type != 2 || pfxBag.data == null || !string.equals(this.getBagLabel(i2))) continue;
            return i2;
        }
        return -1;
    }

    public int certByPublic(byte[] byArray) {
        if (byArray == null) {
            return -1;
        }
        byte[] byArray2 = Ddec.TryGetElementBuf(byArray, "SsG");
        for (int i2 = 0; i2 < this.bags.length; ++i2) {
            if (this.bags[i2].type != 3) continue;
            try {
                Certificate certificate = new Certificate(this.bags[i2].data);
                byte[] byArray3 = certificate.getPublicKey();
                if (!Arrays.equals(byArray2, byArray3)) continue;
                return i2;
            }
            catch (DsException dsException) {
                // empty catch block
            }
        }
        return -1;
    }

    public String toString() {
        return this.description;
    }
}

