/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor.DsLib.KeyStores;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import ua.avtor.DsLib.Algorithms.CryptoAlgorithmFactory;
import ua.avtor.DsLib.Certificate;
import ua.avtor.DsLib.CertificateException;
import ua.avtor.DsLib.DsAlgorithmException;
import ua.avtor.DsLib.DsDataCorruptedException;
import ua.avtor.DsLib.DsException;
import ua.avtor.DsLib.DsInvalidOperationException;
import ua.avtor.DsLib.KeyStores.KeyStore;
import ua.avtor.DsLib.KeyStores.KeyStoreException;
import ua.avtor.DsLib.KeyStores.KeyStoreInvalidPasswordException;
import ua.avtor.DsLib.KeyStores.KeyStoreLoginRequiredException;
import ua.avtor.DsLib.KeyStores.KeyStoreNotFoundException;
import ua.avtor.DsLib.KeyStores.PfxBag;
import ua.avtor.DsLib.KeyStores.PfxSlot;
import ua.avtor.DsLib.KeyStores.SlotInfo;
import ua.avtor.DsLib.PrivateKeys.PrivateKey;
import ua.avtor.DsLib.Utils.ArrayUtil;
import ua.avtor.DsLib.Utils.Ddec;

public class KeyStorePKCS12
extends KeyStore {
    private CryptoAlgorithmFactory algs;
    private PfxSlot[] slots = new PfxSlot[0];

    public KeyStorePKCS12(CryptoAlgorithmFactory cryptoAlgorithmFactory) {
        this.algs = cryptoAlgorithmFactory;
        try {
            this.addSlot(null, "default");
        }
        catch (DsDataCorruptedException dsDataCorruptedException) {
            throw new RuntimeException(dsDataCorruptedException);
        }
    }

    public KeyStorePKCS12(byte[] byArray, CryptoAlgorithmFactory cryptoAlgorithmFactory) throws DsDataCorruptedException {
        this.algs = cryptoAlgorithmFactory;
        this.addSlot(byArray, "default");
    }

    /*
     * WARNING - void declaration
     */
    public KeyStorePKCS12(String string, CryptoAlgorithmFactory cryptoAlgorithmFactory) throws IOException, DsException {
        this.algs = cryptoAlgorithmFactory;
        boolean bl = string.indexOf(42) >= 0 || string.indexOf(63) >= 0;
        File[] fileArray = new File[]{new File(string)};
        if (bl) {
            void var5_7;
            String object = fileArray[0].getParent();
            if (object == null) {
                String string2 = ".";
            }
            File file = new File((String)var5_7);
            fileArray = file.listFiles(new MsWinFilter(fileArray[0].getName()));
        } else if (!fileArray[0].exists()) {
            throw new FileNotFoundException(string);
        }
        for (File file : fileArray) {
            if (file.isDirectory()) continue;
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[(int)file.length()];
            fileInputStream.read(byArray);
            fileInputStream.close();
            if (byArray.length != Ddec.DerGetTotalSize(byArray)) {
                throw new DsDataCorruptedException();
            }
            String string3 = file.getName();
            int n2 = string3.lastIndexOf(46);
            if (n2 > 0) {
                string3 = string3.substring(0, n2);
            }
            this.addSlot(byArray, string3);
        }
    }

    private void ensureSlot(int n2) {
        if (n2 < 0 || n2 >= this.slots.length) {
            throw new IllegalArgumentException();
        }
    }

    protected KeyGenerationParam extractKeyGenerationParams(String string, byte[] byArray) {
        if (string.equals("1.2.840.113549.1.1.1")) {
            byte[] byArray2 = Ddec.TryGetElementBuf(byArray, "SsGSI");
            return new KeyGenerationParam((byArray2.length & 0xFFFFFFFC) * 8, null);
        }
        byte[] byArray3 = Ddec.TryGetElementBuf(byArray, "SSdx");
        return new KeyGenerationParam(0, byArray3);
    }

    public int addSlot(byte[] byArray, String string) throws DsDataCorruptedException {
        int n2 = this.slots.length;
        PfxSlot pfxSlot = new PfxSlot(byArray, string, this.algs);
        PfxSlot[] pfxSlotArray = new PfxSlot[this.slots.length + 1];
        System.arraycopy(this.slots, 0, pfxSlotArray, 0, this.slots.length);
        this.slots = pfxSlotArray;
        this.slots[n2] = pfxSlot;
        return n2;
    }

    public byte[] getEncoded(int n2) throws DsInvalidOperationException, DsAlgorithmException {
        this.ensureSlot(n2);
        return this.slots[n2].getEncoded();
    }

    protected PrivateKey makeKey(int n2, int n3) throws KeyStoreException {
        if (n3 < 0) {
            throw new KeyStoreNotFoundException();
        }
        byte[] byArray = this.slots[n2].bags[n3].data;
        if (byArray == null) {
            throw new KeyStoreLoginRequiredException();
        }
        PrivateKey privateKey = this.algs.getSignerAlg(byArray, null, -1, null);
        if (privateKey == null) {
            throw new KeyStoreException("Key loading error", new DsAlgorithmException());
        }
        return privateKey;
    }

    public void login(int n2, String string) throws KeyStoreException {
        this.ensureSlot(n2);
        try {
            if (!this.slots[n2].login(string)) {
                throw new KeyStoreInvalidPasswordException();
            }
        }
        catch (DsAlgorithmException dsAlgorithmException) {
            throw new KeyStoreException("", dsAlgorithmException);
        }
    }

    public void logout(int n2) throws KeyStoreException {
        this.ensureSlot(n2);
        try {
            this.slots[n2].logout();
        }
        catch (DsAlgorithmException dsAlgorithmException) {
            throw new KeyStoreException("", dsAlgorithmException);
        }
    }

    public boolean isLoggedIn(int n2) throws KeyStoreException {
        this.ensureSlot(n2);
        return this.slots[n2].isLoggedIn();
    }

    public void changePassword(int n2, String string, String string2) throws KeyStoreException {
        this.ensureSlot(n2);
        try {
            if (!this.slots[n2].changePassword(string, string2)) {
                throw new KeyStoreInvalidPasswordException();
            }
        }
        catch (DsAlgorithmException dsAlgorithmException) {
            throw new KeyStoreException("", dsAlgorithmException);
        }
    }

    public int findSlot(String string) throws KeyStoreException {
        if (string == null || string.length() == 0) {
            if (this.slots.length > 0) {
                return 0;
            }
            throw new KeyStoreNotFoundException();
        }
        for (int i2 = 0; i2 < this.slots.length; ++i2) {
            if (!(string.charAt(0) == '@' ? this.slots[i2].description.toLowerCase().startsWith(string.substring(1).toLowerCase()) : this.slots[i2].description.toLowerCase().equals(string.toLowerCase()))) continue;
            return i2;
        }
        throw new KeyStoreNotFoundException();
    }

    public int findSlot(Certificate certificate) throws KeyStoreException {
        int n2;
        byte[] byArray = certificate.getSubjectKeyIdentifier();
        if (byArray != null) {
            for (int i2 = 0; i2 < this.slots.length; ++i2) {
                n2 = this.slots[i2].keyByKeyIdentifier(byArray);
                if (n2 < 0) continue;
                return i2;
            }
        }
        byte[] byArray2 = certificate.getPublicKeyInfo();
        for (n2 = 0; n2 < this.slots.length; ++n2) {
            int n3 = this.slots[n2].keyByPublic(byArray2);
            if (n3 < 0) continue;
            return n2;
        }
        throw new KeyStoreNotFoundException();
    }

    public int findSlot(byte[] byArray) throws KeyStoreException {
        block3: {
            block2: {
                if (byArray[0] != 4) break block2;
                byte[] byArray2 = Ddec.TryGetElementBuf(byArray, "Q");
                if (byArray2 == null) break block3;
                for (int i2 = 0; i2 < this.slots.length; ++i2) {
                    int n2 = this.slots[i2].keyByKeyIdentifier(byArray2);
                    if (n2 < 0) continue;
                    return i2;
                }
                break block3;
            }
            for (int i3 = 0; i3 < this.slots.length; ++i3) {
                int n3 = this.slots[i3].keyByCertId(byArray);
                if (n3 < 0) continue;
                return i3;
            }
        }
        throw new KeyStoreNotFoundException();
    }

    public int[] enumSlots(boolean bl) throws KeyStoreException {
        int[] nArray = new int[this.slots.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = i2;
        }
        return nArray;
    }

    public String[] enumLabels(int n2) throws KeyStoreException {
        this.ensureSlot(n2);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < this.slots[n2].bags.length; ++i2) {
            PfxBag pfxBag = this.slots[n2].bags[i2];
            if (pfxBag.type != 1 && pfxBag.type != 2) continue;
            arrayList.add(this.slots[n2].getBagLabel(i2));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public boolean setSlotProperty(int n2, String string, String string2) {
        this.ensureSlot(n2);
        return this.slots[n2].setSlotProperty(string, string2);
    }

    public SlotInfo getSlotInfo(int n2) throws KeyStoreException {
        this.ensureSlot(n2);
        SlotInfo slotInfo = new SlotInfo();
        slotInfo.description = this.slots[n2].description;
        slotInfo.label = "";
        slotInfo.serial = "";
        slotInfo.flags = 65;
        if (!this.slots[n2].empty) {
            slotInfo.flags |= 0x4080;
        }
        slotInfo.minPasswordLength = 6;
        slotInfo.maxPasswordLength = 64;
        slotInfo.hardware = false;
        slotInfo.pinpad = false;
        return slotInfo;
    }

    public PrivateKey getPrivateKey(int n2, Certificate certificate) throws KeyStoreException {
        this.ensureSlot(n2);
        int n3 = -1;
        byte[] byArray = certificate.getSubjectKeyIdentifier();
        if (byArray != null) {
            n3 = this.slots[n2].keyByKeyIdentifier(byArray);
        }
        if (n3 < 0) {
            byte[] byArray2 = certificate.getPublicKeyInfo();
            n3 = this.slots[n2].keyByPublic(byArray2);
        }
        return this.makeKey(n2, n3);
    }

    public PrivateKey getPrivateKey(int n2, byte[] byArray) throws KeyStoreException {
        this.ensureSlot(n2);
        int n3 = -1;
        if (byArray[0] == 4) {
            byte[] byArray2 = Ddec.TryGetElementBuf(byArray, "Q");
            if (byArray2 != null) {
                n3 = this.slots[n2].keyByKeyIdentifier(byArray2);
            }
        } else {
            n3 = this.slots[n2].keyByCertId(byArray);
        }
        return this.makeKey(n2, n3);
    }

    public PrivateKey getPrivateKey(int n2, String string) throws KeyStoreException {
        this.ensureSlot(n2);
        int n3 = this.slots[n2].keyByLabel(string);
        return this.makeKey(n2, n3);
    }

    public void importPrivateKey(int n2, String string, boolean bl, PrivateKey privateKey) throws KeyStoreException {
        int n3;
        byte[] byArray;
        this.ensureSlot(n2);
        if (!this.slots[n2].isLoggedIn()) {
            throw new KeyStoreLoginRequiredException();
        }
        try {
            byte[] byArray2 = Ddec.TryGetElementBuf(privateKey.getPublicKeyInfo(), "SsG");
            privateKey.digestUpdate(byArray2);
            byArray = privateKey.digestGet();
        }
        catch (DsException dsException) {
            throw new KeyStoreException("", dsException);
        }
        try {
            n3 = this.slots[n2].insertBag(privateKey.getEncoded(), 2, null);
        }
        catch (DsException dsException) {
            throw new KeyStoreException("", dsException);
        }
        this.slots[n2].setBagAttribute(n3, "1.2.840.113549.1.9.21", 4, byArray);
        if (string != null && string.length() > 0) {
            this.slots[n2].setBagAttribute(n3, "1.2.840.113549.1.9.20", 30, ArrayUtil.AsBigEndianUnicode(string));
        }
    }

    public PrivateKey generatePrivateKey(int n2, String string, boolean bl, String string2, int n3, byte[] byArray) throws KeyStoreException {
        this.ensureSlot(n2);
        PrivateKey privateKey = this.algs.getSignerAlg(null, string2, n3, byArray);
        if (privateKey == null) {
            throw new KeyStoreException("Key generation error", new DsAlgorithmException());
        }
        this.importPrivateKey(n2, string, bl, privateKey);
        return privateKey;
    }

    public PrivateKey generatePrivateKeyByTemplate(int n2, String string, Certificate certificate) throws KeyStoreException {
        boolean bl = (certificate.getKu() & 0x38) != 0;
        String string2 = certificate.getPublicKeyAlgOid();
        KeyGenerationParam keyGenerationParam = this.extractKeyGenerationParams(string2, certificate.getPublicKeyInfo());
        return this.generatePrivateKey(n2, string, bl, string2, keyGenerationParam.keyLength, keyGenerationParam.algParam);
    }

    public void deleteKeyEntry(int n2, PrivateKey privateKey) throws KeyStoreException {
        int n3;
        byte[] byArray;
        this.ensureSlot(n2);
        if (!this.slots[n2].isLoggedIn()) {
            throw new KeyStoreLoginRequiredException();
        }
        try {
            byArray = privateKey.getPublicKeyInfo();
            n3 = this.slots[n2].keyByPkcs8(privateKey.getEncoded());
        }
        catch (DsException dsException) {
            throw new KeyStoreException("", dsException);
        }
        if (n3 < 0) {
            n3 = this.slots[n2].keyByPublic(byArray);
        }
        if (n3 < 0) {
            throw new KeyStoreNotFoundException();
        }
        this.slots[n2].removeBag(n3);
        n3 = this.slots[n2].certByPublic(byArray);
        if (n3 >= 0) {
            this.slots[n2].removeBag(n3);
        }
    }

    public Certificate[] getCertificates(int n2, boolean bl, int n3, String string) throws KeyStoreException {
        if (n2 >= this.slots.length) {
            throw new IllegalArgumentException();
        }
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        for (int i2 = 0; i2 < this.slots.length; ++i2) {
            if (n2 >= 0 && n2 != i2) continue;
            for (int i3 = 0; i3 < this.slots[i2].bags.length; ++i3) {
                Certificate certificate;
                PfxBag pfxBag = this.slots[i2].bags[i3];
                if (pfxBag.type != 3) continue;
                try {
                    certificate = new Certificate(pfxBag.data);
                }
                catch (CertificateException certificateException) {
                    continue;
                }
                byte by = certificate.getKu();
                if ((n3 & 4) != 0 && (by & 6) == 0 || (n3 & 1) != 0 && (by & 0xC0) == 0 || (n3 & 2) != 0 && (by & 0x38) == 0 || string != null && !certificate.getPublicKeyAlgOid().startsWith(string)) continue;
                if (bl) {
                    int n4 = -1;
                    byte[] byArray = certificate.getSubjectKeyIdentifier();
                    if (byArray != null) {
                        n4 = this.slots[i2].keyByKeyIdentifier(byArray);
                    }
                    if (n4 < 0) {
                        n4 = this.slots[i2].keyByPublic(certificate.getPublicKeyInfo());
                    }
                    if (n4 < 0) continue;
                }
                arrayList.add(certificate);
            }
        }
        return arrayList.toArray(new Certificate[arrayList.size()]);
    }

    public Certificate[] getCertificateChain(Certificate certificate) throws KeyStoreException {
        boolean bl;
        if (certificate.isSelfSigned()) {
            return new Certificate[0];
        }
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        block2: do {
            bl = false;
            for (int i2 = 0; i2 < this.slots.length; ++i2) {
                for (int i3 = 0; i3 < this.slots[i2].bags.length; ++i3) {
                    PfxBag pfxBag = this.slots[i2].bags[i3];
                    if (pfxBag.type != 3) continue;
                    try {
                        Certificate certificate2 = new Certificate(pfxBag.data);
                        if (!certificate2.isSignerOf(certificate)) continue;
                        certificate = certificate2;
                        arrayList.add(certificate);
                        bl = true;
                        break;
                    }
                    catch (CertificateException certificateException) {
                        // empty catch block
                    }
                }
                if (bl) continue block2;
            }
        } while (bl && !certificate.isSelfSigned() && arrayList.size() < 16);
        return arrayList.toArray(new Certificate[arrayList.size()]);
    }

    public void setCertificate(int n2, PrivateKey privateKey, Certificate certificate) throws KeyStoreException {
        byte[] byArray;
        this.ensureSlot(n2);
        if (!this.slots[n2].isLoggedIn()) {
            throw new KeyStoreLoginRequiredException();
        }
        try {
            byArray = certificate != null ? certificate.getPublicKeyInfo() : privateKey.getPublicKeyInfo();
        }
        catch (DsException dsException) {
            throw new KeyStoreException("", dsException);
        }
        int n3 = this.slots[n2].certByPublic(byArray);
        if (n3 >= 0) {
            this.slots[n2].removeBag(n3);
        }
        if (certificate != null) {
            int n4;
            try {
                n4 = this.slots[n2].keyByPkcs8(privateKey.getEncoded());
            }
            catch (DsException dsException) {
                throw new KeyStoreException("", dsException);
            }
            if (n4 < 0) {
                throw new KeyStoreNotFoundException();
            }
            this.slots[n2].insertBag(certificate.getEncoded(), 3, null);
            byte[] byArray2 = certificate.getSubjectKeyIdentifier();
            if (byArray2 != null) {
                this.slots[n2].setBagAttribute(n4, "1.2.840.113549.1.9.21", 4, byArray2);
            }
        }
    }

    public void setCertificateChain(int n2, PrivateKey privateKey, Certificate[] certificateArray) throws KeyStoreException {
        Certificate certificate = null;
        if (certificateArray != null && certificateArray.length > 0) {
            certificate = certificateArray[0];
        }
        this.setCertificate(n2, privateKey, certificate);
        if (certificateArray != null) {
            for (int i2 = 1; i2 < certificateArray.length; ++i2) {
                this.slots[n2].insertBag(certificateArray[i2].getEncoded(), 3, null);
            }
        }
    }

    static class MsWinFilter
    implements FilenameFilter {
        String mask;

        public MsWinFilter(String string) {
            if (string.endsWith("*.*")) {
                string = string.substring(0, string.length() - 2);
            }
            this.mask = string.toLowerCase();
        }

        public boolean accept(File file, String string) {
            block4: {
                string = string.toLowerCase();
                int n2 = 0;
                int n3 = this.mask.length();
                int n4 = 0;
                int n5 = string.length();
                while (true) {
                    char c2;
                    char c3 = n2 < n3 ? this.mask.charAt(n2++) : (char)'\u0000';
                    char c4 = c2 = n4 < n5 ? string.charAt(n4++) : (char)'\u0000';
                    if (c3 == '\u0000' && c2 == '\u0000') break block4;
                    if (c3 == '*') {
                        if (n2 != n3) {
                            int n6 = string.lastIndexOf(this.mask.charAt(n2));
                            if (n6 < n4 - 1) {
                                return false;
                            }
                            n4 = n6;
                            continue;
                        }
                        break block4;
                    }
                    if (c3 != c2 && c3 != '?') break;
                }
                return false;
            }
            return true;
        }
    }

    protected static class KeyGenerationParam {
        public int keyLength;
        public byte[] algParam;

        public KeyGenerationParam(int n2, byte[] byArray) {
            this.keyLength = n2;
            this.algParam = byArray;
        }
    }
}

