/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor.DsLib.KeyStores;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_SLOT_INFO;
import sun.security.pkcs11.wrapper.CK_TOKEN_INFO;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import ua.avtor.DsLib.Certificate;
import ua.avtor.DsLib.DsAlgorithmException;
import ua.avtor.DsLib.DsException;
import ua.avtor.DsLib.KeyStores.KeyStore;
import ua.avtor.DsLib.KeyStores.KeyStoreException;
import ua.avtor.DsLib.KeyStores.KeyStoreInvalidPasswordException;
import ua.avtor.DsLib.KeyStores.KeyStoreLockedException;
import ua.avtor.DsLib.KeyStores.KeyStoreLoginRequiredException;
import ua.avtor.DsLib.KeyStores.KeyStoreNotFoundException;
import ua.avtor.DsLib.KeyStores.KeyStorePkcs11Exception;
import ua.avtor.DsLib.KeyStores.SlotInfo;
import ua.avtor.DsLib.PrivateKeys.PKCS11Utils.Pkcs11Module;
import ua.avtor.DsLib.PrivateKeys.PKCS11Utils.Pkcs11Session;
import ua.avtor.DsLib.PrivateKeys.PrivateKey;
import ua.avtor.DsLib.PrivateKeys.PrivateKeyDstu;
import ua.avtor.DsLib.PrivateKeys.PrivateKeyRsa;
import ua.avtor.DsLib.Utils.ArrayUtil;
import ua.avtor.DsLib.Utils.Ddec;
import ua.avtor.DsLib.Utils.DdecException;
import ua.avtor.DsLib.Utils.Pointer;
import ua.avtor.DsLib.Utils.Two;

public class KeyStorePKCS11
extends KeyStore {
    protected Pkcs11Module[] p11mods;
    protected SlotRecord[] slots;
    protected CertRecord[] certs;
    static String libsSeparator = ";";

    private void addSlotRecord(int n2, long l2, CK_SLOT_INFO cK_SLOT_INFO, CK_TOKEN_INFO cK_TOKEN_INFO) {
        SlotRecord[] slotRecordArray;
        String string = String.valueOf(cK_TOKEN_INFO.serialNumber).trim();
        String string2 = String.valueOf(cK_SLOT_INFO.slotDescription).trim();
        String string3 = string + '@' + string2;
        int n3 = 0;
        if (this.slots == null) {
            this.slots = new SlotRecord[1];
        } else {
            for (int i2 = 0; i2 < this.slots.length; ++i2) {
                if (!this.slots[i2].refId.equals(string3)) continue;
                this.slots[i2].stillPresent = true;
                return;
            }
            n3 = this.slots.length;
            slotRecordArray = new SlotRecord[n3 + 1];
            System.arraycopy(this.slots, 0, slotRecordArray, 0, this.slots.length);
            this.slots = slotRecordArray;
        }
        slotRecordArray = new SlotRecord(n2, l2, string3);
        slotRecordArray.description = string2;
        slotRecordArray.serial = string;
        slotRecordArray.label = String.valueOf(cK_TOKEN_INFO.label).trim();
        slotRecordArray.flags = (int)((cK_SLOT_INFO.flags & 0xFL) + (cK_TOKEN_INFO.flags << 4));
        this.slots[n3] = slotRecordArray;
    }

    private void rescanSlots() {
        int n2;
        if (this.slots != null) {
            for (n2 = 0; n2 < this.slots.length; ++n2) {
                this.slots[n2].stillPresent = false;
            }
        }
        for (n2 = 0; n2 < this.p11mods.length; ++n2) {
            long[] lArray;
            try {
                lArray = this.p11mods[n2].getSlotList(true);
            }
            catch (PKCS11Exception pKCS11Exception) {
                continue;
            }
            for (long l2 : lArray) {
                try {
                    CK_SLOT_INFO cK_SLOT_INFO = this.p11mods[n2].getSlotInfo(l2);
                    CK_TOKEN_INFO cK_TOKEN_INFO = this.p11mods[n2].getTokenInfo(l2);
                    this.addSlotRecord(n2, l2, cK_SLOT_INFO, cK_TOKEN_INFO);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this.slots == null) {
            this.slots = new SlotRecord[0];
        }
    }

    private void ensureSlots() {
        if (this.slots == null) {
            this.rescanSlots();
        }
    }

    private void ensureSession(int n2) throws PKCS11Exception {
        if (this.slots == null) {
            this.rescanSlots();
        }
        if (n2 < 0 || n2 >= this.slots.length) {
            throw new IllegalArgumentException();
        }
        if (this.slots[n2].session0 == null) {
            this.slots[n2].session0 = this.p11mods[this.slots[n2].moduleIx].newSession(this.slots[n2].mSlot);
        }
    }

    private void ensureCertificates() {
        if (this.certs != null) {
            return;
        }
        this.ensureSlots();
        ArrayList<CertRecord> arrayList = new ArrayList<CertRecord>();
        for (int i2 = 0; i2 < this.slots.length; ++i2) {
            try {
                long[] lArray;
                if (!this.slots[i2].stillPresent) continue;
                this.ensureSession(i2);
                for (long l2 : lArray = this.slots[i2].session0.findAllObjects(1L)) {
                    try {
                        byte[] byArray = this.slots[i2].session0.getAttributeValue(l2, 17L);
                        arrayList.add(new CertRecord(new Certificate(byArray), i2));
                    }
                    catch (DsException dsException) {
                        // empty catch block
                    }
                }
                continue;
            }
            catch (PKCS11Exception pKCS11Exception) {
                // empty catch block
            }
        }
        this.certs = arrayList.toArray(new CertRecord[arrayList.size()]);
    }

    public Pkcs11Session getSlotSession(int n2) throws PKCS11Exception {
        this.ensureSession(n2);
        return this.slots[n2].session0;
    }

    protected KeySearchAttr extractKeySearchAttribute(byte[] byArray) throws KeyStoreException {
        String string = Ddec.TryGetElementOid(byArray, "SSD");
        byte[] byArray2 = Ddec.TryGetElementBuf(byArray, "SsG");
        if (string.equals("1.2.840.113549.1.1.1")) {
            byte[] byArray3 = Ddec.TryGetElementBuf(byArray2, "SI");
            if (byArray3 == null) {
                throw new KeyStoreNotFoundException();
            }
            if (byArray3.length > 1 && byArray3[0] == 0) {
                System.arraycopy(byArray3, 1, byArray3, 0, byArray3.length - 1);
                byArray3 = ArrayUtil.resizeOf(byArray3, byArray3.length - 1);
            }
            return new KeySearchAttr(288L, byArray3);
        }
        if (string.equals("1.2.804.2.1.1.1.1.3.1.1.1.1")) {
            byte[] byArray4 = new byte[byArray2.length - 2];
            System.arraycopy(byArray2, 2, byArray4, 0, byArray4.length);
            ArrayUtil.reverse(byArray2);
            System.arraycopy(byArray4, 0, byArray2, 2, byArray4.length);
        }
        return new KeySearchAttr(385L, byArray2);
    }

    protected KeyGenerationParam extractKeyGenerationParams(String string, byte[] byArray) {
        if (string.equals("1.2.840.113549.1.1.1")) {
            byte[] byArray2 = Ddec.TryGetElementBuf(byArray, "SsGSI");
            return new KeyGenerationParam((byArray2.length & 0xFFFFFFFC) * 8, null);
        }
        byte[] byArray3 = Ddec.TryGetElementBuf(byArray, "SSdx");
        if (string.equals("1.2.804.2.1.1.1.1.3.1.1.1.1") && Ddec.DerIsElementPresent(byArray3, "SSoe0siQ")) {
            try {
                byte[] byArray4 = Ddec.DerGetElementReverse(byArray3, "SSoe0siQ");
                Two<Pointer, Integer> two = Ddec.DerGetElementPtr(byArray3, "SSoe0siQ");
                ((Pointer)two.first).UpdateData(byArray4, (int)((Integer)two.second));
                byArray4 = Ddec.DerGetElementReverse(byArray3, "SSoe0siqiQ");
                two = Ddec.DerGetElementPtr(byArray3, "SSoe0siqiQ");
                ((Pointer)two.first).UpdateData(byArray4, (int)((Integer)two.second));
            }
            catch (DdecException ddecException) {
                // empty catch block
            }
        }
        return new KeyGenerationParam(0, byArray3);
    }

    protected String extractAlgOid(long l2) throws DsAlgorithmException {
        if (l2 == 2151809329L) {
            return "1.2.804.2.1.1.1.1.3.1.1";
        }
        if (l2 == 0L) {
            return "1.2.840.113549.1.1.1";
        }
        throw new DsAlgorithmException("CKK " + Long.toHexString(l2));
    }

    protected PrivateKey createPrivateKey(int n2, long l2, String string, boolean bl, String string2, int n3, byte[] byArray) throws DsException, PKCS11Exception {
        if (string2.startsWith("1.2.804.2.1.1.1.1.3.1.1")) {
            return new PrivateKeyDstu(this, n2, this.slots[n2].session0, l2, string, bl, string2, n3, byArray);
        }
        if (string2.equals("1.2.840.113549.1.1.1")) {
            return new PrivateKeyRsa(this, n2, this.slots[n2].session0, l2, string, bl, string2, n3, byArray);
        }
        throw new DsAlgorithmException(string2);
    }

    public KeyStorePKCS11(String string) throws KeyStoreException {
        String[] stringArray = string.split(libsSeparator);
        this.p11mods = new Pkcs11Module[stringArray.length];
        try {
            for (int i2 = 0; i2 < this.p11mods.length; ++i2) {
                this.p11mods[i2] = new Pkcs11Module(stringArray[i2]);
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (pKCS11Exception.getErrorCode() == 2L) {
                throw new KeyStoreNotFoundException();
            }
            throw new KeyStorePkcs11Exception(pKCS11Exception);
        }
    }

    public void login(int n2, String string) throws KeyStoreException {
        try {
            this.ensureSession(n2);
            this.slots[n2].session0.login(string);
        }
        catch (PKCS11Exception pKCS11Exception) {
            switch ((int)pKCS11Exception.getErrorCode()) {
                case 161: {
                    throw new KeyStoreInvalidPasswordException();
                }
                case 160: {
                    throw new KeyStoreInvalidPasswordException();
                }
                case 164: {
                    throw new KeyStoreLockedException("", pKCS11Exception);
                }
            }
            throw new KeyStorePkcs11Exception(pKCS11Exception);
        }
    }

    public void logout(int n2) throws KeyStoreException {
        try {
            this.ensureSession(n2);
            this.slots[n2].session0.logout();
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new KeyStorePkcs11Exception(pKCS11Exception);
        }
    }

    public boolean isLoggedIn(int n2) throws KeyStoreException {
        try {
            this.ensureSession(n2);
            return (this.slots[n2].session0.getSessionState() & 1L) != 0L;
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new KeyStorePkcs11Exception(pKCS11Exception);
        }
    }

    public void changePassword(int n2, String string, String string2) throws KeyStoreException {
        try {
            this.ensureSession(n2);
            this.slots[n2].session0.changePin(string, string2);
        }
        catch (PKCS11Exception pKCS11Exception) {
            switch ((int)pKCS11Exception.getErrorCode()) {
                case 161: {
                    throw new KeyStoreInvalidPasswordException();
                }
                case 160: {
                    throw new KeyStoreInvalidPasswordException();
                }
                case 164: {
                    throw new KeyStoreLockedException("", pKCS11Exception);
                }
            }
            throw new KeyStorePkcs11Exception(pKCS11Exception);
        }
    }

    public int findSlot(String string) throws KeyStoreException {
        this.ensureSlots();
        if (string == null || string.length() == 0) {
            for (int i2 = 0; i2 < this.slots.length; ++i2) {
                if (!this.slots[i2].stillPresent) continue;
                return i2;
            }
            throw new KeyStoreNotFoundException();
        }
        if (string.charAt(0) == '@') {
            for (int i3 = 0; i3 < this.slots.length; ++i3) {
                if (!this.slots[i3].stillPresent || !this.slots[i3].description.startsWith(string.substring(1))) continue;
                return i3;
            }
        } else {
            int n2;
            for (n2 = 0; n2 < this.slots.length; ++n2) {
                if (!this.slots[n2].stillPresent || !this.slots[n2].label.startsWith(string)) continue;
                return n2;
            }
            for (n2 = 0; n2 < this.slots.length; ++n2) {
                if (!this.slots[n2].stillPresent || !this.slots[n2].serial.equals(string)) continue;
                return n2;
            }
        }
        throw new KeyStoreNotFoundException();
    }

    public int findSlot(Certificate certificate) throws KeyStoreException {
        KeySearchAttr keySearchAttr = this.extractKeySearchAttribute(certificate.getPublicKeyInfo());
        this.ensureSlots();
        for (int i2 = 0; i2 < this.slots.length; ++i2) {
            try {
                if (!this.slots[i2].stillPresent) continue;
                this.ensureSession(i2);
                this.slots[i2].session0.getPublicKeyHandle(null, keySearchAttr.id, keySearchAttr.value);
                return i2;
            }
            catch (PKCS11Exception pKCS11Exception) {
                // empty catch block
            }
        }
        throw new KeyStoreNotFoundException();
    }

    public int findSlot(byte[] byArray) throws KeyStoreException {
        this.ensureCertificates();
        for (int i2 = 0; i2 < this.certs.length; ++i2) {
            if (!this.certs[i2].cert.isMyIdentifier(byArray)) continue;
            return this.certs[i2].slot;
        }
        throw new KeyStoreNotFoundException();
    }

    public int[] enumSlots(boolean bl) throws KeyStoreException {
        if (bl) {
            this.rescanSlots();
            this.certs = null;
        } else {
            this.ensureSlots();
        }
        int n2 = 0;
        for (int i2 = 0; i2 < this.slots.length; ++i2) {
            if (!this.slots[i2].stillPresent) continue;
            ++n2;
        }
        int[] nArray = new int[n2];
        n2 = 0;
        for (int i3 = 0; i3 < this.slots.length; ++i3) {
            if (!this.slots[i3].stillPresent) continue;
            nArray[n2++] = i3;
        }
        return nArray;
    }

    public String[] enumLabels(int n2) throws KeyStoreException {
        long[] lArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            this.ensureSession(n2);
            lArray = this.slots[n2].session0.findAllObjects(2L);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new KeyStorePkcs11Exception(pKCS11Exception);
        }
        for (long l2 : lArray) {
            String string;
            block8: {
                string = null;
                try {
                    byte[] byArray = this.slots[n2].session0.getAttributeValue(l2, 3L);
                    if (byArray.length <= 0) break block8;
                    try {
                        string = new String(byArray, "UTF8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new IllegalArgumentException(unsupportedEncodingException);
                    }
                }
                catch (PKCS11Exception pKCS11Exception) {
                    // empty catch block
                }
            }
            if (string == null) {
                string = "##" + Long.toString(l2);
            }
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public SlotInfo getSlotInfo(int n2) throws KeyStoreException {
        this.ensureSlots();
        if (n2 < 0 || n2 >= this.slots.length) {
            throw new IllegalArgumentException();
        }
        SlotInfo slotInfo = new SlotInfo();
        slotInfo.description = this.slots[n2].description;
        slotInfo.label = this.slots[n2].label;
        slotInfo.serial = this.slots[n2].serial;
        try {
            CK_TOKEN_INFO cK_TOKEN_INFO = this.p11mods[this.slots[n2].moduleIx].getTokenInfo(this.slots[n2].mSlot);
            slotInfo.flags = (int)((long)(this.slots[n2].flags & 0xF) + (cK_TOKEN_INFO.flags << 4));
            slotInfo.minPasswordLength = (int)cK_TOKEN_INFO.ulMinPinLen;
            slotInfo.maxPasswordLength = (int)cK_TOKEN_INFO.ulMaxPinLen;
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new KeyStorePkcs11Exception(pKCS11Exception);
        }
        slotInfo.hardware = (slotInfo.flags & 4) != 0;
        slotInfo.pinpad = (slotInfo.flags & 0x1000) != 0;
        return slotInfo;
    }

    public PrivateKey getPrivateKey(int n2, Certificate certificate) throws KeyStoreException {
        KeySearchAttr keySearchAttr = this.extractKeySearchAttribute(certificate.getPublicKeyInfo());
        try {
            this.ensureSession(n2);
            long l2 = this.slots[n2].session0.getPublicKeyHandle(null, keySearchAttr.id, keySearchAttr.value);
            long l3 = this.slots[n2].session0.getBindedObjectHandle(l2, 3L);
            return this.createPrivateKey(n2, l3, null, false, certificate.getPublicKeyAlgOid(), -1, null);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new KeyStoreNotFoundException("", pKCS11Exception);
        }
        catch (DsException dsException) {
            throw new KeyStoreNotFoundException("", dsException);
        }
    }

    public PrivateKey getPrivateKey(int n2, byte[] byArray) throws KeyStoreException {
        this.ensureCertificates();
        Certificate certificate = null;
        for (int i2 = 0; i2 < this.certs.length; ++i2) {
            if (this.certs[i2].slot != n2 || !this.certs[i2].cert.isMyIdentifier(byArray)) continue;
            certificate = this.certs[i2].cert;
            break;
        }
        if (certificate == null) {
            throw new KeyStoreNotFoundException();
        }
        return this.getPrivateKey(n2, certificate);
    }

    public PrivateKey getPrivateKey(int n2, String string) throws KeyStoreException {
        try {
            this.ensureSession(n2);
            long l2 = string.startsWith("##") ? Long.parseLong(string.substring(2)) : this.slots[n2].session0.getPublicKeyHandle(string, 0L, null);
            long l3 = this.slots[n2].session0.getBindedObjectHandle(l2, 3L);
            long l4 = this.slots[n2].session0.getAttribute(l3, 256L).getLong();
            return this.createPrivateKey(n2, l3, null, false, this.extractAlgOid(l4), -1, null);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new KeyStoreNotFoundException("", pKCS11Exception);
        }
        catch (DsException dsException) {
            throw new KeyStoreNotFoundException("", dsException);
        }
    }

    public PrivateKey generatePrivateKey(int n2, String string, boolean bl, String string2, int n3, byte[] byArray) throws KeyStoreException {
        try {
            this.ensureSession(n2);
            return this.createPrivateKey(n2, 0L, string, bl, string2, n3, byArray);
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (pKCS11Exception.getErrorCode() == 257L) {
                throw new KeyStoreLoginRequiredException();
            }
            throw new KeyStorePkcs11Exception(pKCS11Exception);
        }
        catch (DsException dsException) {
            throw new KeyStoreException("", dsException);
        }
    }

    public PrivateKey generatePrivateKeyByTemplate(int n2, String string, Certificate certificate) throws KeyStoreException {
        boolean bl = (certificate.getKu() & 0x38) != 0;
        String string2 = certificate.getPublicKeyAlgOid();
        KeyGenerationParam keyGenerationParam = this.extractKeyGenerationParams(string2, certificate.getPublicKeyInfo());
        return this.generatePrivateKey(n2, string, bl, string2, keyGenerationParam.keyLength, keyGenerationParam.algParam);
    }

    public void deleteKeyEntry(int n2, PrivateKey privateKey) throws KeyStoreException {
        try {
            privateKey.deleteContainer();
            this.certs = null;
        }
        catch (DsException dsException) {
            Throwable throwable = dsException.getCause();
            if (throwable instanceof PKCS11Exception && ((PKCS11Exception)throwable).getErrorCode() == 257L) {
                throw new KeyStoreLoginRequiredException();
            }
            throw new KeyStoreException("", dsException);
        }
    }

    public Certificate[] getCertificates(int n2, boolean bl, int n3, String string) throws KeyStoreException {
        this.ensureCertificates();
        if (n2 >= this.slots.length) {
            throw new IllegalArgumentException();
        }
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        for (int i2 = 0; i2 < this.certs.length; ++i2) {
            if (n2 >= 0 && n2 != this.certs[i2].slot) continue;
            byte by = this.certs[i2].cert.getKu();
            if ((n3 & 4) != 0 && (by & 6) == 0 || (n3 & 1) != 0 && (by & 0xC0) == 0 || (n3 & 2) != 0 && (by & 0x38) == 0 || string != null && !this.certs[i2].cert.getPublicKeyAlgOid().startsWith(string)) continue;
            if (bl) {
                KeySearchAttr keySearchAttr = this.extractKeySearchAttribute(this.certs[i2].cert.getPublicKeyInfo());
                try {
                    this.ensureSession(this.certs[i2].slot);
                    this.slots[this.certs[i2].slot].session0.getPublicKeyHandle(null, keySearchAttr.id, keySearchAttr.value);
                }
                catch (PKCS11Exception pKCS11Exception) {
                    continue;
                }
            }
            arrayList.add(this.certs[i2].cert);
        }
        return arrayList.toArray(new Certificate[arrayList.size()]);
    }

    public Certificate[] getCertificateChain(Certificate certificate) throws KeyStoreException {
        boolean bl;
        this.ensureCertificates();
        if (certificate.isSelfSigned()) {
            return new Certificate[0];
        }
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        block0: do {
            bl = false;
            for (int i2 = 0; i2 < this.certs.length; ++i2) {
                if (!this.certs[i2].cert.isSignerOf(certificate)) continue;
                certificate = this.certs[i2].cert;
                arrayList.add(certificate);
                bl = true;
                continue block0;
            }
        } while (bl && !certificate.isSelfSigned() && arrayList.size() < 16);
        return arrayList.toArray(new Certificate[arrayList.size()]);
    }

    public void setCertificate(int n2, PrivateKey privateKey, Certificate certificate) throws KeyStoreException {
        byte[] byArray;
        long l2;
        try {
            this.ensureSession(n2);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new KeyStorePkcs11Exception(pKCS11Exception);
        }
        Pkcs11Session pkcs11Session = this.slots[n2].session0;
        try {
            byte[] byArray2 = certificate != null ? certificate.getPublicKeyInfo() : privateKey.getPublicKeyInfo();
            KeySearchAttr keySearchAttr = this.extractKeySearchAttribute(byArray2);
            l2 = pkcs11Session.getPublicKeyHandle(null, keySearchAttr.id, keySearchAttr.value);
            byArray = pkcs11Session.getAttributeValue(l2, 258L);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new KeyStoreNotFoundException("", pKCS11Exception);
        }
        catch (DsException dsException) {
            throw new KeyStoreNotFoundException("", dsException);
        }
        this.certs = null;
        for (int i2 = 0; i2 < 10; ++i2) {
            try {
                long l3 = pkcs11Session.getBindedObjectHandle(l2, 1L);
                pkcs11Session.destroyObject(l3);
                continue;
            }
            catch (PKCS11Exception pKCS11Exception) {
                if (pKCS11Exception.getErrorCode() != 257L) break;
                throw new KeyStoreLoginRequiredException();
            }
        }
        if (certificate != null) {
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 1L), new CK_ATTRIBUTE(128L, 0L), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(258L, byArray), new CK_ATTRIBUTE(17L, certificate.getEncoded()), new CK_ATTRIBUTE(257L, certificate.getSubjectDN())};
            try {
                pkcs11Session.createObject(cK_ATTRIBUTEArray);
            }
            catch (PKCS11Exception pKCS11Exception) {
                if (pKCS11Exception.getErrorCode() == 257L) {
                    throw new KeyStoreLoginRequiredException();
                }
                throw new KeyStorePkcs11Exception(pKCS11Exception);
            }
        }
    }

    public void setCertificateChain(int n2, PrivateKey privateKey, Certificate[] certificateArray) throws KeyStoreException {
        Certificate certificate = null;
        if (certificateArray != null && certificateArray.length > 0) {
            certificate = certificateArray[0];
        }
        this.setCertificate(n2, privateKey, certificate);
    }

    protected static class KeyGenerationParam {
        public int keyLength;
        public byte[] algParam;

        public KeyGenerationParam(int n2, byte[] byArray) {
            this.keyLength = n2;
            this.algParam = byArray;
        }
    }

    protected static class KeySearchAttr {
        public long id;
        public byte[] value;

        public KeySearchAttr(long l2, byte[] byArray) {
            this.id = l2;
            this.value = byArray;
        }
    }

    protected static class CertRecord {
        public Certificate cert;
        public int slot;

        public CertRecord(Certificate certificate, int n2) {
            this.cert = certificate;
            this.slot = n2;
        }
    }

    protected static class SlotRecord {
        public int moduleIx;
        public long mSlot;
        public String description;
        public String label;
        public String serial;
        public int flags;
        public String refId;
        public Pkcs11Session session0;
        public boolean stillPresent;

        public SlotRecord(int n2, long l2, String string) {
            this.moduleIx = n2;
            this.mSlot = l2;
            this.refId = string;
            this.session0 = null;
            this.stillPresent = true;
        }
    }
}

