/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor.DsLib;

import java.io.IOException;
import java.util.ArrayList;
import ua.avtor.DsLib.Algorithms.CryptoAlgorithmFactory;
import ua.avtor.DsLib.Algorithms.MessageDigestAlg;
import ua.avtor.DsLib.Algorithms.MessageVerifierAlg;
import ua.avtor.DsLib.CertRevocationList;
import ua.avtor.DsLib.Certificate;
import ua.avtor.DsLib.CertificateException;
import ua.avtor.DsLib.Certificates.CertificateFinder;
import ua.avtor.DsLib.DsAlgorithmException;
import ua.avtor.DsLib.DsDataCorruptedException;
import ua.avtor.DsLib.DsDataNotFoundException;
import ua.avtor.DsLib.DsException;
import ua.avtor.DsLib.DsInvalidOperationException;
import ua.avtor.DsLib.DsInvalidParamException;
import ua.avtor.DsLib.DsTspException;
import ua.avtor.DsLib.OcspResponse;
import ua.avtor.DsLib.PrivateKeys.PrivateKey;
import ua.avtor.DsLib.SignerInfo;
import ua.avtor.DsLib.Utils.Ddec;
import ua.avtor.DsLib.Utils.DdecException;
import ua.avtor.DsLib.Utils.DerEncoder;
import ua.avtor.DsLib.Utils.Pointer;
import ua.avtor.DsLib.Utils.Two;

public class CmsSigned {
    final byte stgUPDATE = 1;
    final byte stgDATAFIXED = (byte)2;
    final byte stgVFBEGIN = (byte)4;
    final byte stgVFFIXED = (byte)8;
    final byte stgVFUPDATE = (byte)16;
    final String OID_SIGNED_DATA = "1.2.840.113549.1.7.2";
    final String OID_CONTENT_TYPE = "1.2.840.113549.1.9.3";
    final String OID_MESSAGE_DIGEST = "1.2.840.113549.1.9.4";
    protected int stage;
    protected boolean attachedData;
    protected String contentTypeOid;
    protected byte[] content;
    protected ArrayList<Certificate> certificates = new ArrayList();
    protected ArrayList<CmsSignerInfo> signers = new ArrayList();
    protected ArrayList<CertRevocationList> crls = new ArrayList();
    protected ArrayList<OcspResponse> ocsps = new ArrayList();

    public CmsSigned(boolean bl) {
        this.contentTypeOid = "1.2.840.113549.1.7.1";
        this.attachedData = bl;
        this.stage = 0;
    }

    public CmsSigned(byte[] byArray) throws DsDataCorruptedException, CertificateException {
        Object object;
        this.stage = 2;
        this.attachedData = false;
        try {
            if (!Ddec.DerGetElementOid(byArray, "SD").equals("1.2.840.113549.1.7.2")) {
                throw new DsDataCorruptedException();
            }
        }
        catch (DdecException ddecException) {
            throw new DsDataCorruptedException();
        }
        try {
            this.contentTypeOid = Ddec.DerGetElementOid(byArray, "SdE0SiuSD");
        }
        catch (DdecException ddecException) {
            throw new DsDataCorruptedException();
        }
        try {
            this.content = Ddec.DerGetElementBuf(byArray, "SdE0SiuSdE0Q");
            this.attachedData = true;
        }
        catch (DdecException ddecException) {
            // empty catch block
        }
        Ddec.DerSearchRec derSearchRec = Ddec.DerFindFirstElement(byArray, "SdE0SiusE0");
        while (derSearchRec != null) {
            this.addCertificate(derSearchRec.der.Copy(derSearchRec.size));
            derSearchRec = Ddec.DerFindNextElement(derSearchRec);
        }
        derSearchRec = Ddec.DerFindFirstElement(byArray, "SdE0Siusoe0E1");
        while (derSearchRec != null) {
            if (derSearchRec.der.Get() == 48) {
                this.addCRL(derSearchRec.der.Copy(derSearchRec.size));
            }
            if (derSearchRec.der.Get() == 161) {
                object = new byte[]{6, 8, 43, 6, 1, 5, 5, 7, 16, 2};
                try {
                    byte[] byArray2 = Ddec.DerGetElementBuf(derSearchRec.der, "E1d");
                    if (new Pointer(byArray2).CompareTo((byte[])object)) {
                        this.addOCSPResponse(Ddec.DerGetElementBuf(derSearchRec.der, "E1ds"));
                    }
                }
                catch (DdecException ddecException) {
                    // empty catch block
                }
            }
            derSearchRec = Ddec.DerFindNextElement(derSearchRec);
        }
        derSearchRec = Ddec.DerFindFirstElement(byArray, "SdE0Siusoe0oe1U");
        while (derSearchRec != null) {
            object = new CmsSignerInfo();
            ((CmsSignerInfo)object).info = new SignerInfo(derSearchRec.der.Copy(derSearchRec.size));
            ((CmsSignerInfo)object).sgDigestIndex = -1;
            this.signers.add((CmsSignerInfo)object);
            derSearchRec = Ddec.DerFindNextElement(derSearchRec);
        }
    }

    public final void addCertificate(byte[] byArray) throws CertificateException {
        this.certificates.add(new Certificate(byArray));
    }

    public final void addCRL(byte[] byArray) throws CertificateException {
        this.crls.add(new CertRevocationList(byArray));
    }

    public final void addOCSPResponse(byte[] byArray) throws DsDataCorruptedException {
        this.ocsps.add(new OcspResponse(byArray));
    }

    public final void removeCertificates() {
        this.certificates.clear();
        this.crls.clear();
        this.ocsps.clear();
    }

    public SignerInfo addSigner(byte[] byArray, PrivateKey privateKey) throws CertificateException {
        SignerInfo signerInfo = new SignerInfo(byArray, privateKey);
        int n2 = this.signers.size();
        for (int i2 = 0; i2 < this.signers.size(); ++i2) {
            if (this.signers.get((int)i2).sgDigestIndex != i2 || !this.digestAlgIsEqual(signerInfo, this.signers.get((int)i2).info)) continue;
            n2 = i2;
            break;
        }
        CmsSignerInfo cmsSignerInfo = new CmsSignerInfo();
        cmsSignerInfo.info = signerInfo;
        cmsSignerInfo.sgDigestIndex = n2;
        this.signers.add(cmsSignerInfo);
        return signerInfo;
    }

    public final void update(byte[] byArray) throws DsException {
        this.stage |= 1;
        for (int i2 = 0; i2 < this.signers.size(); ++i2) {
            SignerInfo signerInfo = this.signers.get((int)i2).info;
            if (signerInfo.hasSignature() || this.signers.get((int)i2).sgDigestIndex != i2) continue;
            signerInfo.privateKey.digestUpdate(byArray);
        }
        if (this.attachedData && (this.stage & 2) == 0) {
            if (this.content == null) {
                this.content = new byte[byArray.length];
            } else {
                byte[] byArray2 = new byte[this.content.length + byArray.length];
                System.arraycopy(this.content, 0, byArray2, 0, this.content.length);
                this.content = byArray2;
            }
            System.arraycopy(byArray, 0, this.content, this.content.length - byArray.length, byArray.length);
        }
    }

    public final void setContentType(String string) {
        this.contentTypeOid = string;
    }

    public final boolean isContentAttached() {
        return this.attachedData;
    }

    public final String getContentType() {
        return this.contentTypeOid;
    }

    public final byte[] getContent() {
        return this.content;
    }

    public final Certificate getAdditionalCertificate(int n2) {
        try {
            return this.certificates.get(n2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final CertRevocationList getCRL(int n2) {
        try {
            return this.crls.get(n2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final OcspResponse getOCSPResponse(int n2) {
        try {
            return this.ocsps.get(n2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final int getSignerCount() {
        return this.signers.size();
    }

    public final SignerInfo getSigner(int n2) {
        try {
            return this.signers.get((int)n2).info;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final void verifyBegin(CryptoAlgorithmFactory cryptoAlgorithmFactory, CertificateFinder certificateFinder) throws DsInvalidOperationException, CertificateException, DsDataCorruptedException, DsDataNotFoundException, DsInvalidParamException, DsAlgorithmException {
        Object object;
        Object object2;
        Object object3;
        for (CmsSignerInfo object4 : this.signers) {
            object4.verifierAlg = null;
            object4.digestAlg = null;
            object4.vfDigestIndex = -1;
        }
        for (CmsSignerInfo cmsSignerInfo : this.signers) {
            object3 = cmsSignerInfo.info;
            if (((SignerInfo)object3).getCertificate() != null) continue;
            object2 = ((SignerInfo)object3).getSignerIdentifier();
            if (object2[0] == 48) {
                object = this.findLocalCertificate(0, (byte[])object2);
                if (object == null && certificateFinder != null) {
                    object = certificateFinder.findCertificate(0, (byte[])object2);
                }
            } else {
                object = this.findLocalCertificate(1, new Pointer((byte[])object2).Next(2).Copy(((byte[])object2).length - 2));
                if (object == null && certificateFinder != null) {
                    object = certificateFinder.findCertificate(1, new Pointer((byte[])object2).Next(2).Copy(((byte[])object2).length - 2));
                }
            }
            if (object == null || !this.isCertIdMatch(cryptoAlgorithmFactory, (SignerInfo)object3, (byte[])object)) continue;
            ((SignerInfo)object3).setCertificateData((byte[])object);
        }
        for (int i2 = 0; i2 < this.signers.size(); ++i2) {
            SignerInfo signerInfo = this.signers.get((int)i2).info;
            object3 = signerInfo.getCertificate();
            if (object3 == null) {
                signerInfo.verificationStatus = 2;
                continue;
            }
            object2 = this.signers.get(i2);
            object2.verifierAlg = cryptoAlgorithmFactory.getVerifierAlg(signerInfo.getDigestOid(), signerInfo.getDigestParams(), signerInfo.getSignatureOid(), signerInfo.getSignatureParams(), signerInfo.getCertificate());
            if (object2.verifierAlg == null) {
                signerInfo.verificationStatus = 4;
                continue;
            }
            if (!signerInfo.hasSignedAttributes()) {
                object2.vfDigestIndex = -1;
            } else {
                object = cryptoAlgorithmFactory.getDigestAlg(signerInfo.getDigestOid(), signerInfo.getDigestParams(), signerInfo.getCertificate());
                if (object == null) {
                    signerInfo.verificationStatus = 4;
                    continue;
                }
                object2.digestAlg = object;
                object2.vfDigestIndex = i2;
                for (int i3 = 0; i3 < i2; ++i3) {
                    if (this.signers.get((int)i3).vfDigestIndex != i3) continue;
                    MessageDigestAlg messageDigestAlg = this.signers.get((int)i3).digestAlg;
                    if (!this.digestAlgIsEqual(object.getOid(), object.getParams(), messageDigestAlg.getOid(), messageDigestAlg.getParams())) continue;
                    object2.digestAlg = null;
                    object2.vfDigestIndex = i3;
                    break;
                }
            }
            signerInfo.verificationStatus = 1;
        }
        this.stage |= 4;
        if (this.attachedData) {
            this.verifyUpdate(this.content);
            this.stage |= 8;
        }
    }

    public final void verifyUpdate(byte[] byArray) throws DsInvalidOperationException {
        if ((this.stage & 4) == 0 || (this.stage & 8) != 0) {
            throw new DsInvalidOperationException();
        }
        this.stage |= 0x10;
        for (int i2 = 0; i2 < this.signers.size(); ++i2) {
            CmsSignerInfo cmsSignerInfo = this.signers.get(i2);
            if (cmsSignerInfo.info.verificationStatus != 1) continue;
            if (cmsSignerInfo.vfDigestIndex == -1) {
                cmsSignerInfo.verifierAlg.update(byArray);
                continue;
            }
            if (cmsSignerInfo.vfDigestIndex != i2) continue;
            cmsSignerInfo.digestAlg.update(byArray);
        }
    }

    public final SignerInfo verifySigner(int n2) throws DsException {
        if ((this.stage & 0x10) == 0) {
            throw new DsInvalidOperationException();
        }
        this.stage |= 8;
        if (n2 >= this.signers.size()) {
            return null;
        }
        CmsSignerInfo cmsSignerInfo = this.signers.get(n2);
        if (cmsSignerInfo.info.verificationStatus != 1) {
            if (cmsSignerInfo.info.verificationStatus != 0) {
                return null;
            }
            return cmsSignerInfo.info;
        }
        byte[] byArray = cmsSignerInfo.info.getSignature();
        if (cmsSignerInfo.vfDigestIndex == -1) {
            cmsSignerInfo.info.verificationStatus = cmsSignerInfo.verifierAlg.verify(byArray) ? 0 : 5;
        } else {
            byte[] byArray2;
            CmsSignerInfo cmsSignerInfo2 = this.signers.get(cmsSignerInfo.vfDigestIndex);
            if (cmsSignerInfo2.digestSize == 0) {
                byArray2 = cmsSignerInfo2.digestAlg.getDigest();
                if (byArray2.length > (cmsSignerInfo2.digest == null ? 64 : cmsSignerInfo2.digest.length)) {
                    throw new DsException(0x70000001);
                }
                cmsSignerInfo2.digestSize = byArray2.length;
                cmsSignerInfo2.digest = (byte[])byArray2.clone();
            }
            cmsSignerInfo.info.verificationStatus = 5;
            try {
                byte[] byArray3 = cmsSignerInfo.info.getSignedAttribute("1.2.840.113549.1.9.4");
                if (byArray3.length != 2 + cmsSignerInfo2.digestSize) {
                    return null;
                }
                if (!new Pointer(byArray3).Next(2).CompareTo(cmsSignerInfo2.digest)) {
                    return null;
                }
                byte[] byArray4 = cmsSignerInfo.info.getSignedAttribute("1.2.840.113549.1.9.3");
                if (!new Pointer(byArray4).CompareTo(byArray2 = Ddec.DerEncodeOid(this.contentTypeOid))) {
                    return null;
                }
            }
            catch (Exception exception) {
                return null;
            }
            byArray2 = cmsSignerInfo.info.getSignedAttributes();
            cmsSignerInfo.verifierAlg.update(byArray2);
            cmsSignerInfo.info.verificationStatus = cmsSignerInfo.verifierAlg.verify(byArray) ? 0 : 5;
        }
        if (cmsSignerInfo.info.verificationStatus == 0) {
            cmsSignerInfo.info.verificationStatus = this.afterVerificationSuccess(cmsSignerInfo);
        }
        if (cmsSignerInfo.info.verificationStatus != 0) {
            return null;
        }
        return cmsSignerInfo.info;
    }

    public final boolean verifyAll() throws DsException {
        if (this.signers.isEmpty()) {
            return false;
        }
        for (int i2 = 0; i2 < this.signers.size(); ++i2) {
            if (this.verifySigner(i2) != null) continue;
            return false;
        }
        return true;
    }

    public final void ensureSigned() throws DsException, IOException {
        SignerInfo signerInfo;
        boolean bl = false;
        for (CmsSignerInfo cmsSignerInfo : this.signers) {
            signerInfo = cmsSignerInfo.info;
            if (signerInfo.hasSignature()) continue;
            bl = true;
        }
        if (bl) {
            this.calcContentDigests();
            for (CmsSignerInfo cmsSignerInfo : this.signers) {
                signerInfo = cmsSignerInfo.info;
                if (signerInfo.hasSignature()) continue;
                this.beforeSigning(cmsSignerInfo);
                signerInfo.ensureSigned();
                this.afterSigning(cmsSignerInfo);
            }
        }
    }

    public final byte[] getEncoded() throws DsException, IOException {
        Object object;
        int n2 = this.calcCmsVersion();
        this.ensureSigned();
        this.beforeEncoding();
        DerEncoder derEncoder = new DerEncoder();
        derEncoder.SeqBegin();
        derEncoder.addOid("1.2.840.113549.1.7.2");
        derEncoder.SpecificBegin((byte)-96);
        derEncoder.SeqBegin();
        derEncoder.addInteger(n2);
        this.encodeDigestList(derEncoder);
        derEncoder.SeqBegin();
        derEncoder.addOid(this.contentTypeOid);
        if (this.attachedData) {
            derEncoder.SpecificBegin((byte)-96);
            derEncoder.addOctets(this.content);
            derEncoder.SpecificEnd();
        }
        derEncoder.SeqEnd();
        if (!this.certificates.isEmpty()) {
            derEncoder.SpecificBegin((byte)-96);
            for (Certificate object2 : this.certificates) {
                object = object2.getEncoded();
                derEncoder.addObject((byte[])object);
            }
            derEncoder.SpecificEnd();
        }
        if (!this.crls.isEmpty() || !this.ocsps.isEmpty()) {
            derEncoder.SpecificBegin((byte)-95);
            for (CertRevocationList certRevocationList : this.crls) {
                object = certRevocationList.getEncoded();
                derEncoder.addObject((byte[])object);
            }
            for (OcspResponse ocspResponse : this.ocsps) {
                derEncoder.SpecificBegin((byte)-95);
                derEncoder.addOid("1.3.6.1.5.5.7.16.2");
                object = ocspResponse.getEncoded();
                derEncoder.addObject((byte[])object);
                derEncoder.SpecificEnd();
            }
            derEncoder.SpecificEnd();
        }
        derEncoder.SetBegin();
        for (CmsSignerInfo cmsSignerInfo : this.signers) {
            object = cmsSignerInfo.info;
            byte[] byArray = object.getEncoded();
            derEncoder.addObject(byArray);
        }
        derEncoder.SetEnd();
        derEncoder.SeqEnd();
        derEncoder.SpecificEnd();
        derEncoder.SeqEnd();
        return derEncoder.getEncoded();
    }

    protected void beforeSigning(CmsSignerInfo cmsSignerInfo) throws DsInvalidParamException, DsInvalidOperationException, DsAlgorithmException, CertificateException {
    }

    protected void afterSigning(CmsSignerInfo cmsSignerInfo) throws DsInvalidOperationException, DsTspException, DsDataCorruptedException, DsAlgorithmException, IOException {
    }

    protected int afterVerificationSuccess(CmsSignerInfo cmsSignerInfo) throws DsInvalidParamException {
        return 0;
    }

    protected void beforeEncoding() {
    }

    int calcCmsVersion() {
        if (!this.contentTypeOid.equals("1.2.840.113549.1.7.1")) {
            return 3;
        }
        for (CmsSignerInfo cmsSignerInfo : this.signers) {
            if (cmsSignerInfo.info.getVersion() != 3) continue;
            return 3;
        }
        return 1;
    }

    void calcContentDigests() throws DsException {
        byte[] byArray;
        if ((this.stage & 1) == 0) {
            if (this.attachedData && (this.stage & 2) != 0) {
                this.update(this.content);
            } else {
                throw new DsInvalidOperationException();
            }
        }
        if ((byArray = Ddec.DerEncodeOid(this.contentTypeOid)) == null || byArray.length == 0) {
            throw new DsInvalidParamException();
        }
        for (int i2 = 0; i2 < this.signers.size(); ++i2) {
            SignerInfo signerInfo = this.signers.get((int)i2).info;
            if (signerInfo.hasSignature() || this.signers.get((int)i2).sgDigestIndex != i2) continue;
            byte[] byArray2 = signerInfo.privateKey.digestGet();
            if (byArray2.length > 64) {
                throw new DsInvalidParamException();
            }
            byte[] byArray3 = new byte[byArray2.length + 2];
            byArray3[0] = 4;
            byArray3[1] = (byte)byArray2.length;
            System.arraycopy(byArray2, 0, byArray3, 2, byArray2.length);
            for (CmsSignerInfo cmsSignerInfo : this.signers) {
                if (cmsSignerInfo.sgDigestIndex != i2) continue;
                cmsSignerInfo.info.addSignedAttribute("1.2.840.113549.1.9.3", byArray, byArray.length);
                cmsSignerInfo.info.addSignedAttribute("1.2.840.113549.1.9.4", byArray3, 2 + byArray2.length);
                cmsSignerInfo.sgDigestIndex = -1;
            }
        }
        this.stage |= 2;
        this.stage &= 0xFFFFFFFE;
    }

    boolean digestAlgIsEqual(String string, byte[] byArray, String string2, byte[] byArray2) {
        byte[] byArray3 = new byte[]{5, 0};
        if (string.equals(string2)) {
            int n2;
            if (byArray == null) {
                byArray = byArray3;
            }
            if (byArray2 == null) {
                byArray2 = byArray3;
            }
            if (byArray == byArray2) {
                return true;
            }
            int n3 = Ddec.DerGetTotalSize(byArray);
            if (n3 != (n2 = Ddec.DerGetTotalSize(byArray2))) {
                return false;
            }
            if (new Pointer(byArray).CompareTo(byArray2)) {
                return true;
            }
        }
        return false;
    }

    boolean digestAlgIsEqual(SignerInfo signerInfo, SignerInfo signerInfo2) {
        return this.digestAlgIsEqual(signerInfo.getDigestOid(), signerInfo.getDigestParams(), signerInfo2.getDigestOid(), signerInfo2.getDigestParams());
    }

    void encodeDigestList(DerEncoder derEncoder) {
        derEncoder.SetBegin();
        for (int i2 = 0; i2 < this.signers.size(); ++i2) {
            boolean bl = true;
            for (int i3 = 0; i3 < i2; ++i3) {
                if (!this.digestAlgIsEqual(this.signers.get((int)i2).info, this.signers.get((int)i3).info)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            SignerInfo signerInfo = this.signers.get((int)i2).info;
            derEncoder.SeqBegin();
            derEncoder.addOid(signerInfo.getDigestOid());
            derEncoder.addDerParams(signerInfo.getDigestParams());
            derEncoder.SeqEnd();
        }
        derEncoder.SetEnd();
    }

    byte[] findLocalCertificate(int n2, byte[] byArray) throws CertificateException {
        for (Certificate certificate : this.certificates) {
            Object object;
            if (n2 == 0) {
                try {
                    object = Ddec.DerGetElementPtr(byArray, "Ssi");
                }
                catch (DdecException ddecException) {
                    continue;
                }
                byte[] byArray2 = certificate.getSerial();
                if (!((Pointer)object.first).CompareTo(byArray2)) continue;
                try {
                    object = Ddec.DerGetElementPtr(byArray, "Ss");
                }
                catch (DdecException ddecException) {
                    ddecException.printStackTrace();
                }
                byte[] byArray3 = certificate.getIssuerDN();
                if (!((Pointer)object.first).CompareTo(byArray3)) {
                    continue;
                }
            } else {
                try {
                    object = certificate.getSubjectKeyIdentifier();
                    if (!new Pointer(byArray).CompareTo((byte[])object)) {
                    }
                }
                catch (Exception exception) {}
                continue;
            }
            return certificate.getEncoded();
        }
        return null;
    }

    boolean isCertIdMatch(CryptoAlgorithmFactory cryptoAlgorithmFactory, SignerInfo signerInfo, byte[] byArray) throws DsInvalidParamException, DsDataNotFoundException, DsDataCorruptedException, DsAlgorithmException, CertificateException {
        Two<Pointer, Integer> two;
        String string;
        byte[] byArray2;
        if (signerInfo.isSignedAttributePresent("1.2.840.113549.1.9.16.2.47")) {
            byArray2 = signerInfo.getSignedAttribute("1.2.840.113549.1.9.16.2.47");
            try {
                string = Ddec.DerGetElementOid(byArray2, "SSSSD");
            }
            catch (DdecException ddecException) {
                string = "2.16.840.1.101.3.4.2.1";
            }
        } else if (signerInfo.isSignedAttributePresent("1.2.840.113549.1.9.16.2.12")) {
            byArray2 = signerInfo.getSignedAttribute("1.2.840.113549.1.9.16.2.12");
            string = "1.3.14.3.2.26";
        } else {
            return true;
        }
        try {
            two = Ddec.DerGetElementPtr(byArray2, "SSSosQ");
        }
        catch (DdecException ddecException) {
            throw new DsDataCorruptedException();
        }
        if ((Integer)two.second != 0) {
            MessageDigestAlg messageDigestAlg = cryptoAlgorithmFactory.getDigestAlg(string, null, null);
            if (messageDigestAlg == null) {
                throw new DsAlgorithmException();
            }
            messageDigestAlg.update(byArray);
            byte[] byArray3 = messageDigestAlg.getDigest();
            return ((Pointer)two.first).CompareTo(byArray3);
        }
        try {
            two = Ddec.DerGetElementPtr(byArray2, "SSSosqSSE4s");
        }
        catch (DdecException ddecException) {
            return false;
        }
        Certificate certificate = new Certificate(byArray);
        byte[] byArray4 = certificate.getIssuerDN();
        if (!((Pointer)two.first).CompareTo(byArray4)) {
            return false;
        }
        try {
            two = Ddec.DerGetElementPtr(byArray2, "SSSosqSsi");
        }
        catch (DdecException ddecException) {
            return false;
        }
        byArray4 = certificate.getSerial();
        return ((Pointer)two.first).CompareTo(byArray4);
    }

    protected class CmsSignerInfo {
        public SignerInfo info;
        public MessageDigestAlg digestAlg;
        public MessageVerifierAlg verifierAlg;
        public int sgDigestIndex;
        public int vfDigestIndex;
        public byte[] digest;
        public int digestSize;
        public long timestampTm;
        public int anyflags;
        public Object anyptr;

        protected CmsSignerInfo() {
        }
    }
}

