/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor.DsLib;

import java.util.ArrayList;
import java.util.Arrays;
import ua.avtor.DsLib.Algorithms.ContentEncryptionAlg;
import ua.avtor.DsLib.Algorithms.CryptoAlgorithmFactory;
import ua.avtor.DsLib.Algorithms.KeyWrapAlg;
import ua.avtor.DsLib.Certificate;
import ua.avtor.DsLib.CertificateException;
import ua.avtor.DsLib.Certificates.CertificateFinder;
import ua.avtor.DsLib.DsAlgorithmException;
import ua.avtor.DsLib.DsDataCorruptedException;
import ua.avtor.DsLib.DsDataNotFoundException;
import ua.avtor.DsLib.DsException;
import ua.avtor.DsLib.DsInvalidOperationException;
import ua.avtor.DsLib.DsInvalidParamException;
import ua.avtor.DsLib.PrivateKeys.PrivateKey;
import ua.avtor.DsLib.RecipientInfo;
import ua.avtor.DsLib.Utils.Ddec;
import ua.avtor.DsLib.Utils.DdecException;
import ua.avtor.DsLib.Utils.DerEncoder;
import ua.avtor.DsLib.Utils.Pointer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsEnveloped {
    final String OID_ENVELOPED_DATA = "1.2.840.113549.1.7.3";
    boolean hasEncoded;
    boolean defidByIssuerSN;
    boolean attachedData;
    String contentTypeOid;
    byte[] content = new byte[0];
    int contentEncryptedSize = 0;
    int contentPlaintextSize = 0;
    String contentEncAlgOid;
    byte[] contentEncAlgParams;
    ContentEncryptionAlg encryptionAlg;
    ArrayList<CmsRecipientInfo> recipients = new ArrayList();
    ArrayList<byte[]> unprotectedAttrs = new ArrayList();
    ArrayList<Certificate> certificates = new ArrayList();

    public CmsEnveloped(boolean bl) {
        this.hasEncoded = false;
        this.contentTypeOid = "1.2.840.113549.1.7.1";
        this.attachedData = bl;
        this.contentEncryptedSize = 0;
        this.encryptionAlg = null;
        this.contentEncAlgParams = null;
    }

    public CmsEnveloped(byte[] byArray) throws DsDataCorruptedException {
        this(byArray, null);
    }

    public CmsEnveloped(byte[] byArray, CertificateFinder certificateFinder) throws DsDataCorruptedException {
        this.hasEncoded = true;
        this.attachedData = false;
        this.contentEncryptedSize = 0;
        this.encryptionAlg = null;
        this.contentEncAlgParams = null;
        try {
            if (!Ddec.DerGetElementOid(byArray, "SD").equals("1.2.840.113549.1.7.3")) {
                throw new DsDataCorruptedException();
            }
        }
        catch (DdecException ddecException) {
            throw new DsDataCorruptedException();
        }
        try {
            this.contentTypeOid = Ddec.DerGetElementOid(byArray, "SdE0Sioe0uSD");
        }
        catch (DdecException ddecException) {
            throw new DsDataCorruptedException();
        }
        try {
            this.contentEncAlgOid = Ddec.DerGetElementOid(byArray, "SdE0Sioe0uSdSD");
        }
        catch (DdecException ddecException) {
            throw new DsDataCorruptedException();
        }
        try {
            this.contentEncAlgParams = Ddec.DerGetElementBuf(byArray, "SdE0Sioe0uSdSdx");
        }
        catch (DdecException ddecException) {
            // empty catch block
        }
        try {
            this.content = Ddec.DerGetElementBuf(byArray, "SdE0Sioe0uSdsY0");
            this.attachedData = true;
            this.contentEncryptedSize = this.content.length;
        }
        catch (DdecException ddecException) {
            // empty catch block
        }
        Ddec.DerSearchRec derSearchRec = Ddec.DerFindElementInit(byArray, "SdE0SiE0E0");
        while (Ddec.DerFindNextElement(derSearchRec) != null) {
            try {
                this.certificates.add(new Certificate(derSearchRec.der.Copy(derSearchRec.size)));
            }
            catch (DsException dsException) {
                throw new DsDataCorruptedException();
            }
        }
        derSearchRec = Ddec.DerFindFirstElement(byArray, "SdE0Sioe0U");
        while (derSearchRec != null) {
            CmsRecipientInfo cmsRecipientInfo = new CmsRecipientInfo();
            cmsRecipientInfo.info = new RecipientInfo(derSearchRec.der.Copy(derSearchRec.size), certificateFinder, this.certificates);
            this.recipients.add(cmsRecipientInfo);
            derSearchRec = Ddec.DerFindNextElement(derSearchRec);
        }
        derSearchRec = Ddec.DerFindFirstElement(byArray, "SdE0Sioe0uE1");
        while (derSearchRec != null) {
            this.unprotectedAttrs.add(derSearchRec.der.Copy(derSearchRec.size));
            derSearchRec = Ddec.DerFindNextElement(derSearchRec);
        }
    }

    public final void setContentType(String string) {
        this.contentTypeOid = string;
    }

    public final void setContentEncryptionAlg(String string, byte[] byArray) {
        this.contentEncAlgOid = string;
        this.contentEncAlgParams = null;
        if (byArray != null) {
            this.contentEncAlgParams = (byte[])byArray.clone();
        }
    }

    public final void setIdentificationByIssuerSN(boolean bl) {
        this.defidByIssuerSN = bl;
    }

    public final void addRecipient(byte[] byArray, int n2) throws DsInvalidOperationException, CertificateException {
        if (this.hasEncoded) {
            throw new DsInvalidOperationException();
        }
        RecipientInfo recipientInfo = new RecipientInfo(byArray, n2);
        recipientInfo.setPreferIdIssuerSN(this.defidByIssuerSN);
        CmsRecipientInfo cmsRecipientInfo = new CmsRecipientInfo();
        cmsRecipientInfo.info = recipientInfo;
        cmsRecipientInfo.encSchema = n2;
        this.recipients.add(cmsRecipientInfo);
    }

    public final void update(byte[] byArray) throws DsInvalidOperationException {
        this.update(byArray, 0, byArray.length);
    }

    public final void update(byte[] byArray, int n2, int n3) throws DsInvalidOperationException {
        if (!this.attachedData || this.hasEncoded) {
            throw new DsInvalidOperationException();
        }
        byte[] byArray2 = new byte[this.contentPlaintextSize + n3 + 64];
        System.arraycopy(this.content, 0, byArray2, 0, this.contentPlaintextSize);
        this.content = byArray2;
        System.arraycopy(byArray, n2, this.content, this.contentPlaintextSize, n3);
        this.contentPlaintextSize += n3;
    }

    public final boolean isContentAttached() {
        return this.attachedData;
    }

    public final int getRecipientCount() {
        return this.recipients.size();
    }

    public final RecipientInfo getRecipient(int n2) {
        if (n2 >= this.recipients.size()) {
            return null;
        }
        return this.recipients.get((int)n2).info;
    }

    public final int getRecipientIndex(byte[] byArray) throws CertificateException {
        Certificate certificate = new Certificate(byArray);
        int n2 = this.getRecipientCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                RecipientInfo recipientInfo = this.getRecipient(i2);
                byte[] byArray2 = recipientInfo.getRecipientIdentifier();
                if (!certificate.isMyIdentifier(byArray2)) continue;
                return i2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    public final void addUnprotectedAttribute(String string, byte[] byArray) {
        DerEncoder derEncoder = new DerEncoder();
        derEncoder.SeqBegin();
        derEncoder.addOid(string);
        derEncoder.SetBegin();
        derEncoder.addObject(byArray);
        derEncoder.SetEnd();
        derEncoder.SeqEnd();
        this.unprotectedAttrs.add(derEncoder.getEncoded());
    }

    public final boolean isUnprotectedAttributePresent(String string) throws DsInvalidParamException {
        try {
            this.getUnprotectedAttribute(string);
        }
        catch (DsDataNotFoundException dsDataNotFoundException) {
            return false;
        }
        return true;
    }

    public final byte[] getUnprotectedAttribute(String string) throws DsDataNotFoundException, DsInvalidParamException {
        return this.getEncodedAttribute(this.unprotectedAttrs, string);
    }

    public final byte[] getEncoded(CryptoAlgorithmFactory cryptoAlgorithmFactory) throws DsAlgorithmException, DsInvalidOperationException, CertificateException {
        ContentEncryptionAlg contentEncryptionAlg;
        if (this.contentEncAlgOid == null || this.contentEncAlgOid.isEmpty()) {
            this.choiceContentEncAlg();
        }
        if ((contentEncryptionAlg = cryptoAlgorithmFactory.getEncryptionAlg(this.contentEncAlgOid, this.contentEncAlgParams, null)) == null) {
            throw new DsAlgorithmException();
        }
        DerEncoder derEncoder = new DerEncoder();
        derEncoder.SeqBegin();
        derEncoder.addOid("1.2.840.113549.1.7.3");
        derEncoder.SpecificBegin((byte)-96);
        derEncoder.SeqBegin();
        derEncoder.addInteger(this.calcCmsVersion());
        this.encodeOriginatorInfo(derEncoder);
        derEncoder.SetBegin();
        for (CmsRecipientInfo object : this.recipients) {
            RecipientInfo recipientInfo = object.info;
            KeyWrapAlg keyWrapAlg = cryptoAlgorithmFactory.getWrapAlg(object.encSchema, recipientInfo.getCertificate());
            if (keyWrapAlg == null) {
                throw new DsAlgorithmException();
            }
            boolean bl = keyWrapAlg.wrap(contentEncryptionAlg.getKeyOctets());
            if (!bl) {
                throw new DsAlgorithmException();
            }
            byte[] byArray = recipientInfo.getEncoded(keyWrapAlg);
            derEncoder.addObject(byArray);
        }
        derEncoder.SetEnd();
        derEncoder.SeqBegin();
        derEncoder.addOid(this.contentTypeOid);
        derEncoder.SeqBegin();
        derEncoder.addOid(contentEncryptionAlg.getOid());
        derEncoder.addDerParams(contentEncryptionAlg.getParams());
        derEncoder.SeqEnd();
        if (this.attachedData) {
            int n2 = contentEncryptionAlg.encryptFinal(this.content, 0, this.contentPlaintextSize);
            derEncoder.addSpecific((byte)-128, this.content, n2);
            this.contentEncryptedSize = n2;
        } else {
            this.encryptionAlg = contentEncryptionAlg;
        }
        derEncoder.SeqEnd();
        if (!this.unprotectedAttrs.isEmpty()) {
            derEncoder.SpecificBegin((byte)-95);
            for (byte[] byArray : this.unprotectedAttrs) {
                derEncoder.addObject(byArray);
            }
            derEncoder.SpecificEnd();
        }
        derEncoder.SeqEnd();
        derEncoder.SpecificEnd();
        derEncoder.SeqEnd();
        this.hasEncoded = true;
        return derEncoder.getEncoded();
    }

    public final ContentEncryptionAlg newContentEncryptor() throws DsInvalidOperationException {
        if (this.encryptionAlg == null) {
            throw new DsInvalidOperationException();
        }
        ContentEncryptionAlg contentEncryptionAlg = this.encryptionAlg;
        this.encryptionAlg = null;
        return contentEncryptionAlg;
    }

    public final byte[] decrypt(int n2, PrivateKey privateKey, CryptoAlgorithmFactory cryptoAlgorithmFactory) throws DsException {
        byte[] byArray;
        if (!this.attachedData || !this.hasEncoded) {
            throw new DsInvalidOperationException();
        }
        ContentEncryptionAlg contentEncryptionAlg = this.newContentDecryptor(n2, privateKey, cryptoAlgorithmFactory);
        int n3 = contentEncryptionAlg.decryptFinal(byArray = (byte[])this.content.clone(), 0, this.contentEncryptedSize);
        if (this.contentEncryptedSize == n3) {
            return byArray;
        }
        return new Pointer(byArray).Copy(n3);
    }

    public final ContentEncryptionAlg newContentDecryptor(int n2, PrivateKey privateKey, CryptoAlgorithmFactory cryptoAlgorithmFactory) throws DsException {
        RecipientInfo recipientInfo = this.getRecipient(n2);
        if (recipientInfo == null) {
            throw new DsInvalidParamException();
        }
        byte[] byArray = recipientInfo.decryptSessionKey(privateKey);
        ContentEncryptionAlg contentEncryptionAlg = cryptoAlgorithmFactory.getEncryptionAlg(this.contentEncAlgOid, this.contentEncAlgParams, byArray);
        Arrays.fill(byArray, (byte)0);
        return contentEncryptionAlg;
    }

    protected void encodeOriginatorInfo(DerEncoder derEncoder) {
    }

    int calcCmsVersion() {
        return 2;
    }

    void choiceContentEncAlg() {
        this.contentEncAlgOid = "1.2.804.2.1.1.1.1.1.1.2";
        this.contentEncAlgParams = null;
    }

    byte[] getEncodedAttribute(ArrayList<byte[]> arrayList, String string) throws DsDataNotFoundException, DsInvalidParamException {
        byte[] byArray = Ddec.DerEncodeOid(string);
        if (byArray == null) {
            throw new DsInvalidParamException();
        }
        for (byte[] byArray2 : arrayList) {
            byte[] byArray3;
            try {
                byArray3 = Ddec.DerGetElementBuf(byArray2, "Sd");
            }
            catch (DdecException ddecException) {
                continue;
            }
            if (!new Pointer(byArray).CompareTo(byArray3)) continue;
            try {
                return Ddec.DerGetElementBuf(byArray2, "SdUx");
            }
            catch (DdecException ddecException) {
            }
        }
        throw new DsDataNotFoundException();
    }

    class CmsRecipientInfo {
        public RecipientInfo info;
        public int encSchema;

        CmsRecipientInfo() {
        }
    }
}

