/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor.DsLib;

import java.io.IOException;
import ua.avtor.DsLib.Algorithms.CryptoAlgorithmFactory;
import ua.avtor.DsLib.Algorithms.MessageDigestAlg;
import ua.avtor.DsLib.CertRevocationList;
import ua.avtor.DsLib.Certificate;
import ua.avtor.DsLib.CertificateException;
import ua.avtor.DsLib.Certificates.CertificateFinder;
import ua.avtor.DsLib.Certificates.CertificatePathValidator;
import ua.avtor.DsLib.Certificates.CertificateValidationPolicy;
import ua.avtor.DsLib.Certificates.CertificateValidatorCache;
import ua.avtor.DsLib.Certificates.CertstoreCms;
import ua.avtor.DsLib.CmsSigned;
import ua.avtor.DsLib.DsAlgorithmException;
import ua.avtor.DsLib.DsDataCorruptedException;
import ua.avtor.DsLib.DsDataNotFoundException;
import ua.avtor.DsLib.DsException;
import ua.avtor.DsLib.DsInvalidOperationException;
import ua.avtor.DsLib.DsInvalidParamException;
import ua.avtor.DsLib.DsTspException;
import ua.avtor.DsLib.OcspResponse;
import ua.avtor.DsLib.PrivateKeys.PrivateKey;
import ua.avtor.DsLib.SignaturePolicy;
import ua.avtor.DsLib.SignerInfo;
import ua.avtor.DsLib.TimeStampRequest;
import ua.avtor.DsLib.TimeStampResponse;
import ua.avtor.DsLib.Transport.UriTransport;
import ua.avtor.DsLib.Utils.DerEncoder;
import ua.avtor.DsLib.Utils.Three;
import ua.avtor.DsLib.Utils.Two;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsAdvanced
extends CmsSigned {
    protected UriTransport timestampTransport = null;
    protected String timestampUri;
    protected boolean wantTspCert = true;
    protected boolean addESSsgCertDNSN = true;
    protected boolean convertingTsu = true;
    protected boolean tsuValidationSelftimed = false;
    protected boolean preferOcspCAdES = false;
    CryptoAlgorithmFactory advAlgs;
    byte[] encodedSgPolicy;
    boolean attachSigningTime = false;

    public CmsAdvanced(boolean bl, CryptoAlgorithmFactory cryptoAlgorithmFactory) {
        super(bl);
        this.advAlgs = cryptoAlgorithmFactory;
    }

    public CmsAdvanced(byte[] byArray, CryptoAlgorithmFactory cryptoAlgorithmFactory) throws DsDataCorruptedException, CertificateException {
        super(byArray);
        this.advAlgs = cryptoAlgorithmFactory;
    }

    public void verifyBegin(CertificateFinder certificateFinder) throws DsDataCorruptedException, DsDataNotFoundException, DsInvalidParamException, DsInvalidOperationException, DsAlgorithmException, CertificateException {
        super.verifyBegin(this.advAlgs, certificateFinder);
    }

    @Override
    public SignerInfo addSigner(byte[] byArray, PrivateKey privateKey) throws CertificateException {
        SignerInfo signerInfo = super.addSigner(byArray, privateKey);
        this.addCertificate(byArray);
        return signerInfo;
    }

    public void setSignaturePolicy(byte[] byArray) {
        this.encodedSgPolicy = byArray;
    }

    public void setSignaturePolicyUri(String string, String string2) {
        SignaturePolicy signaturePolicy = new SignaturePolicy(string, string2);
        this.setSignaturePolicy(signaturePolicy.getEncoded());
    }

    public byte[] getSignaturePolicy(int n2) throws DsDataNotFoundException, DsInvalidParamException {
        SignerInfo signerInfo = this.getSigner(n2);
        if (signerInfo == null) {
            throw new DsDataNotFoundException();
        }
        if (signerInfo.isSignedAttributePresent("1.2.840.113549.1.9.16.2.15")) {
            return signerInfo.getSignedAttribute("1.2.840.113549.1.9.16.2.15");
        }
        return null;
    }

    public void mustAttachSigningTime(boolean bl) {
        this.attachSigningTime = bl;
    }

    public void setSignatureTimeStampServer(UriTransport uriTransport, String string) {
        this.timestampTransport = uriTransport;
        if (string != null) {
            this.timestampUri = string;
        }
    }

    public void ensureTimeStamped() throws DsException, IOException {
        this.ensureSigned();
        for (int i2 = 0; i2 < this.getSignerCount(); ++i2) {
            SignerInfo signerInfo = this.getSigner(i2);
            if (signerInfo.isUnsignedAttributePresent("1.2.840.113549.1.9.16.2.14")) continue;
            this.addSignatureTimeStamp(signerInfo);
        }
    }

    public long getStampingTime(int n2) throws DsDataNotFoundException, DsInvalidOperationException {
        SignerInfo signerInfo = this.getSigner(n2);
        if (signerInfo == null) {
            throw new DsDataNotFoundException();
        }
        long l2 = ((CmsSigned.CmsSignerInfo)this.signers.get((int)n2)).timestampTm;
        if (l2 == 0L) {
            throw new DsInvalidOperationException();
        }
        return l2;
    }

    public Three<Boolean, Long, Integer> validateTimeStamp(int n2, CertificateValidatorCache certificateValidatorCache, CertificateValidationPolicy certificateValidationPolicy) throws DsException {
        Three<Certificate, Long, Integer> three = this.verifyTimeStamp(n2, certificateValidatorCache);
        Certificate certificate = (Certificate)three.first;
        if (certificate == null) {
            return new Three<Boolean, Long, Integer>(false, (Long)three.second, (Integer)three.third);
        }
        CertificatePathValidator certificatePathValidator = new CertificatePathValidator(this.advAlgs, certificateValidatorCache);
        if (certificatePathValidator.validate(certificate, "1.3.6.1.5.5.7.3.8", 0L, certificateValidationPolicy) != 0) {
            return new Three<Boolean, Long, Integer>(false, (Long)three.second, (Integer)three.third);
        }
        ((CmsSigned.CmsSignerInfo)this.signers.get((int)n2)).timestampTm = (Long)three.second;
        return new Three<Boolean, Long, Integer>(true, (Long)three.second, (Integer)three.third);
    }

    public Two<Boolean, Integer> validateSignerAtStampingTime(int n2, boolean bl, String string, CertificateValidatorCache certificateValidatorCache, CertificateValidationPolicy certificateValidationPolicy) throws DsException {
        int n3;
        Object object;
        SignerInfo signerInfo = this.getSigner(n2);
        if (signerInfo == null) {
            throw new DsDataNotFoundException();
        }
        long l2 = ((CmsSigned.CmsSignerInfo)this.signers.get((int)n2)).timestampTm;
        if (l2 == 0L) {
            if (signerInfo.isUnsignedAttributePresent("1.2.840.113549.1.9.16.2.14")) {
                object = this.validateTimeStamp(n2, certificateValidatorCache, certificateValidationPolicy);
                l2 = (Long)((Three)object).second;
                n3 = (Integer)((Three)object).third;
                if (!((Boolean)((Three)object).first).booleanValue()) {
                    return new Two<Boolean, Integer>(false, n3);
                }
            } else {
                if (bl) {
                    throw new DsDataNotFoundException();
                }
                l2 = System.currentTimeMillis();
            }
        }
        object = new CertificatePathValidator(this.advAlgs, certificateValidatorCache);
        CertstoreCms certstoreCms = new CertstoreCms(this);
        n3 = ((CertificatePathValidator)object).validate(signerInfo.getCertificate(), string, l2, certificateValidationPolicy, certstoreCms);
        return new Two<Boolean, Integer>(n3 == 0, n3);
    }

    public Two<Boolean, Integer> validateAllAtStampingTime(boolean bl, String string, CertificateValidatorCache certificateValidatorCache, CertificateValidationPolicy certificateValidationPolicy) throws DsException {
        if (this.getSignerCount() < 1) {
            throw new DsDataNotFoundException();
        }
        int n2 = 0;
        for (int i2 = 0; i2 < this.getSignerCount(); ++i2) {
            Two<Boolean, Integer> two = this.validateSignerAtStampingTime(i2, bl, string, certificateValidatorCache, certificateValidationPolicy);
            boolean bl2 = (Boolean)two.first;
            n2 = (Integer)two.second;
            if (bl2) continue;
            return new Two<Boolean, Integer>(false, n2);
        }
        return new Two<Boolean, Integer>(true, n2);
    }

    public Two<Boolean, Integer> validateSignerCAdES_C(int n2, String string, CertificateValidatorCache certificateValidatorCache, CertificateValidationPolicy certificateValidationPolicy) throws DsException {
        boolean bl;
        SignerInfo signerInfo = this.getSigner(n2);
        if (signerInfo == null) {
            throw new DsDataNotFoundException();
        }
        if (signerInfo.getCertificate() == null) {
            throw new DsInvalidOperationException();
        }
        if (!signerInfo.isUnsignedAttributePresent("1.2.840.113549.1.9.16.2.14")) {
            throw new DsDataNotFoundException();
        }
        Three<Certificate, Long, Integer> three = this.verifyTimeStamp(n2, certificateValidatorCache);
        Certificate certificate = (Certificate)three.first;
        long l2 = (Long)three.second;
        int n3 = (Integer)three.third;
        if (certificate == null) {
            return new Two<Boolean, Integer>(false, n3);
        }
        byte[] byArray = signerInfo.getUnsignedAttribute("1.2.840.113549.1.9.16.2.14");
        CmsAdvanced cmsAdvanced = new CmsAdvanced(byArray, this.advAlgs);
        SignerInfo signerInfo2 = cmsAdvanced.getSigner(0);
        if (signerInfo2.isUnsignedAttributePresent("1.2.840.113549.1.9.16.2.21")) {
            long l3 = 0L;
            if (this.tsuValidationSelftimed) {
                l3 = l2;
            }
            bl = (n3 = this.validateCertCAdEStp(certificate, certificateValidatorCache, signerInfo2, "1.3.6.1.5.5.7.3.8", l3, certificateValidationPolicy)) == 0;
        } else {
            CertificatePathValidator certificatePathValidator = new CertificatePathValidator(this.advAlgs, certificateValidatorCache);
            n3 = certificatePathValidator.validate(certificate, "1.3.6.1.5.5.7.3.8", 0L, certificateValidationPolicy);
            boolean bl2 = bl = n3 == 0;
        }
        if (!bl) {
            return new Two<Boolean, Integer>(false, n3);
        }
        ((CmsSigned.CmsSignerInfo)this.signers.get((int)n2)).timestampTm = l2;
        n3 = this.validateCertCAdEStp(signerInfo.getCertificate(), certificateValidatorCache, signerInfo, string, l2, certificateValidationPolicy);
        bl = n3 == 0;
        return new Two<Boolean, Integer>(bl, n3);
    }

    public Two<Boolean, Integer> validateAllCAdES_C(String string, CertificateValidatorCache certificateValidatorCache, CertificateValidationPolicy certificateValidationPolicy) throws DsException {
        if (this.getSignerCount() < 1) {
            throw new DsDataNotFoundException();
        }
        int n2 = 0;
        for (int i2 = 0; i2 < this.getSignerCount(); ++i2) {
            Two<Boolean, Integer> two = this.validateSignerCAdES_C(i2, string, certificateValidatorCache, certificateValidationPolicy);
            if (!((Boolean)two.first).booleanValue()) {
                return two;
            }
            n2 = (Integer)two.second;
        }
        return new Two<Boolean, Integer>(true, n2);
    }

    public void convertToCAdES_C(CertificateValidatorCache certificateValidatorCache, CertificateValidationPolicy certificateValidationPolicy) throws DsException, IOException {
        this.convertToCAdEStp(certificateValidatorCache, certificateValidationPolicy, false);
    }

    public void convertToCAdES_X(CertificateValidatorCache certificateValidatorCache, CertificateValidationPolicy certificateValidationPolicy) throws DsException, IOException {
        this.convertToCAdEStp(certificateValidatorCache, certificateValidationPolicy, true);
    }

    @Override
    protected void beforeSigning(CmsSigned.CmsSignerInfo cmsSignerInfo) throws DsInvalidParamException, DsInvalidOperationException, DsAlgorithmException, CertificateException {
        SignerInfo signerInfo = cmsSignerInfo.info;
        this.addSigningCertificateId(signerInfo);
        if (this.encodedSgPolicy != null) {
            signerInfo.addSignedAttribute("1.2.840.113549.1.9.16.2.15", this.encodedSgPolicy, this.encodedSgPolicy.length);
        }
        if (this.attachSigningTime) {
            DerEncoder derEncoder = new DerEncoder();
            derEncoder.addTime(System.currentTimeMillis());
            signerInfo.addSignedAttribute("1.2.840.113549.1.9.5", derEncoder.getEncoded(), derEncoder.getSize());
        }
    }

    @Override
    protected void afterSigning(CmsSigned.CmsSignerInfo cmsSignerInfo) throws DsInvalidOperationException, DsTspException, DsDataCorruptedException, DsAlgorithmException, IOException {
        SignerInfo signerInfo = cmsSignerInfo.info;
        if (this.timestampTransport != null) {
            this.addSignatureTimeStamp(signerInfo);
        }
    }

    @Override
    protected int afterVerificationSuccess(CmsSigned.CmsSignerInfo cmsSignerInfo) throws DsInvalidParamException {
        if (!cmsSignerInfo.info.isSignedAttributePresent("1.2.840.113549.1.9.16.2.47") && !cmsSignerInfo.info.isSignedAttributePresent("1.2.840.113549.1.9.16.2.12")) {
            return 6;
        }
        return super.afterVerificationSuccess(cmsSignerInfo);
    }

    protected long addSignatureTimeStamp(SignerInfo signerInfo) throws DsInvalidOperationException, DsAlgorithmException, DsDataCorruptedException, DsTspException, IOException {
        if (this.timestampTransport == null) {
            throw new DsInvalidOperationException();
        }
        TimeStampRequest timeStampRequest = new TimeStampRequest(signerInfo.getDigestOid(), signerInfo.getDigestParams(), this.advAlgs);
        timeStampRequest.reqCertificate(this.wantTspCert);
        byte[] byArray = signerInfo.getSignature();
        timeStampRequest.update(byArray);
        byte[] byArray2 = timeStampRequest.getEncoded();
        byArray = this.timestampTransport.post(this.timestampUri, byArray2, "application/timestamp-query", null);
        TimeStampResponse timeStampResponse = new TimeStampResponse(byArray);
        if (timeStampResponse.getStatus() != 0) {
            throw new DsTspException(timeStampResponse.getStatus());
        }
        if (!timeStampResponse.compareWithRequest(byArray2)) {
            throw new DsTspException(2);
        }
        long l2 = timeStampResponse.getGenerationTime();
        byte[] byArray3 = timeStampResponse.getCms();
        signerInfo.addUnsignedAttribute("1.2.840.113549.1.9.16.2.14", byArray3, byArray3.length);
        return l2;
    }

    protected Three<Certificate, Long, Integer> verifyTimeStamp(int n2, CertificateValidatorCache certificateValidatorCache) throws DsException {
        int n3 = 5;
        long l2 = 0L;
        SignerInfo signerInfo = this.getSigner(n2);
        if (signerInfo == null) {
            throw new DsDataNotFoundException();
        }
        if (!signerInfo.isUnsignedAttributePresent("1.2.840.113549.1.9.16.2.14")) {
            throw new DsDataNotFoundException();
        }
        byte[] byArray = signerInfo.getUnsignedAttribute("1.2.840.113549.1.9.16.2.14");
        TimeStampResponse timeStampResponse = new TimeStampResponse(byArray);
        timeStampResponse.compareWithDocBegin(null, this.advAlgs);
        timeStampResponse.compareWithDocUpdate(signerInfo.getSignature());
        boolean bl = timeStampResponse.compareWithDocFinal();
        if (!bl) {
            n3 = 5;
            return new Three<Object, Long, Integer>(null, l2, n3);
        }
        CmsSigned cmsSigned = new CmsSigned(timeStampResponse.getCms());
        cmsSigned.verifyBegin(this.advAlgs, certificateValidatorCache.getCertificateFinder());
        bl = cmsSigned.verifyAll();
        if (!bl) {
            n3 = cmsSigned.getSigner(0).getVerificationStatus();
            return new Three<Object, Long, Integer>(null, l2, n3);
        }
        Certificate certificate = cmsSigned.getSigner(0).getCertificate();
        if (!certificate.isEkuPresent("1.3.6.1.5.5.7.3.8")) {
            n3 = -12;
            return new Three<Object, Long, Integer>(null, l2, n3);
        }
        l2 = timeStampResponse.getGenerationTime();
        return new Three<Certificate, Long, Integer>(certificate.clone(), l2, n3);
    }

    void addSigningCertificateId(SignerInfo signerInfo) throws DsAlgorithmException, CertificateException, DsInvalidParamException, DsInvalidOperationException {
        String string = signerInfo.getDigestOid();
        boolean bl = !string.equals("1.3.14.3.2.26");
        byte[] byArray = signerInfo.getCertificate().getEncoded();
        MessageDigestAlg messageDigestAlg = this.advAlgs.getDigestAlg(string, null, null);
        if (messageDigestAlg == null) {
            throw new DsAlgorithmException();
        }
        messageDigestAlg.update(byArray);
        byte[] byArray2 = messageDigestAlg.getDigest();
        DerEncoder derEncoder = new DerEncoder();
        derEncoder.SeqBegin();
        derEncoder.SeqBegin();
        derEncoder.SeqBegin();
        if (bl) {
            derEncoder.SeqBegin();
            derEncoder.addOid(signerInfo.privateKey.getDigestOid());
            if (signerInfo.getDigestParams() != null) {
                derEncoder.addDerParams(signerInfo.privateKey.getDigestParams());
            }
            derEncoder.SeqEnd();
        }
        derEncoder.addOctets(byArray2);
        if (this.addESSsgCertDNSN) {
            derEncoder.SeqBegin();
            derEncoder.SeqBegin();
            derEncoder.SpecificBegin((byte)-92);
            derEncoder.addObject(signerInfo.getCertificate().getIssuerDN());
            derEncoder.SpecificEnd();
            derEncoder.SeqEnd();
            derEncoder.addObject(signerInfo.getCertificate().getSerial());
            derEncoder.SeqEnd();
        }
        derEncoder.SeqEnd();
        derEncoder.SeqEnd();
        derEncoder.SeqEnd();
        String string2 = "1.2.840.113549.1.9.16.2.12";
        if (bl) {
            string2 = "1.2.840.113549.1.9.16.2.47";
        }
        signerInfo.addSignedAttribute(string2, derEncoder.getEncoded(), derEncoder.getSize());
    }

    void convertToCAdEStp(CertificateValidatorCache certificateValidatorCache, CertificateValidationPolicy certificateValidationPolicy, boolean bl) throws DsException, IOException {
        int n2;
        Object object;
        this.ensureSigned();
        for (int i2 = 0; i2 < this.getSignerCount(); ++i2) {
            object = this.getSigner(i2);
            if (((SignerInfo)object).getCertificate() == null) {
                throw new DsInvalidOperationException();
            }
            if (((SignerInfo)object).isUnsignedAttributePresent("1.2.840.113549.1.9.16.2.14")) continue;
            throw new DsInvalidOperationException();
        }
        CertificatePathValidator certificatePathValidator = new CertificatePathValidator(this.advAlgs, certificateValidatorCache, this.preferOcspCAdES);
        object = new CollectReferencePolicy(certificateValidationPolicy, this.advAlgs);
        for (n2 = 0; n2 < this.getSignerCount(); ++n2) {
            byte[] byArray;
            Object object2;
            SignerInfo signerInfo = this.getSigner(n2);
            Three<Boolean, Long, Integer> three = this.validateTimeStamp(n2, certificateValidatorCache, (CertificateValidationPolicy)object);
            boolean bl2 = (Boolean)three.first;
            long l2 = (Long)three.second;
            if (!bl2) {
                throw new DsDataCorruptedException();
            }
            if (this.convertingTsu) {
                object2 = signerInfo.getUnsignedAttribute("1.2.840.113549.1.9.16.2.14");
                CmsSigned cmsSigned = new CmsSigned((byte[])object2);
                SignerInfo signerInfo2 = cmsSigned.getSigner(0);
                cmsSigned.removeCertificates();
                cmsSigned.addCertificate(((CollectReferencePolicy)object).certs[0].getEncoded());
                byArray = ((CollectReferencePolicy)object).getEncodedCertsC(signerInfo2.getDigestOid());
                signerInfo2.setUnsignedAttribute("1.2.840.113549.1.9.16.2.21", byArray, byArray.length);
                byArray = ((CollectReferencePolicy)object).getEncodedCrlsC(signerInfo2.getDigestOid());
                signerInfo2.setUnsignedAttribute("1.2.840.113549.1.9.16.2.22", byArray, byArray.length);
                if (bl) {
                    byArray = ((CollectReferencePolicy)object).getEncodedCertsX();
                    signerInfo2.setUnsignedAttribute("1.2.840.113549.1.9.16.2.23", byArray, byArray.length);
                    byArray = ((CollectReferencePolicy)object).getEncodedCrlsX();
                    signerInfo2.setUnsignedAttribute("1.2.840.113549.1.9.16.2.24", byArray, byArray.length);
                }
                object2 = cmsSigned.getEncoded();
                signerInfo.setUnsignedAttribute("1.2.840.113549.1.9.16.2.14", (byte[])object2, ((byte[])object2).length);
            }
            object2 = new CertstoreCms(this);
            boolean bl3 = bl2 = certificatePathValidator.validate(signerInfo.getCertificate(), "any", l2, (CertificateValidationPolicy)object, (CertificateFinder)object2) == 0;
            if (!bl2) {
                throw new DsDataCorruptedException();
            }
            byArray = ((CollectReferencePolicy)object).getEncodedCertsC(signerInfo.getDigestOid());
            signerInfo.setUnsignedAttribute("1.2.840.113549.1.9.16.2.21", byArray, byArray.length);
            byArray = ((CollectReferencePolicy)object).getEncodedCrlsC(signerInfo.getDigestOid());
            signerInfo.setUnsignedAttribute("1.2.840.113549.1.9.16.2.22", byArray, byArray.length);
            if (!bl) continue;
            byArray = ((CollectReferencePolicy)object).getEncodedCertsX();
            signerInfo.setUnsignedAttribute("1.2.840.113549.1.9.16.2.23", byArray, byArray.length);
            byArray = ((CollectReferencePolicy)object).getEncodedCrlsX();
            signerInfo.setUnsignedAttribute("1.2.840.113549.1.9.16.2.24", byArray, byArray.length);
        }
        this.removeCertificates();
        for (n2 = 0; n2 < this.getSignerCount(); ++n2) {
            byte[] byArray = this.getSigner(n2).getCertificate().getEncoded();
            this.addCertificate(byArray);
        }
    }

    int validateCertCAdEStp(Certificate certificate, CertificateValidatorCache certificateValidatorCache, SignerInfo signerInfo, String string, long l2, CertificateValidationPolicy certificateValidationPolicy) throws DsDataCorruptedException, DsDataNotFoundException, DsInvalidOperationException, CertificateException, DsAlgorithmException, DsInvalidParamException {
        byte[] byArray = signerInfo.getUnsignedAttribute("1.2.840.113549.1.9.16.2.21");
        byte[] byArray2 = signerInfo.getUnsignedAttribute("1.2.840.113549.1.9.16.2.22");
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        if (signerInfo.isUnsignedAttributePresent("1.2.840.113549.1.9.16.2.23")) {
            byte[] byArray5 = signerInfo.getUnsignedAttribute("1.2.840.113549.1.9.16.2.23");
            byte[] byArray6 = signerInfo.getUnsignedAttribute("1.2.840.113549.1.9.16.2.24");
            byArray3 = byArray5;
            byArray4 = byArray6;
        }
        CertificatePathValidator certificatePathValidator = new CertificatePathValidator(this.advAlgs, certificateValidatorCache);
        return certificatePathValidator.validateLong(certificate, string, l2, certificateValidationPolicy, byArray, byArray2, byArray3, byArray4);
    }

    static class CollectReferencePolicy
    extends CertificateValidationPolicy {
        final byte MAX_PATH_DEPTH = (byte)12;
        final byte MAX_CRLS = (byte)4;
        public Certificate[] certs = new Certificate[12];
        public CertRevocationList[][] crls = new CertRevocationList[12][];
        public OcspResponse[] ocsps = new OcspResponse[12];
        CertificateValidationPolicy bp;
        CryptoAlgorithmFactory algs;

        public CollectReferencePolicy(CertificateValidationPolicy certificateValidationPolicy, CryptoAlgorithmFactory cryptoAlgorithmFactory) {
            this.bp = certificateValidationPolicy;
            this.algs = cryptoAlgorithmFactory;
            for (int i2 = 0; i2 < this.crls.length; ++i2) {
                this.crls[i2] = new CertRevocationList[4];
            }
        }

        public String getAcceptablePolicy() {
            return this.bp.getAcceptablePolicy();
        }

        public String getSupportedExtension() {
            return this.bp.getSupportedExtension();
        }

        public String getOcspDigsetOid(Certificate certificate) throws CertificateException {
            return this.bp.getOcspDigsetOid(certificate);
        }

        public int getOcspTimeTolerance() {
            return this.bp.getOcspTimeTolerance();
        }

        public int filterCert(Certificate certificate, int n2) {
            if (n2 == 0) {
                this.reset();
            }
            if (n2 < 12) {
                this.certs[n2] = certificate.clone();
            }
            return this.bp.filterCert(certificate, n2);
        }

        public int filterCrl(CertRevocationList certRevocationList, int n2) {
            if (n2 < 12) {
                for (int i2 = 0; i2 < 4; ++i2) {
                    if (this.crls[n2][i2] != null) continue;
                    this.crls[n2][i2] = certRevocationList.clone();
                    break;
                }
            }
            return this.bp.filterCrl(certRevocationList, n2);
        }

        public int filterOcsp(OcspResponse ocspResponse, int n2) {
            if (n2 < 12) {
                this.ocsps[n2] = ocspResponse.clone();
            }
            return this.bp.filterOcsp(ocspResponse, n2);
        }

        public byte[] getEncodedCertsC(String string) throws DsAlgorithmException {
            MessageDigestAlg messageDigestAlg = this.algs.getDigestAlg(string, null, null);
            if (messageDigestAlg == null) {
                throw new DsAlgorithmException();
            }
            DerEncoder derEncoder = new DerEncoder();
            derEncoder.SeqBegin();
            for (int i2 = 1; i2 < 12 && this.certs[i2] != null; ++i2) {
                byte[] byArray = this.certs[i2].getEncoded();
                derEncoder.SeqBegin();
                messageDigestAlg.update(byArray);
                this.encodeOtherHash(derEncoder, messageDigestAlg);
                derEncoder.SeqEnd();
            }
            derEncoder.SeqEnd();
            return derEncoder.getEncoded();
        }

        public byte[] getEncodedCrlsC(String string) throws DsAlgorithmException, DsDataCorruptedException, DsInvalidOperationException {
            MessageDigestAlg messageDigestAlg = this.algs.getDigestAlg(string, null, null);
            if (messageDigestAlg == null) {
                throw new DsAlgorithmException();
            }
            DerEncoder derEncoder = new DerEncoder();
            derEncoder.SeqBegin();
            for (int i2 = 0; i2 < 12 && (this.crls[i2][0] != null || this.ocsps[i2] != null); ++i2) {
                derEncoder.SeqBegin();
                if (this.crls[i2][0] != null) {
                    derEncoder.SpecificBegin((byte)-96);
                    derEncoder.SeqBegin();
                    derEncoder.SeqBegin();
                    for (int i3 = 0; i3 < 4 && this.crls[i2][i3] != null; ++i3) {
                        byte[] byArray = this.crls[i2][i3].getEncoded();
                        derEncoder.SeqBegin();
                        messageDigestAlg.update(byArray);
                        this.encodeOtherHash(derEncoder, messageDigestAlg);
                        derEncoder.SeqEnd();
                    }
                    derEncoder.SeqEnd();
                    derEncoder.SeqEnd();
                    derEncoder.SpecificEnd();
                }
                if (this.ocsps[i2] != null) {
                    derEncoder.SpecificBegin((byte)-95);
                    derEncoder.SeqBegin();
                    derEncoder.SeqBegin();
                    derEncoder.SeqBegin();
                    derEncoder.addObject(this.ocsps[i2].getOcspIdentifier());
                    byte[] byArray = this.ocsps[i2].getBasicOCSPResponse();
                    messageDigestAlg.update(byArray);
                    this.encodeOtherHash(derEncoder, messageDigestAlg);
                    derEncoder.SeqEnd();
                    derEncoder.SeqEnd();
                    derEncoder.SeqEnd();
                    derEncoder.SpecificEnd();
                }
                derEncoder.SeqEnd();
            }
            derEncoder.SeqEnd();
            return derEncoder.getEncoded();
        }

        public byte[] getEncodedCertsX() {
            DerEncoder derEncoder = new DerEncoder();
            derEncoder.SeqBegin();
            for (int i2 = 1; i2 < 12 && this.certs[i2] != null; ++i2) {
                derEncoder.addObject(this.certs[i2].getEncoded());
            }
            derEncoder.SeqEnd();
            return derEncoder.getEncoded();
        }

        public byte[] getEncodedCrlsX() throws DsInvalidOperationException {
            int n2;
            DerEncoder derEncoder = new DerEncoder();
            derEncoder.SeqBegin();
            boolean bl = false;
            boolean bl2 = false;
            for (n2 = 0; n2 < 12; ++n2) {
                if (this.crls[n2][0] != null) {
                    bl = true;
                }
                if (this.ocsps[n2] == null) continue;
                bl2 = true;
            }
            if (bl) {
                derEncoder.SpecificBegin((byte)-96);
                derEncoder.SeqBegin();
                for (n2 = 0; n2 < 12; ++n2) {
                    for (int i2 = 0; i2 < 4 && this.crls[n2][i2] != null; ++i2) {
                        derEncoder.addObject(this.crls[n2][i2].getEncoded());
                    }
                }
                derEncoder.SeqEnd();
                derEncoder.SpecificEnd();
            }
            if (bl2) {
                derEncoder.SpecificBegin((byte)-95);
                derEncoder.SeqBegin();
                for (n2 = 0; n2 < 12; ++n2) {
                    if (this.ocsps[n2] == null) continue;
                    derEncoder.addObject(this.ocsps[n2].getBasicOCSPResponse());
                }
                derEncoder.SeqEnd();
                derEncoder.SpecificEnd();
            }
            derEncoder.SeqEnd();
            return derEncoder.getEncoded();
        }

        void reset() {
            for (int i2 = 0; i2 < 12; ++i2) {
                this.certs[i2] = null;
                this.ocsps[i2] = null;
                for (int i3 = 0; i3 < 4; ++i3) {
                    this.crls[i2][i3] = null;
                }
            }
        }

        void encodeOtherHash(DerEncoder derEncoder, MessageDigestAlg messageDigestAlg) {
            byte[] byArray = messageDigestAlg.getDigest();
            if (messageDigestAlg.getOid().equals("1.3.14.3.2.26")) {
                derEncoder.addOctets(byArray);
            } else {
                derEncoder.SeqBegin();
                derEncoder.SeqBegin();
                derEncoder.addOid(messageDigestAlg.getOid());
                derEncoder.addDerParams(messageDigestAlg.getParams());
                derEncoder.SeqEnd();
                derEncoder.addOctets(byArray);
                derEncoder.SeqEnd();
            }
        }
    }
}

