/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor.DsLib.Certificates;

import ua.avtor.DsLib.Algorithms.CryptoAlgorithmFactory;
import ua.avtor.DsLib.Algorithms.MessageDigestAlg;
import ua.avtor.DsLib.Algorithms.MessageVerifierAlg;
import ua.avtor.DsLib.CertRevocationList;
import ua.avtor.DsLib.Certificate;
import ua.avtor.DsLib.CertificateException;
import ua.avtor.DsLib.Certificates.CertificateFinder;
import ua.avtor.DsLib.Certificates.CertificateValidationPolicy;
import ua.avtor.DsLib.Certificates.CertificateValidatorCache;
import ua.avtor.DsLib.DsAlgorithmException;
import ua.avtor.DsLib.DsDataCorruptedException;
import ua.avtor.DsLib.DsDataNotFoundException;
import ua.avtor.DsLib.DsInvalidOperationException;
import ua.avtor.DsLib.OcspRequest;
import ua.avtor.DsLib.OcspResponse;
import ua.avtor.DsLib.Utils.Ddec;
import ua.avtor.DsLib.Utils.DdecException;
import ua.avtor.DsLib.Utils.Pointer;
import ua.avtor.DsLib.Utils.Two;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificatePathValidator {
    static final byte kuCERTSIGN = 4;
    static final byte kuCRLSIGN = 2;
    static final int MAX_RECURSIVE_DEPTH = 10;
    CertificateValidatorCache cache;
    CryptoAlgorithmFactory algs;
    boolean preferOCSP;

    public CertificatePathValidator(CryptoAlgorithmFactory cryptoAlgorithmFactory, CertificateValidatorCache certificateValidatorCache) {
        this.algs = cryptoAlgorithmFactory;
        this.cache = certificateValidatorCache;
        this.preferOCSP = false;
    }

    public CertificatePathValidator(CryptoAlgorithmFactory cryptoAlgorithmFactory, CertificateValidatorCache certificateValidatorCache, boolean bl) {
        this.algs = cryptoAlgorithmFactory;
        this.cache = certificateValidatorCache;
        this.preferOCSP = bl && certificateValidatorCache.isOcspSupport();
    }

    public final int validate(Certificate certificate, long l2, CertificateValidationPolicy certificateValidationPolicy) throws CertificateException, DsDataCorruptedException, DsInvalidOperationException, DsAlgorithmException {
        return this.validate(certificate, null, l2, certificateValidationPolicy, null);
    }

    public final int validate(Certificate certificate, String string, long l2, CertificateValidationPolicy certificateValidationPolicy) throws CertificateException, DsDataCorruptedException, DsInvalidOperationException, DsAlgorithmException {
        return this.validate(certificate, string, l2, certificateValidationPolicy, null);
    }

    public final int validate(Certificate certificate, String string, long l2, CertificateValidationPolicy certificateValidationPolicy, CertificateFinder certificateFinder) throws CertificateException, DsDataCorruptedException, DsInvalidOperationException, DsAlgorithmException {
        int n2;
        if (l2 == 0L) {
            l2 = System.currentTimeMillis();
        }
        if ((n2 = this.validateUsage(certificate, string)) != 0) {
            return n2;
        }
        int n3 = this.cache.getCertStatus(certificate);
        if (certificateValidationPolicy != null) {
            n2 = this.validateCrt(certificate, n3, l2, 0, certificateValidationPolicy, certificateFinder);
        } else {
            CertificateValidationPolicy certificateValidationPolicy2 = new CertificateValidationPolicy();
            n2 = this.validateCrt(certificate, n3, l2, 0, certificateValidationPolicy2, certificateFinder);
        }
        return n2;
    }

    public final int validateLong(Certificate certificate, String string, long l2, CertificateValidationPolicy certificateValidationPolicy, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) throws DsDataCorruptedException, DsDataNotFoundException, DsInvalidOperationException, DsAlgorithmException, CertificateException {
        int n2;
        LongContext longContext = new LongContext();
        longContext.certRefs = byArray;
        longContext.crlRefs = byArray2;
        longContext.certVals = byArray3;
        longContext.crlVals = byArray4;
        if (l2 == 0L) {
            l2 = System.currentTimeMillis();
        }
        if ((n2 = this.validateUsage(certificate, string)) != 0) {
            return n2;
        }
        int n3 = this.cache.getCertStatus(certificate);
        if (certificateValidationPolicy != null) {
            n2 = this.validateCrtLong(certificate, n3, l2, 0, certificateValidationPolicy, longContext);
        } else {
            CertificateValidationPolicy certificateValidationPolicy2 = new CertificateValidationPolicy();
            n2 = this.validateCrtLong(certificate, n3, l2, 0, certificateValidationPolicy2, longContext);
        }
        return n2;
    }

    int verifyCertSignature(Certificate certificate, Certificate certificate2) throws CertificateException {
        MessageVerifierAlg messageVerifierAlg = this.algs.getVerifierAlg(null, null, certificate.getSignatureAlgOid(), certificate.getSignatureAlgParams(), certificate2);
        if (messageVerifierAlg == null) {
            return -18;
        }
        Two<Pointer, Integer> two = certificate.getSignedDataPtr();
        messageVerifierAlg.update(((Pointer)two.first).Copy((Integer)two.second));
        two = certificate.getSignaturePtr();
        boolean bl = messageVerifierAlg.verify(((Pointer)two.first).Copy((Integer)two.second));
        if (!bl) {
            return -4;
        }
        return 0;
    }

    int verifyCrlSignature(CertRevocationList certRevocationList, Certificate certificate) throws CertificateException {
        MessageVerifierAlg messageVerifierAlg = this.algs.getVerifierAlg(null, null, certRevocationList.getSignatureAlgOid(), certRevocationList.getSignatureAlgParams(), certificate);
        if (messageVerifierAlg == null) {
            return -18;
        }
        Two<Pointer, Integer> two = certRevocationList.getSignedDataPtr();
        messageVerifierAlg.update(((Pointer)two.first).Copy((Integer)two.second));
        two = certRevocationList.getSignaturePtr();
        boolean bl = messageVerifierAlg.verify(((Pointer)two.first).Copy((Integer)two.second));
        if (!bl) {
            return -4;
        }
        return 0;
    }

    int acceptPolicy(Certificate certificate, CertificateValidationPolicy certificateValidationPolicy) {
        String[] stringArray = new String[]{"2.5.29.32", "1.3.6.1.5.5.7.1.3"};
        String string = certificateValidationPolicy.getObligePolicy();
        boolean bl = string == null;
        for (int i2 = 0; i2 < 2; ++i2) {
            Two<byte[], Boolean> two = certificate.getExtension(stringArray[i2]);
            byte[] byArray = (byte[])two.first;
            boolean bl2 = (Boolean)two.second;
            if (byArray == null) continue;
            Ddec.DerSearchRec derSearchRec = Ddec.DerFindFirstElement(byArray, "S");
            while (derSearchRec != null) {
                byte[] byArray2;
                try {
                    byArray2 = Ddec.DerGetElementBuf(derSearchRec.der, "Sd");
                }
                catch (DdecException ddecException) {
                    return -6;
                }
                if (string != null && Ddec.DerIsOidInCsvList(byArray2, string)) {
                    bl = true;
                }
                if (bl2 && !Ddec.DerIsOidInCsvList(byArray2, certificateValidationPolicy.getAcceptablePolicy())) {
                    return -6;
                }
                derSearchRec = Ddec.DerFindNextElement(derSearchRec);
            }
        }
        if (!bl) {
            return -6;
        }
        return 0;
    }

    int validateCrt(Certificate certificate, int n2, long l2, int n3, CertificateValidationPolicy certificateValidationPolicy, CertificateFinder certificateFinder) throws CertificateException, DsDataCorruptedException, DsInvalidOperationException, DsAlgorithmException {
        String string;
        int n4;
        if (n3 > 10) {
            return -4;
        }
        int n5 = certificateValidationPolicy.filterCert(certificate, n3);
        if (n5 != 0) {
            return n5;
        }
        if (!certificate.isValidAtTime(l2)) {
            return -2;
        }
        if (certificate.hasCriticalExtensionExcept(certificateValidationPolicy.getSupportedExtension())) {
            return -6;
        }
        n5 = this.acceptPolicy(certificate, certificateValidationPolicy);
        if (n5 != 0) {
            return n5;
        }
        if (n2 == 2) {
            return 0;
        }
        if (n2 == 3) {
            return -1;
        }
        if (certificate.isSelfSigned()) {
            return -8;
        }
        Two<Certificate, Integer> two = this.cache.getSignerOf(certificate);
        Certificate certificate2 = (Certificate)two.first;
        int n6 = (Integer)two.second;
        if (certificate2 == null && certificateFinder != null) {
            n6 = 0;
            certificate2 = this.findSignerOf(certificate, certificateFinder);
        }
        if (certificate2 == null) {
            return -8;
        }
        try {
            n4 = this.validateCrt(certificate2, n6, l2, n3 + 1, certificateValidationPolicy, certificateFinder);
            if (n4 != 0) {
                return n4;
            }
        }
        catch (Exception exception) {
            return -4;
        }
        if (!certificate2.isCA()) {
            return -6;
        }
        if ((certificate2.getKu() & 4) == 0) {
            return -6;
        }
        if (n3 > certificate2.getMaxPathLength()) {
            return -6;
        }
        if (n2 != 1 && (n4 = this.verifyCertSignature(certificate, certificate2)) != 0) {
            return n4;
        }
        if (this.preferOCSP && (string = certificate.getOCSPResponder(0)) != null && !string.isEmpty()) {
            return this.validateStatusByOcsp(certificate, certificate2, l2, n3, certificateValidationPolicy);
        }
        return this.validateStatusByCrl(certificate, certificate2, l2, n3, certificateValidationPolicy);
    }

    int validateUsage(Certificate certificate, String string) {
        int n2 = 0;
        byte by = certificate.getKu();
        if (string == null || !string.equals("any")) {
            if (string != null && string.indexOf(101) == 0) {
                if ((by & 0x38) == 0) {
                    n2 = -12;
                }
            } else {
                if ((by & 0xC0) == 0 && by != 0 && string != null) {
                    n2 = -12;
                }
                if (!certificate.isEkuAllowed(string)) {
                    n2 = -12;
                }
            }
        }
        return n2;
    }

    int validateStatusByCrl(Certificate certificate, Certificate certificate2, long l2, int n2, CertificateValidationPolicy certificateValidationPolicy) throws DsDataCorruptedException, CertificateException {
        boolean bl = true;
        boolean bl2 = false;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        boolean bl3 = false;
        int n3 = 0;
        String string = certificate.getCRLDistributionPointUri(n3);
        while (string != null && !string.isEmpty()) {
            Two<CertRevocationList, Integer> two = this.cache.getCrl(string);
            CertRevocationList certRevocationList = (CertRevocationList)two.first;
            int n4 = (Integer)two.second;
            if (n4 != 7) {
                boolean bl4;
                int n5;
                if (certRevocationList == null) {
                    return -9;
                }
                if (!certRevocationList.isValidAtTime(l2)) {
                    this.cache.setCrlStatus(string, 8, 0L);
                    two = this.cache.getCrl(string);
                    certRevocationList = (CertRevocationList)two.first;
                    n4 = (Integer)two.second;
                    if (certRevocationList == null) {
                        return -9;
                    }
                    if (!certRevocationList.isValidAtTime(l2)) {
                        return -3;
                    }
                }
                if ((n5 = certificateValidationPolicy.filterCrl(certRevocationList, n2)) != 0) {
                    return n5;
                }
                long l6 = certRevocationList.getCrlNumber();
                if (l6 < l4) {
                    return -7;
                }
                l4 = l6;
                if (!bl3) {
                    if (certRevocationList.isDelta()) {
                        return -7;
                    }
                    l5 = l4;
                    l3 = certRevocationList.nextUpdate();
                } else {
                    if (!certRevocationList.isDelta()) {
                        return -7;
                    }
                    if (l5 < certRevocationList.getBaseCrlNumber()) {
                        return -7;
                    }
                    long l7 = certRevocationList.nextUpdate();
                    if (l7 < l3) {
                        l3 = l7;
                    }
                }
                if (!certRevocationList.isSignedBy(certificate2)) {
                    return -7;
                }
                if (n4 != 2 && n4 != 1) {
                    if ((certificate2.getKu() & 2) == 0) {
                        return -6;
                    }
                    int n6 = this.verifyCrlSignature(certRevocationList, certificate2);
                    if (n6 != 0) {
                        return n6;
                    }
                    this.cache.setCrlStatus(string, 1, certRevocationList.nextUpdate());
                }
                Two<Boolean, Integer> two2 = certRevocationList.isCertificateValidAt(certificate, l2);
                int n7 = (Integer)two2.second;
                boolean bl5 = bl4 = (Boolean)two2.first == false;
                if (bl4) {
                    bl = false;
                }
                if (!bl4 && n7 > 0) {
                    bl = true;
                }
                bl2 = true;
            }
            ++n3;
            if (bl3) {
                string = certificate.getFreshestCRLDistributionPointUri(n3);
                continue;
            }
            string = certificate.getCRLDistributionPointUri(n3);
            if (string != null && !string.isEmpty()) continue;
            n3 = 0;
            bl3 = true;
            string = certificate.getFreshestCRLDistributionPointUri(n3);
        }
        if (!bl) {
            return -1;
        }
        if (!bl2 && !certificateValidationPolicy.allowBypassCrl(certificate, n2)) {
            return -7;
        }
        this.cache.setCertStatus(certificate, 1, l3);
        return 0;
    }

    int validateStatusByOcsp(Certificate certificate, Certificate certificate2, long l2, int n2, CertificateValidationPolicy certificateValidationPolicy) throws CertificateException, DsAlgorithmException, DsDataCorruptedException, DsInvalidOperationException {
        int n3;
        OcspRequest ocspRequest;
        byte[] byArray;
        String string = certificate.getOCSPResponder(0);
        byte[] byArray2 = this.cache.getOcsp(string, byArray = (ocspRequest = new OcspRequest(certificateValidationPolicy.getOcspDigsetOid(certificate), this.algs, certificate, certificate2)).getEncoded());
        if (byArray2 == null) {
            return -14;
        }
        OcspResponse ocspResponse = new OcspResponse(byArray2);
        if (ocspResponse.getResponseStatus() != 0) {
            return -14;
        }
        long l3 = System.currentTimeMillis();
        int n4 = certificateValidationPolicy.filterOcsp(ocspResponse, n2);
        if (n4 != 0) {
            return n4;
        }
        Certificate certificate3 = ocspResponse.verifySignature(this.algs, this.cache.getCertificateFinder(), null);
        if (certificate3 == null) {
            if (ocspResponse.getVerificationStatus() == 2) {
                return -15;
            }
            return -16;
        }
        long l4 = ocspResponse.getResponseTime();
        int n5 = l4 > l3 ? (int)((l4 - l3) / 1000L) : (int)((l3 - l4) / 1000L);
        if (n5 > certificateValidationPolicy.getOcspTimeTolerance()) {
            return -17;
        }
        if (!certificate3.isEkuPresent("1.3.6.1.5.5.7.3.9")) {
            return -15;
        }
        if (!certificate3.isValidAtTime(l2)) {
            return -15;
        }
        if (certificate3.hasCriticalExtensionExcept(certificateValidationPolicy.getSupportedExtension())) {
            return -15;
        }
        if (this.acceptPolicy(certificate3, certificateValidationPolicy) != 0) {
            return -15;
        }
        int n6 = this.cache.getCertStatus(certificate3);
        if (n6 == 3) {
            return -15;
        }
        if (n6 != 2) {
            if (!certificate2.isSignerOf(certificate3)) {
                return -6;
            }
            if (n6 != 1) {
                if (this.verifyCertSignature(certificate3, certificate2) != 0) {
                    return -15;
                }
                this.cache.setCertStatus(certificate3, 1, 0L);
            }
        }
        if ((n3 = ((Integer)ocspResponse.getCerificateStatus((OcspRequest)ocspRequest).first).intValue()) == 0) {
            return 0;
        }
        if (n3 == 1) {
            return -1;
        }
        return -16;
    }

    Certificate findSignerOf(Certificate certificate, CertificateFinder certificateFinder) throws CertificateException {
        byte[] byArray;
        byte[] byArray2 = certificate.getAuthorityKeyIdentifier();
        if (byArray2 != null) {
            byArray = certificateFinder.findCertificate(1, byArray2);
        } else {
            byte[] byArray3 = certificate.getIssuerDN();
            byArray = certificateFinder.findCertificate(2, byArray3);
        }
        if (byArray == null) {
            return null;
        }
        return new Certificate(byArray);
    }

    Certificate findSignerOf(Certificate certificate, byte[] byArray) throws CertificateException {
        byte[] byArray2 = certificate.getAuthorityKeyIdentifier();
        byte[] byArray3 = certificate.getIssuerDN();
        Ddec.DerSearchRec derSearchRec = Ddec.DerFindFirstElement(byArray, "S");
        while (derSearchRec != null) {
            Certificate certificate2 = new Certificate(derSearchRec.der.Copy(derSearchRec.size));
            if (byArray2 != null ? new Pointer(byArray2).CompareTo(certificate2.getSubjectKeyIdentifier()) : new Pointer(byArray3).CompareTo(certificate2.getSubjectDN())) {
                return certificate2.clone();
            }
            derSearchRec = Ddec.DerFindNextElement(derSearchRec);
        }
        return null;
    }

    int findCertRefIndex(Certificate certificate, byte[] byArray) throws DsAlgorithmException, DsDataCorruptedException {
        byte[] byArray2 = null;
        String string = "";
        int n2 = 0;
        Ddec.DerSearchRec derSearchRec = Ddec.DerFindFirstElement(byArray, "S");
        while (derSearchRec != null) {
            Two<String, byte[]> two = CertificatePathValidator.decodeOtherHash(derSearchRec.der, "Sx");
            if (!((String)two.first).equals(string)) {
                MessageDigestAlg messageDigestAlg = this.algs.getDigestAlg((String)two.first, null, null);
                if (messageDigestAlg == null) {
                    throw new DsAlgorithmException();
                }
                byte[] byArray3 = certificate.getEncoded();
                messageDigestAlg.update(byArray3);
                byArray2 = messageDigestAlg.getDigest();
                string = (String)two.first;
            }
            if (new Pointer(byArray2).CompareTo((byte[])two.second)) {
                return n2;
            }
            ++n2;
            derSearchRec = Ddec.DerFindNextElement(derSearchRec);
        }
        return -1;
    }

    CertRevocationList findCrlByRef(byte[] byArray, Pointer pointer, byte[] byArray2) throws CertificateException, DsAlgorithmException, DsDataCorruptedException {
        Two<String, byte[]> two = CertificatePathValidator.decodeOtherHash(pointer, "Sx");
        Ddec.DerSearchRec derSearchRec = Ddec.DerFindFirstElement(byArray2, "SE0S");
        while (derSearchRec != null) {
            CertRevocationList certRevocationList = new CertRevocationList(derSearchRec.der.Copy(derSearchRec.size));
            if (new Pointer(byArray).CompareTo(certRevocationList.getIssuerDN())) {
                MessageDigestAlg messageDigestAlg = this.algs.getDigestAlg((String)two.first, null, null);
                if (messageDigestAlg == null) {
                    throw new DsAlgorithmException();
                }
                byte[] byArray3 = certRevocationList.getEncoded();
                messageDigestAlg.update(byArray3);
                byte[] byArray4 = messageDigestAlg.getDigest();
                if (new Pointer(byArray4).CompareTo((byte[])two.second)) {
                    return certRevocationList.clone();
                }
            }
            derSearchRec = Ddec.DerFindNextElement(derSearchRec);
        }
        return null;
    }

    OcspResponse findOcspByRef(byte[] byArray, byte[] byArray2) throws DsAlgorithmException, DsDataCorruptedException, DsInvalidOperationException {
        Object object;
        String string = null;
        byte[] byArray3 = null;
        boolean bl = false;
        try {
            Ddec.DerGetElementNull(byArray, "Ssx");
            object = CertificatePathValidator.decodeOtherHash(new Pointer(byArray), "Ssx");
            string = (String)((Two)object).first;
            byArray3 = (byte[])((Two)object).second;
            bl = true;
        }
        catch (DdecException ddecException) {
            // empty catch block
        }
        object = Ddec.DerFindFirstElement(byArray2, "Soe0E1S");
        while (object != null) {
            Pointer pointer;
            OcspResponse ocspResponse = new OcspResponse(((Ddec.DerSearchRec)object).der.Copy(((Ddec.DerSearchRec)object).size), true);
            try {
                pointer = (Pointer)Ddec.DerGetElementPtr((byte[])byArray, (String)"Ss").first;
            }
            catch (DdecException ddecException) {
                throw new DsDataCorruptedException();
            }
            if (pointer.CompareTo(ocspResponse.getOcspIdentifier())) {
                if (!bl) {
                    return ocspResponse.clone();
                }
                MessageDigestAlg messageDigestAlg = this.algs.getDigestAlg(string, null, null);
                if (messageDigestAlg == null) {
                    throw new DsAlgorithmException();
                }
                byte[] byArray4 = ocspResponse.getBasicOCSPResponse();
                messageDigestAlg.update(byArray4);
                byte[] byArray5 = messageDigestAlg.getDigest();
                if (new Pointer(byArray5).CompareTo(byArray3)) {
                    return ocspResponse.clone();
                }
            }
            object = Ddec.DerFindNextElement((Ddec.DerSearchRec)object);
        }
        return null;
    }

    int validateStatusLongByCrl(byte[] byArray, Certificate certificate, Certificate certificate2, long l2, int n2, CertificateValidationPolicy certificateValidationPolicy, byte[] byArray2) throws CertificateException, DsDataCorruptedException, DsAlgorithmException {
        Object object;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        int n3 = 0;
        Ddec.DerSearchRec derSearchRec = Ddec.DerFindFirstElement(byArray, "S");
        while (derSearchRec != null) {
            boolean bl4;
            byte[] byArray3 = certificate.getIssuerDN();
            object = byArray2 != null ? this.findCrlByRef(byArray3, derSearchRec.der, byArray2) : this.cache.getCrlByRef(byArray3, derSearchRec.der.Copy(derSearchRec.size));
            if (object == null) {
                return -9;
            }
            if (!((CertRevocationList)object).isValidAtTime(l2)) {
                return -3;
            }
            int n4 = certificateValidationPolicy.filterCrl((CertRevocationList)object, n2);
            if (n4 != 0) {
                return n4;
            }
            long l6 = ((CertRevocationList)object).getCrlNumber();
            if (l6 < l4) {
                return -7;
            }
            l4 = l6;
            if (!((CertRevocationList)object).isDelta()) {
                l5 = l4;
                bl2 = true;
                l3 = ((CertRevocationList)object).nextUpdate();
            } else {
                if (n3 == 0) {
                    return -7;
                }
                if (l5 < ((CertRevocationList)object).getBaseCrlNumber()) {
                    return -7;
                }
                bl3 = true;
                long l7 = ((CertRevocationList)object).nextUpdate();
                if (l7 < l3) {
                    l3 = l7;
                }
            }
            if (!((CertRevocationList)object).isSignedBy(certificate2)) {
                return -7;
            }
            if ((certificate2.getKu() & 2) == 0) {
                return -6;
            }
            int n5 = this.verifyCrlSignature((CertRevocationList)object, certificate2);
            if (n5 != 0) {
                return n5;
            }
            Two<Boolean, Integer> two = ((CertRevocationList)object).isCertificateValidAt(certificate, l2);
            int n6 = (Integer)two.second;
            boolean bl5 = bl4 = (Boolean)two.first == false;
            if (bl4) {
                bl = false;
            }
            if (!bl4 && n6 > 0) {
                bl = true;
            }
            ++n3;
            derSearchRec = Ddec.DerFindNextElement(derSearchRec);
        }
        if (!bl) {
            return -1;
        }
        if (!bl2) {
            return -7;
        }
        if (!(bl3 || certificateValidationPolicy.allowBypassCrl(certificate, n2) || (object = certificate.getFreshestCRLDistributionPointUri(0)) == null || ((String)object).isEmpty())) {
            return -7;
        }
        this.cache.setCertStatus(certificate, 1, l3);
        return 0;
    }

    int validateStatusLongByOcsp(byte[] byArray, Certificate certificate, Certificate certificate2, long l2, int n2, CertificateValidationPolicy certificateValidationPolicy, byte[] byArray2) throws DsDataCorruptedException, DsInvalidOperationException, DsAlgorithmException, CertificateException {
        int n3;
        int n4;
        byte[] byArray3;
        block20: {
            try {
                byArray3 = Ddec.DerGetElementBuf(byArray, "Ss");
            }
            catch (DdecException ddecException) {
                throw new DsDataCorruptedException();
            }
            try {
                Ddec.DerGetElementNull(byArray3, "Ssx");
            }
            catch (DdecException ddecException) {
                if (certificateValidationPolicy.allowUnhashedOcsp()) break block20;
                return -6;
            }
        }
        OcspResponse ocspResponse = byArray2 != null ? this.findOcspByRef(byArray3, byArray2) : this.cache.getOcspByRef(byArray3);
        if (ocspResponse == null) {
            return -14;
        }
        byte[] byArray4 = ocspResponse.getBasicOCSPResponse();
        OcspResponse ocspResponse2 = new OcspResponse(byArray4, true);
        int n5 = certificateValidationPolicy.filterOcsp(ocspResponse2, n2);
        if (n5 != 0) {
            return n5;
        }
        Certificate certificate3 = ocspResponse2.verifySignature(this.algs, this.cache.getCertificateFinder(), null);
        if (certificate3 == null) {
            if (ocspResponse2.getVerificationStatus() == 2) {
                return -15;
            }
            return -16;
        }
        long l3 = ocspResponse2.getResponseTime();
        if (l3 < l2 && (n4 = (int)((l2 - l3) / 1000L)) > certificateValidationPolicy.getOcspTimeTolerance()) {
            return -17;
        }
        if (!certificate3.isEkuPresent("1.3.6.1.5.5.7.3.9")) {
            return -15;
        }
        if (!certificate3.isValidAtTime(l2)) {
            return -15;
        }
        if (certificate3.hasCriticalExtensionExcept(certificateValidationPolicy.getSupportedExtension())) {
            return -15;
        }
        if (this.acceptPolicy(certificate3, certificateValidationPolicy) != 0) {
            return -15;
        }
        n4 = this.cache.getCertStatus(certificate3);
        if (n4 == 3) {
            return -15;
        }
        if (n4 != 2) {
            if (!certificate2.isSignerOf(certificate3)) {
                return -6;
            }
            if (n4 != 1) {
                if (this.verifyCertSignature(certificate3, certificate2) != 0) {
                    return -15;
                }
                this.cache.setCertStatus(certificate3, 1, 0L);
            }
        }
        if ((n3 = ((Integer)ocspResponse2.getCerificateStatus((Certificate)certificate, null, (CryptoAlgorithmFactory)this.algs).first).intValue()) == 0) {
            return 0;
        }
        if (n3 == 1) {
            return -1;
        }
        return -16;
    }

    int validateCrtLong(Certificate certificate, int n2, long l2, int n3, CertificateValidationPolicy certificateValidationPolicy, LongContext longContext) throws CertificateException, DsDataCorruptedException, DsAlgorithmException, DsInvalidOperationException, DsDataNotFoundException {
        int n4;
        Certificate certificate2;
        int n5;
        if (n3 > 10) {
            return -4;
        }
        int n6 = certificateValidationPolicy.filterCert(certificate, n3);
        if (n6 != 0) {
            return n6;
        }
        if (!certificate.isValidAtTime(l2)) {
            return -2;
        }
        if (certificate.hasCriticalExtensionExcept(certificateValidationPolicy.getSupportedExtension())) {
            return -6;
        }
        n6 = this.acceptPolicy(certificate, certificateValidationPolicy);
        if (n6 != 0) {
            return n6;
        }
        int n7 = 0;
        if (longContext.certRefs != null && n3 > 0) {
            n5 = this.findCertRefIndex(certificate, longContext.certRefs);
            if (n5 < 0) {
                return -10;
            }
            n7 = n5 + 1;
        }
        if (n2 == 2) {
            return 0;
        }
        if (n2 == 3) {
            return -1;
        }
        if (certificate.isSelfSigned()) {
            return -8;
        }
        n5 = 0;
        if (longContext.certVals != null) {
            certificate2 = this.findSignerOf(certificate, longContext.certVals);
            if (certificate2 != null) {
                n5 = this.cache.getCertStatus(certificate2);
            }
        } else {
            Two<Certificate, Integer> two = this.cache.getSignerOf(certificate);
            certificate2 = (Certificate)two.first;
            n5 = (Integer)two.second;
        }
        if (certificate2 == null) {
            return -8;
        }
        try {
            n4 = this.validateCrtLong(certificate2, n5, l2, n3 + 1, certificateValidationPolicy, longContext);
            if (n4 != 0) {
                return n4;
            }
        }
        catch (Exception exception) {
            return -4;
        }
        if (!certificate2.isCA()) {
            return -6;
        }
        if ((certificate2.getKu() & 4) == 0) {
            return -6;
        }
        if (n3 > certificate2.getMaxPathLength()) {
            return -6;
        }
        if (certificate2.hasCriticalExtensionExcept(certificateValidationPolicy.getSupportedExtension())) {
            return -6;
        }
        if (n2 != 1 && (n4 = this.verifyCertSignature(certificate, certificate2)) != 0) {
            return n4;
        }
        Ddec.DerSearchRec derSearchRec = Ddec.DerFindFirstElement(longContext.crlRefs, "S");
        for (n4 = 0; derSearchRec != null && n4 != n7; ++n4) {
            derSearchRec = Ddec.DerFindNextElement(derSearchRec);
        }
        if (derSearchRec == null) {
            throw new DsDataCorruptedException();
        }
        try {
            Ddec.DerGetElementNull(derSearchRec.der, "Soe0E1SSs");
            try {
                return this.validateStatusLongByOcsp(Ddec.DerGetElementBuf(derSearchRec.der, "Soe0E1Ss"), certificate, certificate2, l2, n3, certificateValidationPolicy, longContext.crlVals);
            }
            catch (DdecException ddecException) {
                throw new DsDataNotFoundException();
            }
        }
        catch (DdecException ddecException) {
            try {
                return this.validateStatusLongByCrl(Ddec.DerGetElementBuf(derSearchRec.der, "SE0Ss"), certificate, certificate2, l2, n3, certificateValidationPolicy, longContext.crlVals);
            }
            catch (DdecException ddecException2) {
                throw new DsDataNotFoundException();
            }
        }
    }

    static Two<String, byte[]> decodeOtherHash(Pointer pointer, String string) throws DsDataCorruptedException {
        String string2;
        byte[] byArray;
        byte[] byArray2;
        try {
            byArray2 = Ddec.DerGetElementBuf(pointer, string);
        }
        catch (DdecException ddecException) {
            throw new DsDataCorruptedException();
        }
        try {
            byArray = Ddec.DerGetElementBuf(byArray2, "Q");
            string2 = "1.3.14.3.2.26";
        }
        catch (DdecException ddecException) {
            try {
                string2 = Ddec.DerGetElementOid(byArray2, "SSD");
                byArray = Ddec.DerGetElementBuf(byArray2, "SsQ");
            }
            catch (DdecException ddecException2) {
                throw new DsDataCorruptedException();
            }
        }
        return new Two<String, byte[]>(string2, byArray);
    }

    class LongContext {
        public byte[] certRefs;
        public byte[] crlRefs;
        public byte[] certVals;
        public byte[] crlVals;

        LongContext() {
        }
    }
}

