/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor.DsLib.Certificates;

import java.io.IOException;
import ua.avtor.DsLib.CertRevocationList;
import ua.avtor.DsLib.Certificate;
import ua.avtor.DsLib.CertificateException;
import ua.avtor.DsLib.Certificates.CertificateFinder;
import ua.avtor.DsLib.Certificates.CertificateValidatorCache;
import ua.avtor.DsLib.Transport.UriTransport;
import ua.avtor.DsLib.Utils.Two;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateConstructedCache
extends CertificateValidatorCache {
    protected CertificateFinder trustedStore;
    protected CertificateFinder generalStore;
    protected UriTransport transport;

    public CertificateConstructedCache(CertificateFinder certificateFinder, CertificateFinder certificateFinder2, UriTransport uriTransport) {
        this.trustedStore = certificateFinder;
        this.generalStore = certificateFinder2;
        this.transport = uriTransport;
    }

    @Override
    public int getCertStatus(Certificate certificate) throws CertificateException {
        int n2 = 0;
        byte[] byArray = certificate.getSubjectKeyIdentifier();
        byte[] byArray2 = certificate.getSubjectDN();
        byte[] byArray3 = byArray != null ? this.trustedStore.findCertificate(1, byArray) : this.trustedStore.findCertificate(2, byArray2);
        if (byArray3 != null && certificate.isEqualTo(byArray3)) {
            n2 = 2;
        }
        return n2;
    }

    @Override
    public Two<Certificate, Integer> getSignerOf(Certificate certificate) throws CertificateException {
        int n2 = 0;
        byte[] byArray = certificate.getAuthorityKeyIdentifier();
        byte[] byArray2 = certificate.getIssuerDN();
        byte[] byArray3 = byArray != null ? this.trustedStore.findCertificate(1, byArray) : this.trustedStore.findCertificate(2, byArray2);
        if (byArray3 != null) {
            n2 = 2;
            return new Two<Certificate, Integer>(new Certificate(byArray3), n2);
        }
        if (this.generalStore != null && (byArray3 = byArray != null ? this.generalStore.findCertificate(1, byArray) : this.generalStore.findCertificate(2, byArray2)) != null) {
            n2 = 0;
            return new Two<Certificate, Integer>(new Certificate(byArray3), n2);
        }
        return new Two<Object, Integer>(null, n2);
    }

    @Override
    public void setCertStatus(Certificate certificate, int n2, long l2) {
    }

    @Override
    public Two<CertRevocationList, Integer> getCrl(String string) {
        int n2 = 0;
        String string2 = string.split("[|]")[0];
        if (string2.indexOf("http:") != 0) {
            n2 = 7;
            return new Two<Object, Integer>(null, n2);
        }
        CertRevocationList certRevocationList = null;
        try {
            byte[] byArray = this.transport.get(string2, null, null);
            certRevocationList = new CertRevocationList(byArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Two<Object, Integer>(certRevocationList, n2);
    }

    @Override
    public void setCrlStatus(String string, int n2, long l2) {
    }

    @Override
    public CertificateFinder getCertificateFinder() {
        return this.generalStore;
    }

    @Override
    public boolean isOcspSupport() {
        return true;
    }

    @Override
    public byte[] getOcsp(String string, byte[] byArray) {
        try {
            return this.transport.post(string, byArray, "application/ocsp-request", null);
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

