/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor.DsLib;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import ua.avtor.DsLib.CertificateDataNotFoundException;
import ua.avtor.DsLib.CertificateException;
import ua.avtor.DsLib.Utils.Ddec;
import ua.avtor.DsLib.Utils.DdecException;
import ua.avtor.DsLib.Utils.Pointer;
import ua.avtor.DsLib.Utils.Three;
import ua.avtor.DsLib.Utils.Two;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Certificate {
    final int ERR_FILE_NOT_FOUND = -3;
    final int ERR_CORRUPTED = -9;
    final byte[] emptyExtensions = new byte[]{48, 0};
    private byte[] cer;
    private byte[] pExtensions;
    private byte[] pPublicKey;
    static final ST_X509KeyOidts[] X500KeysOids = new ST_X509KeyOidts[]{new ST_X509KeyOidts("CN", "2.5.4.3"), new ST_X509KeyOidts("SN", "2.5.4.4"), new ST_X509KeyOidts("C", "2.5.4.6"), new ST_X509KeyOidts("L", "2.5.4.7"), new ST_X509KeyOidts("ST", "2.5.4.8"), new ST_X509KeyOidts("O", "2.5.4.10"), new ST_X509KeyOidts("OU", "2.5.4.11"), new ST_X509KeyOidts("T", "2.5.4.12"), new ST_X509KeyOidts("G", "2.5.4.42"), new ST_X509KeyOidts("I", "2.5.4.43"), new ST_X509KeyOidts("DC", "0.9.2342.19200300.100.1.25"), new ST_X509KeyOidts("E", "1.2.840.113549.1.9.1"), new ST_X509KeyOidts("STREET", "2.5.4.9")};

    public Certificate() {
    }

    public Certificate(String string) throws IOException, CertificateException {
        this.loadFromFile(string);
    }

    public Certificate(byte[] byArray) throws CertificateException {
        this.loadFromMemory(byArray);
    }

    public Certificate clone() {
        return this;
    }

    public final byte[] getEncoded() {
        return this.cer;
    }

    public final byte[] getSerial() throws CertificateException {
        try {
            return Ddec.DerGetElementBuf(this.cer, "SSoe0i");
        }
        catch (DdecException ddecException) {
            throw new CertificateException(-9);
        }
    }

    public final byte[] getIssuerDN() {
        return Ddec.TryGetElementBuf(this.cer, "SSoe0iss");
    }

    public final byte[] getSubjectDN() {
        return Ddec.TryGetElementBuf(this.cer, "SSoe0issss");
    }

    public final String getIssuerName(String string) throws CertificateException {
        return this.getRdnAttributeStr(this.getIssuerDN(), string);
    }

    public final String getSubjectName(String string) throws CertificateException {
        return this.getRdnAttributeStr(this.getSubjectDN(), string);
    }

    public final String getDirectoryAttribute(String string) {
        byte[] byArray = this.getDirectoryAttributeSet(string);
        if (byArray == null) {
            return null;
        }
        try {
            return Ddec.DerGetElementStr(byArray, "UC");
        }
        catch (DdecException ddecException) {
            return null;
        }
    }

    public final byte[] getDirectoryAttributeSet(String string) {
        try {
            Three<Pointer, Integer, Boolean> three = this.getExtensionPtr("2.5.29.9");
            String string2 = "f" + string + "u";
            return Ddec.DerGetElementBuf((Pointer)three.first, string2);
        }
        catch (DdecException ddecException) {
            return null;
        }
    }

    public final long getNotBefore() throws CertificateException {
        try {
            return Ddec.DerGetElementTime(this.cer, "SSoe0issST");
        }
        catch (DdecException ddecException) {
            throw new CertificateException(-9);
        }
    }

    public final long getNotAfter() throws CertificateException {
        try {
            return Ddec.DerGetElementTime(this.cer, "SSoe0issStT");
        }
        catch (DdecException ddecException) {
            throw new CertificateException(-9);
        }
    }

    public final boolean isCA() {
        try {
            return Ddec.DerGetElementBool(this.pExtensions, "f2.5.29.19 obQ=SB");
        }
        catch (DdecException ddecException) {
            return false;
        }
    }

    public final int getMaxPathLength() {
        byte[] byArray;
        try {
            byArray = Ddec.DerGetElementBuf(this.pExtensions, "f2.5.29.19 obQ=s");
        }
        catch (DdecException ddecException) {
            return -1;
        }
        try {
            return Ddec.DerGetElementInt(byArray, "SbI");
        }
        catch (DdecException ddecException) {
            return Integer.MAX_VALUE;
        }
    }

    public final boolean isSignerOf(Certificate certificate) {
        byte[] byArray = Ddec.TryGetElementBuf(certificate.cer, "SSoe0iss");
        byte[] byArray2 = Ddec.TryGetElementBuf(this.cer, "SSoe0issss");
        return Arrays.equals(byArray, byArray2);
    }

    public final boolean isSelfSigned() {
        return this.isSignerOf(this);
    }

    public final byte getKu() {
        try {
            return Ddec.DerGetElementForward(this.pExtensions, "f2.5.29.15 obQ=G")[0];
        }
        catch (DdecException ddecException) {
            return 0;
        }
    }

    public final boolean isEkuPresent(String string) {
        byte[] byArray = Ddec.DerEncodeOid(string);
        Ddec.DerSearchRec derSearchRec = Ddec.DerFindFirstElement(this.pExtensions, "f2.5.29.37 obQ=S");
        while (derSearchRec != null) {
            if (derSearchRec.size == byArray.length && derSearchRec.der.CompareTo(byArray)) {
                return true;
            }
            derSearchRec = Ddec.DerFindNextElement(derSearchRec);
        }
        return false;
    }

    public final boolean isEkuAllowed(String string) {
        boolean bl;
        try {
            bl = Ddec.DerGetElementBool(this.pExtensions, "f2.5.29.37 B");
        }
        catch (DdecException ddecException) {
            bl = false;
        }
        if (!bl) {
            return true;
        }
        if (string == null || string.equals("")) {
            return false;
        }
        return this.isEkuPresent(string);
    }

    public final boolean hasCriticalEkuExcept(String string) {
        try {
            if (!Ddec.DerGetElementBool(this.pExtensions, "f2.5.29.37 B")) {
                return false;
            }
        }
        catch (DdecException ddecException) {
            return false;
        }
        Ddec.DerSearchRec derSearchRec = Ddec.DerFindFirstElement(this.pExtensions, "f2.5.29.37 obQ=S");
        while (derSearchRec != null) {
            if (!Ddec.DerIsOidInCsvList(derSearchRec.der, string)) {
                return true;
            }
            derSearchRec = Ddec.DerFindNextElement(derSearchRec);
        }
        return false;
    }

    public final boolean hasCriticalExtensionExcept(String string) {
        Ddec.DerSearchRec derSearchRec = Ddec.DerFindFirstElement(this.pExtensions, "S");
        while (derSearchRec != null) {
            block6: {
                try {
                    byte[] byArray;
                    if (!Ddec.DerGetElementBool(derSearchRec.der, "SdB")) break block6;
                    try {
                        byArray = Ddec.DerGetElementBuf(derSearchRec.der, "Sd");
                    }
                    catch (DdecException ddecException) {
                        byArray = null;
                    }
                    if (!Ddec.DerIsOidInCsvList(byArray, string)) {
                        return true;
                    }
                }
                catch (DdecException ddecException) {
                    // empty catch block
                }
            }
            derSearchRec = Ddec.DerFindNextElement(derSearchRec);
        }
        return false;
    }

    public final boolean isExtensionPresent(String string) {
        try {
            this.getExtensionPtr(string);
            return true;
        }
        catch (DdecException ddecException) {
            return false;
        }
    }

    public final Two<byte[], Boolean> getExtension(String string) {
        Three<Pointer, Integer, Boolean> three;
        try {
            three = this.getExtensionPtr(string);
        }
        catch (DdecException ddecException) {
            return new Two<Object, Boolean>(null, false);
        }
        return new Two<byte[], Boolean>(((Pointer)three.first).Copy((Integer)three.second), (Boolean)three.third);
    }

    public final byte[] getSubjectKeyIdentifier() {
        try {
            return Ddec.DerGetElementBuf(this.pExtensions, "f2.5.29.14 obQ=Q");
        }
        catch (DdecException ddecException) {
            return null;
        }
    }

    public final byte[] getAuthorityKeyIdentifier() {
        try {
            return Ddec.DerGetElementBuf(this.pExtensions, "f2.5.29.35 obQ=SY0");
        }
        catch (DdecException ddecException) {
            return null;
        }
    }

    public final String getEMail() throws CertificateDataNotFoundException {
        try {
            return Ddec.DerGetElementStr(this.pExtensions, "F2.5.29.17obQ=SY1");
        }
        catch (DdecException ddecException) {
            try {
                return Ddec.DerGetElementStr(this.cer, "SSoe0isssF1.2.840.113549.1.9.1C");
            }
            catch (DdecException ddecException2) {
                throw new CertificateDataNotFoundException();
            }
        }
    }

    public final String getCRLDistributionPointUri(int n2) {
        return this.getCRLDistributionPoint(n2, (byte)6, false);
    }

    public final String getFreshestCRLDistributionPointUri(int n2) {
        return this.getCRLDistributionPoint(n2, (byte)6, true);
    }

    public final String getOCSPResponder(int n2) {
        return this.getAuthorityInfo(1, n2);
    }

    public final String getCAIssuers(int n2) {
        return this.getAuthorityInfo(2, n2);
    }

    public final long getQcLimitValueAmount() {
        try {
            byte[] byArray = Ddec.DerGetElementBuf(this.pExtensions, "F1.3.6.1.5.5.7.1.3obQ=F0.4.0.1862.1.2s");
            int n2 = Ddec.DerGetElementInt(byArray, "SxiI");
            long l2 = Ddec.DerGetElementInt64(byArray, "SxI");
            if (n2 > 20) {
                return 0L;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                l2 *= 10L;
            }
            return l2;
        }
        catch (DdecException ddecException) {
            return 0L;
        }
    }

    public final String getQcLimitValueCurrency() {
        try {
            byte[] byArray = Ddec.DerGetElementBuf(this.pExtensions, "F1.3.6.1.5.5.7.1.3obQ=F0.4.0.1862.1.2Sx");
            if (byArray[0] != 2) {
                return Ddec.DerGetElementStr(byArray, "C");
            }
            int n2 = Ddec.DerGetElementInt(byArray, "I");
            if (n2 > 999 || n2 < 0) {
                return null;
            }
            return Integer.toString(n2);
        }
        catch (DdecException ddecException) {
            return null;
        }
    }

    public final boolean isValidAtTime(long l2) throws CertificateException {
        if (l2 == 0L) {
            l2 = System.currentTimeMillis();
        }
        return l2 >= this.getNotBefore() && l2 <= this.getNotAfter();
    }

    public final boolean isEqualTo(Certificate certificate) {
        return Arrays.equals(certificate.cer, this.cer);
    }

    public final boolean isEqualTo(byte[] byArray) {
        return Arrays.equals(byArray, this.cer);
    }

    public final boolean isMyIdentifier(byte[] byArray) {
        if (byArray.length < 3) {
            return false;
        }
        if (byArray[0] != 48) {
            if (byArray[0] != 4 || byArray[1] == 0 || byArray[1] > 127) {
                return false;
            }
            byte[] byArray2 = this.getSubjectKeyIdentifier();
            if (byArray2 == null || byArray2.length != byArray.length - 2) {
                return false;
            }
            for (int i2 = 0; i2 < byArray2.length; ++i2) {
                if (byArray2[i2] == byArray[i2 + 2]) continue;
                return false;
            }
            return true;
        }
        try {
            byte[] byArray3 = Ddec.DerGetElementBuf(byArray, "Ssi");
            if (!Arrays.equals(byArray3, this.getSerial())) {
                return false;
            }
            byte[] byArray4 = Ddec.DerGetElementBuf(byArray, "Ss");
            return Arrays.equals(byArray4, this.getIssuerDN());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public final byte[] getPublicKeyInfo() {
        return this.pPublicKey;
    }

    public final byte[] getPublicKeyAlg() {
        return Ddec.TryGetElementBuf(this.pPublicKey, "Ss");
    }

    public final String getPublicKeyAlgOid() {
        return Ddec.TryGetElementOid(this.pPublicKey, "SSD");
    }

    public final byte[] getPublicKeyAlgParams() {
        try {
            return Ddec.DerGetElementBuf(this.pPublicKey, "SSdx");
        }
        catch (DdecException ddecException) {
            return null;
        }
    }

    public final byte[] getPublicKey() throws CertificateException {
        try {
            return Ddec.DerGetElementBuf(this.pPublicKey, "SsG");
        }
        catch (DdecException ddecException) {
            throw new CertificateException(-9);
        }
    }

    public final byte[] getSignatureAlg() throws CertificateException {
        try {
            return Ddec.DerGetElementBuf(this.cer, "Sss");
        }
        catch (DdecException ddecException) {
            throw new CertificateException(-9);
        }
    }

    public final String getSignatureAlgOid() throws CertificateException {
        try {
            return Ddec.DerGetElementOid(this.cer, "SsSD");
        }
        catch (DdecException ddecException) {
            throw new CertificateException(-9);
        }
    }

    public final byte[] getSignatureAlgParams() {
        try {
            byte[] byArray = Ddec.DerGetElementBuf(this.cer, "SsSdx");
            if (byArray.length == 2) {
                return null;
            }
            return byArray;
        }
        catch (DdecException ddecException) {
            return null;
        }
    }

    public final Two<Pointer, Integer> getSignedDataPtr() throws CertificateException {
        try {
            return Ddec.DerGetElementPtr(this.cer, "Ss");
        }
        catch (DdecException ddecException) {
            throw new CertificateException(-9);
        }
    }

    public final Two<Pointer, Integer> getSignaturePtr() throws CertificateException {
        try {
            return Ddec.DerGetElementPtr(this.cer, "SssG");
        }
        catch (DdecException ddecException) {
            throw new CertificateException(-9);
        }
    }

    private void loadFromFile(String string) throws CertificateException, IOException {
        File file = new File(string);
        if (!file.exists()) {
            throw new CertificateException(-3);
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        this.cer = new byte[(int)file.length()];
        fileInputStream.read(this.cer);
        fileInputStream.close();
        if (this.cer.length != Ddec.DerGetTotalSize(this.cer)) {
            throw new CertificateException(-9);
        }
        this.refreshState();
    }

    private void loadFromMemory(byte[] byArray) throws CertificateException {
        int n2 = byArray.length;
        if (n2 <= 8 || Ddec.DerGetTotalSize(byArray) != n2) {
            throw new CertificateException(-9);
        }
        this.cer = (byte[])byArray.clone();
        this.refreshState();
    }

    private void refreshState() throws CertificateException {
        Two<Pointer, Integer> two;
        try {
            two = Ddec.DerGetElementPtr(this.cer, "SSoe0isssss");
            this.pPublicKey = ((Pointer)two.first).Copy((Integer)two.second);
            Ddec.DerGetElementPtr(this.pPublicKey, "SSD");
        }
        catch (DdecException ddecException) {
            throw new CertificateException(-9);
        }
        try {
            two = Ddec.DerGetElementPtr(this.cer, "SSoe0isssssoy1oy2E3s");
            this.pExtensions = ((Pointer)two.first).Copy((Integer)two.second);
        }
        catch (DdecException ddecException) {
            this.pExtensions = this.emptyExtensions;
        }
    }

    private Three<Pointer, Integer, Boolean> getExtensionPtr(String string) throws DdecException {
        String string2 = "f" + string;
        boolean bl = false;
        try {
            bl = Ddec.DerGetElementBool(this.pExtensions, string2 + "B");
        }
        catch (DdecException ddecException) {
            // empty catch block
        }
        Two<Pointer, Integer> two = Ddec.DerGetElementPtr(this.pExtensions, string2 + "obQ");
        return new Three<Pointer, Integer, Boolean>((Pointer)two.first, (Integer)two.second, bl);
    }

    private String getCRLDistributionPoint(int n2, byte by, boolean bl) {
        String string = "Y" + (char)(by + 48);
        String string2 = "f2.5.29.31 obQ=S";
        if (bl) {
            string2 = "f2.5.29.46 obQ=S";
        }
        Ddec.DerSearchRec derSearchRec = Ddec.DerFindFirstElement(this.pExtensions, string2);
        while (derSearchRec != null) {
            if (n2 == 0) {
                String string3 = "";
                Ddec.DerSearchRec derSearchRec2 = Ddec.DerFindFirstElement(derSearchRec.der, "SE0E0");
                while (derSearchRec2 != null) {
                    try {
                        byte[] byArray = Ddec.DerGetElementBuf(derSearchRec2.der, string);
                        string3 = string3.equals("") ? new String(byArray, "UTF8") : string3 + "|" + new String(byArray, "UTF8");
                    }
                    catch (DdecException ddecException) {
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    derSearchRec2 = Ddec.DerFindNextElement(derSearchRec2);
                }
                return string3;
            }
            --n2;
            derSearchRec = Ddec.DerFindNextElement(derSearchRec);
        }
        return "";
    }

    private String getRdnAttributeStr(byte[] byArray, String string) {
        String string2 = string;
        if (string.charAt(0) >= 'A') {
            string2 = "";
            for (ST_X509KeyOidts sT_X509KeyOidts : X500KeysOids) {
                if (!string.equals(sT_X509KeyOidts.key)) continue;
                string2 = sT_X509KeyOidts.oid;
                break;
            }
            if (string2.equals("")) {
                return null;
            }
        }
        String string3 = "F" + string2 + "C";
        try {
            return Ddec.DerGetElementStr(byArray, string3);
        }
        catch (DdecException ddecException) {
            return null;
        }
    }

    private String getAuthorityInfo(int n2, int n3) {
        byte[] byArray = new byte[]{6, 8, 43, 6, 1, 5, 5, 7, 48, (byte)n2};
        Ddec.DerSearchRec derSearchRec = Ddec.DerFindFirstElement(this.pExtensions, "f1.3.6.1.5.5.7.1.1 obQ=S");
        while (derSearchRec != null) {
            block7: {
                try {
                    Two<Pointer, Integer> two = Ddec.DerGetElementPtr(derSearchRec.der, "Sd");
                    if (!((Pointer)two.first).CompareTo(byArray)) break block7;
                    try {
                        byte[] byArray2 = Ddec.DerGetElementBuf(derSearchRec.der, "SdY6");
                        if (n3 == 0) {
                            return new String(byArray2, "UTF8");
                        }
                        --n3;
                    }
                    catch (DdecException ddecException) {
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        return null;
                    }
                }
                catch (DdecException ddecException) {
                    // empty catch block
                }
            }
            derSearchRec = Ddec.DerFindNextElement(derSearchRec);
        }
        return null;
    }

    public String toString() {
        if (this.cer != null) {
            try {
                return this.getSubjectName("2.5.4.3");
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        return super.toString();
    }

    static class ST_X509KeyOidts {
        public String key;
        public String oid;

        public ST_X509KeyOidts(String string, String string2) {
            this.key = string;
            this.oid = string2;
        }
    }
}

