/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor.DsLib;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import ua.avtor.DsLib.Certificate;
import ua.avtor.DsLib.CertificateException;
import ua.avtor.DsLib.DsDataCorruptedException;
import ua.avtor.DsLib.Utils.Ddec;
import ua.avtor.DsLib.Utils.DdecException;
import ua.avtor.DsLib.Utils.Pointer;
import ua.avtor.DsLib.Utils.Two;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertRevocationList {
    static final int REASON_NOT_IN_CRL = -1;
    static final int REASON_UNSPECIFIED = 0;
    static final int REASON_HOLD = 6;
    static final int REASON_REMOVE = 8;
    static final int ERR_FILE_NOT_FOUND = -3;
    static final int ERR_CORRUPTED = -9;
    final byte[] emptyExtensions = new byte[]{48, 0};
    byte[] crl;
    byte[] pExtensions;

    public CertRevocationList() {
    }

    public CertRevocationList(String string) throws CertificateException, IOException {
        File file = new File(string);
        if (!file.exists()) {
            throw new CertificateException(-3);
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        this.crl = new byte[(int)file.length()];
        fileInputStream.read(this.crl);
        fileInputStream.close();
        if (this.crl.length != Ddec.DerGetTotalSize(this.crl)) {
            throw new CertificateException(-9);
        }
        this.refreshState();
    }

    public CertRevocationList(byte[] byArray) throws CertificateException {
        int n2 = byArray.length;
        if (n2 <= 8 || Ddec.DerGetTotalSize(byArray) != n2) {
            throw new CertificateException(-9);
        }
        this.crl = (byte[])byArray.clone();
        this.refreshState();
    }

    public CertRevocationList clone() {
        CertRevocationList certRevocationList = new CertRevocationList();
        certRevocationList.crl = this.crl;
        certRevocationList.pExtensions = this.pExtensions;
        return certRevocationList;
    }

    public final byte[] getEncoded() {
        return this.crl;
    }

    public final byte[] getIssuerDN() throws CertificateException {
        try {
            return Ddec.DerGetElementBuf(this.crl, "SSoiss");
        }
        catch (DdecException ddecException) {
            throw new CertificateException(-9);
        }
    }

    public final long thisUpdate() throws DsDataCorruptedException {
        try {
            return Ddec.DerGetElementTime(this.crl, "SSoissT");
        }
        catch (DdecException ddecException) {
            throw new DsDataCorruptedException();
        }
    }

    public final long nextUpdate() {
        try {
            return Ddec.DerGetElementTime(this.crl, "SSoisstT");
        }
        catch (DdecException ddecException) {
            return 0L;
        }
    }

    public final boolean isValidAtTime(long l2) throws DsDataCorruptedException {
        long l3 = this.nextUpdate();
        if (l2 == 0L) {
            l2 = System.currentTimeMillis();
        }
        if (l3 == 0L) {
            l3 = l2;
        }
        return l2 >= this.thisUpdate() && l2 <= l3;
    }

    public final boolean isSignedBy(Certificate certificate) throws CertificateException {
        try {
            Two<Pointer, Integer> two = Ddec.DerGetElementPtr(this.crl, "SSoiss");
            byte[] byArray = certificate.getSubjectDN();
            return ((Pointer)two.first).CompareTo(byArray);
        }
        catch (DdecException ddecException) {
            throw new CertificateException(-9);
        }
    }

    public final boolean isDelta() {
        try {
            Ddec.DerGetElementNull(this.pExtensions, "F2.5.29.27obQ");
            return true;
        }
        catch (DdecException ddecException) {
            return false;
        }
    }

    public final long getCrlNumber() {
        long l2 = 0L;
        try {
            l2 = Ddec.DerGetElementInt64(this.pExtensions, "F2.5.29.20obQI");
        }
        catch (DdecException ddecException) {
            // empty catch block
        }
        return l2;
    }

    public final long getBaseCrlNumber() {
        long l2 = 0L;
        try {
            l2 = Ddec.DerGetElementInt64(this.pExtensions, "F2.5.29.27obQI");
        }
        catch (DdecException ddecException) {
            // empty catch block
        }
        return l2;
    }

    public final boolean isCertificateValid(Certificate certificate) throws DsDataCorruptedException, CertificateException {
        return (Boolean)this.isCertificateValidAt((Certificate)certificate, (long)System.currentTimeMillis()).first;
    }

    public final Two<Boolean, Integer> isCertificateValidAt(Certificate certificate, long l2) throws CertificateException, DsDataCorruptedException {
        byte[] byArray = certificate.getSerial();
        int n2 = byArray.length;
        int n3 = 0;
        int n4 = -1;
        Ddec.DerSearchRec derSearchRec = Ddec.DerFindFirstElement(this.crl, "SSoisstotS");
        while (derSearchRec != null) {
            Two<Pointer, Integer> two;
            try {
                two = Ddec.DerGetElementPtr(derSearchRec.der, "Si");
            }
            catch (DdecException ddecException) {
                throw new DsDataCorruptedException();
            }
            if (n2 == (Integer)two.second && ((Pointer)two.first).CompareTo(byArray)) {
                long l3;
                try {
                    l3 = Ddec.DerGetElementTime(derSearchRec.der, "SiT");
                }
                catch (DdecException ddecException) {
                    throw new DsDataCorruptedException();
                }
                if (l3 > l2) break;
                n4 = 0;
                try {
                    two = Ddec.DerGetElementPtr(derSearchRec.der, "SitF2.5.29.21obQZ");
                    n4 = ((Pointer)two.first).Get();
                }
                catch (DdecException ddecException) {
                    // empty catch block
                }
                if (n4 == 6) {
                    n3 = 17;
                } else if (n4 == 8) {
                    n3 = 16;
                } else {
                    n3 = 49;
                    break;
                }
            }
            derSearchRec = Ddec.DerFindNextElement(derSearchRec);
        }
        return new Two<Boolean, Integer>(!(n3 & true), n4);
    }

    public final byte[] getSignatureAlg() throws CertificateException {
        try {
            return Ddec.DerGetElementBuf(this.crl, "Sss");
        }
        catch (DdecException ddecException) {
            throw new CertificateException(-9);
        }
    }

    public final String getSignatureAlgOid() throws CertificateException {
        try {
            return Ddec.DerGetElementOid(this.crl, "SsSD");
        }
        catch (DdecException ddecException) {
            throw new CertificateException(-9);
        }
    }

    public final byte[] getSignatureAlgParams() {
        try {
            byte[] byArray = Ddec.DerGetElementBuf(this.crl, "SsSdx");
            if (byArray.length == 2) {
                return null;
            }
            return byArray;
        }
        catch (DdecException ddecException) {
            return null;
        }
    }

    public final Two<Pointer, Integer> getSignedDataPtr() throws CertificateException {
        try {
            return Ddec.DerGetElementPtr(this.crl, "Ss");
        }
        catch (DdecException ddecException) {
            throw new CertificateException(-9);
        }
    }

    public final Two<Pointer, Integer> getSignaturePtr() throws CertificateException {
        try {
            return Ddec.DerGetElementPtr(this.crl, "SssG");
        }
        catch (DdecException ddecException) {
            throw new CertificateException(-9);
        }
    }

    void refreshState() throws CertificateException {
        try {
            Ddec.DerGetElementNull(this.crl, "SSoisst");
        }
        catch (DdecException ddecException) {
            throw new CertificateException(-9);
        }
        try {
            this.pExtensions = Ddec.DerGetElementBuf(this.crl, "SSoisstotsE0s");
        }
        catch (DdecException ddecException) {
            this.pExtensions = this.emptyExtensions;
        }
    }
}

