/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor.DsLib.Algorithms;

import java.io.UnsupportedEncodingException;
import ua.avtor.DsLib.Algorithms.ContentEncryptionAlg;
import ua.avtor.DsLib.Algorithms.CryptoAlgorithmFactory;
import ua.avtor.DsLib.Algorithms.CryptolibAlgFactory;
import ua.avtor.DsLib.Algorithms.MessageDigestAlg;
import ua.avtor.DsLib.Algorithms.PasswordBasedAlg;
import ua.avtor.DsLib.DsAlgorithmException;
import ua.avtor.DsLib.DsDataCorruptedException;
import ua.avtor.DsLib.DsException;
import ua.avtor.DsLib.Utils.ArrayUtil;
import ua.avtor.DsLib.Utils.Ddec;
import ua.avtor.DsLib.Utils.DdecException;
import ua.avtor.DsLib.Utils.DerEncoder;

public class PasswordBasedPBES2
extends PasswordBasedAlg {
    private String oid;
    private String prfOid;
    private String encOid;
    private byte[] encParam;
    private byte[] salt;
    private int iterations;
    private ContentEncryptionAlg encryptor;
    private MessageDigestAlg digester;

    protected byte[] genPbKdf2(String string, CryptoAlgorithmFactory cryptoAlgorithmFactory, int n2) {
        byte[] byArray = new byte[]{};
        try {
            byArray = string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        MessageDigestAlg messageDigestAlg = cryptoAlgorithmFactory.getHmacAlg(this.prfOid, null, byArray);
        byte[] byArray2 = null;
        byte[] byArray3 = new byte[4];
        do {
            byte[] byArray4;
            byArray3[3] = (byte)(byArray3[3] + 1);
            messageDigestAlg.update(this.salt);
            messageDigestAlg.update(byArray3);
            byte[] byArray5 = byArray4 = messageDigestAlg.getDigest();
            for (int i2 = 1; i2 < this.iterations; ++i2) {
                messageDigestAlg.update(byArray4);
                byArray4 = messageDigestAlg.getDigest();
                for (int i3 = 0; i3 < byArray4.length; ++i3) {
                    int n3 = i3;
                    byArray5[n3] = (byte)(byArray5[n3] ^ byArray4[i3]);
                }
            }
            if (byArray2 == null) {
                byArray2 = byArray5;
                continue;
            }
            byArray2 = ArrayUtil.resizeOf(byArray2, byArray2.length + byArray5.length);
            System.arraycopy(byArray5, 0, byArray2, byArray2.length - byArray5.length, byArray5.length);
        } while (byArray2.length < n2);
        ArrayUtil.clear(byArray);
        return byArray2;
    }

    public PasswordBasedPBES2(String string, String string2, byte[] byArray, CryptoAlgorithmFactory cryptoAlgorithmFactory) throws DsException {
        this.oid = string2;
        String string3 = Ddec.TryGetElementOid(byArray, "SSD");
        if (string3 == null || !string3.equals("1.2.840.113549.1.5.12")) {
            throw new DsAlgorithmException("unknown PbeKdf");
        }
        this.prfOid = Ddec.TryGetElementOid(byArray, "SSd SqioiSD");
        if (this.prfOid == null) {
            this.prfOid = "1.3.6.1.5.5.8.1.2";
        }
        this.salt = Ddec.TryGetElementBuf(byArray, "SSd SQ");
        try {
            this.iterations = Ddec.DerGetElementInt(byArray, "SSd SqI");
        }
        catch (DdecException ddecException) {
            throw new DsDataCorruptedException("kdf2");
        }
        this.encOid = Ddec.TryGetElementOid(byArray, "SsSD");
        this.encParam = Ddec.TryGetElementBuf(byArray, "SsSdx");
        byte[] byArray2 = this.genPbKdf2(string, cryptoAlgorithmFactory, 32);
        if (string2.endsWith("14")) {
            this.digester = cryptoAlgorithmFactory.getMacingAlg(this.encOid, this.encParam, byArray2);
        } else {
            this.encryptor = cryptoAlgorithmFactory.getEncryptionAlg(this.encOid, this.encParam, byArray2);
        }
        ArrayUtil.clear(byArray2);
    }

    public PasswordBasedPBES2(String string, String string2, byte[] byArray, int n2, String string3, String string4, CryptolibAlgFactory cryptolibAlgFactory) {
        byte[] byArray2;
        this.oid = string2;
        this.salt = byArray;
        this.iterations = n2;
        this.prfOid = string3;
        this.encOid = string4;
        if (string2.endsWith("13")) {
            this.encryptor = cryptolibAlgFactory.getEncryptionAlg(this.encOid, null, null);
            if (this.encryptor != null) {
                this.encParam = this.encryptor.getParams();
                byArray2 = this.genPbKdf2(string, cryptolibAlgFactory, this.encryptor.getKeySize());
                this.encryptor = cryptolibAlgFactory.getEncryptionAlg(this.encOid, this.encParam, byArray2);
                ArrayUtil.clear(byArray2);
            }
        }
        if (string2.endsWith("14")) {
            this.digester = cryptolibAlgFactory.getMacingAlg(this.encOid, null, null);
            if (this.digester != null) {
                this.encParam = this.digester.getParams();
                byArray2 = this.genPbKdf2(string, cryptolibAlgFactory, this.digester.getBlockSize());
                this.digester = cryptolibAlgFactory.getMacingAlg(this.encOid, this.encParam, byArray2);
                ArrayUtil.clear(byArray2);
            }
        }
    }

    public String getOid() {
        return this.oid;
    }

    public byte[] getParams() {
        DerEncoder derEncoder = new DerEncoder();
        derEncoder.SeqBegin();
        derEncoder.SeqBegin();
        derEncoder.addOid("1.2.840.113549.1.5.12");
        derEncoder.SeqBegin();
        derEncoder.addOctets(this.salt);
        derEncoder.addInteger(this.iterations);
        derEncoder.SeqBegin();
        derEncoder.addOid(this.prfOid);
        derEncoder.addNull();
        derEncoder.SeqEnd();
        derEncoder.SeqEnd();
        derEncoder.SeqEnd();
        derEncoder.SeqBegin();
        derEncoder.addOid(this.encOid);
        derEncoder.addDerParams(this.encParam);
        derEncoder.SeqEnd();
        derEncoder.SeqEnd();
        return derEncoder.getEncoded();
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public int getIterations() {
        return this.iterations;
    }

    public String getKdf2PrfOid() {
        return this.prfOid;
    }

    public String getPbe2EncOid() {
        return this.encOid;
    }

    public ContentEncryptionAlg getEncryptor() {
        return this.encryptor;
    }

    public MessageDigestAlg getDigester() {
        return this.digester;
    }
}

