/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor.DsLib.Algorithms;

import ua.avtor.DsLib.Algorithms.ContentEncryptionAlg;
import ua.avtor.DsLib.Algorithms.CryptoAlgorithmFactory;
import ua.avtor.DsLib.Algorithms.MessageDigestAlg;
import ua.avtor.DsLib.Algorithms.PasswordBasedAlg;
import ua.avtor.DsLib.Utils.ArrayUtil;
import ua.avtor.DsLib.Utils.DerEncoder;

public class PasswordBasedPBES1
extends PasswordBasedAlg {
    private String oid;
    private byte[] salt;
    private int iterations;
    private ContentEncryptionAlg encryptor;
    private MessageDigestAlg digester;

    byte[] genPbKdf1(String string, MessageDigestAlg messageDigestAlg, int n2, byte[] byArray, int n3, CryptoAlgorithmFactory cryptoAlgorithmFactory) {
        int n4;
        int n5 = messageDigestAlg.getBlockSize();
        byte[] byArray2 = new byte[n5];
        byte[] byArray3 = ArrayUtil.AsBigEndianUnicode(string);
        for (int i2 = 0; i2 < n5; ++i2) {
            byArray2[i2] = (byte)n2;
        }
        byte[] byArray4 = new byte[n5 * 2];
        for (n4 = 0; n4 < n5; ++n4) {
            byArray4[n4] = byArray[n4 % byArray.length];
        }
        for (n4 = 0; n4 < n5; ++n4) {
            int n6 = n4 % (byArray3.length + 2);
            if (n6 >= byArray3.length) continue;
            byArray4[n5 + n4] = byArray3[n6];
        }
        byte[] byArray5 = null;
        do {
            int n7;
            int n8;
            messageDigestAlg.update(byArray2);
            messageDigestAlg.update(byArray4);
            byte[] byArray6 = messageDigestAlg.getDigest();
            for (n8 = 1; n8 < n3; ++n8) {
                messageDigestAlg.update(byArray6);
                byArray6 = messageDigestAlg.getDigest();
            }
            if (byArray5 == null) {
                byArray5 = byArray6;
            } else {
                byArray5 = ArrayUtil.resizeOf(byArray5, byArray5.length + byArray6.length);
                System.arraycopy(byArray6, 0, byArray5, byArray5.length - byArray6.length, byArray6.length);
            }
            n8 = 1;
            for (n7 = n5 - 1; n7 >= 0; --n7) {
                n8 = n8 + (byArray4[n7] & 0xFF) + (byArray6[n7 % byArray6.length] & 0xFF);
                byArray4[n7] = (byte)n8;
                n8 >>>= 8;
            }
            n8 = 1;
            for (n7 = n5 - 1; n7 >= 0; --n7) {
                n8 = n8 + (byArray4[n5 + n7] & 0xFF) + (byArray6[n7 % byArray6.length] & 0xFF);
                byArray4[n5 + n7] = (byte)n8;
                n8 >>>= 8;
            }
        } while (n2 == 1 && byArray5.length < 32);
        ArrayUtil.clear(byArray3);
        return byArray5;
    }

    public PasswordBasedPBES1(String string, String string2, MessageDigestAlg messageDigestAlg, byte[] byArray, int n2, CryptoAlgorithmFactory cryptoAlgorithmFactory) {
        this.oid = string2;
        this.salt = byArray;
        this.iterations = n2;
        if (string2.equals(messageDigestAlg.getOid())) {
            byte[] byArray2 = this.genPbKdf1(string, messageDigestAlg, 3, byArray, n2, cryptoAlgorithmFactory);
            this.digester = cryptoAlgorithmFactory.getHmacAlg(string2, null, byArray2);
        } else {
            byte[] byArray3 = this.genPbKdf1(string, messageDigestAlg, 1, byArray, n2, cryptoAlgorithmFactory);
            byte[] byArray4 = this.genPbKdf1(string, messageDigestAlg, 2, byArray, n2, cryptoAlgorithmFactory);
            byte[] byArray5 = new byte[10];
            System.arraycopy(byArray4, 0, byArray5, 2, 8);
            byArray5[0] = 4;
            byArray5[1] = 8;
            this.encryptor = cryptoAlgorithmFactory.getEncryptionAlg(string2, byArray5, byArray3);
        }
        messageDigestAlg = null;
    }

    public String getOid() {
        return this.oid;
    }

    public byte[] getParams() {
        DerEncoder derEncoder = new DerEncoder();
        derEncoder.SeqBegin();
        derEncoder.addOctets(this.salt);
        derEncoder.addInteger(this.iterations);
        derEncoder.SeqEnd();
        return derEncoder.getEncoded();
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public int getIterations() {
        return this.iterations;
    }

    public String getKdf2PrfOid() {
        return null;
    }

    public String getPbe2EncOid() {
        return null;
    }

    public ContentEncryptionAlg getEncryptor() {
        return this.encryptor;
    }

    public MessageDigestAlg getDigester() {
        return this.digester;
    }
}

