/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor.DsLib.Algorithms;

import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import ua.avtor.DsLib.Algorithms.MessageVerifierAlg;
import ua.avtor.DsLib.Certificate;

public class MessageVerifierRsa15
extends MessageVerifierAlg {
    private Signature h;
    private boolean initialized = false;

    MessageVerifierRsa15(String string, byte[] byArray, Certificate certificate, String string2) throws NoSuchAlgorithmException {
        byte[] byArray2 = certificate.getPublicKeyInfo();
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray2);
        this.h = Signature.getInstance(string2);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        try {
            PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            this.h.initVerify(publicKey);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            return;
        }
        catch (InvalidKeyException invalidKeyException) {
            return;
        }
        this.initialized = true;
    }

    public void update(byte[] byArray) {
        try {
            this.h.update(byArray);
        }
        catch (SignatureException signatureException) {
            this.initialized = false;
        }
    }

    public void update(byte[] byArray, int n2, int n3) {
        try {
            this.h.update(byArray, n2, n3);
        }
        catch (SignatureException signatureException) {
            this.initialized = false;
        }
    }

    public boolean verify(byte[] byArray) {
        if (!this.initialized) {
            return false;
        }
        try {
            return this.h.verify(byArray);
        }
        catch (SignatureException signatureException) {
            return false;
        }
    }
}

