/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor.DsLib.Algorithms;

import java.math.BigInteger;
import ua.avtor.DsLib.Algorithms.MessageDigestAlg;
import ua.avtor.DsLib.Algorithms.MessageVerifierAlg;
import ua.avtor.DsLib.Certificate;
import ua.avtor.DsLib.Utils.Ddec;
import ua.avtor.DsLib.Utils.DdecException;
import ua.kiev.author.cryptolib.EcPoint;
import ua.kiev.author.cryptolib.Ecc4145;

public class MessageVerifierDstu4145
extends MessageVerifierAlg {
    private MessageDigestAlg digestAlg;
    private Ecc4145 ecc;
    private EcPoint keyQ;
    private boolean initialized;

    static void reverse(byte[] byArray) {
        for (int i2 = 0; i2 < byArray.length / 2; ++i2) {
            byte by = byArray[i2];
            byArray[i2] = byArray[byArray.length - i2 - 1];
            byArray[byArray.length - i2 - 1] = by;
        }
    }

    static boolean initializeEccByCert(Certificate certificate, Ecc4145 ecc4145, EcPoint ecPoint) {
        int[] nArray;
        Object object;
        byte[] byArray;
        boolean bl = false;
        String string = certificate.getPublicKeyAlgOid();
        if (!string.equals("1.2.804.2.1.1.1.1.3.1.1")) {
            if (string.equals("1.2.804.2.1.1.1.1.3.1.1.1.1")) {
                bl = true;
            } else {
                return false;
            }
        }
        byte[] byArray2 = certificate.getPublicKeyInfo();
        try {
            byArray = Ddec.DerGetElementBuf(byArray2, "SSdSx");
        }
        catch (DdecException ddecException) {
            return false;
        }
        if (byArray[0] == 6) {
            if (!ecc4145.SetStdParamsByEncodedOid(byArray, 0)) {
                return false;
            }
        } else {
            BigInteger bigInteger;
            int[] nArray2;
            byte[] byArray3;
            int n2;
            int n3;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            try {
                n3 = Ddec.DerGetElementInt(byArray, "Soe0SI");
                if (Ddec.DerIsElementPresent(byArray, "Soe0SiI")) {
                    n4 = Ddec.DerGetElementInt(byArray, "Soe0SiI");
                } else if (Ddec.DerIsElementPresent(byArray, "Soe0SiSI")) {
                    n6 = Ddec.DerGetElementInt(byArray, "Soe0SiSI");
                    n5 = Ddec.DerGetElementInt(byArray, "Soe0SiSiI");
                    n4 = Ddec.DerGetElementInt(byArray, "Soe0SiSiiI");
                }
            }
            catch (DdecException ddecException) {
                return false;
            }
            if (!ecc4145.SetBaseField(n3, n4, n5, n6)) {
                return false;
            }
            try {
                n2 = Ddec.DerGetElementInt(byArray, "Soe0sI");
                byArray3 = Ddec.DerGetElementBuf(byArray, "Soe0siQ");
                nArray2 = bl ? ecc4145.fromByteArrayEl(byArray3) : ecc4145.fromByteArrayLsbEl(byArray3);
                byArray3 = Ddec.DerGetElementBuf(byArray, "Soe0siqI");
                bigInteger = new BigInteger(byArray3);
            }
            catch (DdecException ddecException) {
                return false;
            }
            if (!ecc4145.SetCurve(n2, nArray2, bigInteger)) {
                return false;
            }
            try {
                byArray3 = Ddec.DerGetElementBuf(byArray, "Soe0siqiQ");
                int[] nArray3 = bl ? ecc4145.fromByteArrayEl(byArray3) : ecc4145.fromByteArrayLsbEl(byArray3);
                EcPoint ecPoint2 = ecc4145.ExpandPoint(nArray3);
                if (!ecc4145.SetBasePoint(ecPoint2)) {
                    return false;
                }
            }
            catch (DdecException ddecException) {
                return false;
            }
        }
        try {
            object = Ddec.DerGetElementBuf(byArray2, "SsG=Q");
            if (bl) {
                nArray = ecc4145.fromByteArrayEl((byte[])object);
            } else {
                MessageVerifierDstu4145.reverse(object);
                nArray = ecc4145.fromByteArrayEl((byte[])object);
            }
        }
        catch (DdecException ddecException) {
            return false;
        }
        object = ecc4145.ExpandPoint(nArray);
        ecPoint.update(object.x, object.y);
        return true;
    }

    MessageVerifierDstu4145(String string, byte[] byArray, Certificate certificate, MessageDigestAlg messageDigestAlg) {
        this.digestAlg = messageDigestAlg;
        this.initialized = false;
        this.ecc = new Ecc4145();
        this.keyQ = new EcPoint();
        if (!MessageVerifierDstu4145.initializeEccByCert(certificate, this.ecc, this.keyQ)) {
            return;
        }
        this.initialized = true;
    }

    public void update(byte[] byArray, int n2, int n3) {
        this.digestAlg.update(byArray, n2, n3);
    }

    public void update(byte[] byArray) {
        this.digestAlg.update(byArray, 0, byArray.length);
    }

    public boolean verify(byte[] byArray) {
        if (!this.initialized) {
            return false;
        }
        if (byArray.length < 2) {
            return false;
        }
        byte[] byArray2 = this.digestAlg.getDigest();
        if (byArray.length <= this.ecc.SignSize) {
            return this.ecc.Check(this.keyQ, byArray2, byArray);
        }
        int n2 = 0;
        if (byArray[0] == 4) {
            if (byArray.length <= 129) {
                if (byArray[1] == byArray.length - 2) {
                    n2 = 2;
                }
            } else if ((byArray[1] & 0xFF) == 129 && (byArray[2] & 0xFF) == byArray.length - 3) {
                n2 = 3;
            }
        }
        if (n2 > 0) {
            byte[] byArray3 = new byte[byArray.length - n2];
            System.arraycopy(byArray, n2, byArray3, 0, byArray.length - n2);
            boolean bl = this.ecc.Check(this.keyQ, byArray2, byArray3);
            if (bl) {
                return true;
            }
            if (byArray.length > this.ecc.BaseSize * 2) {
                return false;
            }
        }
        return this.ecc.Check(this.keyQ, byArray2, byArray);
    }
}

