/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor.DsLib.Algorithms;

import ua.avtor.DsLib.Algorithms.MessageDigestAlg;

public class MessageHmacGeneral
extends MessageDigestAlg {
    private MessageDigestAlg digestAlg;
    private byte[] key;
    private boolean initialized;

    public MessageHmacGeneral(MessageDigestAlg messageDigestAlg, byte[] byArray) {
        this.digestAlg = messageDigestAlg;
        this.initialized = false;
        if (byArray.length > messageDigestAlg.getBlockSize()) {
            messageDigestAlg.update(byArray);
            this.key = messageDigestAlg.getDigest();
        } else {
            this.key = (byte[])byArray.clone();
        }
    }

    protected void finalize() throws Throwable {
        if (this.key != null) {
            for (int i2 = 0; i2 < this.key.length; ++i2) {
                this.key[i2] = 0;
            }
        }
        super.finalize();
    }

    private void startHmac(int n2) {
        int n3 = this.digestAlg.getBlockSize();
        byte[] byArray = new byte[n3];
        System.arraycopy(this.key, 0, byArray, 0, this.key.length);
        int n4 = 0;
        while (n4 < n3) {
            int n5 = n4++;
            byArray[n5] = (byte)(byArray[n5] ^ n2);
        }
        this.digestAlg.update(byArray);
    }

    public String getOid() {
        return this.digestAlg.getOid();
    }

    public byte[] getParams() {
        return this.digestAlg.getParams();
    }

    public int getBlockSize() {
        return this.digestAlg.getBlockSize();
    }

    public void update(byte[] byArray) {
        if (!this.initialized) {
            this.startHmac(54);
            this.initialized = true;
        }
        this.digestAlg.update(byArray);
    }

    public void update(byte[] byArray, int n2, int n3) {
        if (!this.initialized) {
            this.startHmac(54);
            this.initialized = true;
        }
        this.digestAlg.update(byArray, n2, n3);
    }

    public byte[] getDigest() {
        this.initialized = false;
        byte[] byArray = this.digestAlg.getDigest();
        this.startHmac(92);
        this.digestAlg.update(byArray);
        return this.digestAlg.getDigest();
    }
}

