/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor.DsLib.Algorithms;

import java.util.Arrays;
import ua.avtor.DsLib.Algorithms.MessageDigestAlg;
import ua.kiev.author.cryptolib.Gost34311;

public class MessageDigestGost34311
extends MessageDigestAlg {
    private byte[] pParams = null;
    private Gost34311 h;
    static final byte[] gostDefaultSBox = new byte[]{-87, -42, -21, 69, -15, 60, 112, -126, -128, -60, -106, 123, 35, 31, 94, -83, -10, 88, -21, -92, -64, 55, 41, 29, 56, -39, 107, -16, 37, -54, 78, 23, -8, -23, 114, 13, -58, 21, -76, 58, 40, -105, 95, 11, -63, -34, -93, 100, 56, -75, 100, -22, 44, 23, -97, -48, 18, 62, 109, -72, -6, -59, 121, 4};

    static byte[] convertSBoxToU2L(byte[] byArray) {
        byte[] byArray2 = new byte[64];
        int n2 = 0;
        for (int i2 = 0; i2 < 64; ++i2) {
            n2 = (i2 >> 1 & 7) + (i2 & 0xF0);
            byArray2[i2] = (byte)(byArray[n2 + 8] & 0xF0 | byArray[n2] >> 4 & 0xF);
            byArray2[++i2] = (byte)(byArray[n2 + 8] << 4 | byArray[n2] & 0xF);
        }
        return byArray2;
    }

    MessageDigestGost34311(byte[] byArray) {
        byte[] byArray2 = new byte[64];
        if (byArray == null || byArray[0] == 5) {
            System.arraycopy(gostDefaultSBox, 0, byArray2, 0, 64);
        } else {
            if (byArray[0] != 4) {
                throw new IllegalArgumentException();
            }
            switch (byArray[1] & 0xFF) {
                case 64: {
                    System.arraycopy(byArray, 2, byArray2, 0, 64);
                    break;
                }
                case 129: {
                    for (int i2 = 0; i2 < 64; ++i2) {
                        byArray2[i2] = (byte)(byArray[3 + i2 * 2] * 16 + byArray[3 + i2 * 2 + 1]);
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            if (!Arrays.equals(byArray2, gostDefaultSBox)) {
                this.pParams = new byte[66];
                this.pParams[0] = 4;
                this.pParams[1] = 64;
                System.arraycopy(byArray2, 0, this.pParams, 2, 64);
            }
        }
        this.h = new Gost34311(MessageDigestGost34311.convertSBoxToU2L(byArray2), null);
    }

    public String getOid() {
        return "1.2.804.2.1.1.1.1.2.1";
    }

    public byte[] getParams() {
        return this.pParams;
    }

    public int getBlockSize() {
        return 32;
    }

    public void update(byte[] byArray, int n2, int n3) {
        this.h.Hash(byArray, n2, n3);
    }

    public void update(byte[] byArray) {
        this.h.Hash(byArray, 0, byArray.length);
    }

    public byte[] getDigest() {
        return this.h.HashEnd();
    }
}

