/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor.DsLib.Algorithms;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import ua.avtor.DsLib.Algorithms.CryptolibAlgFactory;
import ua.avtor.DsLib.Algorithms.KeyWrapAlg;
import ua.avtor.DsLib.Certificate;

public class KeyWrapRsa15
extends KeyWrapAlg {
    private int mode;
    private Cipher h;
    private byte[] wrappedKey;
    private boolean initialized;

    public KeyWrapRsa15(int n2, Certificate certificate, CryptolibAlgFactory cryptolibAlgFactory) throws NoSuchAlgorithmException {
        this.mode = n2;
        this.initialized = false;
        byte[] byArray = certificate.getPublicKeyInfo();
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
        try {
            this.h = Cipher.getInstance("RSA/ECB/PKCS1PADDING");
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            this.h.init(1, publicKey);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new NoSuchAlgorithmException();
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            return;
        }
        catch (InvalidKeyException invalidKeyException) {
            return;
        }
        this.initialized = true;
    }

    public String getOid() {
        return "1.2.840.113549.1.1.1";
    }

    public byte[] getParams() {
        return new byte[]{5, 0};
    }

    public boolean wrap(byte[] byArray) {
        if (!this.initialized) {
            return false;
        }
        try {
            this.wrappedKey = this.h.doFinal(byArray);
        }
        catch (GeneralSecurityException generalSecurityException) {
            return false;
        }
        return true;
    }

    public byte[] getWrappedKey() {
        return this.wrappedKey;
    }

    public byte[] getEphemeralKey() {
        return null;
    }
}

