/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor.DsLib.Algorithms;

import java.math.BigInteger;
import java.util.Arrays;
import ua.avtor.DsLib.Algorithms.CryptolibAlgFactory;
import ua.avtor.DsLib.Algorithms.KeyWrapAlg;
import ua.avtor.DsLib.Algorithms.MessageDigestGost34311;
import ua.avtor.DsLib.Algorithms.MessageVerifierDstu4145;
import ua.avtor.DsLib.Certificate;
import ua.avtor.DsLib.Utils.Ddec;
import ua.avtor.DsLib.Utils.DdecException;
import ua.kiev.author.cryptolib.EcDHKD;
import ua.kiev.author.cryptolib.EcPoint;
import ua.kiev.author.cryptolib.Ecc4145;
import ua.kiev.author.cryptolib.Gost28147;
import ua.kiev.author.cryptolib.Prng4145A;

public class KeyWrapDstu4145
extends KeyWrapAlg {
    private int mode;
    private boolean withCofactor;
    private boolean formatMSB;
    private boolean initialized;
    private EcPoint keyQ;
    private CryptolibAlgFactory rndAlg;
    private EcDHKD ecdh;
    private byte[] certSBox = new byte[64];
    private byte[] wrappedKey;
    private byte[] ephKey;
    private static final int kwmP112 = 0;
    private static final int kwmP112_COMP = 256;
    private static final int kwmP112_NOCF = 512;
    private static final int kwmAVTOR_KT = 1;
    private static byte[] gostDefaultSBox = new byte[]{-87, -42, -21, 69, -15, 60, 112, -126, -128, -60, -106, 123, 35, 31, 94, -83, -10, 88, -21, -92, -64, 55, 41, 29, 56, -39, 107, -16, 37, -54, 78, 23, -8, -23, 114, 13, -58, 21, -76, 58, 40, -105, 95, 11, -63, -34, -93, 100, 56, -75, 100, -22, 44, 23, -97, -48, 18, 62, 109, -72, -6, -59, 121, 4};

    private static void reverse(byte[] byArray) {
        for (int i2 = 0; i2 < byArray.length / 2; ++i2) {
            byte by = byArray[i2];
            byArray[i2] = byArray[byArray.length - i2 - 1];
            byArray[byArray.length - i2 - 1] = by;
        }
    }

    KeyWrapDstu4145(int n2, boolean bl, Certificate certificate, CryptolibAlgFactory cryptolibAlgFactory) {
        this.mode = n2;
        this.withCofactor = bl;
        this.rndAlg = cryptolibAlgFactory;
        if ((n2 & 0x200) != 0) {
            this.withCofactor = false;
        }
        this.initialized = false;
        Ecc4145 ecc4145 = new Ecc4145(new Prng4145A());
        this.keyQ = new EcPoint();
        if (!MessageVerifierDstu4145.initializeEccByCert(certificate, ecc4145, this.keyQ)) {
            return;
        }
        this.formatMSB = certificate.getPublicKeyAlgOid().equals("1.2.804.2.1.1.1.1.3.1.1.1.1");
        byte[] byArray = certificate.getPublicKeyAlgParams();
        if (!Ddec.DerIsElementPresent(byArray, "SxQ")) {
            System.arraycopy(gostDefaultSBox, 0, this.certSBox, 0, 64);
        } else {
            try {
                byte[] byArray2 = Ddec.DerGetElementBuf(byArray, "SxQ");
                if (byArray2.length == 64) {
                    System.arraycopy(byArray2, 0, this.certSBox, 0, 64);
                } else {
                    for (int i2 = 0; i2 < 64; ++i2) {
                        this.certSBox[i2] = (byte)(byArray2[i2 * 2] * 16 + byArray2[i2 * 2 + 1]);
                    }
                }
            }
            catch (DdecException ddecException) {
                return;
            }
        }
        this.ecdh = new EcDHKD(ecc4145, this.certSBox, true);
        this.initialized = true;
    }

    public String getOid() {
        if (this.mode == 1) {
            return "1.2.804.2.1.1.1.1.3.1.1";
        }
        if (this.withCofactor) {
            return "1.2.804.2.1.1.1.1.3.4";
        }
        return "1.2.804.2.1.1.1.1.3.5";
    }

    public byte[] getParams() {
        if (this.mode == 1) {
            return new byte[]{5, 0};
        }
        return new byte[]{48, 15, 6, 11, 42, -122, 36, 2, 1, 1, 1, 1, 1, 1, 5, 5, 0};
    }

    private boolean wrapAvtorKt(byte[] byArray) {
        Object[] objectArray = this.ecdh.DeriveKeySend(this.keyQ);
        byte[] byArray2 = (byte[])objectArray[1];
        EcPoint ecPoint = (EcPoint)objectArray[2];
        if (byArray.length != 32) {
            return false;
        }
        byte[] byArray3 = new byte[6];
        byte[] byArray4 = new byte[42];
        Gost28147 gost28147 = new Gost28147(MessageDigestGost34311.convertSBoxToU2L(gostDefaultSBox), byArray2);
        gost28147.MAC(byArray, byArray.length);
        gost28147.GetMAC4(byArray3, 2);
        byArray3[0] = 4;
        byArray3[1] = 4;
        byte[] byArray5 = new byte[8];
        this.rndAlg.generateRandom(byArray5);
        System.arraycopy(byArray5, 0, byArray4, 2, 8);
        System.arraycopy(byArray, 0, byArray4, 10, byArray.length);
        gost28147.SetSync(byArray5);
        gost28147.M2Enc(byArray4, 10, byArray.length);
        byArray4[0] = 4;
        byArray4[1] = (byte)(8 + byArray.length);
        int n2 = 2 + byArray4[1];
        Arrays.fill(byArray2, (byte)0);
        gost28147 = null;
        byte[] byArray6 = this.ecdh.toByteArray(ecPoint.x);
        KeyWrapDstu4145.reverse(byArray6);
        this.ephKey = new byte[2 + byArray6.length];
        this.ephKey[0] = 4;
        this.ephKey[1] = (byte)byArray6.length;
        System.arraycopy(byArray6, 0, this.ephKey, 2, byArray6.length);
        byte[] byArray7 = new byte[]{6, 11, 43, 6, 1, 4, 1, -127, -38, 86, 2, 4, 2};
        int n3 = 13 + this.ephKey.length + byArray4.length + 6;
        this.wrappedKey = new byte[2 + n3];
        this.wrappedKey[0] = 48;
        this.wrappedKey[1] = (byte)n3;
        System.arraycopy(byArray7, 0, this.wrappedKey, 2, 13);
        System.arraycopy(this.ephKey, 0, this.wrappedKey, 15, this.ephKey.length);
        System.arraycopy(byArray4, 0, this.wrappedKey, 15 + this.ephKey.length, byArray4.length);
        System.arraycopy(byArray3, 0, this.wrappedKey, 15 + this.ephKey.length + byArray4.length, 6);
        this.ephKey = null;
        return true;
    }

    private boolean wrapUaP112(byte[] byArray) {
        Object object;
        Object object2;
        int n2 = 0;
        byte[] byArray2 = null;
        while (true) {
            object2 = this.ecdh.GetInternalEcc().GeneratePrivateKey();
            object = this.ecdh.GetInternalEcc().CalcPublicKey((BigInteger)object2);
            byte[] byArray3 = this.ecdh.toByteArrayLsb(((EcPoint)object).x);
            if (this.formatMSB) {
                KeyWrapDstu4145.reverse(byArray3);
            }
            this.ephKey = new byte[2 + byArray3.length];
            this.ephKey[0] = 4;
            this.ephKey[1] = (byte)byArray3.length;
            System.arraycopy(byArray3, 0, this.ephKey, 2, byArray3.length);
            int n3 = 2;
            if ((this.mode & 0x100) != 0) {
                n3 = 6;
            }
            if (this.withCofactor) {
                n3 |= 1;
            }
            if ((byArray2 = this.ecdh.DeriveKeyEx(this.keyQ, (BigInteger)object2, n3, null)) != null || (this.mode & 0x100) == 0 || n2 >= 48) break;
            ++n2;
        }
        object2 = null;
        if (byArray2 == null) {
            return false;
        }
        if (byArray.length > 64 || byArray.length < 1) {
            return false;
        }
        object2 = new byte[8];
        this.rndAlg.generateRandom((byte[])object2);
        object = new Gost28147(this.certSBox, byArray2, true);
        this.wrappedKey = ((Gost28147)object).WrapKey((byte[])object2, byArray, 0, byArray.length);
        Arrays.fill(byArray2, (byte)0);
        object = null;
        return true;
    }

    public boolean wrap(byte[] byArray) {
        if (!this.initialized) {
            return false;
        }
        switch (this.mode & 0xFF) {
            case 1: {
                return this.wrapAvtorKt(byArray);
            }
            case 0: {
                return this.wrapUaP112(byArray);
            }
        }
        return false;
    }

    public byte[] getWrappedKey() {
        return this.wrappedKey;
    }

    public byte[] getEphemeralKey() {
        return this.ephKey;
    }
}

