/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor.DsLib.Algorithms;

import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import ua.avtor.DsLib.Algorithms.ContentEncryptionAes;
import ua.avtor.DsLib.Algorithms.ContentEncryptionAlg;
import ua.avtor.DsLib.Algorithms.ContentEncryptionDesRc2;
import ua.avtor.DsLib.Algorithms.CryptolibAlgFactory;
import ua.avtor.DsLib.Algorithms.KeyWrapAlg;
import ua.avtor.DsLib.Algorithms.KeyWrapRsa15;
import ua.avtor.DsLib.Algorithms.MessageDigestAlg;
import ua.avtor.DsLib.Algorithms.MessageDigestJCA;
import ua.avtor.DsLib.Algorithms.MessageVerifierAlg;
import ua.avtor.DsLib.Algorithms.MessageVerifierRsa15;
import ua.avtor.DsLib.Algorithms.PasswordBasedAlg;
import ua.avtor.DsLib.Algorithms.PasswordBasedPBES1;
import ua.avtor.DsLib.Certificate;
import ua.avtor.DsLib.DsException;
import ua.avtor.DsLib.PrivateKeys.PrivateKey;
import ua.avtor.DsLib.PrivateKeys.PrivateKeyRsaPkcs8;
import ua.avtor.DsLib.Utils.Ddec;

public class InternationalAlgFactory
extends CryptolibAlgFactory {
    public MessageDigestAlg getDigestAlg(String string, byte[] byArray, Certificate certificate) {
        try {
            if (string.equals("1.3.14.3.2.26")) {
                return new MessageDigestJCA(string, "SHA-1", 64);
            }
            if (string.equals("2.16.840.1.101.3.4.2.4")) {
                return new MessageDigestJCA(string, "SHA-224", 64);
            }
            if (string.equals("2.16.840.1.101.3.4.2.1")) {
                return new MessageDigestJCA(string, "SHA-256", 64);
            }
            if (string.equals("2.16.840.1.101.3.4.2.2")) {
                return new MessageDigestJCA(string, "SHA-384", 128);
            }
            if (string.equals("2.16.840.1.101.3.4.2.3")) {
                return new MessageDigestJCA(string, "SHA-512", 128);
            }
            if (string.equals("1.2.840.113549.2.5")) {
                return new MessageDigestJCA(string, "MD5", 64);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
        return super.getDigestAlg(string, byArray, certificate);
    }

    public MessageVerifierAlg getVerifierAlg(String string, byte[] byArray, String string2, byte[] byArray2, Certificate certificate) {
        try {
            if (string2.equals("1.2.840.113549.1.1.1")) {
                String string3 = "";
                if (string.equals("1.3.14.3.2.26")) {
                    string3 = "SHA1";
                }
                if (string.equals("2.16.840.1.101.3.4.2.4")) {
                    string3 = "SHA224";
                }
                if (string.equals("2.16.840.1.101.3.4.2.1")) {
                    string3 = "SHA256";
                }
                if (string.equals("2.16.840.1.101.3.4.2.2")) {
                    string3 = "SHA384";
                }
                if (string.equals("2.16.840.1.101.3.4.2.3")) {
                    string3 = "SHA512";
                }
                if (string.equals("1.2.840.113549.2.5")) {
                    string3 = "MD5";
                }
                if (string3.equals("")) {
                    return null;
                }
                return new MessageVerifierRsa15(string2, byArray2, certificate, string3 + "withRSA");
            }
            if (string2.equals("1.2.840.113549.1.1.5") || string2.equals("1.3.14.3.2.29")) {
                return new MessageVerifierRsa15(string2, byArray2, certificate, "SHA1withRSA");
            }
            if (string2.equals("1.2.840.113549.1.1.11")) {
                return new MessageVerifierRsa15(string2, byArray2, certificate, "SHA256withRSA");
            }
            if (string2.equals("1.2.840.113549.1.1.12")) {
                return new MessageVerifierRsa15(string2, byArray2, certificate, "SHA384withRSA");
            }
            if (string2.equals("1.2.840.113549.1.1.13")) {
                return new MessageVerifierRsa15(string2, byArray2, certificate, "SHA512withRSA");
            }
            if (string2.equals("1.2.840.113549.1.1.4") || string2.equals("1.3.14.3.2.3")) {
                return new MessageVerifierRsa15(string2, byArray2, certificate, "MD5withRSA");
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
        return super.getVerifierAlg(string, byArray, string2, byArray2, certificate);
    }

    public MessageDigestAlg getHmacAlg(String string, byte[] byArray, byte[] byArray2) {
        if (string.equals("1.2.840.113549.2.7") || string.equals("1.3.6.1.5.5.8.1.2")) {
            string = "1.3.14.3.2.26";
        } else if (string.equals("1.2.840.113549.2.9")) {
            string = "2.16.840.1.101.3.4.2.1";
        } else if (string.equals("1.2.840.113549.2.10")) {
            string = "2.16.840.1.101.3.4.2.2";
        } else if (string.equals("1.2.840.113549.2.11")) {
            string = "2.16.840.1.101.3.4.2.3";
        } else if (string.equals("1.2.840.113549.2.8")) {
            string = "2.16.840.1.101.3.4.2.4";
        } else if (string.equals("1.3.6.1.5.5.8.1.1")) {
            string = "1.2.840.113549.2.5";
        }
        return super.getHmacAlg(string, byArray, byArray2);
    }

    public ContentEncryptionAlg getEncryptionAlg(String string, byte[] byArray, byte[] byArray2) {
        int n2;
        if (string.charAt(0) == '2' && string.charAt(2) == '1') {
            n2 = 0;
            if (string.equals("2.16.840.1.101.3.4.1.2")) {
                n2 = 130;
            }
            if (string.equals("2.16.840.1.101.3.4.1.4")) {
                n2 = 132;
            }
            if (string.equals("2.16.840.1.101.3.4.1.22")) {
                n2 = 194;
            }
            if (string.equals("2.16.840.1.101.3.4.1.24")) {
                n2 = 196;
            }
            if (string.equals("2.16.840.1.101.3.4.1.42")) {
                n2 = 258;
            }
            if (string.equals("2.16.840.1.101.3.4.1.44")) {
                n2 = 260;
            }
            if (n2 > 0) {
                if (byArray2 == null && byArray == null || byArray == GENERATE) {
                    byArray = new byte[18];
                    this.generateRandom(byArray);
                    byArray[0] = 4;
                    byArray[1] = 16;
                }
                byte[] byArray3 = null;
                if (byArray2 == null) {
                    byArray3 = new byte[(n2 & 0x1F0) / 8];
                    this.generateRandom(byArray3);
                    byArray2 = byArray3;
                }
                try {
                    ContentEncryptionAes contentEncryptionAes = new ContentEncryptionAes(n2 & 0x1F0, n2 & 7, byArray, byArray2);
                    if (byArray3 != null) {
                        Arrays.fill(byArray3, (byte)0);
                    }
                    return contentEncryptionAes;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    return null;
                }
            }
        }
        if (string.charAt(0) == '1') {
            n2 = 0;
            if (string.equals("1.3.14.3.2.7") || string.equals("1.3.36.3.1.1.2.1")) {
                n2 = 8;
            }
            if (string.equals("1.2.840.113549.3.7") || string.equals("1.3.36.3.1.3.2.1")) {
                n2 = 24;
            }
            if (string.equals("1.2.840.113549.1.12.1.3")) {
                n2 = 24;
            }
            if (string.equals("1.2.840.113549.1.12.1.4")) {
                n2 = 16;
            }
            if (n2 > 0) {
                if (byArray2 == null && byArray == null || byArray == GENERATE) {
                    byArray = new byte[10];
                    this.generateRandom(byArray);
                    byArray[0] = 4;
                    byArray[1] = 8;
                }
                byte[] byArray4 = null;
                if (byArray2 == null) {
                    byArray4 = new byte[n2];
                    this.generateRandom(byArray4);
                    byArray2 = byArray4;
                }
                try {
                    ContentEncryptionDesRc2 contentEncryptionDesRc2 = new ContentEncryptionDesRc2(0, n2, 2, byArray, byArray2);
                    if (byArray4 != null) {
                        Arrays.fill(byArray4, (byte)0);
                    }
                    return contentEncryptionDesRc2;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    return null;
                }
            }
        }
        if (string.charAt(5) == '4') {
            n2 = 0;
            if (string.equals("1.2.840.113549.1.12.1.5")) {
                n2 = 528;
            }
            if (string.equals("1.2.840.113549.1.12.1.6")) {
                n2 = 517;
            }
            if (n2 > 0) {
                if (byArray2 == null && byArray == null || byArray == GENERATE) {
                    byArray = new byte[10];
                    this.generateRandom(byArray);
                    byArray[0] = 4;
                    byArray[1] = 8;
                }
                byte[] byArray5 = null;
                if (byArray2 == null) {
                    byArray5 = new byte[n2 & 0xFF];
                    this.generateRandom(byArray5);
                    byArray2 = byArray5;
                }
                if ((n2 & 0xFF00) == 512) {
                    try {
                        ContentEncryptionDesRc2 contentEncryptionDesRc2 = new ContentEncryptionDesRc2(2, n2 & 0xFF, 2, byArray, byArray2);
                        if (byArray5 != null) {
                            Arrays.fill(byArray5, (byte)0);
                        }
                        return contentEncryptionDesRc2;
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        return null;
                    }
                }
            }
        }
        return super.getEncryptionAlg(string, byArray, byArray2);
    }

    public KeyWrapAlg getWrapAlg(int n2, Certificate certificate) {
        try {
            if (certificate.getPublicKeyAlgOid().equals("1.2.840.113549.1.1.1")) {
                return new KeyWrapRsa15(n2, certificate, this);
            }
        }
        catch (Exception exception) {
            return null;
        }
        return super.getWrapAlg(n2, certificate);
    }

    public PasswordBasedAlg getPasswordBasedAlg(String string, String string2, byte[] byArray) {
        if (string2.compareTo("1.2.840.113549.1.12.1.1") >= 0 && string2.compareTo("1.2.840.113549.1.12.1.6") <= 0) {
            byte[] byArray2 = Ddec.TryGetElementBuf(byArray, "SosQ");
            int n2 = Ddec.TryGetElementInt(byArray, "SosqI");
            MessageDigestAlg messageDigestAlg = this.getDigestAlg("1.3.14.3.2.26", null, null);
            return new PasswordBasedPBES1(string, string2, messageDigestAlg, byArray2, n2, this);
        }
        return super.getPasswordBasedAlg(string, string2, byArray);
    }

    public PasswordBasedAlg getPasswordBasedAlg(String string, String string2, byte[] byArray, int n2, String string3, String string4) {
        if (string2.compareTo("1.2.840.113549.1.12.1.1") >= 0 && string2.compareTo("1.2.840.113549.1.12.1.6") <= 0) {
            MessageDigestAlg messageDigestAlg = this.getDigestAlg("1.3.14.3.2.26", null, null);
            return new PasswordBasedPBES1(string, string2, messageDigestAlg, byArray, n2, this);
        }
        return super.getPasswordBasedAlg(string, string2, byArray, n2, string3, string4);
    }

    public PrivateKey getSignerAlg(byte[] byArray, String string, int n2, byte[] byArray2) {
        if (string == null) {
            string = Ddec.TryGetElementOid(byArray, "SiSD");
        }
        if (string.equals("1.2.840.113549.1.1.1")) {
            try {
                return new PrivateKeyRsaPkcs8(byArray, string, n2, byArray2);
            }
            catch (DsException dsException) {
                return null;
            }
        }
        return super.getSignerAlg(byArray, string, n2, byArray2);
    }
}

