/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor.DsLib.Algorithms;

import java.util.Arrays;
import ua.avtor.DsLib.Algorithms.ContentEncryptionAlg;
import ua.avtor.DsLib.Algorithms.ContentEncryptionGost28147;
import ua.avtor.DsLib.Algorithms.CryptoAlgorithmFactory;
import ua.avtor.DsLib.Algorithms.KeyWrapAlg;
import ua.avtor.DsLib.Algorithms.KeyWrapDstu4145;
import ua.avtor.DsLib.Algorithms.MessageDigestAlg;
import ua.avtor.DsLib.Algorithms.MessageDigestGost34311;
import ua.avtor.DsLib.Algorithms.MessageHmacGeneral;
import ua.avtor.DsLib.Algorithms.MessageVerifierAlg;
import ua.avtor.DsLib.Algorithms.MessageVerifierDstu4145;
import ua.avtor.DsLib.Algorithms.PasswordBasedAlg;
import ua.avtor.DsLib.Algorithms.PasswordBasedPBES1;
import ua.avtor.DsLib.Algorithms.PasswordBasedPBES2;
import ua.avtor.DsLib.Certificate;
import ua.avtor.DsLib.DsException;
import ua.avtor.DsLib.PrivateKeys.PrivateKey;
import ua.avtor.DsLib.PrivateKeys.PrivateKeyDstuPkcs8;
import ua.avtor.DsLib.Utils.Ddec;
import ua.kiev.author.cryptolib.Prng4145A;

public class CryptolibAlgFactory
extends CryptoAlgorithmFactory {
    private static final Object rngLock = new Object();
    private static Prng4145A rng = null;

    public MessageDigestAlg getDigestAlg(String string, byte[] byArray, Certificate certificate) {
        if (string.equals("1.2.804.2.1.1.1.1.2.1")) {
            if (certificate != null) {
                try {
                    byte[] byArray2;
                    String string2 = certificate.getPublicKeyAlgOid();
                    if ((string2.equals("1.2.804.2.1.1.1.1.3.1.1") || string2.equals("1.2.804.2.1.1.1.1.3.1.1.1.1")) && (byArray2 = certificate.getPublicKeyAlgParams()) != null) {
                        byArray = Ddec.DerGetElementBuf(byArray2, "Sxq");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return new MessageDigestGost34311(byArray);
        }
        return null;
    }

    public MessageVerifierAlg getVerifierAlg(String string, byte[] byArray, String string2, byte[] byArray2, Certificate certificate) {
        if (string2.equals("1.2.804.2.1.1.1.1.3.1.1")) {
            MessageDigestAlg messageDigestAlg = this.getDigestAlg("1.2.804.2.1.1.1.1.2.1", null, certificate);
            if (messageDigestAlg == null) {
                return null;
            }
            return new MessageVerifierDstu4145(string2, byArray2, certificate, messageDigestAlg);
        }
        return null;
    }

    public MessageDigestAlg getHmacAlg(String string, byte[] byArray, byte[] byArray2) {
        MessageDigestAlg messageDigestAlg;
        if (string.equals("1.2.804.2.1.1.1.1.1.2")) {
            string = "1.2.804.2.1.1.1.1.2.1";
        }
        if ((messageDigestAlg = this.getDigestAlg(string, byArray, null)) == null) {
            return null;
        }
        return new MessageHmacGeneral(messageDigestAlg, byArray2);
    }

    public ContentEncryptionAlg getEncryptionAlg(String string, byte[] byArray, byte[] byArray2) {
        if (string.equals("1.2.804.2.1.1.1.1.1.1.2") || string.equals("1.2.804.2.1.1.1.1.1.1.3")) {
            if (byArray2 == null && byArray == null || byArray == GENERATE) {
                byte[] byArray3 = new byte[8];
                this.generateRandom(byArray3);
                byArray = new byte[12];
                System.arraycopy(byArray3, 0, byArray, 4, 8);
                byArray[0] = 48;
                byArray[1] = 10;
                byArray[2] = 4;
                byArray[3] = 8;
            }
            boolean bl = false;
            if (byArray2 == null) {
                byArray2 = new byte[32];
                this.generateRandom(byArray2);
                bl = true;
            }
            ContentEncryptionGost28147 contentEncryptionGost28147 = new ContentEncryptionGost28147(Integer.parseInt(string.substring(22, 23)), byArray, byArray2);
            if (bl) {
                Arrays.fill(byArray2, (byte)0);
            }
            return contentEncryptionGost28147;
        }
        return null;
    }

    public KeyWrapAlg getWrapAlg(int n2, Certificate certificate) {
        try {
            String string = certificate.getPublicKeyAlgOid();
            if (string.equals("1.2.804.2.1.1.1.1.3.1.1") || string.equals("1.2.804.2.1.1.1.1.3.1.1.1.1")) {
                return new KeyWrapDstu4145(n2, true, certificate, this);
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    public PasswordBasedAlg getPasswordBasedAlg(String string, String string2, byte[] byArray) {
        if (string2.equals("1.2.840.113549.1.5.13") || string2.equals("1.2.840.113549.1.5.14")) {
            try {
                return new PasswordBasedPBES2(string, string2, byArray, this);
            }
            catch (DsException dsException) {
                return null;
            }
        }
        byte[] byArray2 = Ddec.TryGetElementBuf(byArray, "SosQ");
        int n2 = Ddec.TryGetElementInt(byArray, "SosqI");
        MessageDigestAlg messageDigestAlg = this.getDigestAlg(string2, null, null);
        if (messageDigestAlg == null) {
            return null;
        }
        return new PasswordBasedPBES1(string, string2, messageDigestAlg, byArray2, n2, this);
    }

    public PasswordBasedAlg getPasswordBasedAlg(String string, String string2, byte[] byArray, int n2, String string3, String string4) {
        if (string2.equals("1.2.840.113549.1.5.13") || string2.equals("1.2.840.113549.1.5.14")) {
            return new PasswordBasedPBES2(string, string2, byArray, n2, string3, string4, this);
        }
        MessageDigestAlg messageDigestAlg = this.getDigestAlg(string2, null, null);
        if (messageDigestAlg == null) {
            return null;
        }
        return new PasswordBasedPBES1(string, string2, messageDigestAlg, byArray, n2, this);
    }

    public PrivateKey getSignerAlg(byte[] byArray, String string, int n2, byte[] byArray2) {
        if (string == null) {
            string = Ddec.TryGetElementOid(byArray, "SiSD");
        }
        if (string.startsWith("1.2.804.2.1.1.1.1.3.1.1")) {
            try {
                return new PrivateKeyDstuPkcs8(byArray, string, n2, byArray2);
            }
            catch (DsException dsException) {
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateRandom(byte[] byArray) {
        Object object = rngLock;
        synchronized (object) {
            if (rng == null) {
                rng = new Prng4145A();
            }
            rng.nextBytes(byArray);
        }
    }
}

