/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor.DsLib.Algorithms;

import ua.avtor.DsLib.Algorithms.ContentEncryptionAlg;
import ua.kiev.author.cryptolib.Gost28147;

public class ContentEncryptionGost28147
extends ContentEncryptionAlg {
    private int mode;
    private byte[] pParams;
    private byte[] key = new byte[32];
    private Gost28147 h;
    private static byte[] gostDefaultParams = new byte[]{48, 76, 4, 8, 0, 0, 0, 0, 0, 0, 0, 0, 4, 64, -87, -42, -21, 69, -15, 60, 112, -126, -128, -60, -106, 123, 35, 31, 94, -83, -10, 88, -21, -92, -64, 55, 41, 29, 56, -39, 107, -16, 37, -54, 78, 23, -8, -23, 114, 13, -58, 21, -76, 58, 40, -105, 95, 11, -63, -34, -93, 100, 56, -75, 100, -22, 44, 23, -97, -48, 18, 62, 109, -72, -6, -59, 121, 4};
    private static byte[] gostShortDefaultParams = new byte[]{48, 10, 4, 8, 0, 0, 0, 0, 0, 0, 0, 0};

    ContentEncryptionGost28147(int n2, byte[] byArray, byte[] byArray2) {
        this.mode = n2;
        this.pParams = null;
        int n3 = 0;
        int n4 = 0;
        if (byArray != null) {
            if (byArray[0] == 4) {
                if (byArray[1] == 8) {
                    n3 = 2;
                }
                if (byArray[1] == 64) {
                    n4 = 2;
                }
            }
            if (byArray[0] == 48 && byArray[1] >= 10) {
                if (byArray[3] == 64) {
                    n4 = 4;
                }
                if (byArray[3] == 8) {
                    n3 = 4;
                    if (byArray[1] >= 76 && byArray[13] == 64) {
                        n4 = 14;
                    }
                }
            }
        }
        if (n4 != 0) {
            this.pParams = (byte[])gostDefaultParams.clone();
            System.arraycopy(byArray, n4, this.pParams, 14, 64);
            if (n3 != 0) {
                System.arraycopy(byArray, n3, this.pParams, 4, 8);
            }
        } else if (n3 != 0) {
            this.pParams = (byte[])gostShortDefaultParams.clone();
            System.arraycopy(byArray, n3, this.pParams, 4, 8);
        }
        byte[] byArray3 = new byte[64];
        if (n4 != 0) {
            System.arraycopy(byArray, n4, byArray3, 0, 64);
        } else {
            System.arraycopy(gostDefaultParams, 14, byArray3, 0, 64);
        }
        System.arraycopy(byArray2, 0, this.key, 0, 32);
        byte[] byArray4 = new byte[64];
        int n5 = 0;
        for (int i2 = 0; i2 < 64; ++i2) {
            n5 = (i2 >> 1 & 7) + (i2 & 0xF0);
            byArray4[i2] = (byte)(byArray3[n5 + 8] & 0xF0 | byArray3[n5] >> 4 & 0xF);
            byArray4[++i2] = (byte)(byArray3[n5 + 8] << 4 | byArray3[n5] & 0xF);
        }
        this.h = new Gost28147(byArray4, this.key);
        if (n3 != 0) {
            byte[] byArray5 = new byte[8];
            System.arraycopy(byArray, n3, byArray5, 0, 8);
            this.h.SetSync(byArray5);
        }
    }

    public void finalize() {
        for (int i2 = 0; i2 < 32; ++i2) {
            this.key[i2] = 0;
        }
    }

    public String getOid() {
        if (this.mode == 3) {
            return "1.2.804.2.1.1.1.1.1.1.3";
        }
        if (this.mode == 2) {
            return "1.2.804.2.1.1.1.1.1.1.2";
        }
        return null;
    }

    public byte[] getParams() {
        return this.pParams;
    }

    public byte[] getKeyOctets() {
        return this.key;
    }

    public int getKeySize() {
        return 32;
    }

    public int encrypt(byte[] byArray, int n2, int n3) {
        switch (this.mode) {
            case 2: {
                this.h.M2Enc(byArray, n2, n3);
                break;
            }
            case 3: {
                this.h.M3Enc(byArray, n2, n3);
            }
        }
        return n3;
    }

    public int encryptFinal(byte[] byArray, int n2, int n3) {
        return this.encrypt(byArray, n2, n3);
    }

    public int decrypt(byte[] byArray, int n2, int n3) {
        switch (this.mode) {
            case 2: {
                this.h.M2Dec(byArray, n2, n3);
                break;
            }
            case 3: {
                this.h.M3Dec(byArray, n2, n3);
            }
        }
        return n3;
    }

    public int decryptFinal(byte[] byArray, int n2, int n3) {
        return this.decrypt(byArray, n2, n3);
    }

    public int encrypt(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        System.arraycopy(byArray, n2, byArray2, n4, n3);
        return this.encrypt(byArray2, n4, n3);
    }

    public int encryptFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        System.arraycopy(byArray, n2, byArray2, n4, n3);
        return this.encrypt(byArray2, n4, n3);
    }

    public int decrypt(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        System.arraycopy(byArray, n2, byArray2, n4, n3);
        return this.decrypt(byArray2, n4, n3);
    }

    public int decryptFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        System.arraycopy(byArray, n2, byArray2, n4, n3);
        return this.decrypt(byArray2, n4, n3);
    }
}

