/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor.DsLib.Algorithms;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import ua.avtor.DsLib.Algorithms.ContentEncryptionAlg;

public class ContentEncryptionDesRc2
extends ContentEncryptionAlg {
    private int keySize;
    private int mode;
    private int rcX;
    private byte[] sync = new byte[8];
    private byte[] key;
    private int direction;
    private Cipher des;
    private static boolean vmandroid = System.getProperty("java.vm.name").equalsIgnoreCase("dalvik");

    ContentEncryptionDesRc2(int n2, int n3, int n4, byte[] byArray, byte[] byArray2) throws NoSuchAlgorithmException {
        this.keySize = n3;
        this.mode = n4;
        this.rcX = n2;
        this.direction = 0;
        if (byArray != null && byArray[0] == 4) {
            System.arraycopy(byArray, 2, this.sync, 0, 8);
        }
        this.key = new byte[n3];
        System.arraycopy(byArray2, 0, this.key, 0, n3);
        if (n4 != 2) {
            throw new IllegalArgumentException();
        }
        try {
            this.des = n2 == 2 ? Cipher.getInstance("RC2/CBC/PKCS5PADDING") : (n3 > 8 || vmandroid ? Cipher.getInstance("DESede/CBC/PKCS5PADDING") : Cipher.getInstance("DES/CBC/PKCS5PADDING"));
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new NoSuchAlgorithmException();
        }
    }

    public void finalize() {
        for (int i2 = 0; i2 < this.key.length; ++i2) {
            this.key[i2] = 0;
        }
    }

    public String getOid() {
        if (this.mode != 2) {
            return null;
        }
        if (this.rcX == 2) {
            return "1.2.840.113549.3.2";
        }
        if (this.keySize == 8) {
            return "1.3.14.3.2.7";
        }
        if (this.keySize > 8) {
            return "1.2.840.113549.3.7";
        }
        return null;
    }

    public byte[] getParams() {
        byte[] byArray = new byte[10];
        byArray[0] = 4;
        byArray[1] = 8;
        System.arraycopy(this.sync, 0, byArray, 2, 8);
        return byArray;
    }

    public byte[] getKeyOctets() {
        return this.key;
    }

    public int getKeySize() {
        return this.keySize;
    }

    private void initKey(int n2) {
        this.direction = n2;
        try {
            String string = "DES";
            byte[] byArray = this.key;
            byte[] byArray2 = null;
            if (this.rcX == 2) {
                string = "RC2";
            } else {
                if (this.keySize > 8) {
                    string = "DESede";
                }
                if (this.keySize == 8 && vmandroid) {
                    string = "DESede";
                    byArray2 = new byte[24];
                    System.arraycopy(this.key, 0, byArray2, 0, 8);
                    System.arraycopy(this.key, 0, byArray2, 8, 8);
                    System.arraycopy(this.key, 0, byArray2, 16, 8);
                    byArray = byArray2;
                }
            }
            if (this.direction == 1) {
                this.des.init(1, (Key)new SecretKeySpec(byArray, string), new IvParameterSpec(this.sync));
            } else {
                this.des.init(2, (Key)new SecretKeySpec(byArray, string), new IvParameterSpec(this.sync));
            }
            if (byArray2 != null) {
                Arrays.fill(byArray2, (byte)0);
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    public int encrypt(byte[] byArray, int n2, int n3) {
        if (this.direction == 0) {
            this.initKey(1);
        }
        try {
            return this.des.update(byArray, n2, n3, byArray, n2);
        }
        catch (ShortBufferException shortBufferException) {
            throw new IllegalArgumentException(shortBufferException);
        }
    }

    public int encryptFinal(byte[] byArray, int n2, int n3) {
        if (this.direction == 0) {
            this.initKey(1);
        }
        try {
            return this.des.doFinal(byArray, n2, n3, byArray, n2);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    public int decrypt(byte[] byArray, int n2, int n3) {
        if (this.direction == 0) {
            this.initKey(2);
        }
        try {
            byte[] byArray2 = new byte[136];
            int n4 = 0;
            int n5 = n2;
            while (n3 > 0) {
                int n6 = 128;
                if (n6 > n3) {
                    n6 = n3;
                }
                int n7 = this.des.update(byArray, n2, n6, byArray2, 0);
                System.arraycopy(byArray2, 0, byArray, n5, n7);
                n5 += n7;
                n4 += n7;
                n2 += n6;
                n3 -= n6;
            }
            Arrays.fill(byArray2, (byte)0);
            return n4;
        }
        catch (ShortBufferException shortBufferException) {
            throw new IllegalArgumentException(shortBufferException);
        }
    }

    public int decryptFinal(byte[] byArray, int n2, int n3) {
        if (this.direction == 0) {
            this.initKey(2);
        }
        try {
            if (vmandroid) {
                byte[] byArray2 = new byte[byArray.length + 8];
                int n4 = this.des.doFinal(byArray, n2, n3, byArray2, n2);
                System.arraycopy(byArray2, n2, byArray, n2, n4);
                Arrays.fill(byArray2, (byte)0);
                return n4;
            }
            return this.des.doFinal(byArray, n2, n3, byArray, n2);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    public int encrypt(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        if (this.direction == 0) {
            this.initKey(1);
        }
        try {
            return this.des.update(byArray, n2, n3, byArray2, n4);
        }
        catch (ShortBufferException shortBufferException) {
            throw new IllegalArgumentException(shortBufferException);
        }
    }

    public int encryptFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        if (this.direction == 0) {
            this.initKey(1);
        }
        try {
            return this.des.doFinal(byArray, n2, n3, byArray2, n4);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    public int decrypt(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        if (this.direction == 0) {
            this.initKey(2);
        }
        try {
            return this.des.update(byArray, n2, n3, byArray2, n4);
        }
        catch (ShortBufferException shortBufferException) {
            throw new IllegalArgumentException(shortBufferException);
        }
    }

    public int decryptFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        if (this.direction == 0) {
            this.initKey(2);
        }
        try {
            return this.des.doFinal(byArray, n2, n3, byArray2, n4);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
    }
}

