/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor.DsLib.Algorithms;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import ua.avtor.DsLib.Algorithms.ContentEncryptionAlg;

public class ContentEncryptionAes
extends ContentEncryptionAlg {
    private int keyLength;
    private int mode;
    private int feedBackLen;
    private int direction;
    private byte[] sync = new byte[16];
    private byte[] key;
    private Cipher aes;
    private static boolean vmandroid = System.getProperty("java.vm.name").equalsIgnoreCase("dalvik");

    ContentEncryptionAes(int n2, int n3, byte[] byArray, byte[] byArray2) throws NoSuchAlgorithmException {
        this.keyLength = n2;
        this.mode = n3;
        this.feedBackLen = 128;
        this.direction = 0;
        if (byArray != null) {
            if (byArray[0] == 4) {
                System.arraycopy(byArray, 2, this.sync, 0, 16);
            }
            if (byArray[0] == 48) {
                System.arraycopy(byArray, 4, this.sync, 0, 16);
                if (byArray[1] > 18) {
                    this.feedBackLen = byArray[byArray[1] + 1] & 0xFF;
                }
            }
        }
        this.key = (byte[])byArray2.clone();
        try {
            switch (n3) {
                case 1: {
                    this.aes = Cipher.getInstance("AES/ECB/PKCS5PADDING");
                    break;
                }
                case 2: {
                    this.aes = Cipher.getInstance("AES/CBC/PKCS5PADDING");
                    break;
                }
                case 3: {
                    this.aes = Cipher.getInstance("AES/OFB128/NOPADDING");
                    break;
                }
                case 4: {
                    this.aes = Cipher.getInstance("AES/CFB" + Integer.toString(this.feedBackLen) + "/NOPADDING");
                }
            }
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new NoSuchAlgorithmException();
        }
    }

    public void finalize() {
        for (int i2 = 0; i2 < this.key.length; ++i2) {
            this.key[i2] = 0;
        }
    }

    public String getOid() {
        switch (this.keyLength + this.mode) {
            case 129: {
                return "2.16.840.1.101.3.4.1.1";
            }
            case 130: {
                return "2.16.840.1.101.3.4.1.2";
            }
            case 131: {
                return "2.16.840.1.101.3.4.1.3";
            }
            case 132: {
                return "2.16.840.1.101.3.4.1.4";
            }
            case 193: {
                return "2.16.840.1.101.3.4.1.21";
            }
            case 194: {
                return "2.16.840.1.101.3.4.1.22";
            }
            case 195: {
                return "2.16.840.1.101.3.4.1.23";
            }
            case 196: {
                return "2.16.840.1.101.3.4.1.24";
            }
            case 257: {
                return "2.16.840.1.101.3.4.1.41";
            }
            case 258: {
                return "2.16.840.1.101.3.4.1.42";
            }
            case 259: {
                return "2.16.840.1.101.3.4.1.43";
            }
            case 260: {
                return "2.16.840.1.101.3.4.1.44";
            }
        }
        return null;
    }

    public byte[] getParams() {
        if (this.mode == 4) {
            int n2 = 1;
            if (this.feedBackLen >= 128) {
                n2 = 2;
            }
            byte[] byArray = new byte[22 + n2];
            byArray[0] = 48;
            byArray[1] = (byte)(20 + n2);
            byArray[2] = 4;
            byArray[3] = 16;
            System.arraycopy(this.sync, 0, byArray, 4, 16);
            byArray[20] = 2;
            byArray[21] = (byte)n2;
            byArray[21 + n2] = (byte)this.feedBackLen;
            return byArray;
        }
        byte[] byArray = new byte[18];
        byArray[0] = 4;
        byArray[1] = 16;
        System.arraycopy(this.sync, 0, byArray, 2, 16);
        return byArray;
    }

    public byte[] getKeyOctets() {
        return this.key;
    }

    public int getKeySize() {
        return this.keyLength / 8;
    }

    private void initKey(int n2) {
        this.direction = n2;
        try {
            if (this.direction == 1) {
                this.aes.init(1, (Key)new SecretKeySpec(this.key, "AES"), new IvParameterSpec(this.sync));
            } else {
                this.aes.init(2, (Key)new SecretKeySpec(this.key, "AES"), new IvParameterSpec(this.sync));
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    public int encrypt(byte[] byArray, int n2, int n3) {
        if (this.direction == 0) {
            this.initKey(1);
        }
        try {
            return this.aes.update(byArray, n2, n3, byArray, n2);
        }
        catch (ShortBufferException shortBufferException) {
            throw new IllegalArgumentException(shortBufferException);
        }
    }

    public int encryptFinal(byte[] byArray, int n2, int n3) {
        if (this.direction == 0) {
            this.initKey(1);
        }
        try {
            return this.aes.doFinal(byArray, n2, n3, byArray, n2);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    public int decrypt(byte[] byArray, int n2, int n3) {
        if (this.direction == 0) {
            this.initKey(2);
        }
        try {
            byte[] byArray2 = new byte[144];
            int n4 = 0;
            int n5 = n2;
            while (n3 > 0) {
                int n6 = 128;
                if (n6 > n3) {
                    n6 = n3;
                }
                int n7 = this.aes.update(byArray, n2, n6, byArray2, 0);
                System.arraycopy(byArray2, 0, byArray, n5, n7);
                n5 += n7;
                n4 += n7;
                n2 += n6;
                n3 -= n6;
            }
            Arrays.fill(byArray2, (byte)0);
            return n4;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    public int decryptFinal(byte[] byArray, int n2, int n3) {
        if (this.direction == 0) {
            this.initKey(2);
        }
        try {
            if (vmandroid) {
                byte[] byArray2 = new byte[byArray.length + 16];
                int n4 = this.aes.doFinal(byArray, n2, n3, byArray2, n2);
                System.arraycopy(byArray2, n2, byArray, n2, n4);
                Arrays.fill(byArray2, (byte)0);
                return n4;
            }
            return this.aes.doFinal(byArray, n2, n3, byArray, n2);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    public int encrypt(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        if (this.direction == 0) {
            this.initKey(1);
        }
        try {
            return this.aes.update(byArray, n2, n3, byArray2, n4);
        }
        catch (ShortBufferException shortBufferException) {
            throw new IllegalArgumentException(shortBufferException);
        }
    }

    public int encryptFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        if (this.direction == 0) {
            this.initKey(1);
        }
        try {
            return this.aes.doFinal(byArray, n2, n3, byArray2, n4);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    public int decrypt(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        if (this.direction == 0) {
            this.initKey(2);
        }
        try {
            return this.aes.update(byArray, n2, n3, byArray2, n4);
        }
        catch (ShortBufferException shortBufferException) {
            throw new IllegalArgumentException(shortBufferException);
        }
    }

    public int decryptFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        if (this.direction == 0) {
            this.initKey(2);
        }
        try {
            return this.aes.doFinal(byArray, n2, n3, byArray2, n4);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
    }
}

