/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor;

import java.security.InvalidKeyException;
import java.security.PublicKey;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import ua.avtor.Consts;
import ua.avtor.b;
import ua.avtor.p;
import ua.kiev.author.cryptolib.EcPoint;
import ua.kiev.author.cryptolib.Ecc4145;

public final class DSTU4145PublicKey
implements PublicKey {
    EcPoint keyQ;
    Ecc4145 ec = null;
    byte[] uz;

    DSTU4145PublicKey(EcPoint ecPoint, Ecc4145 ecc4145, byte[] byArray) throws InvalidKeyException {
        this.keyQ = ecPoint.newCopy();
        this.ec = ecc4145;
        this.uz = byArray;
    }

    static byte[] UnPackUz(byte[] byArray) {
        if (byArray.length == 64) {
            return DSTU4145PublicKey.a(byArray);
        }
        if (byArray.length == 128) {
            return DSTU4145PublicKey.b(byArray);
        }
        return null;
    }

    private static byte[] a(byte[] byArray) {
        int n2 = 0;
        byte[] byArray2 = new byte[64];
        for (int i2 = 0; i2 < 64; ++i2) {
            n2 = (i2 >> 1 & 7) + (i2 & 0xF0);
            byArray2[i2] = (byte)(byArray[n2 + 8] & 0xF0 | byArray[n2] >> 4 & 0xF);
            byArray2[++i2] = (byte)(byArray[n2 + 8] << 4 | byArray[n2] & 0xF);
        }
        return byArray2;
    }

    private static byte[] b(byte[] byArray) {
        byte[] byArray2 = new byte[64];
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int i3 = 0; i3 < 16; ++i3) {
                byArray2[i2 * 16 + i3] = (byte)(byArray[2 * i2 * 16 + i3] + (byArray[(2 * i2 + 1) * 16 + i3] << 4));
            }
        }
        return byArray2;
    }

    static byte[] UzCrlToCert(byte[] byArray) {
        int n2 = 0;
        int n3 = 0;
        byte[] byArray2 = new byte[64];
        while (n2 < 64) {
            n3 = (n2 & 0xF0) + (n2 & 7) * 2;
            byArray2[n2] = (byte)((byte)((byArray[n3] & 0xF) << 4) | (byte)(byArray[n3 + 1] & 0xF));
            byArray2[n2 + 8] = (byte)((byte)(byArray[n3] & 0xFFFFFFF0) | (byte)(byArray[n3 + 1] >> 4 & 0xF));
            if ((++n2 & 7) != 0) continue;
            n2 += 8;
        }
        return byArray2;
    }

    DSTU4145PublicKey(byte[] byArray) throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(byArray);
            DerValue[] derValueArray = derInputStream.getSequence(3);
            DerInputStream derInputStream2 = new DerInputStream(derValueArray[0].toByteArray());
            DerValue[] derValueArray2 = derInputStream2.getSequence(3);
            Object[] objectArray = b.a(derValueArray2[1].toByteArray());
            this.ec = (Ecc4145)objectArray[0];
            this.uz = (byte[])objectArray[1];
            byte[] byArray2 = derValueArray[1].getBitString();
            byte[] byArray3 = new byte[byArray2.length - 2];
            System.arraycopy(byArray2, 2, byArray3, 0, byArray3.length);
            Consts.ByteReverse(byArray3, byArray3.length);
            int[] nArray = this.ec.fromByteArrayEl(byArray3);
            this.keyQ = this.ec.ExpandPoint(nArray);
        }
        catch (Exception exception) {
            throw new InvalidKeyException(Consts.GetMsgError(14));
        }
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public String getAlgorithm() {
        return "DSTU4145";
    }

    @Override
    public byte[] getEncoded() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putOID(new ObjectIdentifier(Consts.strStdOid));
            derOutputStream.write(b.a(this.ec, this.uz));
            DerOutputStream derOutputStream2 = new DerOutputStream();
            derOutputStream2.write((byte)48, derOutputStream);
            byte[] byArray = this.ec.toByteArray(this.ec.ShrinkPoint(this.keyQ));
            Consts.ByteReverse(byArray, byArray.length);
            byte[] byArray2 = new byte[byArray.length + 2];
            byArray2[0] = 4;
            byArray2[1] = (byte)byArray.length;
            System.arraycopy(byArray, 0, byArray2, 2, byArray.length);
            derOutputStream2.putBitString(byArray2);
            DerOutputStream derOutputStream3 = new DerOutputStream();
            derOutputStream3.write((byte)48, derOutputStream2);
            return derOutputStream3.toByteArray();
        }
        catch (Exception exception) {
            throw new RuntimeException(Consts.GetMsgError(14));
        }
    }

    byte[] getEncodedParams() {
        try {
            byte[] byArray = b.a(this.ec, this.uz);
            return byArray;
        }
        catch (Exception exception) {
            throw new RuntimeException(Consts.GetMsgError(14));
        }
    }

    public int bitLength() {
        if (this.ec == null) {
            return 0;
        }
        return this.ec.GetBaseField()[0];
    }

    public String toString() {
        Ecc4145 ecc4145 = null;
        if (this.ec == null) {
            ecc4145 = new Ecc4145(p.getInstance());
            ecc4145.SetStdCurve(Consts.a, false);
            ecc4145.SetStdBasePoint();
        } else {
            ecc4145 = this.ec;
        }
        int[] nArray = ecc4145.ShrinkPoint(this.keyQ);
        byte[] byArray = ecc4145.toByteArray(nArray);
        Consts.ByteReverse(byArray, byArray.length);
        byte[] byArray2 = new byte[byArray.length + 2];
        byArray2[0] = 4;
        byArray2[1] = (byte)byArray.length;
        System.arraycopy(byArray, 0, byArray2, 2, byArray.length);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < byArray2.length; ++i2) {
            String string = Integer.toHexString(0xFF & byArray2[i2]);
            if (string.length() < 2) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
        }
        return new String(stringBuffer.toString());
    }

    public byte[] getHashSBoxes() {
        if (this.uz == null) {
            return null;
        }
        return b.b(this.uz);
    }

    public boolean equals(Object object) {
        if (object instanceof DSTU4145PublicKey) {
            DSTU4145PublicKey dSTU4145PublicKey = (DSTU4145PublicKey)object;
            if (!this.keyQ.equals(dSTU4145PublicKey.keyQ)) {
                return false;
            }
            Ecc4145 ecc4145 = dSTU4145PublicKey.ec;
            return this.ec.GetBasePoint().equals(ecc4145.GetBasePoint());
        }
        return false;
    }

    public int hashCode() {
        if (this.keyQ == null) {
            return 0;
        }
        return this.keyQ.x[1];
    }
}

