/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import ua.avtor.Consts;
import ua.avtor.DSTU4145AlgorithmParameterSpec;
import ua.avtor.DSTU4145PrivateKey_SW;
import ua.avtor.DSTU4145PublicKey;
import ua.avtor.p;
import ua.kiev.author.cryptolib.EcPoint;
import ua.kiev.author.cryptolib.Ecc4145;
import ua.kiev.author.cryptolib.StdCurves;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class DSTU4145KeyPairGenerator
extends KeyPairGeneratorSpi {
    private static final int a = 257;
    private Ecc4145 a;
    byte[] a = new byte[64];

    private Ecc4145 a(int n2) {
        EcPoint ecPoint = StdCurves.GetStandardBasePoint(n2, false);
        if (ecPoint == null) {
            return null;
        }
        Ecc4145 ecc4145 = new Ecc4145(p.getInstance());
        ecc4145.SetStdCurve(n2, false);
        ecc4145.SetBasePoint(ecPoint);
        return ecc4145;
    }

    @Override
    public void initialize(int n2, SecureRandom secureRandom) throws InvalidParameterException {
        this.a = this.a(n2);
        if (this.a == null) {
            throw new InvalidParameterException(Consts.GetMsgError(6));
        }
        this.a = Consts.a;
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec == null) {
            this.a = this.a(257);
            this.a = Consts.a;
            return;
        }
        if (!(algorithmParameterSpec instanceof DSTU4145AlgorithmParameterSpec) && (algorithmParameterSpec = DSTU4145AlgorithmParameterSpec.copyInstance(algorithmParameterSpec)) == null) {
            throw new InvalidAlgorithmParameterException(Consts.GetMsgError(16));
        }
        DSTU4145AlgorithmParameterSpec dSTU4145AlgorithmParameterSpec = (DSTU4145AlgorithmParameterSpec)algorithmParameterSpec;
        this.a = dSTU4145AlgorithmParameterSpec.ec;
        this.a = dSTU4145AlgorithmParameterSpec.uz;
    }

    @Override
    public KeyPair generateKeyPair() {
        DSTU4145PrivateKey_SW dSTU4145PrivateKey_SW;
        DSTU4145PublicKey dSTU4145PublicKey;
        BigInteger bigInteger;
        if (this.a == null) {
            this.a = this.a(257);
            this.a = Consts.a;
        }
        if ((bigInteger = this.a.GeneratePrivateKey()) == null) {
            throw new ProviderException("Internal error #Gkp1");
        }
        EcPoint ecPoint = this.a.CalcPublicKey(bigInteger);
        if (ecPoint == null) {
            throw new ProviderException(Consts.GetMsgError(10));
        }
        try {
            dSTU4145PublicKey = new DSTU4145PublicKey(ecPoint, this.a, this.a);
            dSTU4145PrivateKey_SW = new DSTU4145PrivateKey_SW(bigInteger, this.a, this.a);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new ProviderException(invalidKeyException);
        }
        return new KeyPair(dSTU4145PublicKey, dSTU4145PrivateKey_SW);
    }
}

