/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import ua.avtor.Consts;
import ua.avtor.DSTU4145PrivateKey;
import ua.avtor.DSTU4145PrivateKeySpec;
import ua.avtor.DSTU4145PrivateKey_SW;
import ua.avtor.DSTU4145PublicKey;
import ua.avtor.DSTU4145PublicKeySpec;

public final class DSTU4145KeyFactory
extends KeyFactorySpi {
    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (key instanceof DSTU4145PrivateKey) {
            DSTU4145PrivateKeySpec dSTU4145PrivateKeySpec = null;
            try {
                dSTU4145PrivateKeySpec = new DSTU4145PrivateKeySpec(key.getEncoded());
            }
            catch (Exception exception) {
                throw new InvalidKeySpecException(Consts.GetMsgError(7));
            }
            return dSTU4145PrivateKeySpec;
        }
        if (key instanceof DSTU4145PublicKey) {
            try {
                return new DSTU4145PublicKeySpec(key.getEncoded());
            }
            catch (Exception exception) {
                throw new InvalidKeySpecException(Consts.GetMsgError(7));
            }
        }
        if (key instanceof PublicKey) {
            try {
                return new DSTU4145PublicKeySpec(key.getEncoded());
            }
            catch (Exception exception) {
                throw new InvalidKeySpecException(Consts.GetMsgError(7));
            }
        }
        throw new InvalidKeySpecException(Consts.GetMsgError(7));
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof DSTU4145PrivateKey) {
            return (DSTU4145PrivateKey)key;
        }
        if (key instanceof DSTU4145PublicKey) {
            return (DSTU4145PublicKey)key;
        }
        throw new InvalidKeyException(Consts.GetMsgError(7));
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        DSTU4145PrivateKey dSTU4145PrivateKey;
        block5: {
            dSTU4145PrivateKey = null;
            try {
                if (keySpec instanceof DSTU4145PrivateKeySpec) {
                    dSTU4145PrivateKey = ((DSTU4145PrivateKeySpec)keySpec).getKey();
                    break block5;
                }
                if (keySpec instanceof PKCS8EncodedKeySpec) {
                    byte[] byArray = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
                    dSTU4145PrivateKey = new DSTU4145PrivateKey_SW(byArray);
                    break block5;
                }
                if (keySpec instanceof X509EncodedKeySpec) {
                    byte[] byArray = ((X509EncodedKeySpec)keySpec).getEncoded();
                    dSTU4145PrivateKey = new DSTU4145PrivateKey_SW(byArray);
                    break block5;
                }
                throw new InvalidKeySpecException(Consts.GetMsgError(7));
            }
            catch (Exception exception) {
                throw new InvalidKeySpecException(Consts.GetMsgError(7));
            }
        }
        return dSTU4145PrivateKey;
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        DSTU4145PublicKey dSTU4145PublicKey;
        block5: {
            dSTU4145PublicKey = null;
            try {
                if (keySpec instanceof DSTU4145PublicKeySpec) {
                    dSTU4145PublicKey = ((DSTU4145PublicKeySpec)keySpec).getKey();
                    break block5;
                }
                if (keySpec instanceof PKCS8EncodedKeySpec) {
                    byte[] byArray = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
                    dSTU4145PublicKey = new DSTU4145PublicKey(byArray);
                    break block5;
                }
                if (keySpec instanceof X509EncodedKeySpec) {
                    byte[] byArray = ((X509EncodedKeySpec)keySpec).getEncoded();
                    dSTU4145PublicKey = new DSTU4145PublicKey(byArray);
                    break block5;
                }
                throw new InvalidKeySpecException(Consts.GetMsgError(7));
            }
            catch (Exception exception) {
                throw new InvalidKeySpecException(Consts.GetMsgError(7));
            }
        }
        return dSTU4145PublicKey;
    }
}

