/*
 * Decompiled with CFR 0.152.
 */
package ua.avtor;

import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.PKCS9Attribute;
import sun.security.pkcs.PKCS9Attributes;
import sun.security.pkcs.ParsingException;
import sun.security.pkcs.SignerInfo;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.KeyUsageExtension;
import sun.security.x509.OIDMap;
import ua.avtor.QcStatementsExtension;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class AvCmsVerifier {
    protected PKCS7 a;
    protected boolean a;
    public int lastStatus = 0;
    private static final int a = 0;
    private static final int b = 1;
    private static final int c = 2;
    private static final int d = 3;
    private static final int e = 4;
    private static final int f = 5;
    private int g = 0;
    private X509Certificate[] a;
    private int[] a;
    private AlgorithmId[] a;
    private MessageDigest[] a;
    private byte[][] a = null;

    public AvCmsVerifier(byte[] byArray) throws ParsingException {
        this.a = new PKCS7(byArray);
    }

    public SignerInfo[] getSignerInfos() {
        return this.a.getSignerInfos();
    }

    public ContentInfo getContentInfo() {
        return this.a.getContentInfo();
    }

    public void setAdditionalCertificates(Certificate[] certificateArray) {
        this.a = null;
        if (certificateArray != null) {
            this.a = new X509Certificate[certificateArray.length];
            System.arraycopy(certificateArray, 0, this.a, 0, certificateArray.length);
        }
    }

    public X509Certificate getCertificate(SignerInfo signerInfo) throws IOException {
        X509Certificate x509Certificate = this.a.getCertificate(signerInfo.getCertificateSerialNumber(), signerInfo.getIssuerName());
        if (x509Certificate == null && this.a != null) {
            for (int i2 = 0; i2 < this.a.length; ++i2) {
                BigInteger bigInteger = this.a[i2].getSerialNumber();
                if (!bigInteger.equals(signerInfo.getCertificateSerialNumber())) continue;
                Principal principal = this.a[i2].getIssuerDN();
                if (!signerInfo.getIssuerName().equals(principal)) continue;
                x509Certificate = this.a[i2];
                break;
            }
        }
        return x509Certificate;
    }

    public ArrayList getCertificateChain(SignerInfo signerInfo) {
        int n2 = 0;
        int n3 = 0;
        X509Certificate[] x509CertificateArray = this.a.getCertificates();
        if (x509CertificateArray != null) {
            n2 = x509CertificateArray.length;
        }
        if (this.a != null) {
            n3 = this.a.length;
        }
        if (n2 + n3 == 0) {
            return null;
        }
        X509Certificate[] x509CertificateArray2 = new X509Certificate[n2 + n3];
        if (n2 != 0) {
            System.arraycopy(x509CertificateArray, 0, x509CertificateArray2, 0, n2);
        }
        if (n3 != 0) {
            System.arraycopy(this.a, 0, x509CertificateArray2, n2, n3);
        }
        PKCS7 pKCS7 = new PKCS7(null, null, x509CertificateArray2, null);
        try {
            this.lastStatus = 0;
            return signerInfo.getCertificateChain(pKCS7);
        }
        catch (IOException iOException) {
            this.lastStatus = 5;
            return null;
        }
    }

    static byte[] a(PublicKey publicKey) {
        try {
            DerValue[] derValueArray = new DerInputStream(publicKey.getEncoded()).getSequence(2);
            derValueArray = new DerInputStream(derValueArray[0].toByteArray()).getSequence(2);
            derValueArray = new DerInputStream(derValueArray[1].toByteArray()).getSequence(2);
            if (derValueArray.length > 1) {
                return derValueArray[1].toByteArray();
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void a() throws NoSuchAlgorithmException, IOException {
        SignerInfo[] signerInfoArray = this.getSignerInfos();
        this.a = new int[signerInfoArray.length];
        for (int i2 = 0; i2 < signerInfoArray.length; ++i2) {
            Object object;
            Object object2;
            AlgorithmId algorithmId = signerInfoArray[i2].getDigestAlgorithmId();
            int n2 = 0;
            if (this.a != null) {
                n2 = this.a.length;
            }
            boolean bl = false;
            for (int i3 = 0; i3 < n2; ++i3) {
                if (!this.a[i3].equals(algorithmId.getOID()) || !Arrays.equals((byte[])(object2 = this.a[i3].getEncodedParams()), (byte[])(object = algorithmId.getEncodedParams()))) continue;
                this.a[i2] = i3;
                bl = true;
                break;
            }
            if (bl) continue;
            this.a[i2] = n2;
            AlgorithmId[] algorithmIdArray = new AlgorithmId[n2 + 1];
            if (n2 > 0) {
                System.arraycopy(this.a, 0, algorithmIdArray, 0, n2);
            }
            algorithmIdArray[n2] = algorithmId;
            this.a = algorithmIdArray;
            object2 = MessageDigest.getInstance(algorithmId.getName());
            if (algorithmId.getOID().toString().equals("1.2.804.2.1.1.1.1.2.1")) {
                Object object3;
                object = signerInfoArray[i2].getCertificate(this.a);
                if (object != null) {
                    byte[] byArray;
                    object3 = ((Certificate)object).getPublicKey();
                    if (object3.getAlgorithm().equalsIgnoreCase("DSTU4145") && (byArray = AvCmsVerifier.a((PublicKey)object3)) != null) {
                        ((MessageDigest)object2).update(byArray, -1, byArray.length);
                    }
                } else {
                    object3 = algorithmId.getEncodedParams();
                    if (object3 != null) {
                        ((MessageDigest)object2).update((byte[])object3, -1, ((Object)object3).length);
                    }
                }
            }
            object = new MessageDigest[n2 + 1];
            if (n2 > 0) {
                System.arraycopy(this.a, 0, object, 0, n2);
            }
            object[n2] = object2;
            this.a = object;
        }
    }

    public void update(byte[] byArray, int n2, int n3) throws NoSuchAlgorithmException, IOException {
        if (this.g == 0) {
            if (this.a.getContentInfo().getContent() != null) {
                throw new IOException("CMS content present");
            }
            this.a();
            this.g = 1;
        }
        if (this.g != 1) {
            throw new IllegalStateException();
        }
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            this.a[i2].update(byArray, n2, n3);
        }
    }

    public void update(byte[] byArray) throws NoSuchAlgorithmException, IOException {
        this.update(byArray, 0, byArray.length);
    }

    protected String getEncAlgName(SignerInfo signerInfo) {
        String string = signerInfo.getDigestEncryptionAlgorithmId().getName();
        int n2 = string.toLowerCase().lastIndexOf("with");
        if (n2 >= 0) {
            string = string.substring(n2 + 4);
        }
        return string;
    }

    public SignerInfo[] verify() {
        SignerInfo[] signerInfoArray = this.getSignerInfos();
        Vector<SignerInfo> vector = new Vector<SignerInfo>();
        for (int i2 = 0; i2 < signerInfoArray.length; ++i2) {
            try {
                SignerInfo signerInfo = this.verify(signerInfoArray[i2]);
                if (signerInfo == null) continue;
                vector.addElement(signerInfo);
                continue;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                continue;
            }
            catch (IOException iOException) {
                continue;
            }
            catch (SignatureException signatureException) {
                // empty catch block
            }
        }
        if (vector.size() == 0) {
            return null;
        }
        Object[] objectArray = new SignerInfo[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public SignerInfo verify(SignerInfo signerInfo) throws NoSuchAlgorithmException, IOException, SignatureException {
        Signature signature;
        Object object;
        Object object2;
        byte[] byArray;
        this.lastStatus = 1;
        try {
            OIDMap.addAttribute(QcStatementsExtension.class.getName(), "1.3.6.1.5.5.7.1.3", QcStatementsExtension.class);
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        if (this.g == 0) {
            byte[] byArray2 = this.a.getContentInfo().getData();
            if (byArray2 == null || byArray2.length == 0) {
                throw new IOException("No data present");
            }
            this.a();
            this.g = 1;
            this.update(byArray2);
        }
        if (this.g == 1) {
            this.a = new byte[this.a.length][];
            for (int i2 = 0; i2 < this.a.length; ++i2) {
                this.a[i2] = this.a[i2].digest();
            }
            this.g = 2;
        }
        int n2 = -1;
        SignerInfo[] signerInfoArray = this.getSignerInfos();
        for (int i3 = 0; i3 < signerInfoArray.length; ++i3) {
            if (signerInfoArray[i3] != signerInfo) continue;
            n2 = i3;
            break;
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Unknown signer");
        }
        PKCS9Attributes pKCS9Attributes = signerInfo.getAuthenticatedAttributes();
        if (pKCS9Attributes == null) {
            byArray = this.getContentInfo().getData();
        } else {
            object2 = (ObjectIdentifier)pKCS9Attributes.getAttributeValue(PKCS9Attribute.CONTENT_TYPE_OID);
            if (object2 == null || !object2.equals(this.a.getContentInfo().getContentType())) {
                return null;
            }
            object = (byte[])pKCS9Attributes.getAttributeValue(PKCS9Attribute.MESSAGE_DIGEST_OID);
            if (object == null || !Arrays.equals((byte[])object, this.a[this.a[n2]])) {
                return null;
            }
            byArray = pKCS9Attributes.getDerEncoding();
        }
        object2 = this.a[this.a[n2]].getName();
        object = this.getEncAlgName(signerInfo);
        if (byArray == null) {
            signature = Signature.getInstance("NONEwith" + (String)object);
            byArray = this.a[this.a[n2]];
        } else {
            signature = Signature.getInstance((String)object2 + "with" + (String)object);
        }
        X509Certificate x509Certificate = this.getCertificate(signerInfo);
        this.lastStatus = 3;
        if (x509Certificate == null) {
            return null;
        }
        try {
            signature.initVerify(x509Certificate.getPublicKey());
            signature.update(byArray);
        }
        catch (Exception exception) {
            this.lastStatus = 3;
            throw new SignatureException(exception);
        }
        if (!signature.verify(signerInfo.getEncryptedDigest())) {
            this.lastStatus = 2;
            return null;
        }
        if (!this.a) {
            boolean[] blArray = x509Certificate.getKeyUsage();
            if (blArray != null) {
                KeyUsageExtension keyUsageExtension = new KeyUsageExtension(blArray);
                boolean bl = (Boolean)keyUsageExtension.get("digital_signature");
                boolean bl2 = (Boolean)keyUsageExtension.get("non_repudiation");
                if (!bl && !bl2) {
                    this.lastStatus = 4;
                    throw new SignatureException("Key usage restricted");
                }
            }
            if (x509Certificate.hasUnsupportedCriticalExtension()) {
                this.lastStatus = 4;
                throw new SignatureException("Certificate has unsupported critical extension(s)");
            }
        }
        this.lastStatus = 0;
        return signerInfo;
    }
}

