/*
 * Decompiled with CFR 0.152.
 */
package ua.BIT.keystore;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import ua.BIT.keystore.DatSlot;
import ua.BIT.keystore.KeyStoreInvalidOperationException;
import ua.BIT.keystore.PathUtil;
import ua.avtor.DsLib.Algorithms.ContentEncryptionAlg;
import ua.avtor.DsLib.Algorithms.CryptoAlgorithmFactory;
import ua.avtor.DsLib.Algorithms.MessageDigestAlg;
import ua.avtor.DsLib.Algorithms.PasswordBasedAlg;
import ua.avtor.DsLib.Certificate;
import ua.avtor.DsLib.CertificateException;
import ua.avtor.DsLib.Certificates.CertstoreCms;
import ua.avtor.DsLib.Certificates.CertstoreDir;
import ua.avtor.DsLib.DsAlgorithmException;
import ua.avtor.DsLib.DsDataCorruptedException;
import ua.avtor.DsLib.DsException;
import ua.avtor.DsLib.KeyStores.KeyStoreException;
import ua.avtor.DsLib.PrivateKeys.PrivateKey;
import ua.avtor.DsLib.Transport.UriTransport;
import ua.avtor.DsLib.Utils.ArrayUtil;
import ua.avtor.DsLib.Utils.Ddec;
import ua.avtor.DsLib.Utils.DdecException;
import ua.avtor.DsLib.Utils.DerEncoder;
import ua.avtor.DsLib.Utils.Pointer;
import ua.kiev.author.cryptolib.Gost28147;

class Zs2Slot {
    private CryptoAlgorithmFactory algs;
    public int bagsLength = 1;
    private String cachedPsw;
    private byte[] decryptedKey;
    public String description;
    public boolean empty;
    private byte[] encryptedKey;
    private Certificate externalCert;
    public String fileName;
    private byte[] kid;
    private boolean loggedIn;
    public boolean modified;
    private boolean pkcs5format;
    private byte[] pkcs8key;
    private byte[] pubkey;
    private byte[] textKid;
    private byte[] textSubj;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Zs2Slot(byte[] bArr, String str, CryptoAlgorithmFactory cryptoAlgorithmFactory) throws DsDataCorruptedException {
        byte[] bArr6;
        this.algs = cryptoAlgorithmFactory;
        this.description = str;
        int i2 = 0;
        this.loggedIn = false;
        boolean bl = this.empty = bArr == null;
        if (bArr == null) {
            return;
        }
        if (bArr.length < 10 || bArr[0] != 81 || bArr[1] != 76 || bArr[5] != 0) throw new DsDataCorruptedException();
        int i22 = (bArr[2] & 0xFF) + (bArr[3] & 0xFF) * 256 + (bArr[4] & 0xFF) * 256 * 256;
        int i3 = 6 + i22;
        if (i3 > bArr.length) throw new DsDataCorruptedException();
        byte[] bArr2 = new byte[i22];
        this.encryptedKey = bArr2;
        System.arraycopy(bArr, 6, bArr2, 0, i22);
        int i4 = i3 + 4;
        if (i4 > bArr.length) throw new DsDataCorruptedException();
        int i5 = (bArr[i3 + 0] & 0xFF) + (bArr[i3 + 1] & 0xFF) * 256 + (bArr[i3 + 2] & 0xFF) * 256 * 256;
        int i6 = i4 + i5;
        if (i6 > bArr.length) throw new DsDataCorruptedException();
        byte[] bArr3 = new byte[i5];
        this.textKid = bArr3;
        System.arraycopy(bArr, i4, bArr3, 0, i5);
        this.textSubj = new byte[0];
        int i7 = i6 + 4;
        if (i7 <= bArr.length) {
            int i8 = (bArr[i6 + 0] & 0xFF) + (bArr[i6 + 1] & 0xFF) * 256 + (bArr[i6 + 2] & 0xFF) * 256 * 256;
            if (i7 + i8 > bArr.length) throw new DsDataCorruptedException();
            byte[] bArr4 = new byte[i8];
            this.textSubj = bArr4;
            System.arraycopy(bArr, i7, bArr4, 0, i8);
        }
        this.pkcs5format = Zs2Slot.isPkcs5Format(this.encryptedKey);
        byte[] bArr5 = this.textKid;
        if (bArr5.length <= 1) return;
        this.kid = new byte[bArr5.length / 2];
        while (i2 < (bArr6 = this.kid).length * 2) {
            byte b2 = this.textKid[i2];
            int i9 = i2 / 2;
            bArr6[i9] = (byte)((byte)((b2 + ((b2 & 0x40) >> 6) * 9 & 0xF) << 4 - (i2 & 1) * 4) | bArr6[i9]);
            ++i2;
        }
    }

    private byte[] DerGetBytes(Pointer pointer, String str) {
        try {
            return Ddec.DerGetElementBuf(pointer, str);
        }
        catch (DdecException unused) {
            return null;
        }
    }

    private byte[] DerGetBytes(byte[] bArr, String str) {
        try {
            return Ddec.DerGetElementBuf(bArr, str);
        }
        catch (DdecException unused) {
            return null;
        }
    }

    private Gost28147 getEncryptor(String str) {
        byte[] bArr;
        try {
            bArr = str.getBytes("Windows-1251");
        }
        catch (UnsupportedEncodingException unused) {
            bArr = str.getBytes();
        }
        MessageDigestAlg digestAlg = this.algs.getDigestAlg("1.2.804.2.1.1.1.1.2.1", null, null);
        digestAlg.update(bArr);
        ArrayUtil.clear(bArr);
        byte[] digest = digestAlg.getDigest();
        byte[] bArr2 = new byte[8];
        System.arraycopy(digest, 0, bArr2, 0, 8);
        for (int i2 = 0; i2 < 5; ++i2) {
            digestAlg.update(digest);
            digest = digestAlg.getDigest();
        }
        Gost28147 gost28147 = new Gost28147(Gost28147.getVector("400D9F7957C1ACF28ABED466E53B28134A6334ABE5D116CCBD00F257799E882F7D11E942A7C3502C04FABB6E98D5863FD2A8E057FC13312FB5746B9E46CD098A"), digest, false);
        gost28147.SetSync(bArr2);
        return gost28147;
    }

    private static boolean isPkcs5Format(byte[] eKey) {
        if (eKey[0] != 48 || (eKey[1] & 0xFC) != 128 || Ddec.DerGetTotalSize(eKey) != eKey.length) {
            return false;
        }
        String elementOid = Ddec.TryGetElementOid(eKey, "SSD");
        return elementOid != null && elementOid == "1.2.840.113549.1.5.13";
    }

    public int certByPublic(byte[] bArr) {
        if (bArr == null) {
            return -1;
        }
        byte[] TryGetElementBuf = Ddec.TryGetElementBuf(bArr, "SsG");
        Certificate certificate = this.externalCert;
        if (certificate != null) {
            try {
                if (Arrays.equals(TryGetElementBuf, certificate.getPublicKey())) {
                    return 0;
                }
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        return -1;
    }

    public boolean changePassword(String str, String str2) throws DsAlgorithmException, KeyStoreException {
        if (this.loggedIn) {
            if (!str.equals(this.cachedPsw)) {
                return false;
            }
            this.cachedPsw = str2;
            this.modified = true;
        } else if (this.empty) {
            this.cachedPsw = str2;
        } else {
            if (!this.login(str)) {
                return false;
            }
            this.cachedPsw = str2;
            this.modified = true;
            this.logout();
        }
        return true;
    }

    public int findExternalCertificates(String str) {
        if (str != null && str.length() > 0) {
            for (String str2 : str.split(";")) {
                byte[] findCertificate;
                if (str2.startsWith("*")) {
                    String string = str2 = this.fileName == null ? null : PathUtil.getDirectoryName(this.fileName) + str2.substring(1);
                }
                if (str2 == null || str2.length() <= 0 || (findCertificate = new CertstoreDir(str2).findCertificate(1, this.kid)) == null) continue;
                try {
                    Certificate certificate = new Certificate(findCertificate);
                    Certificate certificate2 = this.externalCert;
                    if (certificate2 != null && !certificate2.isSelfSigned()) continue;
                    this.externalCert = certificate;
                }
                catch (CertificateException certificateException) {
                    // empty catch block
                }
            }
        }
        return this.externalCert != null ? 1 : 0;
    }

    public int findExternalCertificatesCMP(UriTransport uriTransport, String str) {
        if (str != null && str.length() > 0) {
            for (String str2 : str.split(";")) {
                boolean z2;
                boolean z3;
                if (str2 == null || str2.length() <= 0) continue;
                CertstoreCms certstoreCms = null;
                try {
                    certstoreCms = DatSlot.RequestCmpServer(uriTransport, str2, this.kid, null, 0);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (certstoreCms != null) {
                    z3 = false;
                    for (int i2 = 0; i2 < this.bagsLength; ++i2) {
                        try {
                            byte[] findCertificate = certstoreCms.findCertificate(1, this.kid);
                            if (findCertificate == null) continue;
                            Certificate certificate = new Certificate(findCertificate);
                            Certificate certificate2 = this.externalCert;
                            if (certificate2 == null || certificate2.isSelfSigned()) {
                                this.externalCert = certificate;
                            }
                            z3 = true;
                            continue;
                        }
                        catch (CertificateException certificateException) {
                            // empty catch block
                        }
                    }
                } else {
                    z3 = false;
                }
                boolean bl = z2 = this.externalCert != null;
                if (z3 && z2) break;
            }
        }
        return this.externalCert != null ? 1 : 0;
    }

    public String getBagLabel(int i2) {
        return "##" + Integer.toString(i2);
    }

    public Certificate getCert(int i2) {
        if (i2 != 0) {
            return null;
        }
        return this.externalCert;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] getEncoded() throws DsAlgorithmException, KeyStoreInvalidOperationException {
        byte[] bArr6;
        if (this.modified) {
            if (!this.loggedIn) throw new KeyStoreInvalidOperationException("not logged in", null);
            if (this.pkcs5format) {
                DerEncoder derEncoder = new DerEncoder();
                byte[] bArr = new byte[16];
                this.algs.generateRandom(bArr);
                PasswordBasedAlg passwordBasedAlg = this.algs.getPasswordBasedAlg(this.cachedPsw, "1.2.840.113549.1.5.13", bArr, 1000, "1.2.804.2.1.1.1.1.1.2", "1.2.804.2.1.1.1.1.1.1.3");
                derEncoder.SeqBegin();
                derEncoder.SeqBegin();
                derEncoder.addOid(passwordBasedAlg.getOid());
                derEncoder.addDerParams(passwordBasedAlg.getParams());
                derEncoder.SeqEnd();
                ContentEncryptionAlg encryptor = passwordBasedAlg.getEncryptor();
                if (encryptor == null) throw new DsAlgorithmException();
                byte[] bArr2 = this.decryptedKey;
                byte[] bArr3 = new byte[bArr2.length + 64];
                derEncoder.addOctets(ArrayUtil.resizeOf(bArr3, encryptor.encryptFinal(bArr2, 0, bArr2.length, bArr3, 0)));
                derEncoder.SeqEnd();
                this.encryptedKey = derEncoder.getEncoded();
            } else {
                this.encryptedKey = (byte[])this.decryptedKey.clone();
                Gost28147 encryptor2 = this.getEncryptor(this.cachedPsw);
                encryptor2.ClearSync();
                byte[] bArr4 = this.encryptedKey;
                encryptor2.MAC(bArr4, 8, bArr4.length - 8);
                encryptor2.GetMAC8(this.encryptedKey, 0);
                Gost28147 encryptor3 = this.getEncryptor(this.cachedPsw);
                byte[] bArr5 = this.encryptedKey;
                encryptor3.M3Enc(bArr5, 0, bArr5.length);
            }
            this.modified = false;
        }
        if ((bArr6 = this.encryptedKey) == null) throw new KeyStoreInvalidOperationException("empty slot", null);
        byte[] bArr7 = new byte[bArr6.length + 6 + 4 + this.textKid.length + 4 + this.textSubj.length];
        bArr7[0] = 81;
        bArr7[1] = 76;
        int length = bArr6.length;
        bArr7[2] = (byte)(length >> 0);
        bArr7[3] = (byte)(length >> 8);
        System.arraycopy(bArr6, 0, bArr7, 6, length);
        int i2 = 6 + length;
        byte[] bArr8 = this.textKid;
        int length2 = bArr8.length;
        bArr7[i2 + 0] = (byte)(length2 >> 0);
        bArr7[i2 + 1] = (byte)(length2 >> 8);
        int i22 = i2 + 4;
        System.arraycopy(bArr8, 0, bArr7, i22, length2);
        int i3 = i22 + length2;
        byte[] bArr9 = this.textSubj;
        int length3 = bArr9.length;
        bArr7[i3 + 0] = (byte)(length3 >> 0);
        bArr7[i3 + 1] = (byte)(length3 >> 8);
        System.arraycopy(bArr9, 0, bArr7, i3 + 4, length3);
        return bArr7;
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public int keyByCertId(byte[] bArr) {
        if (bArr != null && bArr.length >= 3) {
            if (bArr[0] == 48) {
                Certificate certificate = this.externalCert;
                return certificate == null || !certificate.isMyIdentifier(bArr) ? -1 : 0;
            }
            if (bArr[0] != 4) {
                return -1;
            }
            int length = bArr.length - 2;
            byte[] bArr2 = new byte[length];
            System.arraycopy(bArr, 2, bArr2, 0, length);
            return this.keyByKeyIdentifier(bArr2);
        }
        return -1;
    }

    public int keyByKeyIdentifier(byte[] bArr) {
        return Arrays.equals(this.kid, bArr) ? 0 : -1;
    }

    public int keyByLabel(String str) {
        for (int i2 = 0; i2 < this.bagsLength; ++i2) {
            if (!str.equals(this.getBagLabel(i2))) continue;
            return i2;
        }
        return -1;
    }

    public int keyByPublic(byte[] bArr) {
        PrivateKey signerAlg;
        byte[] TryGetElementBuf = Ddec.TryGetElementBuf(bArr, "SsG");
        if (this.pubkey == null && this.loggedIn && (signerAlg = this.algs.getSignerAlg(this.pkcs8data(0), null, 0, null)) != null) {
            try {
                this.pubkey = Ddec.TryGetElementBuf(signerAlg.getPublicKeyInfo(), "SsG");
            }
            catch (DsException dsException) {
                // empty catch block
            }
            signerAlg.cleanup();
        }
        return Arrays.equals(TryGetElementBuf, this.pubkey) ? 0 : -1;
    }

    public byte[] keyIdByLabel(String str) {
        for (int i2 = 0; i2 < this.bagsLength; ++i2) {
            if (!str.equals(this.getBagLabel(i2))) continue;
            return this.kid;
        }
        return null;
    }

    public boolean login(String password) throws KeyStoreException, DsAlgorithmException {
        if (this.loggedIn) {
            throw new KeyStoreException("already loggedIn", null);
        }
        if (this.empty) {
            if (this.cachedPsw == null || !this.cachedPsw.equals(password)) {
                return false;
            }
            this.loggedIn = true;
            return true;
        }
        if (this.pkcs5format) {
            byte[] bytes1;
            String elementOid = Ddec.TryGetElementOid(this.encryptedKey, "SSD");
            ContentEncryptionAlg encryptor = this.algs.getPasswordBasedAlg(password, elementOid, bytes1 = this.DerGetBytes(this.encryptedKey, "SSds")).getEncryptor();
            if (encryptor == null) {
                throw new DsAlgorithmException();
            }
            byte[] bytes2 = this.DerGetBytes(this.encryptedKey, "SsQ");
            int outSize = encryptor.decryptFinal(bytes2, 0, bytes2.length);
            bytes2 = Arrays.copyOf(bytes2, outSize);
            this.decryptedKey = bytes2;
            if (this.decryptedKey[0] != 48 || Ddec.DerGetTotalSize(this.decryptedKey) != this.decryptedKey.length || this.DerGetBytes(this.decryptedKey, "SiSdx") == null) {
                return false;
            }
        } else {
            Gost28147 encryptor = this.getEncryptor(password);
            this.decryptedKey = Arrays.copyOf(this.encryptedKey, this.encryptedKey.length);
            encryptor.M3Dec(this.decryptedKey, 0, this.decryptedKey.length);
            encryptor.ClearSync();
            encryptor.MAC(this.decryptedKey, 8, this.decryptedKey.length - 8);
            boolean flag = encryptor.CheckMAC8(this.decryptedKey, 0);
            if (!flag || this.decryptedKey[8] != 48 || Ddec.DerGetTotalSize(new Pointer(this.decryptedKey, 8)) != this.decryptedKey.length - 8) {
                return false;
            }
        }
        this.cachedPsw = password;
        this.loggedIn = true;
        return true;
    }

    public void logout() throws DsAlgorithmException, KeyStoreInvalidOperationException {
        byte[] bArr2;
        byte[] bArr;
        if (this.modified) {
            this.getEncoded();
        }
        if ((bArr = this.decryptedKey) != null) {
            ArrayUtil.clear(bArr);
        }
        if ((bArr2 = this.pkcs8key) != null) {
            ArrayUtil.clear(bArr2);
        }
        this.cachedPsw = null;
        this.loggedIn = false;
    }

    public byte[] pkcs8data(int i2) {
        if (i2 != 0 || !this.loggedIn) {
            return null;
        }
        if (this.pkcs8key == null) {
            if (this.pkcs5format) {
                this.pkcs8key = (byte[])this.decryptedKey.clone();
            } else {
                DerEncoder derEncoder = new DerEncoder();
                byte[] DerGetBytes = this.DerGetBytes(new Pointer(this.decryptedKey, 8), "Sis");
                byte[] DerGetBytes2 = this.DerGetBytes(new Pointer(this.decryptedKey, 8), "SisQI");
                derEncoder.SeqBegin();
                derEncoder.addInteger(0);
                derEncoder.addObject(DerGetBytes);
                derEncoder.addOctetsReverse(DerGetBytes2);
                derEncoder.SeqEnd();
                this.pkcs8key = derEncoder.getEncoded();
            }
        }
        return this.pkcs8key;
    }

    public boolean trySuitableCertificate(int i2, Certificate certificate) {
        if (i2 != 0) {
            return false;
        }
        Certificate certificate2 = this.externalCert;
        if (certificate2 != null && !certificate2.isSelfSigned()) {
            return false;
        }
        this.externalCert = certificate;
        return true;
    }
}

